/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.birt.report.model.api.olap;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.birt.report.model.api.PropertyHandle;
import org.eclipse.birt.report.model.api.ReportElementHandle;
import org.eclipse.birt.report.model.api.olap.LevelHandle;
import org.eclipse.birt.report.model.core.DesignElement;
import org.eclipse.birt.report.model.core.Module;
import org.eclipse.birt.report.model.elements.interfaces.IHierarchyModel;

public abstract class HierarchyHandle
extends ReportElementHandle
implements IHierarchyModel {
    public HierarchyHandle(Module module, DesignElement element) {
        super(module, element);
    }

    public int getLevelCount() {
        return this.getPropertyHandle("levels").getContentCount();
    }

    public LevelHandle getLevel(String levelName) {
        if (levelName == null) {
            return null;
        }
        LevelHandle found = null;
        List levels = this.getListProperty("levels");
        int i = 0;
        while (i < levels.size()) {
            LevelHandle tmpLevel = (LevelHandle)levels.get(i);
            if (levelName.equals(tmpLevel.getName())) {
                found = tmpLevel;
                break;
            }
            ++i;
        }
        if (found == null) {
            return null;
        }
        return found;
    }

    public LevelHandle getLevel(int index) {
        return (LevelHandle)this.getPropertyHandle("levels").getContent(index);
    }

    public Iterator filtersIterator() {
        PropertyHandle propHandle = this.getPropertyHandle("filter");
        assert (propHandle != null);
        return propHandle.iterator();
    }

    public Iterator accessControlsIterator() {
        return Collections.emptyList().iterator();
    }
}

