/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.nodemodel.util;

import com.google.common.collect.UnmodifiableIterator;
import java.util.NoSuchElementException;
import org.eclipse.xtext.nodemodel.BidiTreeIterator;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;

public class NodeTreeIterator
extends UnmodifiableIterator<INode>
implements BidiTreeIterator<INode> {
    private final INode root;
    private INode lastNextReturned;
    private INode lastPreviousReturned;
    private INode next;
    private boolean nextComputed = false;
    private boolean pruned = false;
    private INode previous;
    private boolean previousComputed = false;

    public NodeTreeIterator(INode root) {
        this.root = root;
    }

    @Override
    public boolean hasNext() {
        if (this.nextComputed) {
            return this.next != null;
        }
        if (this.lastNextReturned == null) {
            this.next = this.lastPreviousReturned != null ? this.lastPreviousReturned : this.root;
        } else if (!this.pruned && this.lastNextReturned instanceof ICompositeNode && ((ICompositeNode)this.lastNextReturned).hasChildren()) {
            this.next = ((ICompositeNode)this.lastNextReturned).getFirstChild();
        } else if (this.root.equals(this.lastNextReturned)) {
            this.next = null;
        } else {
            this.next = this.lastNextReturned.getNextSibling();
            if (this.next == null) {
                ICompositeNode parent = this.lastNextReturned.getParent();
                while (this.next == null && !this.root.equals(parent)) {
                    this.next = parent.getNextSibling();
                    parent = parent.getParent();
                }
            }
        }
        this.nextComputed = true;
        return this.next != null;
    }

    @Override
    public INode next() {
        if (this.next == null && !this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.lastNextReturned = this.next;
        this.lastPreviousReturned = null;
        this.afterAdvance();
        return this.lastNextReturned;
    }

    protected void afterAdvance() {
        this.next = null;
        this.previous = null;
        this.nextComputed = false;
        this.previousComputed = false;
        this.pruned = false;
    }

    @Override
    public boolean hasPrevious() {
        if (this.previousComputed) {
            return this.previous != null;
        }
        if (this.lastPreviousReturned == null) {
            this.previous = this.lastNextReturned != null ? this.lastNextReturned : this.root;
        } else if (!this.pruned && this.lastPreviousReturned instanceof ICompositeNode && ((ICompositeNode)this.lastPreviousReturned).hasChildren()) {
            this.previous = ((ICompositeNode)this.lastPreviousReturned).getLastChild();
        } else if (this.root.equals(this.lastPreviousReturned)) {
            this.previous = null;
        } else {
            this.previous = this.lastPreviousReturned.getPreviousSibling();
            if (this.previous == null) {
                ICompositeNode parent = this.lastPreviousReturned.getParent();
                while (this.previous == null && !this.root.equals(parent)) {
                    this.previous = parent.getPreviousSibling();
                    parent = parent.getParent();
                }
            }
        }
        this.previousComputed = true;
        return this.previous != null;
    }

    @Override
    public INode previous() {
        if (this.previous == null && !this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        this.lastPreviousReturned = this.previous;
        this.lastNextReturned = null;
        this.afterAdvance();
        return this.lastPreviousReturned;
    }

    public void prune() {
        if (this.lastPreviousReturned == null && this.lastNextReturned == null) {
            throw new IllegalStateException("Cannot prune before #next or #previous");
        }
        this.pruned = true;
    }
}

