/*******************************************************************************
 * Copyright (c) 2000, 2018 IBM Corporation and others.
 *
 * This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 *     Martin Karpisek <martin.karpisek@gmail.com> - Bug 443250
 *******************************************************************************/
package org.eclipse.swt.internal.win32;


import org.eclipse.swt.internal.*;

public class OS extends C {
	static {
		Library.loadLibrary ("swt"); //$NON-NLS-1$
	}

	/*
	* SWT Windows flags
	*/
	public static final boolean IsDBLocale;
	public static final boolean IsUnicode = true;
	public static final int WIN32_VERSION;

	public static final String NO_MANIFEST = "org.eclipse.swt.internal.win32.OS.NO_MANIFEST";

	/* Forward references */
	public static final int ACTCTX_FLAG_RESOURCE_NAME_VALID = 0x00000008;
	public static final int ACTCTX_FLAG_SET_PROCESS_DEFAULT = 0x00000010;
	public static final int ACTCTX_FLAG_HMODULE_VALID = 0x00000080;
	public static final int MANIFEST_RESOURCE_ID = 2;
	public static final int SM_IMMENABLED = 0x52;

	static {
		/* Get the Windows version */
		int dwVersion = OS.GetVersion ();
		WIN32_VERSION = VERSION (dwVersion & 0xff, (dwVersion >> 8) & 0xff);

		/* Load the manifest to force the XP Theme */
		if (System.getProperty (NO_MANIFEST) == null) {
			ACTCTX pActCtx = new ACTCTX ();
			pActCtx.cbSize = ACTCTX.sizeof;
			pActCtx.dwFlags = ACTCTX_FLAG_RESOURCE_NAME_VALID | ACTCTX_FLAG_HMODULE_VALID | ACTCTX_FLAG_SET_PROCESS_DEFAULT;
			pActCtx.hModule = OS.GetLibraryHandle ();
			pActCtx.lpResourceName = MANIFEST_RESOURCE_ID;
			int /*long*/ hActCtx = OS.CreateActCtx (pActCtx);
			int /*long*/ [] lpCookie = new int /*long*/ [1];
			OS.ActivateActCtx (hActCtx, lpCookie);
			/*
			* NOTE:  A single activation context is created and activated
			* for the entire lifetime of the program.  It is deactivated
			* and released by Windows when the program exits.
			*/
		}

		/* Make the process DPI aware for Windows Vista */
		OS.SetProcessDPIAware ();

		/* Get the DBCS flag */
		IsDBLocale = OS.GetSystemMetrics (SM_IMMENABLED) != 0;
	}

	/* Constants */
	public static final int ABS_DOWNDISABLED = 8;
	public static final int ABS_DOWNHOT = 6;
	public static final int ABS_DOWNNORMAL = 5;
	public static final int ABS_DOWNPRESSED = 7;
	public static final int ABS_LEFTDISABLED = 12;
	public static final int ABS_LEFTHOT = 10;
	public static final int ABS_LEFTNORMAL = 9;
	public static final int ABS_LEFTPRESSED = 11;
	public static final int ABS_RIGHTDISABLED = 16;
	public static final int ABS_RIGHTHOT = 14;
	public static final int	ABS_RIGHTNORMAL = 13;
	public static final int	ABS_RIGHTPRESSED = 15;
	public static final int ABS_UPDISABLED = 4;
	public static final int ABS_UPHOT = 2;
	public static final int ABS_UPNORMAL = 1;
	public static final int ABS_UPPRESSED = 3;
	public static final int AC_SRC_OVER = 0;
	public static final int AC_SRC_ALPHA = 1;
	public static final int ALTERNATE = 1;
	public static final int ASSOCF_NOTRUNCATE = 0x00000020;
	public static final int ASSOCF_INIT_IGNOREUNKNOWN = 0x400;
	public static final int ASSOCSTR_COMMAND = 1;
	public static final int ASSOCSTR_DEFAULTICON = 15;
	public static final int ASSOCSTR_FRIENDLYAPPNAME = 4;
	public static final int ASSOCSTR_FRIENDLYDOCNAME = 3;
	public static final int ATTR_INPUT = 0x00;
	public static final int ATTR_TARGET_CONVERTED = 0x01;
	public static final int ATTR_CONVERTED = 0x02;
	public static final int ATTR_TARGET_NOTCONVERTED = 0x03;
	public static final int ATTR_INPUT_ERROR = 0x04;
	public static final int ATTR_FIXEDCONVERTED = 0x05;
	public static final int BCM_FIRST = 0x1600;
	public static final int BCM_GETIDEALSIZE = BCM_FIRST + 0x1;
	public static final int BCM_GETIMAGELIST = BCM_FIRST + 0x3;
	public static final int BCM_GETNOTE = BCM_FIRST + 0xa;
	public static final int BCM_GETNOTELENGTH = BCM_FIRST + 0xb;
	public static final int BCM_SETIMAGELIST = BCM_FIRST + 0x2;
	public static final int BCM_SETNOTE = BCM_FIRST + 0x9;
	public static final int BDR_RAISEDOUTER = 0x0001;
	public static final int BDR_SUNKENOUTER = 0x0002;
	public static final int BDR_RAISEDINNER = 0x0004;
	public static final int BDR_SUNKENINNER = 0x0008;
	public static final int BDR_OUTER = 0x0003;
	public static final int BDR_INNER = 0x000c;
	public static final int BDR_RAISED = 0x0005;
	public static final int BDR_SUNKEN = 0x000a;
	public static final int BFFM_INITIALIZED = 0x1;
	public static final int BFFM_SETSELECTION = 0x467;
	public static final int BFFM_VALIDATEFAILED = IsUnicode ? 0x4 : 0x3;
	public static final int BFFM_VALIDATEFAILEDW = 0x4;
	public static final int BFFM_VALIDATEFAILEDA = 0x3;
	public static final int BF_ADJUST = 0x2000;
	public static final int BF_LEFT = 0x0001;
	public static final int BF_TOP = 0x0002;
	public static final int BF_RIGHT = 0x0004;
	public static final int BF_BOTTOM = 0x0008;
	public static final int BF_RECT = (BF_LEFT | BF_TOP | BF_RIGHT | BF_BOTTOM);
	public static final int BIF_EDITBOX = 0x10;
	public static final int BIF_NEWDIALOGSTYLE = 0x40;
	public static final int BIF_RETURNONLYFSDIRS = 0x1;
	public static final int BIF_VALIDATE = 0x20;
	public static final int BITSPIXEL = 0xc;
	public static final int BI_BITFIELDS = 3;
	public static final int BI_RGB = 0;
	public static final int BLACKNESS = 0x42;
	public static final int BLACK_BRUSH = 4;
	public static final int BUTTON_IMAGELIST_ALIGN_LEFT = 0;
	public static final int BUTTON_IMAGELIST_ALIGN_RIGHT = 1;
	public static final int BUTTON_IMAGELIST_ALIGN_CENTER = 4;
	public static final int BM_CLICK = 0xf5;
	public static final int BM_GETCHECK = 0xf0;
	public static final int BM_SETCHECK = 0xf1;
	public static final int BM_SETIMAGE = 0xf7;
	public static final int BM_SETSTYLE = 0xf4;
	public static final int BN_CLICKED = 0x0;
	public static final int BN_DOUBLECLICKED = 0x5;
	public static final int BPBF_COMPATIBLEBITMAP = 0;
	public static final int BPBF_DIB = 1;
	public static final int BPBF_TOPDOWNDIB = 2;
	public static final int BPBF_TOPDOWNMONODIB = 3;
	public static final int BPPF_ERASE = 0x0001;
	public static final int BPPF_NOCLIP = 0x0002;
	public static final int BPPF_NONCLIENT = 0x0004;
	public static final int BP_PUSHBUTTON = 1;
	public static final int BP_RADIOBUTTON = 2;
	public static final int BP_CHECKBOX = 3;
	public static final int BP_GROUPBOX = 4;
	public static final int BST_CHECKED = 0x1;
	public static final int BST_INDETERMINATE = 0x2;
	public static final int BST_UNCHECKED = 0x0;
	public static final int BS_3STATE = 0x5;
	public static final int BS_BITMAP = 0x80;
	public static final int BS_CENTER = 0x300;
	public static final int BS_CHECKBOX = 0x2;
	public static final int BS_COMMANDLINK =  0xe;
	public static final int BS_DEFPUSHBUTTON = 0x1;
	public static final int BS_FLAT = 0x8000;
	public static final int BS_GROUPBOX = 0x7;
	public static final int BS_ICON = 0x40;
	public static final int BS_LEFT = 0x100;
	public static final int BS_MULTILINE = 0x2000;
	public static final int BS_NOTIFY = 0x4000;
	public static final int BS_OWNERDRAW = 0xb;
	public static final int BS_PATTERN = 0x3;
	public static final int BS_PUSHBUTTON = 0x0;
	public static final int BS_PUSHLIKE = 0x1000;
	public static final int BS_RADIOBUTTON = 0x4;
	public static final int BS_RIGHT = 0x200;
	public static final int BS_SOLID = 0x0;
	public static final int BTNS_AUTOSIZE = 0x10;
	public static final int BTNS_BUTTON = 0x0;
	public static final int BTNS_CHECK = 0x2;
	public static final int BTNS_CHECKGROUP = 0x6;
	public static final int BTNS_DROPDOWN = 0x8;
	public static final int BTNS_GROUP = 0x4;
	public static final int BTNS_SEP = 0x1;
	public static final int BTNS_SHOWTEXT = 0x40;
	public static final int CBN_DROPDOWN = 0x7;
	public static final int CBN_EDITCHANGE = 0x5;
	public static final int CBN_KILLFOCUS = 0x4;
	public static final int CBN_SELCHANGE = 0x1;
	public static final int CBN_SETFOCUS = 0x3;
	public static final int CBS_AUTOHSCROLL = 0x40;
	public static final int CBS_DROPDOWN = 0x2;
	public static final int CBS_DROPDOWNLIST = 0x3;
	public static final int CBS_CHECKEDNORMAL = 5;
	public static final int CBS_MIXEDNORMAL = 9;
	public static final int CBS_NOINTEGRALHEIGHT = 0x400;
	public static final int CBS_SIMPLE = 0x1;
	public static final int CBS_UNCHECKEDNORMAL = 1;
	public static final int CBS_CHECKEDDISABLED = 8;
	public static final int CBS_CHECKEDHOT = 6;
	public static final int CBS_CHECKEDPRESSED = 7;
	public static final int CBS_MIXEDDISABLED = 12;
	public static final int CBS_MIXEDHOT = 10;
	public static final int CBS_MIXEDPRESSED = 11;
	public static final int CBS_UNCHECKEDDISABLED = 4;
	public static final int CBS_UNCHECKEDHOT = 2;
	public static final int CBS_UNCHECKEDPRESSED = 3;
	public static final int CB_ADDSTRING = 0x143;
	public static final int CB_DELETESTRING = 0x144;
	public static final int CB_ERR = 0xffffffff;
	public static final int CB_ERRSPACE = 0xfffffffe;
	public static final int CB_FINDSTRINGEXACT = 0x158;
	public static final int CB_GETCOUNT = 0x146;
	public static final int CB_GETCURSEL = 0x147;
	public static final int CB_GETDROPPEDCONTROLRECT = 0x152;
	public static final int CB_GETDROPPEDSTATE = 0x157;
	public static final int CB_GETDROPPEDWIDTH = 0x015f;
	public static final int CB_GETEDITSEL = 0x140;
	public static final int CB_GETHORIZONTALEXTENT = 0x015d;
	public static final int CB_GETITEMHEIGHT = 0x154;
	public static final int CB_GETLBTEXT = 0x148;
	public static final int CB_GETLBTEXTLEN = 0x149;
	public static final int CB_INSERTSTRING = 0x14a;
	public static final int CB_LIMITTEXT = 0x141;
	public static final int CB_RESETCONTENT = 0x14b;
	public static final int CB_SELECTSTRING = 0x14d;
	public static final int CB_SETCURSEL = 0x14e;
	public static final int CB_SETDROPPEDWIDTH= 0x0160;
	public static final int CB_SETEDITSEL = 0x142;
	public static final int CB_SETHORIZONTALEXTENT = 0x015e;
	public static final int CB_SETITEMHEIGHT = 0x0153;
	public static final int CB_SHOWDROPDOWN = 0x14f;
	public static final int CCHDEVICENAME = 32;
	public static final int CCHFORMNAME = 32;
	public static final int CCHILDREN_SCROLLBAR = 5;
	public static final int CCM_FIRST = 0x2000;
	public static final int CCM_SETBKCOLOR = 0x2001;
	public static final int CCM_SETVERSION = 0x2007;
	public static final int CCS_NODIVIDER = 0x40;
	public static final int CCS_NORESIZE = 0x4;
	public static final int CCS_VERT = 0x80;
	public static final int CC_ANYCOLOR = 0x100;
	public static final int CC_ENABLEHOOK = 0x10;
	public static final int CC_FULLOPEN = 0x2;
	public static final int CC_RGBINIT = 0x1;
	public static final int CDDS_POSTERASE = 0x00000004;
	public static final int CDDS_POSTPAINT = 0x00000002;
	public static final int CDDS_PREERASE = 0x00000003;
	public static final int CDDS_PREPAINT = 0x00000001;
	public static final int CDDS_ITEM = 0x00010000;
	public static final int CDDS_ITEMPOSTPAINT = CDDS_ITEM | CDDS_POSTPAINT;
	public static final int CDDS_ITEMPREPAINT = CDDS_ITEM | CDDS_PREPAINT;
	public static final int CDDS_SUBITEM = 0x00020000;
	public static final int CDDS_SUBITEMPOSTPAINT = CDDS_ITEMPOSTPAINT | CDDS_SUBITEM;
	public static final int CDDS_SUBITEMPREPAINT = CDDS_ITEMPREPAINT | CDDS_SUBITEM;
	public static final int CDIS_SELECTED = 0x0001;
	public static final int CDIS_GRAYED = 0x0002;
	public static final int CDIS_DISABLED = 0x0004;
	public static final int CDIS_CHECKED = 0x0008;
	public static final int CDIS_FOCUS = 0x0010;
	public static final int CDIS_DEFAULT = 0x0020;
	public static final int CDIS_HOT = 0x0040;
	public static final int CDIS_MARKED = 0x0080;
	public static final int CDIS_INDETERMINATE = 0x0100;
	public static final int CDIS_SHOWKEYBOARDCUES = 0x0200;
	public static final int CDIS_DROPHILITED = 0x1000;
	public static final int CDM_FIRST = 0x0400 + 100;
	public static final int CDM_GETSPEC = CDM_FIRST;
	public static final int CDN_FIRST = -601;
	public static final int CDN_SELCHANGE = CDN_FIRST - 1;
	public static final int CDRF_DODEFAULT = 0x00000000;
	public static final int CDRF_DOERASE = 0x00000008;
	public static final int CDRF_NEWFONT = 0x00000002;
	public static final int CDRF_NOTIFYITEMDRAW = 0x00000020;
	public static final int CDRF_NOTIFYPOSTERASE = 0x00000040;
	public static final int CDRF_NOTIFYPOSTPAINT = 0x00000010;
	public static final int CDRF_NOTIFYSUBITEMDRAW = 0x00000020;
	public static final int CDRF_SKIPDEFAULT = 0x04;
	public static final int CDRF_SKIPPOSTPAINT = 0x00000100;
	public static final int CERT_SIMPLE_NAME_STR = 1;
	public static final int CFE_AUTOCOLOR = 0x40000000;
	public static final int CFE_ITALIC = 0x2;
	public static final int CFE_STRIKEOUT = 0x8;
	public static final int CFE_UNDERLINE = 0x4;
	public static final int CFM_BOLD = 0x1;
	public static final int CFM_CHARSET = 0x8000000;
	public static final int CFM_COLOR = 0x40000000;
	public static final int CFM_FACE = 0x20000000;
	public static final int CFM_ITALIC = 0x2;
	public static final int CFM_SIZE = 0x80000000;
	public static final int CFM_STRIKEOUT = 0x8;
	public static final int CFM_UNDERLINE = 0x4;
	public static final int CFM_WEIGHT = 0x400000;
	public static final int CFS_POINT = 0x2;
	public static final int CFS_RECT = 0x1;
	public static final int CFS_CANDIDATEPOS = 0x0040;
	public static final int CFS_EXCLUDE = 0x0080;
	public static final int CF_EFFECTS = 0x100;
	public static final int CF_INITTOLOGFONTSTRUCT = 0x40;
	public static final int CF_SCREENFONTS = 0x1;
	public static final int CF_TEXT = 0x1;
	public static final int CF_UNICODETEXT = 13;
	public static final int CF_USESTYLE = 0x80;
	public static final int CLR_DEFAULT = 0xff000000;
	public static final int CLR_INVALID = 0xffffffff;
	public static final int CLR_NONE = 0xffffffff;
	public static final int CLSCTX_INPROC_SERVER = 1;
	public static final int CSIDL_APPDATA = 0x1a;
	public static final int CSIDL_LOCAL_APPDATA = 0x1c;
	public static final int COLORONCOLOR = 0x3;
	public static final int COLOR_3DDKSHADOW = 0x15;
	public static final int COLOR_3DFACE = 0xf;
	public static final int COLOR_3DHIGHLIGHT = 0x14;
	public static final int COLOR_3DHILIGHT = 0x14;
	public static final int COLOR_3DLIGHT = 0x16;
	public static final int COLOR_3DSHADOW = 0x10;
	public static final int COLOR_ACTIVECAPTION = 0x2;
	public static final int COLOR_BTNFACE = 0xf;
	public static final int COLOR_BTNHIGHLIGHT = 0x14;
	public static final int COLOR_BTNSHADOW = 0x10;
	public static final int COLOR_BTNTEXT = 0x12;
	public static final int COLOR_CAPTIONTEXT = 0x9;
	public static final int COLOR_GRADIENTACTIVECAPTION = 0x1b;
	public static final int COLOR_GRADIENTINACTIVECAPTION = 0x1c;
	public static final int COLOR_GRAYTEXT = 0x11;
	public static final int COLOR_HIGHLIGHT = 0xd;
	public static final int COLOR_HIGHLIGHTTEXT = 0xe;
	public static final int COLOR_HOTLIGHT = 26;
	public static final int COLOR_INACTIVECAPTION = 0x3;
	public static final int COLOR_INACTIVECAPTIONTEXT = 0x13;
	public static final int COLOR_INFOBK = 0x18;
	public static final int COLOR_INFOTEXT = 0x17;
	public static final int COLOR_MENU = 0x4;
	public static final int COLOR_MENUTEXT = 0x7;
	public static final int COLOR_SCROLLBAR = 0x0;
	public static final int COLOR_WINDOW = 0x5;
	public static final int COLOR_WINDOWFRAME = 0x6;
	public static final int COLOR_WINDOWTEXT = 0x8;
	public static final int COMPLEXREGION = 0x3;
	public static final int CP_ACP = 0x0;
	public static final int CP_UTF8 = 65001;
	public static final int CP_DROPDOWNBUTTON = 1;
	public static final int CPS_COMPLETE = 0x1;
	public static final int CS_DBLCLKS = 0x8;
	public static final int CS_DROPSHADOW = 0x20000;
	public static final int CS_GLOBALCLASS = 0x4000;
	public static final int CS_HREDRAW = 0x2;
	public static final int CS_VREDRAW = 0x1;
	public static final int CS_OWNDC = 0x20;
	public static final int CW_USEDEFAULT = 0x80000000;
	public static final String DATETIMEPICK_CLASS = "SysDateTimePick32"; //$NON-NLS-1$
	public static final int DCX_CACHE = 0x2;
	public static final int DCX_CLIPCHILDREN = 0x8;
	public static final int DCX_CLIPSIBLINGS = 0x10;
	public static final int DCX_INTERSECTRGN = 0x80;
	public static final int DCX_WINDOW = 0x1;
	public static final int DEFAULT_CHARSET = 0x1;
	public static final int DEFAULT_GUI_FONT = 0x11;
	public static final int DFCS_BUTTONCHECK = 0x0;
	public static final int DFCS_CHECKED = 0x400;
	public static final int DFCS_FLAT = 0x4000;
	public static final int DFCS_INACTIVE = 0x100;
	public static final int DFCS_PUSHED = 0x200;
	public static final int DFCS_SCROLLDOWN = 0x1;
	public static final int DFCS_SCROLLLEFT = 0x2;
	public static final int DFCS_SCROLLRIGHT = 0x3;
	public static final int DFCS_SCROLLUP = 0x0;
	public static final int DFC_BUTTON = 0x4;
	public static final int DFC_SCROLL = 0x3;
	public static final int DIB_RGB_COLORS = 0x0;
	public static final int DISP_E_EXCEPTION = 0x80020009;
	public static final int DI_NORMAL = 0x3;
	public static final int DI_NOMIRROR = 0x10;
	public static final int DLGC_BUTTON = 0x2000;
	public static final int DLGC_HASSETSEL = 0x8;
	public static final int DLGC_STATIC = 0x100;
	public static final int DLGC_WANTALLKEYS = 0x4;
	public static final int DLGC_WANTARROWS = 0x1;
	public static final int DLGC_WANTCHARS = 0x80;
	public static final int DLGC_WANTTAB = 0x2;
	public static final short DMCOLLATE_FALSE = 0;
	public static final short DMCOLLATE_TRUE = 1;
	public static final int DM_SETDEFID = 0x401;
	public static final int DM_COLLATE = 0x00008000;
	public static final int DM_COPIES = 0x00000100;
	public static final int DM_DUPLEX = 0x00001000;
	public static final int DM_ORIENTATION = 0x00000001;
	public static final int DM_OUT_BUFFER = 2;
	public static final short DMORIENT_PORTRAIT = 1;
	public static final short DMORIENT_LANDSCAPE = 2;
	public static final short DMDUP_SIMPLEX = 1;
	public static final short DMDUP_VERTICAL = 2;
	public static final short DMDUP_HORIZONTAL = 3;
	public static final int DSTINVERT = 0x550009;
	public static final int DT_BOTTOM = 0x8;
	public static final int DT_CALCRECT = 0x400;
	public static final int DT_CENTER = 0x1;
	public static final int DT_EDITCONTROL = 0x2000;
	public static final int DT_EXPANDTABS = 0x40;
	public static final int DT_ENDELLIPSIS = 32768;
	public static final int DT_HIDEPREFIX = 0x100000;
	public static final int DT_LEFT = 0x0;
	public static final int DT_NOPREFIX = 0x800;
	public static final int DT_RASPRINTER = 0x2;
	public static final int DT_RIGHT = 0x2;
	public static final int DT_RTLREADING = 0x00020000;
	public static final int DT_SINGLELINE = 0x20;
	public static final int DT_TOP = 0;
	public static final int DT_VCENTER = 4;
	public static final int DT_WORDBREAK = 0x10;
	public static final int DTM_FIRST = 0x1000;
	public static final int DTM_GETSYSTEMTIME = DTM_FIRST + 1;
	public static final int DTM_SETMCSTYLE = DTM_FIRST + 11;
	public static final int DTM_GETIDEALSIZE = DTM_FIRST + 15;
	public static final int DTM_SETFORMAT = DTM_FIRST + 50;
	public static final int DTM_SETSYSTEMTIME = DTM_FIRST + 2;
	public static final int DTN_FIRST = 0xFFFFFD08;
	public static final int DTN_DATETIMECHANGE = DTN_FIRST + 1;
	public static final int DTN_CLOSEUP = DTN_FIRST + 7;
	public static final int DTN_DROPDOWN = DTN_FIRST + 6;
	public static final int DTS_LONGDATEFORMAT = 0x0004;
	public static final int DTS_SHORTDATECENTURYFORMAT = 0x000C;
	public static final int DTS_SHORTDATEFORMAT = 0x0000;
	public static final int DTS_TIMEFORMAT = 0x0009;
	public static final int DTS_UPDOWN = 0x0001;
	public static final int E_POINTER = 0x80004003;
	public static final int EBP_NORMALGROUPBACKGROUND = 5;
	public static final int EBP_NORMALGROUPCOLLAPSE = 6;
	public static final int EBP_NORMALGROUPEXPAND = 7;
	public static final int EBP_NORMALGROUPHEAD = 8;
	public static final int EBNGC_NORMAL = 1;
	public static final int EBNGC_HOT = 2;
	public static final int EBNGC_PRESSED = 3;
	public static final int EBP_HEADERBACKGROUND = 1;
	public static final int EC_LEFTMARGIN = 0x1;
	public static final int EC_RIGHTMARGIN = 0x2;
	public static final int EDGE_RAISED = (BDR_RAISEDOUTER | BDR_RAISEDINNER);
	public static final int EDGE_SUNKEN = (BDR_SUNKENOUTER | BDR_SUNKENINNER);
	public static final int EDGE_ETCHED = (BDR_SUNKENOUTER | BDR_RAISEDINNER);
	public static final int EDGE_BUMP = (BDR_RAISEDOUTER | BDR_SUNKENINNER);
	public static final int ELF_VENDOR_SIZE = 4;
	public static final int EM_CANUNDO = 0xc6;
	public static final int EM_CHARFROMPOS = 0xd7;
	public static final int EM_DISPLAYBAND = 0x433;
	public static final int EM_GETFIRSTVISIBLELINE = 0xce;
	public static final int EM_GETLIMITTEXT = 0xd5;
	public static final int EM_GETLINE = 0xc4;
	public static final int EM_GETLINECOUNT = 0xba;
	public static final int EM_GETMARGINS = 0xd4;
	public static final int EM_GETPASSWORDCHAR = 0xd2;
	public static final int EM_GETSCROLLPOS = 0x4dd;
	public static final int EM_GETSEL = 0xb0;
	public static final int EM_LIMITTEXT = 0xc5;
	public static final int EM_LINEFROMCHAR = 0xc9;
	public static final int EM_LINEINDEX = 0xbb;
	public static final int EM_LINELENGTH = 0xc1;
	public static final int EM_LINESCROLL = 0xb6;
	public static final int EM_POSFROMCHAR = 0xd6;
	public static final int EM_REPLACESEL = 0xc2;
	public static final int EM_SCROLLCARET = 0xb7;
	public static final int EM_SETBKGNDCOLOR = 0x443;
	public static final int EM_SETLIMITTEXT = 0xc5;
	public static final int EM_SETMARGINS = 211;
	public static final int EM_SETOPTIONS = 0x44d;
	public static final int EM_SETPARAFORMAT = 0x447;
	public static final int EM_SETPASSWORDCHAR = 0xcc;
	public static final int EM_SETCUEBANNER = 0x1500 + 1;
	public static final int EM_SETREADONLY = 0xcf;
	public static final int EM_SETRECT = 0xb3;
	public static final int EM_SETSEL = 0xb1;
	public static final int EM_SETTABSTOPS = 0xcb;
	public static final int EM_UNDO = 199;
	public static final int EMR_EXTCREATEFONTINDIRECTW = 82;
	public static final int EMR_EXTTEXTOUTW = 84;
	public static final int EN_ALIGN_LTR_EC = 0x0700;
	public static final int EN_ALIGN_RTL_EC = 0x0701;
	public static final int EN_CHANGE = 0x300;
	public static final int EP_EDITTEXT = 1;
	public static final int ERROR_FILE_NOT_FOUND = 0x2;
	public static final int ERROR_NO_MORE_ITEMS = 0x103;
	public static final int ESB_DISABLE_BOTH = 0x3;
	public static final int ESB_ENABLE_BOTH = 0x0;
	public static final int ES_AUTOHSCROLL = 0x80;
	public static final int ES_AUTOVSCROLL = 0x40;
	public static final int ES_CENTER = 0x1;
	public static final int ES_MULTILINE = 0x4;
	public static final int ES_NOHIDESEL = 0x100;
	public static final int ES_PASSWORD = 0x20;
	public static final int ES_READONLY = 0x800;
	public static final int ES_RIGHT = 0x2;
	public static final int ETO_CLIPPED = 0x4;
	public static final int ETS_NORMAL = 1;
	public static final int ETS_HOT = 2;
	public static final int ETS_SELECTED = 3;
	public static final int ETS_DISABLED = 4;
	public static final int ETS_FOCUSED = 5;
	public static final int ETS_READONLY = 6;
	public static final int EVENT_OBJECT_FOCUS = 0x8005;
	public static final int EVENT_OBJECT_LOCATIONCHANGE = 0x800B;
	public static final int EVENT_OBJECT_SELECTIONWITHIN = 0x8009;
	public static final int EVENT_OBJECT_VALUECHANGE = 0x800E;
	public static final short FADF_FIXEDSIZE = 0x10;
	public static final short FADF_HAVEVARTYPE = 0x80;
	public static final int FALT = 0x10;
	public static final int FCONTROL = 0x8;
	public static final int FE_FONTSMOOTHINGCLEARTYPE = 0x0002;
	public static final int FEATURE_DISABLE_NAVIGATION_SOUNDS = 21;
	public static final int FILE_ATTRIBUTE_DIRECTORY = 0x00000010;
	public static final int FILE_ATTRIBUTE_NORMAL = 0x00000080;
	public static final int FILE_MAP_READ = 4;
	public static final int FLICKDIRECTION_RIGHT = 0;
	public static final int FLICKDIRECTION_UPRIGHT = 1;
	public static final int FLICKDIRECTION_UP = 2;
	public static final int FLICKDIRECTION_UPLEFT = 3;
	public static final int FLICKDIRECTION_LEFT = 4;
	public static final int FLICKDIRECTION_DOWNLEFT = 5;
	public static final int FLICKDIRECTION_DOWN = 6;
	public static final int FLICKDIRECTION_DOWNRIGHT = 7;
	public static final int FLICKDIRECTION_INVALID = 8;
	public static final int FNERR_INVALIDFILENAME = 0x3002;
	public static final int FNERR_BUFFERTOOSMALL = 0x3003;
	public static final int FOF_SILENT = 0x0004;
	public static final int FOF_NOCONFIRMATION = 0x0010;
	public static final int FOF_NOCONFIRMMKDIR = 0x0200;
	public static final int FOF_NOERRORUI = 0x0400;
	public static final int FOF_NO_UI = (FOF_SILENT | FOF_NOCONFIRMATION | FOF_NOERRORUI | FOF_NOCONFIRMMKDIR);
	public static final int FORMAT_MESSAGE_ALLOCATE_BUFFER = 0x00000100;
	public static final int FORMAT_MESSAGE_FROM_SYSTEM = 0x00001000;
	public static final int FORMAT_MESSAGE_IGNORE_INSERTS = 0x00000200;
	public static final int FOS_NOCHANGEDIR = 0x8;
	public static final int FOS_PICKFOLDERS = 0x20;
	public static final int FOS_FORCEFILESYSTEM = 0x40;
	public static final int FR_PRIVATE = 0x10;
	public static final int FSHIFT = 0x4;
	public static final int FVIRTKEY = 0x1;
	public static final int GBS_NORMAL = 1;
	public static final int GBS_DISABLED = 2;
	public static final int GBF_DIRECT = 0x00000001;
	public static final int GBF_COPY = 0x00000002;
	public static final int GBF_VALIDBITS = 0x00000003;
	public static final int GCP_REORDER = 0x0002;
	public static final int GCP_GLYPHSHAPE = 0x0010;
	public static final int GCP_CLASSIN = 0x00080000;
	public static final int GCP_LIGATE = 0x0020;
	public static final int GCS_COMPSTR = 0x8;
	public static final int GCS_RESULTSTR = 0x800;
	public static final int GCS_COMPATTR = 0x0010;
	public static final int GCS_COMPCLAUSE = 0x0020;
	public static final int GCS_CURSORPOS = 0x0080;
	public static final int GET_FEATURE_FROM_PROCESS = 0x2;
	public static final int GF_BEGIN = 1;
	public static final int GF_INERTIA = 2;
	public static final int GF_END = 4;
	public static final int GGI_MARK_NONEXISTING_GLYPHS = 1;
	public static final int GID_BEGIN = 1;
	public static final int GID_END = 2;
	public static final int GID_ZOOM = 3;
	public static final int GID_PAN = 4;
	public static final int GID_ROTATE = 5;
	public static final int GID_TWOFINGERTAP = 6;
	public static final int GID_PRESSANDTAP = 7;
	public static final int GLPS_CLOSED = 1;
	public static final int GLPS_OPENED = 2;
	public static final int GM_ADVANCED = 2;
	public static final int GMDI_USEDISABLED = 0x1;
	public static final int GMEM_FIXED = 0x0;
	public static final int GMEM_MOVEABLE = 0x2;
	public static final int GMEM_ZEROINIT = 0x40;
	public static final int GRADIENT_FILL_RECT_H = 0x0;
	public static final int GRADIENT_FILL_RECT_V = 0x1;
	public static final int GUI_16BITTASK = 0x20;
	public static final int GUI_CARETBLINKING = 0x1;
	public static final int GUI_INMENUMODE = 0x4;
	public static final int GUI_INMOVESIZE = 0x2;
	public static final int GUI_POPUPMENUMODE = 0x10;
	public static final int GUI_SYSTEMMENUMODE = 0x8;
	public static final int GWL_EXSTYLE = 0xffffffec;
	public static final int GWL_ID = -12;
	public static final int GWL_HWNDPARENT = -8;
	public static final int GWL_STYLE = 0xfffffff0;
	public static final int GWL_USERDATA = 0xffffffeb;
	public static final int GWL_WNDPROC = 0xfffffffc;
	public static final int GWLP_ID = -12;
	public static final int GWLP_HWNDPARENT = -8;
	public static final int GWLP_USERDATA = 0xffffffeb;
	public static final int GWLP_WNDPROC = 0xfffffffc;
	public static final int GW_CHILD = 0x5;
	public static final int GW_HWNDFIRST = 0x0;
	public static final int GW_HWNDLAST = 0x1;
	public static final int GW_HWNDNEXT = 0x2;
	public static final int GW_HWNDPREV = 0x3;
	public static final int GW_OWNER = 0x4;
	public static final int HBMMENU_CALLBACK = 0xffffffff;
	public static final int HCBT_CREATEWND = 3;
	public static final int HCF_HIGHCONTRASTON = 0x1;
	public static final int HDF_BITMAP = 0x2000;
	public static final int HDF_BITMAP_ON_RIGHT = 0x1000;
	public static final int HDF_CENTER = 2;
	public static final int HDF_JUSTIFYMASK = 0x3;
	public static final int HDF_IMAGE = 0x0800;
	public static final int HDF_LEFT = 0;
	public static final int HDF_OWNERDRAW = 0x8000;
	public static final int HDF_RIGHT = 1;
	public static final int HDF_SORTUP = 0x0400;
	public static final int HDF_SORTDOWN = 0x0200;
	public static final int HDI_BITMAP = 0x0010;
	public static final int HDI_IMAGE = 32;
	public static final int HDI_ORDER = 0x80;
	public static final int HDI_TEXT = 0x2;
	public static final int HDI_WIDTH = 0x1;
	public static final int HDI_FORMAT = 0x4;
	public static final int HDM_FIRST = 0x1200;
	public static final int HDM_DELETEITEM = HDM_FIRST + 2;
	public static final int HDM_GETBITMAPMARGIN = HDM_FIRST + 21;
	public static final int HDM_GETITEMCOUNT = 0x1200;
	public static final int HDM_GETITEMA = HDM_FIRST + 3;
	public static final int HDM_GETITEMW = HDM_FIRST + 11;
	public static final int HDM_GETITEM = IsUnicode ? HDM_GETITEMW : HDM_GETITEMA;
	public static final int HDM_GETITEMRECT = HDM_FIRST + 7;
	public static final int HDM_GETORDERARRAY = HDM_FIRST + 17;
	public static final int HDM_HITTEST = HDM_FIRST + 6;
	public static final int HDM_INSERTITEMA = HDM_FIRST + 1;
	public static final int HDM_INSERTITEMW = HDM_FIRST + 10;
	public static final int HDM_INSERTITEM = IsUnicode ? HDM_INSERTITEMW : HDM_INSERTITEMA;
	public static final int HDM_LAYOUT = HDM_FIRST + 5;
	public static final int HDM_ORDERTOINDEX = HDM_FIRST + 15;
	public static final int HDM_SETIMAGELIST = HDM_FIRST + 8;
	public static final int HDM_SETITEMA = HDM_FIRST + 4;
	public static final int HDM_SETITEMW = HDM_FIRST + 12;
	public static final int HDM_SETITEM = IsUnicode ? HDM_SETITEMW : HDM_SETITEMA;
	public static final int HDM_SETORDERARRAY = HDM_FIRST + 18;
	public static final int HDN_FIRST = 0xfffffed4;
	public static final int HDN_BEGINDRAG = HDN_FIRST - 10;
	public static final int HDN_BEGINTRACK = IsUnicode ? 0xfffffeba : 0xfffffece;
	public static final int HDN_BEGINTRACKW = 0xfffffeba;
	public static final int HDN_BEGINTRACKA = 0xfffffece;
	public static final int HDN_DIVIDERDBLCLICKA = HDN_FIRST - 5;
	public static final int HDN_DIVIDERDBLCLICKW = HDN_FIRST - 25;
	public static final int HDN_DIVIDERDBLCLICK = IsUnicode ? HDN_DIVIDERDBLCLICKW : HDN_DIVIDERDBLCLICKA;
	public static final int HDN_ENDDRAG = HDN_FIRST - 11;
	public static final int HDN_ITEMCHANGED = IsUnicode ? 0xfffffebf : 0xfffffed3;
	public static final int HDN_ITEMCHANGEDW = 0xfffffebf;
	public static final int HDN_ITEMCHANGEDA = 0xfffffed3;
	public static final int HDN_ITEMCHANGINGW = HDN_FIRST - 20;
	public static final int HDN_ITEMCHANGINGA = HDN_FIRST;
	public static final int HDN_ITEMCLICKW = HDN_FIRST - 22;
	public static final int HDN_ITEMCLICKA = HDN_FIRST - 2;
	public static final int HDN_ITEMDBLCLICKW = HDN_FIRST - 23;
	public static final int HDN_ITEMDBLCLICKA = HDN_FIRST - 3;
	public static final int HDN_ITEMDBLCLICK = IsUnicode ? HDN_ITEMDBLCLICKW : HDN_ITEMDBLCLICKA;
	public static final int HDS_BUTTONS = 0x2;
	public static final int HDS_CHECKBOXES = 0x400;
	public static final int HDS_DRAGDROP = 0x0040;
	public static final int HDS_FILTERBAR = 0x100;
	public static final int HDS_FLAT = 0x200;
	public static final int HDS_FULLDRAG = 0x80;
	public static final int HDS_HIDDEN = 0x8;
	public static final int HDS_HOTTRACK = 0x4;
	public static final int HDS_NOSIZING = 0x800;
	public static final int HDS_OVERFLOW = 0x1000;
	public static final int HEAP_ZERO_MEMORY = 0x8;
	public static final int HELPINFO_MENUITEM = 0x2;
	public static final int HHT_ONDIVIDER = 0x4;
	public static final int HHT_ONDIVOPEN = 0x8;
	public static final int HICF_ARROWKEYS = 0x2;
	public static final int HICF_LEAVING = 0x20;
	public static final int HICF_MOUSE = 0x1;
	public static final int HINST_COMMCTRL = 0xffffffff;
	public static final int HKEY_CLASSES_ROOT = 0x80000000;
	public static final int HKEY_CURRENT_USER = 0x80000001;
	public static final int HKEY_LOCAL_MACHINE = 0x80000002;
	public static final int HORZRES = 0x8;
	public static final int HTBORDER = 0x12;
	public static final int HTCAPTION = 0x2;
	public static final int HTCLIENT = 0x1;
	public static final int HTERROR = -2;
	public static final int HTHSCROLL = 0x6;
	public static final int HTMENU = 0x5;
	public static final int HTNOWHERE = 0x0;
	public static final int HTSYSMENU = 0x3;
	public static final int HTTRANSPARENT = 0xffffffff;
	public static final int HTVSCROLL = 0x7;
	public static final int HWND_BOTTOM = 0x1;
	public static final int HWND_TOP = 0x0;
	public static final int HWND_TOPMOST = 0xffffffff;
	public static final int HWND_NOTOPMOST = -2;
	public static final int ICC_COOL_CLASSES = 0x400;
	public static final int ICC_DATE_CLASSES = 0x100;
	public static final int ICM_NOTOPEN = 0x0;
	public static final int ICON_BIG = 0x1;
	public static final int ICON_SMALL = 0x0;
	public static final int I_IMAGECALLBACK = -1;
	public static final int I_IMAGENONE = -2;
	public static final int IDABORT = 0x3;
	public static final int IDANI_CAPTION = 3;
	public static final int IDB_STD_SMALL_COLOR = 0x0;
	public static final int IDC_APPSTARTING = 0x7f8a;
	public static final int IDC_ARROW = 0x7f00;
	public static final int IDC_CROSS = 0x7f03;
	public static final int IDC_HAND = 0x7f89;
	public static final int IDC_HELP = 0x7f8b;
	public static final int IDC_IBEAM = 0x7f01;
	public static final int IDC_NO = 0x7f88;
	public static final int IDC_SIZE = 0x7f80;
	public static final int IDC_SIZEALL = 0x7f86;
	public static final int IDC_SIZENESW = 0x7f83;
	public static final int IDC_SIZENS = 0x7f85;
	public static final int IDC_SIZENWSE = 0x7f82;
	public static final int IDC_SIZEWE = 0x7f84;
	public static final int IDC_UPARROW = 0x7f04;
	public static final int IDC_WAIT = 0x7f02;
	public static final int IDI_APPLICATION = 32512;
	public static final int IDNO = 0x7;
	public static final int IDOK = 0x1;
	public static final int IDRETRY = 0x4;
	public static final int IDYES = 0x6;
	public static final int ILC_COLOR = 0x0;
	public static final int ILC_COLOR16 = 0x10;
	public static final int ILC_COLOR24 = 0x18;
	public static final int ILC_COLOR32 = 0x20;
	public static final int ILC_COLOR4 = 0x4;
	public static final int ILC_COLOR8 = 0x8;
	public static final int ILC_MASK = 0x1;
	public static final int ILC_MIRROR = 0x2000;
	public static final int IMAGE_ICON = 0x1;
	public static final int IME_CMODE_FULLSHAPE = 0x8;
	public static final int IME_CMODE_KATAKANA = 0x2;
	public static final int IME_CMODE_NATIVE = 0x1;
	public static final int IME_CMODE_ROMAN = 0x10;
	public static final int IME_ESC_HANJA_MODE = 0x1008;
	public static final int IMEMOUSE_LDOWN = 1;
	public static final int INPUT_KEYBOARD = 1;
	public static final int INPUT_MOUSE = 0;
	public static final int INTERNET_MAX_URL_LENGTH = 2084;
	public static final int INTERNET_OPTION_END_BROWSER_SESSION = 42;
	public static final int KEY_ENUMERATE_SUB_KEYS = 0x8;
	public static final int KEY_NOTIFY = 0x10;
	public static final int KEY_QUERY_VALUE = 0x1;
	public static final int KEY_READ = 0x20019;
	public static final int KEY_WRITE = 0x20006;
	public static final int KEYEVENTF_EXTENDEDKEY = 0x0001;
	public static final int KEYEVENTF_KEYUP = 0x0002;
	public static final int L_MAX_URL_LENGTH = 2084;
	public static final int LANG_JAPANESE = 0x11;
	public static final int LANG_KOREAN = 0x12;
	public static final int LANG_NEUTRAL = 0x0;
	public static final int LANG_USER_DEFAULT = 1 << 10;
	public static final int LAYOUT_RTL = 0x1;
	public static final int LBN_DBLCLK = 0x2;
	public static final int LBN_SELCHANGE = 0x1;
	public static final int LBS_EXTENDEDSEL = 0x800;
	public static final int LBS_MULTIPLESEL = 0x8;
	public static final int LBS_NOINTEGRALHEIGHT = 0x100;
	public static final int LBS_NOTIFY = 0x1;
	public static final int LB_ADDSTRING = 0x180;
	public static final int LB_DELETESTRING = 0x182;
	public static final int LB_ERR = 0xffffffff;
	public static final int LB_ERRSPACE = 0xfffffffe;
	public static final int LB_FINDSTRINGEXACT = 0x1a2;
	public static final int LB_GETCARETINDEX = 0x19f;
	public static final int LB_GETCOUNT = 0x18b;
	public static final int LB_GETCURSEL = 0x188;
	public static final int LB_GETHORIZONTALEXTENT = 0x193;
	public static final int LB_GETITEMHEIGHT = 0x1a1;
	public static final int LB_GETITEMRECT = 0x198;
	public static final int LB_GETSEL = 0x187;
	public static final int LB_GETSELCOUNT = 0x190;
	public static final int LB_GETSELITEMS = 0x191;
	public static final int LB_GETTEXT = 0x189;
	public static final int LB_GETTEXTLEN = 0x18a;
	public static final int LB_GETTOPINDEX = 0x18e;
	public static final int LB_INITSTORAGE = 0x1a8;
	public static final int LB_INSERTSTRING = 0x181;
	public static final int LB_RESETCONTENT = 0x184;
	public static final int LB_SELITEMRANGE = 0x19b;
	public static final int LB_SELITEMRANGEEX = 0x183;
	public static final int LB_SETANCHORINDEX = 0xf19c;
	public static final int LB_SETCARETINDEX = 0x19e;
	public static final int LB_SETCURSEL = 0x186;
	public static final int LB_SETHORIZONTALEXTENT = 0x194;
	public static final int LB_SETSEL = 0x185;
	public static final int LB_SETTOPINDEX = 0x197;
	public static final int LF_FULLFACESIZE = 64;
	public static final int LF_FACESIZE = 32;
	public static final int LGRPID_ARABIC = 0xd;
	public static final int LGRPID_HEBREW = 0xc;
	public static final int LGRPID_INSTALLED = 1;
	public static final int LIF_ITEMINDEX = 0x1;
	public static final int LIF_STATE = 0x2;
	public static final int LIS_FOCUSED = 0x1;
	public static final int LIS_ENABLED = 0x2;
	public static final int LISS_HOT = 0x2;
	public static final int LISS_SELECTED = 0x3;
	public static final int LISS_SELECTEDNOTFOCUS = 0x5;
	public static final int LM_GETIDEALHEIGHT = 0x701;
	public static final int LM_SETITEM = 0x702;
	public static final int LM_GETITEM = 0x703;
	public static final int LCID_SUPPORTED = 0x2;
	public static final int LOCALE_IDEFAULTANSICODEPAGE = 0x1004;
	public static final int LOCALE_SDECIMAL = 14;
	public static final int LOCALE_SISO3166CTRYNAME = 0x5a;
	public static final int LOCALE_SISO639LANGNAME = 0x59;
	public static final int LOCALE_STIMEFORMAT = 0x00001003;
	public static final int LOCALE_SYEARMONTH = 0x00001006;
	public static final int LOCALE_USER_DEFAULT = 1024;
	public static final int LOGPIXELSX = 0x58;
	public static final int LOGPIXELSY = 0x5a;
	public static final int LPSTR_TEXTCALLBACK = 0xffffffff;
	public static final int LR_DEFAULTCOLOR = 0x0;
	public static final int LR_SHARED = 0x8000;
	public static final int LVCFMT_BITMAP_ON_RIGHT = 0x1000;
	public static final int LVCFMT_CENTER = 0x2;
	public static final int LVCFMT_IMAGE = 0x800;
	public static final int LVCFMT_LEFT = 0x0;
	public static final int LVCFMT_RIGHT = 0x1;
	public static final int LVCF_FMT = 0x1;
	public static final int LVCF_IMAGE = 0x10;
	public static final int LVCFMT_JUSTIFYMASK = 0x3;
	public static final int LVCF_TEXT = 0x4;
	public static final int LVCF_WIDTH = 0x2;
	public static final int LVHT_ONITEM = 0xe;
	public static final int LVHT_ONITEMICON = 0x2;
	public static final int LVHT_ONITEMLABEL = 0x4;
	public static final int LVHT_ONITEMSTATEICON = 0x8;
	public static final int LVIF_IMAGE = 0x2;
	public static final int LVIF_INDENT = 0x10;
	public static final int LVIF_STATE = 0x8;
	public static final int LVIF_TEXT = 0x1;
	public static final int LVIM_AFTER = 0x00000001;
	public static final int LVIR_BOUNDS = 0x0;
	public static final int LVIR_ICON = 0x1;
	public static final int LVIR_LABEL = 0x2;
	public static final int LVIR_SELECTBOUNDS = 0x3;
	public static final int LVIS_DROPHILITED = 0x8;
	public static final int LVIS_FOCUSED = 0x1;
	public static final int LVIS_SELECTED = 0x2;
	public static final int LVIS_STATEIMAGEMASK = 0xf000;
	public static final int LVM_FIRST = 0x1000;
	public static final int LVM_APPROXIMATEVIEWRECT = 0x1040;
	public static final int LVM_CREATEDRAGIMAGE = LVM_FIRST + 33;
	public static final int LVM_DELETEALLITEMS = 0x1009;
	public static final int LVM_DELETECOLUMN = 0x101c;
	public static final int LVM_DELETEITEM = 0x1008;
	public static final int LVM_ENSUREVISIBLE = 0x1013;
	public static final int LVM_GETBKCOLOR = 0x1000;
	public static final int LVM_GETCOLUMN = 0x105f;
	public static final int LVM_GETCOLUMNORDERARRAY = LVM_FIRST + 59;
	public static final int LVM_GETCOLUMNWIDTH = 0x101d;
	public static final int LVM_GETCOUNTPERPAGE = 0x1028;
	public static final int LVM_GETEXTENDEDLISTVIEWSTYLE = 0x1037;
	public static final int LVM_GETHEADER = 0x101f;
	public static final int LVM_GETIMAGELIST = 0x1002;
	public static final int LVM_GETITEM = IsUnicode ? 0x104b : 0x1005;
	public static final int LVM_GETITEMW = 0x104b;
	public static final int LVM_GETITEMA = 0x1005;
	public static final int LVM_GETITEMCOUNT = 0x1004;
	public static final int LVM_GETITEMRECT = 0x100e;
	public static final int LVM_GETITEMSTATE = 0x102c;
	public static final int LVM_GETNEXTITEM = 0x100c;
	public static final int LVM_GETSELECTEDCOLUMN = LVM_FIRST + 174;
	public static final int LVM_GETSELECTEDCOUNT = 0x1032;
	public static final int LVM_GETSTRINGWIDTH = 0x1057;
	public static final int LVM_GETSUBITEMRECT = 0x1038;
	public static final int LVM_GETTEXTCOLOR = 0x1023;
	public static final int LVM_GETTOOLTIPS = 0x104e;
	public static final int LVM_GETTOPINDEX = 0x1027;
	public static final int LVM_HITTEST = 0x1012;
	public static final int LVM_INSERTCOLUMN = 0x1061;
	public static final int LVM_INSERTITEM = 0x104d;
	public static final int LVM_REDRAWITEMS = LVM_FIRST + 21;
	public static final int LVM_SCROLL = 0x1014;
	public static final int LVM_SETBKCOLOR = 0x1001;
	public static final int LVM_SETCALLBACKMASK = LVM_FIRST + 11;
	public static final int LVM_SETCOLUMN = 0x1060;
	public static final int LVM_SETCOLUMNORDERARRAY = LVM_FIRST + 58;
	public static final int LVM_SETCOLUMNWIDTH = 0x101e;
	public static final int LVM_SETEXTENDEDLISTVIEWSTYLE = 0x1036;
	public static final int LVM_SETIMAGELIST = 0x1003;
	public static final int LVM_SETINSERTMARK = LVM_FIRST + 166;
	public static final int LVM_SETITEM = 0x104c;
	public static final int LVM_SETITEMCOUNT = LVM_FIRST + 47;
	public static final int LVM_SETITEMSTATE = 0x102b;
	public static final int LVM_SETSELECTIONMARK = LVM_FIRST + 67;
	public static final int LVM_SETSELECTEDCOLUMN = LVM_FIRST + 140;
	public static final int LVM_SETTEXTBKCOLOR = 0x1026;
	public static final int LVM_SETTEXTCOLOR = 0x1024;
	public static final int LVM_SETTOOLTIPS = LVM_FIRST + 74;
	public static final int LVM_SUBITEMHITTEST = LVM_FIRST + 57;
	public static final int LVNI_FOCUSED = 0x1;
	public static final int LVNI_SELECTED = 0x2;
	public static final int LVN_BEGINDRAG = 0xffffff93;
	public static final int LVN_BEGINRDRAG = 0xffffff91;
	public static final int LVN_COLUMNCLICK = 0xffffff94;
	public static final int LVN_FIRST = 0xffffff9c;
	public static final int LVN_GETDISPINFOA = LVN_FIRST - 50;
	public static final int LVN_GETDISPINFOW = LVN_FIRST - 77;
	public static final int LVN_ITEMACTIVATE = 0xffffff8e;
	public static final int LVN_ITEMCHANGED = 0xffffff9b;
	public static final int LVN_MARQUEEBEGIN = 0xffffff64;
	public static final int LVN_ODFINDITEMA = LVN_FIRST - 52;
	public static final int LVN_ODFINDITEMW = LVN_FIRST - 79;
	public static final int LVN_ODSTATECHANGED = LVN_FIRST - 15;
	public static final int LVP_LISTITEM = 1;
	public static final int LVSCW_AUTOSIZE = 0xffffffff;
	public static final int LVSCW_AUTOSIZE_USEHEADER = 0xfffffffe;
	public static final int LVSICF_NOINVALIDATEALL = 0x1;
	public static final int LVSICF_NOSCROLL = 0x2;
	public static final int LVSIL_SMALL = 0x1;
	public static final int LVSIL_STATE = 0x2;
	public static final int LVS_EX_DOUBLEBUFFER = 0x10000;
	public static final int LVS_EX_FULLROWSELECT = 0x20;
	public static final int LVS_EX_GRIDLINES = 0x1;
	public static final int LVS_EX_HEADERDRAGDROP = 0x10;
	public static final int LVS_EX_LABELTIP = 0x4000;
	public static final int LVS_EX_ONECLICKACTIVATE = 0x40;
	public static final int LVS_EX_SUBITEMIMAGES = 0x2;
	public static final int LVS_EX_TRACKSELECT = 0x8;
	public static final int LVS_EX_TRANSPARENTBKGND = 0x800000;
	public static final int LVS_EX_TWOCLICKACTIVATE = 0x80;
	public static final int LVS_LIST = 0x3;
	public static final int LVS_NOCOLUMNHEADER = 0x4000;
	public static final int LVS_NOSCROLL = 0x2000;
	public static final int LVS_OWNERDATA = 0x1000;
	public static final int LVS_OWNERDRAWFIXED = 0x400;
	public static final int LVS_REPORT = 0x1;
	public static final int LVS_SHAREIMAGELISTS = 0x40;
	public static final int LVS_SHOWSELALWAYS = 0x8;
	public static final int LVS_SINGLESEL = 0x4;
	public static final int LWA_COLORKEY = 0x00000001;
	public static final int LWA_ALPHA = 0x00000002;
	public static final int MAX_LINKID_TEXT = 48;
	public static final int MAX_PATH = 260;
	public static final int MA_NOACTIVATE = 0x3;
	public static final int MB_ABORTRETRYIGNORE = 0x2;
	public static final int MB_APPLMODAL = 0x0;
	public static final int MB_ICONERROR = 0x10;
	public static final int MB_ICONINFORMATION = 0x40;
	public static final int MB_ICONQUESTION = 0x20;
	public static final int MB_ICONWARNING = 0x30;
	public static final int MB_OK = 0x0;
	public static final int MB_OKCANCEL = 0x1;
	public static final int MB_PRECOMPOSED = 0x1;
	public static final int MB_RETRYCANCEL = 0x5;
	public static final int MB_RIGHT = 0x00080000;
	public static final int MB_RTLREADING = 0x100000;
	public static final int MB_SYSTEMMODAL = 0x1000;
	public static final int MB_TASKMODAL = 0x2000;
	public static final int MB_TOPMOST = 0x00040000;
	public static final int MB_YESNO = 0x4;
	public static final int MB_YESNOCANCEL = 0x3;
	public static final int MCHT_CALENDAR = 0x20000;
	public static final int MCHT_CALENDARDATE = MCHT_CALENDAR | 0x0001;
	public static final int MCM_FIRST = 0x1000;
	public static final int MCM_GETCURSEL = MCM_FIRST + 1;
	public static final int MCM_GETMINREQRECT = MCM_FIRST + 9;
	public static final int MCM_HITTEST = MCM_FIRST + 14;
	public static final int MCM_SETCURSEL = MCM_FIRST + 2;
	public static final int MCN_FIRST = 0xFFFFFD12;
	public static final int MCN_SELCHANGE = MCN_FIRST + 1;
	public static final int MCN_SELECT = MCN_FIRST + 4;
	public static final int MCS_NOTODAY = 0x0010;
	public static final int MCS_WEEKNUMBERS = 0x0004;
	public static final int MDIS_ALLCHILDSTYLES = 0x0001;
	public static final int MDT_EFFECTIVE_DPI = 0;
	public static final int MFS_CHECKED = 0x8;
	public static final int MFS_DISABLED = 0x3;
	public static final int MFS_GRAYED = 0x3;
	public static final int MFT_RADIOCHECK = 0x200;
	public static final int MFT_RIGHTJUSTIFY = 0x4000;
	public static final int MFT_RIGHTORDER = 0x2000;
	public static final int MFT_SEPARATOR = 0x800;
	public static final int MFT_STRING = 0x0;
	public static final int MF_BYCOMMAND = 0x0;
	public static final int MF_BYPOSITION = 0x400;
	public static final int MF_CHECKED = 0x8;
	public static final int MF_DISABLED = 0x2;
	public static final int MF_ENABLED = 0x0;
	public static final int MF_GRAYED = 0x1;
	public static final int MF_HILITE = 0x80;
	public static final int MF_POPUP = 0x10;
	public static final int MF_SEPARATOR = 0x800;
	public static final int MF_SYSMENU = 0x2000;
	public static final int MF_UNCHECKED = 0x0;
	public static final int MIIM_BITMAP = 0x80;
	public static final int MIIM_DATA = 0x20;
	public static final int MIIM_FTYPE = 0x100;
	public static final int MIIM_ID = 0x2;
	public static final int MIIM_STATE = 0x1;
	public static final int MIIM_STRING = 0x40;
	public static final int MIIM_SUBMENU = 0x4;
	public static final int MIIM_TYPE = 0x10;
	public static final int MIM_BACKGROUND = 0x2;
	public static final int MIM_STYLE = 0x10;
	public static final int MK_ALT = 0x20;
	public static final int MK_CONTROL = 0x8;
	public static final int MK_LBUTTON = 0x1;
	public static final int MK_MBUTTON = 0x10;
	public static final int MK_RBUTTON = 0x2;
	public static final int MK_SHIFT = 0x4;
	public static final int MK_XBUTTON1 = 0x20;
	public static final int MK_XBUTTON2 = 0x40;
	public static final int MM_TEXT = 0x1;
	public static final int MNC_CLOSE = 0x1;
	public static final int MNS_CHECKORBMP = 0x4000000;
	public static final int MONITOR_DEFAULTTOPRIMARY = 0x1;
	public static final int MONITOR_DEFAULTTONEAREST = 0x2;
	public static final String MONTHCAL_CLASS = "SysMonthCal32"; //$NON-NLS-1$
	public static final int MOUSEEVENTF_ABSOLUTE = 0x8000;
	public static final int MOUSEEVENTF_LEFTDOWN = 0x0002;
	public static final int MOUSEEVENTF_LEFTUP = 0x0004;
	public static final int MOUSEEVENTF_MIDDLEDOWN = 0x0020;
	public static final int MOUSEEVENTF_MIDDLEUP = 0x0040;
	public static final int MOUSEEVENTF_MOVE = 0x0001;
	public static final int MOUSEEVENTF_RIGHTDOWN = 0x0008;
	public static final int MOUSEEVENTF_RIGHTUP = 0x0010;
	public static final int MOUSEEVENTF_VIRTUALDESK = 0x4000;
	public static final int MOUSEEVENTF_WHEEL = 0x0800;
	public static final int MOUSEEVENTF_XDOWN = 0x0080;
	public static final int MOUSEEVENTF_XUP = 0x0100;
	public static final int MSGF_DIALOGBOX = 0;
	public static final int MSGF_COMMCTRL_BEGINDRAG = 0x4200;
	public static final int MSGF_COMMCTRL_SIZEHEADER = 0x4201;
	public static final int MSGF_COMMCTRL_DRAGSELECT = 0x4202;
	public static final int MSGF_COMMCTRL_TOOLBARCUST = 0x4203;
	public static final int MSGF_MAINLOOP = 8;
	public static final int MSGF_MENU = 2;
	public static final int MSGF_MOVE = 3;
	public static final int MSGF_MESSAGEBOX = 1;
	public static final int MSGF_NEXTWINDOW = 6;
	public static final int MSGF_SCROLLBAR = 5;
	public static final int MSGF_SIZE = 4;
	public static final int MSGF_USER = 4096;
	public static final int MWT_LEFTMULTIPLY = 2;
	public static final int NI_COMPOSITIONSTR = 0x15;
	public static final int NID_READY = 0x80;
	public static final int NID_MULTI_INPUT = 0x40;
	public static final int NIF_ICON = 0x00000002;
	public static final int NIF_INFO = 0x00000010;
	public static final int NIF_MESSAGE = 0x00000001;
	public static final int NIF_STATE = 0x00000008;
	public static final int NIF_TIP = 0x00000004;
	public static final int NIIF_ERROR = 0x00000003;
	public static final int NIIF_INFO = 0x00000001;
	public static final int NIIF_NONE = 0x00000000;
	public static final int NIIF_WARNING = 0x00000002;
	public static final int NIM_ADD = 0x00000000;
	public static final int NIM_DELETE = 0x00000002;
	public static final int NIM_MODIFY = 0x00000001;
	public static final int NIN_SELECT = 0x400 + 0;
	public static final int NINF_KEY = 0x1;
	public static final int NIN_KEYSELECT = NIN_SELECT | NINF_KEY;
	public static final int NIN_BALLOONSHOW = 0x400 + 2;
	public static final int NIN_BALLOONHIDE = 0x400 + 3;
	public static final int NIN_BALLOONTIMEOUT = 0x400 + 4;
	public static final int NIN_BALLOONUSERCLICK = 0x400 + 5;
	public static final int NIS_HIDDEN = 0x00000001;
	public static final int NM_FIRST = 0x0;
	public static final int NM_CLICK = 0xfffffffe;
	public static final int NM_CUSTOMDRAW = NM_FIRST - 12;
	public static final int NM_DBLCLK = 0xfffffffd;
	public static final int NM_RECOGNIZEGESTURE = NM_FIRST - 16;
	public static final int NM_RELEASEDCAPTURE = NM_FIRST - 16;
	public static final int NM_RETURN = 0xfffffffc;
	public static final int NOTIFYICONDATAA_V2_SIZE = NOTIFYICONDATAA_V2_SIZE ();
	public static final int NOTIFYICONDATAW_V2_SIZE = NOTIFYICONDATAW_V2_SIZE ();
	public static final int NOTIFYICONDATA_V2_SIZE = IsUnicode ? NOTIFYICONDATAW_V2_SIZE : NOTIFYICONDATAA_V2_SIZE;
	public static final int NULLREGION = 0x1;
	public static final int NULL_BRUSH = 0x5;
	public static final int NULL_PEN = 0x8;
	public static final int NUMRESERVED = 106;
	public static final int OBJID_WINDOW = 0x00000000;
	public static final int OBJID_SYSMENU = 0xFFFFFFFF;
	public static final int OBJID_TITLEBAR = 0xFFFFFFFE;
	public static final int OBJID_MENU = 0xFFFFFFFD;
	public static final int OBJID_CLIENT = 0xFFFFFFFC;
	public static final int OBJID_VSCROLL = 0xFFFFFFFB;
	public static final int OBJID_HSCROLL = 0xFFFFFFFA;
	public static final int OBJID_SIZEGRIP = 0xFFFFFFF9;
	public static final int OBJID_CARET = 0xFFFFFFF8;
	public static final int OBJID_CURSOR = 0xFFFFFFF7;
	public static final int OBJID_ALERT = 0xFFFFFFF6;
	public static final int OBJID_SOUND = 0xFFFFFFF5;
	public static final int OBJID_QUERYCLASSNAMEIDX = 0xFFFFFFF4;
	public static final int OBJID_NATIVEOM = 0xFFFFFFF0;
	public static final int OBJ_BITMAP = 0x7;
	public static final int OBJ_FONT = 0x6;
	public static final int OBJ_PEN = 0x1;
	public static final int OBM_CHECKBOXES = 0x7ff7;
	public static final int ODS_SELECTED = 0x1;
	public static final int ODT_MENU = 0x1;
	public static final int OFN_ALLOWMULTISELECT = 0x200;
	public static final int OFN_EXPLORER = 0x80000;
	public static final int OFN_ENABLEHOOK = 0x20;
	public static final int OFN_ENABLESIZING = 0x800000;
	public static final int OFN_HIDEREADONLY = 0x4;
	public static final int OFN_NOCHANGEDIR = 0x8;
	public static final int OFN_OVERWRITEPROMPT = 0x2;
	public static final int OIC_BANG = 0x7F03;
	public static final int OIC_HAND = 0x7F01;
	public static final int OIC_INFORMATION = 0x7F04;
	public static final int OIC_QUES = 0x7F02;
	public static final int OIC_WINLOGO = 0x7F05;
	public static final int OPAQUE = 0x2;
	public static final int PATCOPY = 0xf00021;
	public static final int PATINVERT = 0x5a0049;
	public static final int PBM_GETPOS = 0x408;
	public static final int PBM_GETRANGE = 0x407;
	public static final int PBM_GETSTATE = 0x400 + 17;
	public static final int PBM_SETBARCOLOR = 0x409;
	public static final int PBM_SETBKCOLOR = 0x2001;
	public static final int PBM_SETMARQUEE = 0x400 + 10;
	public static final int PBM_SETPOS = 0x402;
	public static final int PBM_SETRANGE32 = 0x406;
	public static final int PBM_SETSTATE = 0x400 + 16;
	public static final int PBM_STEPIT = 0x405;
	public static final int PBS_MARQUEE = 0x08;
	public static final int PBS_SMOOTH = 0x1;
	public static final int PBS_VERTICAL = 0x4;
	public static final int PBS_NORMAL = 1;
	public static final int PBS_HOT = 2;
	public static final int PBS_PRESSED = 3;
	public static final int PBS_DISABLED = 4;
	public static final int PBS_DEFAULTED = 5;
	public static final int PBST_NORMAL = 0x0001;
	public static final int PBST_ERROR = 0x0002;
	public static final int PBST_PAUSED = 0x0003;
	public static final int PD_ALLPAGES = 0x0;
	public static final int PD_COLLATE = 0x10;
	public static final int PD_PAGENUMS = 0x2;
	public static final int PD_PRINTTOFILE = 0x20;
	public static final int PD_RETURNDC = 0x100;
	public static final int PD_RETURNDEFAULT = 0x00000400;
	public static final int PD_SELECTION = 0x1;
	public static final int PD_USEDEVMODECOPIESANDCOLLATE = 0x40000;
	public static final int PFM_TABSTOPS = 0x10;
	public static final int PHYSICALHEIGHT = 0x6f;
	public static final int PHYSICALOFFSETX = 0x70;
	public static final int PHYSICALOFFSETY = 0x71;
	public static final int PHYSICALWIDTH = 0x6e;
	public static final int PLANES = 0xe;
	public static final int PM_NOREMOVE = 0x0;
	public static final int PM_NOYIELD = 0x2;
	public static final int QS_HOTKEY = 0x0080;
	public static final int QS_KEY = 0x0001;
	public static final int QS_MOUSEMOVE = 0x0002;
	public static final int QS_MOUSEBUTTON = 0x0004;
	public static final int QS_MOUSE = QS_MOUSEMOVE | QS_MOUSEBUTTON;
	public static final int QS_INPUT = QS_KEY | QS_MOUSE;
	public static final int QS_POSTMESSAGE = 0x0008;
	public static final int QS_TIMER = 0x0010;
	public static final int QS_PAINT = 0x0020;
	public static final int QS_SENDMESSAGE = 0x0040;
	public static final int QS_ALLINPUT = QS_MOUSEMOVE | QS_MOUSEBUTTON | QS_KEY | QS_POSTMESSAGE | QS_TIMER | QS_PAINT | QS_SENDMESSAGE;
	public static final int PM_QS_INPUT = QS_INPUT << 16;
	public static final int PM_QS_POSTMESSAGE = (QS_POSTMESSAGE | QS_HOTKEY | QS_TIMER) << 16;
	public static final int PM_QS_PAINT = QS_PAINT << 16;
	public static final int PM_QS_SENDMESSAGE = QS_SENDMESSAGE << 16;
	public static final int PM_REMOVE = 0x1;
	public static final String PROGRESS_CLASS = "msctls_progress32"; //$NON-NLS-1$
	public static final int PP_BAR = 1;
	public static final int PP_BARVERT = 2;
	public static final int PP_CHUNK = 3;
	public static final int PP_CHUNKVERT = 4;
	public static final int PRF_CHILDREN = 16;
	public static final int PRF_CLIENT = 0x4;
	public static final int PRF_ERASEBKGND = 0x8;
	public static final int PRF_NONCLIENT = 0x2;
	public static final int PROGRESSCHUNKSIZE = 2411;
	public static final int PROGRESSSPACESIZE = 2412;
	public static final int PS_DASH = 0x1;
	public static final int PS_DASHDOT = 0x3;
	public static final int PS_DASHDOTDOT = 0x4;
	public static final int PS_DOT = 0x2;
	public static final int PS_ENDCAP_FLAT = 0x200;
	public static final int PS_ENDCAP_SQUARE = 0x100;
	public static final int PS_ENDCAP_ROUND = 0x000;
	public static final int PS_ENDCAP_MASK = 0xF00;
	public static final int PS_GEOMETRIC = 0x10000;
	public static final int PS_JOIN_BEVEL = 0x1000;
	public static final int PS_JOIN_MASK = 0xF000;
	public static final int PS_JOIN_MITER = 0x2000;
	public static final int PS_JOIN_ROUND = 0x0000;
	public static final int PS_SOLID = 0x0;
	public static final int PS_STYLE_MASK = 0xf;
	public static final int PS_TYPE_MASK = 0x000f0000;
	public static final int PS_USERSTYLE = 0x7;
	public static final int R2_COPYPEN = 0xd;
	public static final int R2_XORPEN = 0x7;
	public static final int RASTERCAPS = 0x26;
	public static final int RASTER_FONTTYPE = 0x1;
	public static final int RBBIM_CHILD = 0x10;
	public static final int RBBIM_CHILDSIZE = 0x20;
	public static final int RBBIM_COLORS = 0x2;
	public static final int RBBIM_HEADERSIZE = 0x800;
	public static final int RBBIM_ID = 0x100;
	public static final int RBBIM_IDEALSIZE = 0x200;
	public static final int RBBIM_SIZE = 0x40;
	public static final int RBBIM_STYLE = 0x1;
	public static final int RBBIM_TEXT = 0x4;
	public static final int RBBS_BREAK = 0x1;
	public static final int RBBS_GRIPPERALWAYS = 0x80;
	public static final int RBBS_NOGRIPPER = 0x00000100;
	public static final int RBBS_USECHEVRON = 0x00000200;
	public static final int RBBS_VARIABLEHEIGHT = 0x40;
	public static final int RBN_FIRST = 0xfffffcc1;
	public static final int RBN_BEGINDRAG = RBN_FIRST - 4;
	public static final int RBN_CHILDSIZE = RBN_FIRST - 8;
	public static final int RBN_CHEVRONPUSHED = RBN_FIRST - 10;
	public static final int RBN_HEIGHTCHANGE = 0xfffffcc1;
	public static final int RBS_UNCHECKEDNORMAL = 1;
	public static final int RBS_UNCHECKEDHOT = 2;
	public static final int RBS_UNCHECKEDPRESSED = 3;
	public static final int RBS_UNCHECKEDDISABLED = 4;
	public static final int RBS_CHECKEDNORMAL = 5;
	public static final int RBS_CHECKEDHOT = 6;
	public static final int RBS_CHECKEDPRESSED = 7;
	public static final int RBS_CHECKEDDISABLED = 8;
	public static final int RBS_DBLCLKTOGGLE = 0x8000;
	public static final int RBS_BANDBORDERS = 0x400;
	public static final int RBS_VARHEIGHT = 0x200;
	public static final int RB_DELETEBAND = 0x402;
	public static final int RB_GETBANDBORDERS = 0x422;
	public static final int RB_GETBANDCOUNT = 0x40c;
	public static final int RB_GETBANDINFO = 0x41c;
	public static final int RB_GETBANDMARGINS = 0x428;
	public static final int RB_GETBARHEIGHT = 0x41b;
	public static final int RB_GETBKCOLOR = 0x414;
	public static final int RB_GETRECT = 0x409;
	public static final int RB_GETTEXTCOLOR = 0x416;
	public static final int RB_IDTOINDEX = 0x410;
	public static final int RB_INSERTBAND = 0x40a;
	public static final int RB_MOVEBAND = 0x427;
	public static final int RB_SETBANDINFO = 0x40b;
	public static final int RB_SETBKCOLOR = 0x413;
	public static final int RB_SETTEXTCOLOR = 0x415;
	public static final int RC_PALETTE = 0x100;
	public static final int RDW_ALLCHILDREN = 0x80;
	public static final int RDW_ERASE = 0x4;
	public static final int RDW_FRAME = 0x400;
	public static final int RDW_INVALIDATE = 0x1;
	public static final int RDW_UPDATENOW = 0x100;
	public static final String REBARCLASSNAME = "ReBarWindow32"; //$NON-NLS-1$
	public static final int REG_DWORD = 4;
	public static final int REG_OPTION_VOLATILE = 0x1;
	public static final int RGN_AND = 0x1;
	public static final int RGN_COPY = 5;
	public static final int RGN_DIFF = 0x4;
	public static final int RGN_ERROR = 0;
	public static final int RGN_OR = 0x2;
	public static final int RP_BAND = 3;
	public static final int SBP_ARROWBTN = 0x1;
	public static final int SBP_THUMBBTNHORZ = 2;
	public static final int SBP_THUMBBTNVERT = 3;
	public static final int SBP_LOWERTRACKHORZ = 4;
	public static final int SBP_UPPERTRACKHORZ = 5;
	public static final int SBP_LOWERTRACKVERT = 6;
	public static final int SBP_UPPERTRACKVERT = 7;
	public static final int SBP_GRIPPERHORZ = 8;
	public static final int SBP_GRIPPERVERT = 9;
	public static final int SBP_SIZEBOX = 10;
	public static final int SBS_HORZ = 0x0;
	public static final int SBS_VERT = 0x1;
	public static final int SB_BOTH = 0x3;
	public static final int SB_BOTTOM = 0x7;
	public static final int SB_NONE = 0;
	public static final int SB_CONST_ALPHA = 0x00000001;
	public static final int SB_PIXEL_ALPHA = 0x00000002;
	public static final int SB_PREMULT_ALPHA = 0x00000004;
	public static final int SB_CTL = 0x2;
	public static final int SB_ENDSCROLL = 0x8;
	public static final int SB_HORZ = 0x0;
	public static final int SB_LINEDOWN = 0x1;
	public static final int SB_LINEUP = 0x0;
	public static final int SB_PAGEDOWN = 0x3;
	public static final int SB_PAGEUP = 0x2;
	public static final int SB_THUMBPOSITION = 0x4;
	public static final int SB_THUMBTRACK = 0x5;
	public static final int SB_TOP = 0x6;
	public static final int SB_VERT = 0x1;
	public static final int SC_CLOSE = 0xf060;
	public static final int SC_MOVE = 0xf010;
	public static final int SC_HSCROLL = 0xf080;
	public static final int SC_KEYMENU = 0xf100;
	public static final int SC_MAXIMIZE = 0xf030;
	public static final int SC_MINIMIZE = 0xf020;
	public static final int SC_NEXTWINDOW = 0xF040;
	public static final int SC_RESTORE = 0xf120;
	public static final int SC_SIZE = 0xf000;
	public static final int SC_TASKLIST = 0xf130;
	public static final int SC_VSCROLL = 0xf070;
	public static final int SCRBS_NORMAL = 1;
	public static final int SCRBS_HOT = 2;
	public static final int SCRBS_PRESSED = 3;
	public static final int SCRBS_DISABLED = 4;
	public static final int SEM_FAILCRITICALERRORS = 0x1;
	public static final int SET_FEATURE_ON_PROCESS = 0x2;
	public static final int SHADEBLENDCAPS = 120;
	public static final int SHGFI_ICON = 0x000000100;
	public static final int SHGFI_SMALLICON= 0x1;
	public static final int SHGFI_USEFILEATTRIBUTES = 0x000000010;
	public static final int SIGDN_FILESYSPATH = 0x80058000;
	public static final int SIF_ALL = 0x17;
	public static final int SIF_DISABLENOSCROLL = 0x8;
	public static final int SIF_PAGE = 0x2;
	public static final int SIF_POS = 0x4;
	public static final int SIF_RANGE = 0x1;
	public static final int SIF_TRACKPOS = 0x10;
	public static final int SIP_DOWN = 1;
	public static final int SIP_UP = 0;
	public static final int SIPF_ON = 0x1;
	public static final int SIZE_RESTORED = 0;
	public static final int SIZE_MINIMIZED = 1;
	public static final int SIZE_MAXIMIZED = 2;
	public static final int SIZEPALETTE = 104;
	public static final int SM_CMONITORS = 80;
	public static final int SM_CXBORDER = 0x5;
	public static final int SM_CXCURSOR = 0xd;
	public static final int SM_CXDOUBLECLK = 36;
	public static final int SM_CYDOUBLECLK = 37;
	public static final int SM_CXEDGE = 0x2d;
	public static final int SM_CXFOCUSBORDER = 83;
	public static final int SM_CXHSCROLL = 0x15;
	public static final int SM_CXICON = 0x0b;
	public static final int SM_CYICON = 0x0c;
	public static final int SM_CXVIRTUALSCREEN = 78;
	public static final int SM_CYVIRTUALSCREEN = 79;
	public static final int SM_CXSMICON = 49;
	public static final int SM_CYSMICON = 50;
	public static final int SM_CXSCREEN = 0x0;
	public static final int SM_XVIRTUALSCREEN = 76;
	public static final int SM_YVIRTUALSCREEN = 77;
	public static final int SM_CXVSCROLL = 0x2;
	public static final int SM_CYBORDER = 0x6;
	public static final int SM_CYCURSOR = 0xe;
	public static final int SM_CYFOCUSBORDER = 84;
	public static final int SM_CYHSCROLL = 0x3;
	public static final int SM_CYMENU = 0xf;
	public static final int SM_CXMINTRACK = 34;
	public static final int SM_CYMINTRACK = 35;
	public static final int SM_CMOUSEBUTTONS = 43;
	public static final int SM_CYSCREEN = 0x1;
	public static final int SM_CYVSCROLL = 0x14;
	public static final int SM_DIGITIZER = 94;
	public static final int SM_MAXIMUMTOUCHES= 95;
	public static final int SPI_GETFONTSMOOTHINGTYPE = 0x200A;
	public static final int SPI_GETHIGHCONTRAST = 66;
	public static final int SPI_GETWORKAREA = 0x30;
	public static final int SPI_GETMOUSEVANISH = 0x1020;
	public static final int SPI_GETNONCLIENTMETRICS = 41;
	public static final int SPI_GETWHEELSCROLLLINES = 104;
	public static final int SPI_GETCARETWIDTH = 0x2006;
	public static final int SPI_SETSIPINFO = 224;
	public static final int SPI_SETHIGHCONTRAST = 67;
	public static final int SRCAND = 0x8800c6;
	public static final int SRCCOPY = 0xcc0020;
	public static final int SRCINVERT = 0x660046;
	public static final int SRCPAINT = 0xee0086;
	public static final int SS_BITMAP = 0xe;
	public static final int SS_CENTER = 0x1;
	public static final int SS_CENTERIMAGE = 0x200;
	public static final int SS_EDITCONTROL = 0x2000;
	public static final int SS_ICON = 0x3;
	public static final int SS_LEFT = 0x0;
	public static final int SS_LEFTNOWORDWRAP = 0xc;
	public static final int SS_NOTIFY = 0x100;
	public static final int SS_OWNERDRAW = 0xd;
	public static final int SS_REALSIZEIMAGE = 0x800;
	public static final int SS_RIGHT = 0x2;
	public static final int SSA_FALLBACK = 0x00000020;
	public static final int SSA_GLYPHS = 0x00000080;
	public static final int SSA_METAFILE = 0x00000800;
	public static final int SSA_LINK = 0x00001000;
	public static final int STARTF_USESHOWWINDOW = 0x1;
	public static final int STATE_SYSTEM_INVISIBLE = 0x00008000;
	public static final int STATE_SYSTEM_OFFSCREEN = 0x00010000;
	public static final int STATE_SYSTEM_UNAVAILABLE = 0x00000001;
	public static final int STD_COPY = 0x1;
	public static final int STD_CUT = 0x0;
	public static final int STD_FILENEW = 0x6;
	public static final int STD_FILEOPEN = 0x7;
	public static final int STD_FILESAVE = 0x8;
	public static final int STD_PASTE = 0x2;
	public static final int STM_GETIMAGE = 0x173;
	public static final int STM_SETIMAGE = 0x172;
	public static final int SWP_ASYNCWINDOWPOS = 0x4000;
	public static final int SWP_DRAWFRAME = 0x20;
	public static final int SWP_NOACTIVATE = 0x10;
	public static final int SWP_NOCOPYBITS = 0x100;
	public static final int SWP_NOMOVE = 0x2;
	public static final int SWP_NOREDRAW = 0x8;
	public static final int SWP_NOSIZE = 0x1;
	public static final int SWP_NOZORDER = 0x4;
	public static final int SW_ERASE = 0x4;
	public static final int SW_HIDE = 0x0;
	public static final int SW_INVALIDATE = 0x2;
	public static final int SW_MINIMIZE = 0x6;
	public static final int SW_PARENTOPENING = 0x3;
	public static final int SW_RESTORE = 0x9;
	public static final int SW_SCROLLCHILDREN = 0x1;
	public static final int SW_SHOW = 0x5;
	public static final int SW_SHOWMAXIMIZED = 0x3;
	public static final int SW_SHOWMINIMIZED = 0x2;
	public static final int SW_SHOWMINNOACTIVE = 0x7;
	public static final int SW_SHOWNA = 0x8;
	public static final int SW_SHOWNOACTIVATE = 0x4;
	public static final int SYSRGN = 0x4;
	public static final int SYSTEM_FONT = 0xd;
	public static final int S_OK = 0x0;
	public static final int TABP_TABITEM = 1;
	public static final int TABP_TABITEMLEFTEDGE = 2;
	public static final int TABP_TABITEMRIGHTEDGE = 3;
	public static final int TABP_TABITEMBOTHEDGE = 4;
	public static final int TABP_TOPTABITEM = 5;
	public static final int TABP_TOPTABITEMLEFTEDGE = 6;
	public static final int TABP_TOPTABITEMRIGHTEDGE = 7;
	public static final int TABP_TOPTABITEMBOTHEDGE = 8;
	public static final int TABP_PANE = 9;
	public static final int TABP_BODY = 10;
	public static final int TBCDRF_BLENDICON = 0x200000;
	public static final int TBCDRF_HILITEHOTTRACK = 0x20000;
	public static final int TBCDRF_NOBACKGROUND = 0x400000;
	public static final int TBCDRF_NOEDGES = 0x10000;
	public static final int TBCDRF_NOETCHEDEFFECT = 0x100000;
	public static final int TBCDRF_NOMARK = 0x80000;
	public static final int TBCDRF_NOOFFSET = 0x40000;
	public static final int TBCDRF_USECDCOLORS = 0x800000;
	public static final int TBIF_COMMAND = 0x20;
	public static final int TBIF_STATE = 0x4;
	public static final int TBIF_IMAGE = 0x1;
	public static final int TBIF_LPARAM = 0x10;
	public static final int TBIF_SIZE = 0x40;
	public static final int TBIF_STYLE = 0x8;
	public static final int TBIF_TEXT = 0x2;
	public static final int TB_GETEXTENDEDSTYLE = 0x400 + 85;
	public static final int TBM_GETLINESIZE = 0x418;
	public static final int TBM_GETPAGESIZE = 0x416;
	public static final int TBM_GETPOS = 0x400;
	public static final int TBM_GETRANGEMAX = 0x402;
	public static final int TBM_GETRANGEMIN = 0x401;
	public static final int TBM_GETTHUMBRECT = 0x419;
	public static final int TBM_SETLINESIZE = 0x417;
	public static final int TBM_SETPAGESIZE = 0x415;
	public static final int TBM_SETPOS = 0x405;
	public static final int TBM_SETRANGEMAX = 0x408;
	public static final int TBM_SETRANGEMIN = 0x407;
	public static final int TBM_SETTICFREQ = 0x414;
	public static final int TBN_DROPDOWN = 0xfffffd3a;
	public static final int TBN_FIRST = 0xfffffd44;
	public static final int TBN_HOTITEMCHANGE = 0xFFFFFD37;
	public static final int TBSTATE_CHECKED = 0x1;
	public static final int TBSTATE_PRESSED = 0x02;
	public static final int TBSTYLE_CUSTOMERASE = 0x2000;
	public static final int TBSTYLE_DROPDOWN = 0x8;
	public static final int TBSTATE_ENABLED = 0x4;
	public static final int TBSTYLE_AUTOSIZE = 0x10;
	public static final int TBSTYLE_EX_DOUBLEBUFFER = 0x80;
	public static final int TBSTYLE_EX_DRAWDDARROWS = 0x1;
	public static final int TBSTYLE_EX_HIDECLIPPEDBUTTONS = 0x10;
	public static final int TBSTYLE_EX_MIXEDBUTTONS = 0x8;
	public static final int TBSTYLE_FLAT = 0x800;
	public static final int TBSTYLE_LIST = 0x1000;
	public static final int TBSTYLE_TOOLTIPS = 0x100;
	public static final int TBSTYLE_TRANSPARENT = 0x8000;
	public static final int TBSTYLE_WRAPABLE = 0x200;
	public static final int TBS_AUTOTICKS = 0x1;
	public static final int TBS_BOTH = 0x8;
	public static final int TBS_DOWNISLEFT = 0x0400;
	public static final int TBS_HORZ = 0x0;
	public static final int TBS_VERT = 0x2;
	public static final int TB_ADDSTRING = 0x44d;
	public static final int TB_AUTOSIZE = 0x421;
	public static final int TB_BUTTONCOUNT = 0x418;
	public static final int TB_BUTTONSTRUCTSIZE = 0x41e;
	public static final int TB_COMMANDTOINDEX = 0x419;
	public static final int TB_DELETEBUTTON = 0x416;
	public static final int TB_ENDTRACK = 0x8;
	public static final int TB_GETBUTTON = 0x417;
	public static final int TB_GETBUTTONINFO = 0x43f;
	public static final int TB_GETBUTTONSIZE = 0x43a;
	public static final int TB_GETBUTTONTEXT = 0x44b;
	public static final int TB_GETDISABLEDIMAGELIST = 0x437;
	public static final int TB_GETHOTIMAGELIST = 0x435;
	public static final int TB_GETHOTITEM = 0x0400 + 71;
	public static final int TB_GETIMAGELIST = 0x431;
	public static final int TB_GETITEMRECT = 0x41d;
	public static final int TB_GETPADDING = 0x0400 + 86;
	public static final int TB_GETROWS = 0x428;
	public static final int TB_GETSTATE = 0x412;
	public static final int TB_GETTOOLTIPS = 0x423;
	public static final int TB_INSERTBUTTON = 0x443;
	public static final int TB_LOADIMAGES = 0x432;
	public static final int TB_MAPACCELERATOR = 0x0400 + 90;
	public static final int TB_SETBITMAPSIZE = 0x420;
	public static final int TB_SETBUTTONINFO = 0x440;
	public static final int TB_SETBUTTONSIZE = 0x41f;
	public static final int TB_SETDISABLEDIMAGELIST = 0x436;
	public static final int TB_SETEXTENDEDSTYLE = 0x454;
	public static final int TB_SETHOTIMAGELIST = 0x434;
	public static final int TB_SETHOTITEM =  0x0400 + 72;
	public static final int TB_SETIMAGELIST = 0x430;
	public static final int TB_SETPARENT = 0x400 + 37;
	public static final int TB_SETROWS = 0x427;
	public static final int TB_SETSTATE = 0x411;
	public static final int TB_THUMBPOSITION = 0x4;
	public static final int TBPF_NOPROGRESS = 0x0;
	public static final int TBPF_INDETERMINATE = 0x1;
	public static final int TBPF_NORMAL = 0x2;
	public static final int TBPF_ERROR = 0x4;
	public static final int TBPF_PAUSED = 0x8;
	public static final int TCIF_IMAGE = 0x2;
	public static final int TCIF_TEXT = 0x1;
	public static final int TCI_SRCCHARSET = 0x1;
	public static final int TCI_SRCCODEPAGE = 0x2;
	public static final int TCM_ADJUSTRECT = 0x1328;
	public static final int TCM_DELETEITEM = 0x1308;
	public static final int TCM_GETCURSEL = 0x130b;
	public static final int TCM_GETITEMCOUNT = 0x1304;
	public static final int TCM_GETITEMRECT = 0x130a;
	public static final int TCM_GETTOOLTIPS = 0x132d;
	public static final int TCM_HITTEST = 0x130d;
	public static final int TCM_INSERTITEM = 0x133e;
	public static final int TCM_SETCURSEL = 0x130c;
	public static final int TCM_SETIMAGELIST = 0x1303;
	public static final int TCM_SETITEM = 0x133d;
	public static final int TCN_SELCHANGE = 0xfffffdd9;
	public static final int TCN_SELCHANGING = 0xfffffdd8;
	public static final int TCS_BOTTOM = 0x0002;
	public static final int TCS_FOCUSNEVER = 0x8000;
	public static final int TCS_MULTILINE = 0x200;
	public static final int TCS_TABS = 0x0;
	public static final int TCS_TOOLTIPS = 0x4000;
	public static final int TECHNOLOGY = 0x2;
	public static final int TF_ATTR_INPUT = 0;
	public static final int TF_ATTR_TARGET_CONVERTED = 1;
	public static final int TF_ATTR_CONVERTED = 2;
	public static final int TF_ATTR_TARGET_NOTCONVERTED = 3;
	public static final int TF_ATTR_INPUT_ERROR = 4;
	public static final int TF_ATTR_FIXEDCONVERTED = 5;
	public static final int TF_ATTR_OTHER = -1;
	public static final int TF_CT_NONE = 0;
	public static final int TF_CT_SYSCOLOR = 1;
	public static final int TF_CT_COLORREF = 2;
	public static final int TF_LS_NONE = 0;
	public static final int TF_LS_SOLID = 1;
	public static final int TF_LS_DOT = 2;
	public static final int TF_LS_DASH = 3;
	public static final int TF_LS_SQUIGGLE = 4;
	public static final int TIS_NORMAL = 1;
	public static final int TIS_HOT = 2;
	public static final int TIS_SELECTED = 3;
	public static final int TIS_DISABLED = 4;
	public static final int TIS_FOCUSED = 5;
	public static final int TKP_TRACK = 1;
	public static final int TKP_TRACKVERT = 2;
	public static final int TKP_THUMB = 3;
	public static final int TKP_THUMBBOTTOM = 4;
	public static final int TKP_THUMBTOP = 5;
	public static final int TKP_THUMBVERT = 6;
	public static final int TKP_THUMBLEFT = 7;
	public static final int TKP_THUMBRIGHT = 8;
	public static final int TKP_TICS = 9;
	public static final int TKP_TICSVERT = 10;
	public static final int TME_HOVER = 0x1;
	public static final int TME_LEAVE = 0x2;
	public static final int TME_QUERY = 0x40000000;
	public static final int TMPF_VECTOR = 0x2;
	public static final int TMT_CONTENTMARGINS = 3602;
	public static final int TOUCHEVENTF_MOVE = 0x0001;
	public static final int TOUCHEVENTF_DOWN = 0x0002;
	public static final int TOUCHEVENTF_UP = 0x0004;
	public static final int TOUCHEVENTF_INRANGE = 0x0008;
	public static final int TOUCHEVENTF_PRIMARY = 0x0010;
	public static final int TOUCHEVENTF_NOCOALESCE = 0x0020;
	public static final int TOUCHEVENTF_PALM = 0x0080;
	public static final String TOOLBARCLASSNAME = "ToolbarWindow32"; //$NON-NLS-1$
	public static final String TOOLTIPS_CLASS = "tooltips_class32"; //$NON-NLS-1$
	public static final int TP_BUTTON = 1;
	public static final int TP_DROPDOWNBUTTON = 2;
	public static final int TP_SPLITBUTTON = 3;
	public static final int TP_SPLITBUTTONDROPDOWN = 4;
	public static final int TP_SEPARATOR = 5;
	public static final int TP_SEPARATORVERT = 6;
	public static final int TPM_LEFTALIGN = 0x0;
	public static final int TPM_LEFTBUTTON = 0x0;
	public static final int TPM_RIGHTBUTTON = 0x2;
	public static final int TPM_RIGHTALIGN = 0x8;
	public static final String TRACKBAR_CLASS = "msctls_trackbar32"; //$NON-NLS-1$
	public static final int TRANSPARENT = 0x1;
	public static final int TREIS_DISABLED = 4;
	public static final int TREIS_HOT = 2;
	public static final int TREIS_NORMAL = 1;
	public static final int TREIS_SELECTED = 3;
	public static final int TREIS_SELECTEDNOTFOCUS = 5;
	public static final int TS_TRUE = 1;
	public static final int TTDT_AUTOMATIC = 0;
	public static final int TTDT_RESHOW = 1;
	public static final int TTDT_AUTOPOP = 2;
	public static final int TTDT_INITIAL = 3;
	public static final int TTF_ABSOLUTE = 0x80;
	public static final int TTF_IDISHWND = 0x1;
	public static final int TTF_SUBCLASS = 0x10;
	public static final int TTF_RTLREADING = 0x4;
	public static final int TTF_TRACK = 0x20;
	public static final int TTF_TRANSPARENT = 0x100;
	public static final int TTI_NONE = 0;
	public static final int TTI_INFO = 1;
	public static final int TTI_WARNING = 2;
	public static final int TTI_ERROR= 3;
	public static final int TTM_ACTIVATE = 0x400 + 1;
	public static final int TTM_ADDTOOL = 0x432;
	public static final int TTM_ADJUSTRECT = 0x400 + 31;
	public static final int TTM_GETCURRENTTOOLA = 0x400 + 15;
	public static final int TTM_GETCURRENTTOOLW = 0x400 + 59;
	public static final int TTM_GETCURRENTTOOL = 0x400 + (IsUnicode ? 59 : 15);
	public static final int TTM_GETDELAYTIME = 0x400 + 21;
	public static final int TTM_DELTOOL = 0x433;
	public static final int TTM_GETTOOLINFO = 0x400 + 53;
	public static final int TTM_GETTOOLCOUNT = 0x40D;
	public static final int TTM_NEWTOOLRECT = 0x400 + 52;
	public static final int TTM_POP = 0x400 + 28;
	public static final int TTM_SETDELAYTIME = 0x400 + 3;
	public static final int TTM_SETMAXTIPWIDTH = 0x418;
	public static final int TTM_SETTITLEA = 0x400 + 32;
	public static final int TTM_SETTITLEW = 0x400 + 33;
	public static final int TTM_SETTITLE = 0x400 + (IsUnicode ? 33 : 32);
	public static final int TTM_TRACKPOSITION = 1042;
	public static final int TTM_TRACKACTIVATE = 1041;
	public static final int TTM_UPDATE = 0x41D;
	public static final int TTM_UPDATETIPTEXT = 0x400 + 57;
	public static final int TTN_FIRST = 0xfffffdf8;
	public static final int TTN_GETDISPINFO = IsUnicode ? 0xfffffdee : 0xfffffdf8;
	public static final int TTN_GETDISPINFOW = 0xfffffdee;
	public static final int TTN_GETDISPINFOA = 0xfffffdf8;
	public static final int TTN_POP = TTN_FIRST - 2;
	public static final int TTN_SHOW = TTN_FIRST - 1;
	public static final int TTS_ALWAYSTIP = 0x1;
	public static final int TTS_BALLOON = 0x40;
	public static final int TTS_NOANIMATE = 0x10;
	public static final int TTS_NOFADE = 0x20;
	public static final int TTS_NOPREFIX = 0x02;
	public static final int TV_FIRST = 0x1100;
	public static final int TVE_COLLAPSE = 0x1;
	public static final int TVE_COLLAPSERESET = 0x8000;
	public static final int TVE_EXPAND = 0x2;
	public static final int TVGN_CARET = 0x9;
	public static final int TVGN_CHILD = 0x4;
	public static final int TVGN_DROPHILITED = 0x8;
	public static final int TVGN_FIRSTVISIBLE = 0x5;
	public static final int TVGN_LASTVISIBLE = 0xa;
	public static final int TVGN_NEXT = 0x1;
	public static final int TVGN_NEXTVISIBLE = 0x6;
	public static final int TVGN_PARENT = 0x3;
	public static final int TVGN_PREVIOUS = 0x2;
	public static final int TVGN_PREVIOUSVISIBLE = 0x7;
	public static final int TVGN_ROOT = 0x0;
	public static final int TVHT_ONITEM = 0x46;
	public static final int TVHT_ONITEMBUTTON = 16;
	public static final int TVHT_ONITEMICON = 0x2;
	public static final int TVHT_ONITEMINDENT = 0x8;
	public static final int TVHT_ONITEMRIGHT = 0x20;
	public static final int TVHT_ONITEMLABEL = 0x4;
	public static final int TVHT_ONITEMSTATEICON = 0x40;
	public static final int TVIF_HANDLE = 0x10;
	public static final int TVIF_IMAGE = 0x2;
	public static final int TVIF_INTEGRAL = 0x0080;
	public static final int TVIF_PARAM = 0x4;
	public static final int TVIF_SELECTEDIMAGE = 0x20;
	public static final int TVIF_STATE = 0x8;
	public static final int TVIF_TEXT = 0x1;
	public static final int TVIS_DROPHILITED = 0x8;
	public static final int TVIS_EXPANDED = 0x20;
	public static final int TVIS_SELECTED = 0x2;
	public static final int TVIS_STATEIMAGEMASK = 0xf000;
	public static final int /*long*/ TVI_FIRST = -0x0FFFF;
	public static final int /*long*/ TVI_LAST = -0x0FFFE;
	public static final int /*long*/ TVI_ROOT = -0x10000;
	public static final int /*long*/ TVI_SORT = -0x0FFFD;
	public static final int TVM_CREATEDRAGIMAGE = TV_FIRST + 18;
	public static final int TVM_DELETEITEM = 0x1101;
	public static final int TVM_ENSUREVISIBLE = 0x1114;
	public static final int TVM_EXPAND = 0x1102;
	public static final int TVM_GETBKCOLOR = 0x111f;
	public static final int TVM_GETCOUNT = 0x1105;
	public static final int TVM_GETEXTENDEDSTYLE = TV_FIRST + 45;
	public static final int TVM_GETIMAGELIST = 0x1108;
	public static final int TVM_GETITEM = 0x113e;
	public static final int TVM_GETITEMHEIGHT = 0x111c;
	public static final int TVM_GETITEMRECT = 0x1104;
	public static final int TVM_GETITEMSTATE = TV_FIRST + 39;
	public static final int TVM_GETNEXTITEM = 0x110a;
	public static final int TVM_GETTEXTCOLOR = 0x1120;
	public static final int TVM_GETTOOLTIPS = TV_FIRST + 25;
	public static final int TVM_GETVISIBLECOUNT = TV_FIRST + 16;
	public static final int TVM_HITTEST = 0x1111;
	public static final int TVM_INSERTITEM = 0x1132;
	public static final int TVM_MAPACCIDTOHTREEITEM = TV_FIRST + 42;
	public static final int TVM_MAPHTREEITEMTOACCID = TV_FIRST + 43;
	public static final int TVM_SELECTITEM = 0x110b;
	public static final int TVM_SETBKCOLOR = 0x111d;
	public static final int TVM_SETEXTENDEDSTYLE = TV_FIRST + 44;
	public static final int TVM_SETIMAGELIST = 0x1109;
	public static final int TVM_SETINDENT = TV_FIRST + 7;
	public static final int TVM_SETINSERTMARK = 0x111a;
	public static final int TVM_SETITEM = 0x113f;
	public static final int TVM_SETITEMHEIGHT = TV_FIRST + 27;
	public static final int TVM_SETSCROLLTIME = TV_FIRST + 33;
	public static final int TVM_SETTEXTCOLOR = 0x111e;
	public static final int TVM_SORTCHILDREN = TV_FIRST + 19;
	public static final int TVM_SORTCHILDRENCB = TV_FIRST + 21;
	public static final int TVN_BEGINDRAGW = 0xfffffe38;
	public static final int TVN_BEGINDRAGA = 0xfffffe69;
	public static final int TVN_BEGINRDRAGW = 0xfffffe37;
	public static final int TVN_BEGINRDRAGA = 0xfffffe68;
	public static final int TVN_FIRST = 0xfffffe70;
	public static final int TVN_GETDISPINFOA = TVN_FIRST - 3;
	public static final int TVN_GETDISPINFOW = TVN_FIRST - 52;
	public static final int TVN_ITEMCHANGINGW = TVN_FIRST - 17;
	public static final int TVN_ITEMCHANGINGA = TVN_FIRST - 16;
	public static final int TVN_ITEMEXPANDEDA = TVN_FIRST -6;
	public static final int TVN_ITEMEXPANDEDW = TVN_FIRST - 55;
	public static final int TVN_ITEMEXPANDINGW = 0xfffffe3a;
	public static final int TVN_ITEMEXPANDINGA = 0xfffffe6b;
	public static final int TVN_SELCHANGEDW = 0xfffffe3d;
	public static final int TVN_SELCHANGEDA = 0xfffffe6e;
	public static final int TVN_SELCHANGINGW = 0xfffffe3e;
	public static final int TVN_SELCHANGINGA = 0xfffffe6f;
	public static final int TVP_GLYPH = 2;
	public static final int TVP_TREEITEM = 1;
	public static final int TVSIL_NORMAL = 0x0;
	public static final int TVSIL_STATE = 0x2;
	public static final int TVS_DISABLEDRAGDROP = 0x10;
	public static final int TVS_EX_AUTOHSCROLL = 0x0020;
	public static final int TVS_EX_DOUBLEBUFFER = 0x0004;
	public static final int TVS_EX_DIMMEDCHECKBOXES = 0x0200;
	public static final int TVS_EX_DRAWIMAGEASYNC = 0x0400;
	public static final int TVS_EX_EXCLUSIONCHECKBOXES = 0x0100;
	public static final int TVS_EX_FADEINOUTEXPANDOS = 0x0040;
	public static final int TVS_EX_MULTISELECT = 0x0002;
	public static final int TVS_EX_NOINDENTSTATE = 0x0008;
	public static final int TVS_EX_PARTIALCHECKBOXES = 0x0080;
	public static final int TVS_EX_RICHTOOLTIP = 0x0010;
	public static final int TVS_FULLROWSELECT = 0x1000;
	public static final int TVS_HASBUTTONS = 0x1;
	public static final int TVS_HASLINES = 0x2;
	public static final int TVS_LINESATROOT = 0x4;
	public static final int TVS_NOHSCROLL = 0x8000;
	public static final int TVS_NONEVENHEIGHT = 0x4000;
	public static final int TVS_NOSCROLL = 0x2000;
	public static final int TVS_NOTOOLTIPS = 0x80;
	public static final int TVS_SHOWSELALWAYS = 0x20;
	public static final int TVS_TRACKSELECT = 0x200;
	public static final int UDM_GETACCEL = 0x046C;
	public static final int UDM_GETRANGE32 = 0x0470;
	public static final int UDM_GETPOS32 = 0x0472;
	public static final int UDM_SETACCEL = 0x046B;
	public static final int UDM_SETRANGE32 = 0x046f;
	public static final int UDM_SETPOS32 = 0x0471;
	public static final int UDN_DELTAPOS = -722;
	public static final int UDS_ALIGNLEFT = 0x008;
	public static final int UDS_ALIGNRIGHT = 0x004;
	public static final int UDS_AUTOBUDDY = 0x0010;
	public static final int UDS_WRAP = 0x0001;
	public static final int UIS_CLEAR = 2;
	public static final int UIS_INITIALIZE = 3;
	public static final int UIS_SET = 1;
	public static final int UISF_HIDEACCEL = 0x2;
	public static final int UISF_HIDEFOCUS = 0x1;
	public static final String UPDOWN_CLASS = "msctls_updown32"; //$NON-NLS-1$
	public static final int USP_E_SCRIPT_NOT_IN_FONT = 0x80040200;
	public static final int VERTRES = 0xa;
	public static final int VK_BACK = 0x8;
	public static final int VK_CANCEL = 0x3;
	public static final int VK_CAPITAL = 0x14;
	public static final int VK_CONTROL = 0x11;
	public static final int VK_DECIMAL = 0x6E;
	public static final int VK_DELETE = 0x2e;
	public static final int VK_DIVIDE = 0x6f;
	public static final int VK_DOWN = 0x28;
	public static final int VK_END = 0x23;
	public static final int VK_ESCAPE = 0x1b;
	public static final int VK_F1 = 0x70;
	public static final int VK_F10 = 0x79;
	public static final int VK_F11 = 0x7a;
	public static final int VK_F12 = 0x7b;
	public static final int VK_F13 = 0x7c;
	public static final int VK_F14 = 0x7d;
	public static final int VK_F15 = 0x7e;
	public static final int VK_F16 = 0x7F;
	public static final int VK_F17 = 0x80;
	public static final int VK_F18 = 0x81;
	public static final int VK_F19 = 0x82;
	public static final int VK_F20 = 0x83;
	public static final int VK_F2 = 0x71;
	public static final int VK_F3 = 0x72;
	public static final int VK_F4 = 0x73;
	public static final int VK_F5 = 0x74;
	public static final int VK_F6 = 0x75;
	public static final int VK_F7 = 0x76;
	public static final int VK_F8 = 0x77;
	public static final int VK_F9 = 0x78;
	public static final int VK_HANJA = 0x19;
	public static final int VK_HOME = 0x24;
	public static final int VK_INSERT = 0x2d;
	public static final int VK_L = 0x4c;
	public static final int VK_LBUTTON = 0x1;
	public static final int VK_LEFT = 0x25;
	public static final int VK_LCONTROL = 0xA2;
	public static final int VK_LMENU = 0xA4;
	public static final int VK_LSHIFT = 0xA0;
	public static final int VK_MBUTTON = 0x4;
	public static final int VK_MENU = 0x12;
	public static final int VK_MULTIPLY = 0x6A;
	public static final int VK_N = 0x4e;
	public static final int VK_O = 0x4f;
	public static final int VK_NEXT = 0x22;
	public static final int VK_NUMLOCK = 0x90;
	public static final int VK_NUMPAD0 = 0x60;
	public static final int VK_NUMPAD1 = 0x61;
	public static final int VK_NUMPAD2 = 0x62;
	public static final int VK_NUMPAD3 = 0x63;
	public static final int VK_NUMPAD4 = 0x64;
	public static final int VK_NUMPAD5 = 0x65;
	public static final int VK_NUMPAD6 = 0x66;
	public static final int VK_NUMPAD7 = 0x67;
	public static final int VK_NUMPAD8 = 0x68;
	public static final int VK_NUMPAD9 = 0x69;
	public static final int VK_PAUSE = 0x13;
	public static final int VK_PRIOR = 0x21;
	public static final int VK_RBUTTON = 0x2;
	public static final int VK_RETURN = 0xd;
	public static final int VK_RIGHT = 0x27;
	public static final int VK_RCONTROL = 0xA3;
	public static final int VK_RMENU = 0xA5;
	public static final int VK_RSHIFT = 0xA1;
	public static final int VK_SCROLL = 0x91;
	public static final int VK_SEPARATOR = 0x6C;
	public static final int VK_SHIFT = 0x10;
	public static final int VK_SNAPSHOT = 0x2C;
	public static final int VK_SPACE = 0x20;
	public static final int VK_SUBTRACT = 0x6D;
	public static final int VK_TAB = 0x9;
	public static final int VK_UP = 0x26;
	public static final int VK_XBUTTON1 = 0x05;
	public static final int VK_XBUTTON2 = 0x06;
	public static final int VK_ADD = 0x6B;
	public static final int VT_BOOL = 11;
	public static final int VT_LPWSTR = 31;
	public static final short VARIANT_TRUE = -1;
	public static final short VARIANT_FALSE = 0;
	public static final short WA_CLICKACTIVE = 2;
	public static final String WC_HEADER = "SysHeader32"; //$NON-NLS-1$
	public static final String WC_LINK = "SysLink"; //$NON-NLS-1$
	public static final String WC_LISTVIEW = "SysListView32"; //$NON-NLS-1$
	public static final String WC_TABCONTROL = "SysTabControl32"; //$NON-NLS-1$
	public static final String WC_TREEVIEW = "SysTreeView32"; //$NON-NLS-1$
	public static final int WINDING = 2;
	public static final int WH_CBT = 5;
	public static final int WH_GETMESSAGE = 0x3;
	public static final int WH_MSGFILTER = 0xFFFFFFFF;
	public static final int WH_FOREGROUNDIDLE = 11;
	public static final int WHEEL_DELTA = 120;
	public static final int WHEEL_PAGESCROLL = 0xFFFFFFFF;
	public static final int WHITE_BRUSH = 0;
	public static final int WHITENESS = 0x00FF0062;
	public static final int WM_ACTIVATE = 0x6;
	public static final int WM_ACTIVATEAPP = 0x1c;
	public static final int WM_APP = 0x8000;
	public static final int WM_DWMCOLORIZATIONCOLORCHANGED = 0x320;
	public static final int WM_CANCELMODE = 0x1f;
	public static final int WM_CAPTURECHANGED = 0x0215;
	public static final int WM_CHANGEUISTATE = 0x0127;
	public static final int WM_CHAR = 0x102;
	public static final int WM_CLEAR = 0x303;
	public static final int WM_CLOSE = 0x10;
	public static final int WM_COMMAND = 0x111;
	public static final int WM_CONTEXTMENU = 0x7b;
	public static final int WM_COPY = 0x301;
	public static final int WM_CREATE = 0x0001;
	public static final int WM_CTLCOLORBTN = 0x135;
	public static final int WM_CTLCOLORDLG = 0x136;
	public static final int WM_CTLCOLOREDIT = 0x133;
	public static final int WM_CTLCOLORLISTBOX = 0x134;
	public static final int WM_CTLCOLORMSGBOX = 0x132;
	public static final int WM_CTLCOLORSCROLLBAR = 0x137;
	public static final int WM_CTLCOLORSTATIC = 0x138;
	public static final int WM_CUT = 0x300;
	public static final int WM_DEADCHAR = 0x103;
	public static final int WM_DESTROY = 0x2;
	public static final int WM_DPICHANGED = 0x02E0;
	public static final int WM_DRAWITEM = 0x2b;
	public static final int WM_ENDSESSION = 0x16;
	public static final int WM_ENTERIDLE = 0x121;
	public static final int WM_ERASEBKGND = 0x14;
	public static final int WM_GESTURE = 0x0119;
	public static final int WM_GETDLGCODE = 0x87;
	public static final int WM_GETFONT = 0x31;
	public static final int WM_GETOBJECT = 0x003D;
	public static final int WM_GETMINMAXINFO = 0x0024;
	public static final int WM_HELP = 0x53;
	public static final int WM_HOTKEY = 0x0312;
	public static final int WM_HSCROLL = 0x114;
	public static final int WM_IME_CHAR = 0x286;
	public static final int WM_IME_COMPOSITION = 0x10f;
	public static final int WM_IME_COMPOSITION_START = 0x010D;
	public static final int WM_IME_ENDCOMPOSITION = 0x010E;
	public static final int WM_INITDIALOG = 0x110;
	public static final int WM_INITMENUPOPUP = 0x117;
	public static final int WM_INPUTLANGCHANGE = 0x51;
	public static final int WM_KEYDOWN = 0x100;
	public static final int WM_KEYFIRST = 0x100;
	public static final int WM_KEYLAST = 0x108;
	public static final int WM_KEYUP = 0x101;
	public static final int WM_KILLFOCUS = 0x8;
	public static final int WM_LBUTTONDBLCLK = 0x203;
	public static final int WM_LBUTTONDOWN = 0x201;
	public static final int WM_LBUTTONUP = 0x202;
	public static final int WM_MBUTTONDBLCLK = 0x209;
	public static final int WM_MBUTTONDOWN = 0x207;
	public static final int WM_MBUTTONUP = 0x208;
	public static final int WM_MEASUREITEM = 0x2c;
	public static final int WM_MENUCHAR = 0x120;
	public static final int WM_MENUSELECT = 0x11f;
	public static final int WM_MOUSEACTIVATE = 0x21;
	public static final int WM_MOUSEFIRST = 0x200;
	public static final int WM_MOUSEHOVER = 0x2a1;
	public static final int WM_MOUSELEAVE = 0x2a3;
	public static final int WM_MOUSEMOVE = 0x200;
	public static final int WM_MOUSEWHEEL = 0x20a;
	public static final int WM_MOUSEHWHEEL = 0x20e;
	public static final int WM_MOUSELAST = 0x20d;
	public static final int WM_MOVE = 0x3;
	public static final int WM_NCACTIVATE = 0x86;
	public static final int WM_NCCALCSIZE = 0x83;
	public static final int WM_NCHITTEST = 0x84;
	public static final int WM_NCLBUTTONDOWN = 0x00A1;
	public static final int WM_NCPAINT = 0x85;
	public static final int WM_NOTIFY = 0x4e;
	public static final int WM_NULL = 0x0;
	public static final int WM_PAINT = 0xf;
	public static final int WM_PALETTECHANGED = 0x311;
	public static final int WM_PARENTNOTIFY = 0x0210;
	public static final int WM_PASTE = 0x302;
	public static final int WM_PRINT = 0x0317;
	public static final int WM_PRINTCLIENT = 0x0318;
	public static final int WM_QUERYENDSESSION = 0x11;
	public static final int WM_QUERYNEWPALETTE = 0x30f;
	public static final int WM_QUERYOPEN = 0x13;
	public static final int WM_QUERYUISTATE = 0x129;
	public static final int WM_RBUTTONDBLCLK = 0x206;
	public static final int WM_RBUTTONDOWN = 0x204;
	public static final int WM_RBUTTONUP = 0x205;
	public static final int WM_SETCURSOR = 0x20;
	public static final int WM_SETFOCUS = 0x7;
	public static final int WM_SETFONT = 0x30;
	public static final int WM_SETICON = 0x80;
	public static final int WM_SETREDRAW = 0xb;
	public static final int WM_SETTEXT = 12;
	public static final int WM_SETTINGCHANGE = 0x1A;
	public static final int WM_SHOWWINDOW = 0x18;
	public static final int WM_SIZE = 0x5;
	public static final int WM_SYSCHAR = 0x106;
	public static final int WM_SYSCOLORCHANGE = 0x15;
	public static final int WM_SYSCOMMAND = 0x112;
	public static final int WM_SYSKEYDOWN = 0x104;
	public static final int WM_SYSKEYUP = 0x105;
	public static final int WM_TABLET_FLICK = 0x02C0 + 11;
	public static final int WM_TIMER = 0x113;
	public static final int WM_THEMECHANGED = 0x031a;
	public static final int WM_TOUCH = 0x240;
	public static final int WM_UNDO = 0x304;
	public static final int WM_UNINITMENUPOPUP = 0x0125;
	public static final int WM_UPDATEUISTATE = 0x0128;
	public static final int WM_USER = 0x400;
	public static final int WM_VSCROLL = 0x115;
	public static final int WM_WINDOWPOSCHANGED = 0x47;
	public static final int WM_WINDOWPOSCHANGING = 0x46;
	public static final int WPF_RESTORETOMAXIMIZED = 0x0002;
	public static final int WS_BORDER = 0x800000;
	public static final int WS_CAPTION = 0xc00000;
	public static final int WS_CHILD = 0x40000000;
	public static final int WS_CLIPCHILDREN = 0x2000000;
	public static final int WS_CLIPSIBLINGS = 0x4000000;
	public static final int WS_DISABLED = 0x4000000;
	public static final int WS_EX_APPWINDOW = 0x40000;
	public static final int WS_EX_CAPTIONOKBTN = 0x80000000;
	public static final int WS_EX_CLIENTEDGE = 0x200;
	public static final int WS_EX_COMPOSITED = 0x2000000;
	public static final int WS_EX_DLGMODALFRAME = 0x1;
	public static final int WS_EX_LAYERED = 0x00080000;
	public static final int WS_EX_LAYOUTRTL = 0x00400000;
	public static final int WS_EX_LEFTSCROLLBAR = 0x00004000;
	public static final int WS_EX_MDICHILD = 0x00000040;
	public static final int WS_EX_NOINHERITLAYOUT = 0x00100000;
	public static final int WS_EX_NOACTIVATE = 0x08000000;
	public static final int WS_EX_RIGHT = 0x00001000;
	public static final int WS_EX_RTLREADING = 0x00002000;
	public static final int WS_EX_STATICEDGE = 0x20000;
	public static final int WS_EX_TOOLWINDOW = 0x80;
	public static final int WS_EX_TOPMOST = 0x8;
	public static final int WS_EX_TRANSPARENT = 0x20;
	public static final int WS_HSCROLL = 0x100000;
	public static final int WS_MAXIMIZEBOX = 0x10000;
	public static final int WS_MINIMIZEBOX = 0x20000;
	public static final int WS_OVERLAPPED = 0x0;
	public static final int WS_OVERLAPPEDWINDOW = 0xcf0000;
	public static final int WS_POPUP = 0x80000000;
	public static final int WS_SYSMENU = 0x80000;
	public static final int WS_TABSTOP = 0x10000;
	public static final int WS_THICKFRAME = 0x40000;
	public static final int WS_VISIBLE = 0x10000000;
	public static final int WS_VSCROLL = 0x200000;
	public static final int WM_XBUTTONDOWN = 0x020B;
	public static final int WM_XBUTTONUP = 0x020C;
	public static final int WM_XBUTTONDBLCLK = 0x020D;
	public static final int XBUTTON1 = 0x1;
	public static final int XBUTTON2 = 0x2;
	public static final int X509_ASN_ENCODING = 1;

public static int VERSION (int major, int minor) {
	return major << 16 | minor;
}

/** 64 bit */
public static final native int ACCEL_sizeof ();
public static final native int ACTCTX_sizeof ();
public static final native int BITMAP_sizeof ();
public static final native int BITMAPINFOHEADER_sizeof ();
public static final native int BLENDFUNCTION_sizeof ();
public static final native int BP_PAINTPARAMS_sizeof ();
public static final native int BROWSEINFO_sizeof ();
public static final native int BUTTON_IMAGELIST_sizeof ();
public static final native int CANDIDATEFORM_sizeof ();
public static final native int CERT_CONTEXT_sizeof ();
public static final native int CERT_INFO_sizeof ();
public static final native int CERT_NAME_BLOB_sizeof ();
public static final native int CERT_PUBLIC_KEY_INFO_sizeof ();
public static final native int CHOOSECOLOR_sizeof ();
public static final native int CHOOSEFONT_sizeof ();
public static final native int COMBOBOXINFO_sizeof ();
public static final native int COMPOSITIONFORM_sizeof ();
public static final native int CREATESTRUCT_sizeof ();
public static final native int CRYPT_ALGORITHM_IDENTIFIER_sizeof ();
public static final native int CRYPT_BIT_BLOB_sizeof ();
public static final native int CRYPT_INTEGER_BLOB_sizeof ();
public static final native int CRYPT_OBJID_BLOB_sizeof ();
public static final native int DEVMODEA_sizeof ();
public static final native int DEVMODEW_sizeof ();
public static final native int DIBSECTION_sizeof ();
public static final native int DOCHOSTUIINFO_sizeof ();
public static final native int DOCINFO_sizeof ();
public static final native int DRAWITEMSTRUCT_sizeof ();
public static final native int DROPFILES_sizeof ();
public static final native int DTTOPTS_sizeof ();
public static final native int EMR_sizeof ();
public static final native int EMREXTCREATEFONTINDIRECTW_sizeof ();
public static final native int EXTLOGFONTW_sizeof ();
public static final native int FILETIME_sizeof ();
public static final native int FLICK_DATA_sizeof ();
public static final native int FLICK_POINT_sizeof ();
public static final native int GCP_RESULTS_sizeof ();
public static final native int GESTURECONFIG_sizeof ();
public static final native int GESTUREINFO_sizeof ();
public static final native int GRADIENT_RECT_sizeof ();
public static final native int GUITHREADINFO_sizeof ();
public static final native int HDITEM_sizeof ();
public static final native int HDLAYOUT_sizeof ();
public static final native int HDHITTESTINFO_sizeof ();
public static final native int HELPINFO_sizeof ();
public static final native int HIGHCONTRAST_sizeof ();
public static final native int ICONINFO_sizeof ();
public static final native int INITCOMMONCONTROLSEX_sizeof ();
public static final native int INPUT_sizeof ();
public static final native int KEYBDINPUT_sizeof ();
public static final native int LITEM_sizeof ();
public static final native int LOGBRUSH_sizeof ();
public static final native int LOGFONTA_sizeof ();
public static final native int LOGFONTW_sizeof ();
public static final native int LOGPEN_sizeof ();
public static final native int LVCOLUMN_sizeof ();
public static final native int LVHITTESTINFO_sizeof ();
public static final native int LVITEM_sizeof ();
public static final native int LVINSERTMARK_sizeof ();
public static final native int MARGINS_sizeof ();
public static final native int MCHITTESTINFO_sizeof ();
public static final native int MEASUREITEMSTRUCT_sizeof ();
public static final native int MENUBARINFO_sizeof ();
public static final native int MENUINFO_sizeof ();
public static final native int MENUITEMINFO_sizeof ();
public static final native int MINMAXINFO_sizeof ();
public static final native int MOUSEINPUT_sizeof ();
public static final native int MONITORINFO_sizeof ();
public static final native int MSG_sizeof ();
public static final native int NMCUSTOMDRAW_sizeof ();
public static final native int NMHDR_sizeof ();
public static final native int NMHEADER_sizeof ();
public static final native int NMLINK_sizeof ();
public static final native int NMLISTVIEW_sizeof ();
public static final native int NMLVCUSTOMDRAW_sizeof ();
public static final native int NMLVDISPINFO_sizeof ();
public static final native int NMLVFINDITEM_sizeof ();
public static final native int NMLVODSTATECHANGE_sizeof ();
public static final native int NMREBARCHEVRON_sizeof ();
public static final native int NMREBARCHILDSIZE_sizeof ();
public static final native int NMTBHOTITEM_sizeof ();
public static final native int NMTREEVIEW_sizeof ();
public static final native int NMTOOLBAR_sizeof ();
public static final native int NMTTDISPINFOA_sizeof ();
public static final native int NMTTDISPINFOW_sizeof ();
public static final native int NMTTCUSTOMDRAW_sizeof ();
public static final native int NMTBCUSTOMDRAW_sizeof ();
public static final native int NMTVCUSTOMDRAW_sizeof ();
public static final native int NMTVDISPINFO_sizeof ();
public static final native int NMTVITEMCHANGE_sizeof ();
public static final native int NMUPDOWN_sizeof ();
public static final native int NONCLIENTMETRICSA_sizeof ();
public static final native int NONCLIENTMETRICSW_sizeof ();
/** @method flags=const */
public static final native int NOTIFYICONDATAA_V2_SIZE ();
/** @method flags=const */
public static final native int NOTIFYICONDATAW_V2_SIZE ();
public static final native int OFNOTIFY_sizeof ();
public static final native int OPENFILENAME_sizeof ();
public static final native int OUTLINETEXTMETRICA_sizeof ();
public static final native int OUTLINETEXTMETRICW_sizeof ();
public static final native int PAINTSTRUCT_sizeof ();
public static final native int PANOSE_sizeof ();
public static final native int POINT_sizeof ();
public static final native int PRINTDLG_sizeof ();
public static final native int PROCESS_INFORMATION_sizeof ();
public static final native int PROPVARIANT_sizeof ();
public static final native int PROPERTYKEY_sizeof ();
public static final native int REBARBANDINFO_sizeof ();
public static final native int RECT_sizeof ();
public static final native int SAFEARRAY_sizeof ();
public static final native int SAFEARRAYBOUND_sizeof ();
public static final native int SCRIPT_ANALYSIS_sizeof ();
public static final native int SCRIPT_CONTROL_sizeof ();
public static final native int SCRIPT_DIGITSUBSTITUTE_sizeof ();
public static final native int SCRIPT_FONTPROPERTIES_sizeof ();
public static final native int SCRIPT_ITEM_sizeof ();
public static final native int SCRIPT_LOGATTR_sizeof ();
public static final native int SCRIPT_PROPERTIES_sizeof ();
public static final native int SCRIPT_STATE_sizeof ();
public static final native int SCRIPT_STRING_ANALYSIS_sizeof ();
public static final native int SCROLLBARINFO_sizeof ();
public static final native int SCROLLINFO_sizeof ();
public static final native int SHDRAGIMAGE_sizeof();
public static final native int SHELLEXECUTEINFO_sizeof ();
public static final native int SHFILEINFOA_sizeof ();
public static final native int SHFILEINFOW_sizeof ();
public static final native int SIZE_sizeof ();
public static final native int STARTUPINFO_sizeof ();
public static final native int SYSTEMTIME_sizeof ();
public static final native int TBBUTTON_sizeof ();
public static final native int TBBUTTONINFO_sizeof ();
public static final native int TCITEM_sizeof ();
public static final native int TCHITTESTINFO_sizeof ();
public static final native int TEXTMETRICA_sizeof ();
public static final native int TEXTMETRICW_sizeof ();
public static final native int TF_DA_COLOR_sizeof ();
public static final native int TF_DISPLAYATTRIBUTE_sizeof ();
public static final native int TOOLINFO_sizeof ();
public static final native int TOUCHINPUT_sizeof();
public static final native int TRACKMOUSEEVENT_sizeof ();
public static final native int TRIVERTEX_sizeof ();
public static final native int TVHITTESTINFO_sizeof ();
public static final native int TVINSERTSTRUCT_sizeof ();
public static final native int TVITEM_sizeof ();
public static final native int TVITEMEX_sizeof ();
public static final native int TVSORTCB_sizeof ();
public static final native int UDACCEL_sizeof ();
public static final native int WINDOWPLACEMENT_sizeof ();
public static final native int WINDOWPOS_sizeof ();
public static final native int WNDCLASS_sizeof ();

/** Ansi/Unicode wrappers */

public static final int /*long*/ AddFontResourceEx (TCHAR lpszFilename, int fl, int /*long*/ pdv) {
	if (IsUnicode) {
		char [] lpszFilename1 = lpszFilename == null ? null : lpszFilename.chars;
		return AddFontResourceExW (lpszFilename1, fl, pdv);
	}
	byte [] lpszFilename1 = lpszFilename == null ? null : lpszFilename.bytes;
	return AddFontResourceExA (lpszFilename1, fl, pdv);
}

public static final int AssocQueryString(int flags, int str, TCHAR pszAssoc, TCHAR pszExtra, TCHAR pszOut, int[] pcchOut) {
	if (IsUnicode) {
		char [] pszAssoc1 = pszAssoc == null ? null : pszAssoc.chars;
		char [] pszExtra1 = pszExtra == null ? null : pszExtra.chars;
		char [] pszOut1 = pszOut == null ? null : pszOut.chars;
		return AssocQueryStringW (flags, str, pszAssoc1, pszExtra1, pszOut1, pcchOut);
	}
	byte [] pszAssoc1 = pszAssoc == null ? null : pszAssoc.bytes;
	byte [] pszExtra1 = pszExtra == null ? null : pszExtra.bytes;
	byte [] pszOut1 = pszOut == null ? null : pszOut.bytes;
	return AssocQueryStringA (flags, str, pszAssoc1, pszExtra1, pszOut1, pcchOut);
}

public static final int /*long*/ CallWindowProc (int /*long*/ lpPrevWndFunc, int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam) {
	if (IsUnicode) return CallWindowProcW (lpPrevWndFunc, hWnd, Msg, wParam, lParam);
	return CallWindowProcA (lpPrevWndFunc, hWnd, Msg, wParam, lParam);
}

public static final int CertNameToStr (int dwCertEncodingType, CERT_NAME_BLOB pName, int dwStrType, TCHAR psz, int csz) {
	if (IsUnicode) {
		char [] psz1 = psz == null ? null : psz.chars;
		return CertNameToStrW (dwCertEncodingType, pName, dwStrType, psz1, csz);
	}
	byte [] psz1 = psz == null ? null : psz.bytes;
	return CertNameToStrA (dwCertEncodingType, pName, dwStrType, psz1, csz);
}

public static final int /*long*/ CharUpper (int /*long*/ ch) {
	if (IsUnicode) return CharUpperW (ch);
	return CharUpperA (ch);
}

public static final int /*long*/ CharLower (int /*long*/ ch) {
	if (IsUnicode) return CharLowerW (ch);
	return CharLowerA (ch);
}

public static final boolean ChooseColor (CHOOSECOLOR lpcc) {
	if (IsUnicode) return ChooseColorW (lpcc);
	return ChooseColorA (lpcc);
}

public static final boolean ChooseFont (CHOOSEFONT chooseFont) {
	if (IsUnicode) return ChooseFontW (chooseFont);
	return ChooseFontA (chooseFont);
}

public static final int /*long*/ CreateActCtx (ACTCTX pActCtx) {
	if (IsUnicode) return CreateActCtxW (pActCtx);
	return CreateActCtxA (pActCtx);
}

public static final int /*long*/ CreateAcceleratorTable (byte [] lpaccl, int cEntries) {
	if (IsUnicode) return CreateAcceleratorTableW (lpaccl, cEntries);
	return CreateAcceleratorTableA (lpaccl, cEntries);
}

public static final int /*long*/ CreateDC (TCHAR lpszDriver, TCHAR lpszDevice, int /*long*/ lpszOutput, int /*long*/ lpInitData) {
	if (IsUnicode) {
		char [] lpszDriver1 = lpszDriver == null ? null : lpszDriver.chars;
		char [] lpszDevice1 = lpszDevice == null ? null : lpszDevice.chars;
		return CreateDCW (lpszDriver1, lpszDevice1, lpszOutput, lpInitData);
	}
	byte [] lpszDriver1 = lpszDriver == null ? null : lpszDriver.bytes;
	byte [] lpszDevice1 = lpszDevice == null ? null : lpszDevice.bytes;
	return CreateDCA (lpszDriver1, lpszDevice1, lpszOutput, lpInitData);
}

public static final int /*long*/ CreateEnhMetaFile (int /*long*/ hdcRef, TCHAR lpFilename, RECT lpRect, TCHAR lpDescription) {
	if (IsUnicode) {
		char [] lpFilename1 = lpFilename == null ? null : lpFilename.chars;
		char [] lpDescription1 = lpDescription == null ? null : lpDescription.chars;
		return CreateEnhMetaFileW (hdcRef, lpFilename1, lpRect, lpDescription1);
	}
	byte [] lpFilename1 = lpFilename == null ? null : lpFilename.bytes;
	byte [] lpDescription1 = lpDescription == null ? null : lpDescription.bytes;
	return CreateEnhMetaFileA (hdcRef, lpFilename1, lpRect, lpDescription1);
}

public static final int /*long*/ CreateFontIndirect (int /*long*/ lplf) {
	if (IsUnicode) return CreateFontIndirectW (lplf);
	return CreateFontIndirectA (lplf);
}

public static final int /*long*/ CreateFontIndirect (LOGFONT lplf) {
	if (IsUnicode) return CreateFontIndirectW ((LOGFONTW)lplf);
	return CreateFontIndirectA ((LOGFONTA)lplf);
}

public static final boolean CreateProcess (int /*long*/ lpApplicationName, int /*long*/ lpCommandLine, int /*long*/ lpProcessAttributes, int /*long*/ lpThreadAttributes, boolean bInheritHandles, int dwCreationFlags, int /*long*/ lpEnvironment, int /*long*/ lpCurrentDirectory, STARTUPINFO lpStartupInfo, PROCESS_INFORMATION lpProcessInformation) {
	if (IsUnicode) return CreateProcessW (lpApplicationName, lpCommandLine, lpProcessAttributes, lpThreadAttributes, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory, lpStartupInfo, lpProcessInformation);
	return CreateProcessA (lpApplicationName, lpCommandLine, lpProcessAttributes, lpThreadAttributes, bInheritHandles, dwCreationFlags, lpEnvironment, lpCurrentDirectory, lpStartupInfo, lpProcessInformation);
}

public static final int /*long*/ CreateWindowEx (int dwExStyle, TCHAR lpClassName, TCHAR lpWindowName, int dwStyle, int X, int Y, int nWidth, int nHeight, int /*long*/ hWndParent, int /*long*/ hMenu, int /*long*/ hInstance, CREATESTRUCT lpParam) {
	if (IsUnicode) {
		char [] lpClassName1 = lpClassName == null ? null : lpClassName.chars;
		char [] lpWindowName1 = lpWindowName == null ? null : lpWindowName.chars;
		return CreateWindowExW (dwExStyle, lpClassName1, lpWindowName1, dwStyle, X, Y, nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam);
	}
	byte [] lpClassName1 = lpClassName == null ? null : lpClassName.bytes;
	byte [] lpWindowName1 = lpWindowName == null ? null : lpWindowName.bytes;
	return CreateWindowExA (dwExStyle, lpClassName1, lpWindowName1, dwStyle, X, Y, nWidth, nHeight, hWndParent, hMenu, hInstance, lpParam);
}

public static final int /*long*/ DefMDIChildProc (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam) {
	if (IsUnicode) return DefMDIChildProcW (hWnd, Msg, wParam, lParam);
	return DefMDIChildProcA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ DefFrameProc (int /*long*/ hWnd, int /*long*/ hWndMDIClient, int Msg, int /*long*/ wParam, int /*long*/ lParam) {
	if (IsUnicode) return DefFrameProcW (hWnd, hWndMDIClient, Msg, wParam, lParam);
	return DefFrameProcA (hWnd, hWndMDIClient, Msg, wParam, lParam);
}
public static final int /*long*/ DefWindowProc (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam) {
	if (IsUnicode) return DefWindowProcW (hWnd, Msg, wParam, lParam);
	return DefWindowProcA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ DispatchMessage (MSG lpmsg) {
	if (IsUnicode) return DispatchMessageW (lpmsg);
	return DispatchMessageA (lpmsg);
}

public static final int DocumentProperties (int /*long*/ hWnd, int /*long*/ hPrinter, TCHAR pDeviceName, int /*long*/ pDevModeOutput, int /*long*/ pDevModeInput, int fMode) {
	if (IsUnicode) {
		char [] pDeviceName1 = pDeviceName == null ? null : pDeviceName.chars;
		return DocumentPropertiesW (hWnd, hPrinter, pDeviceName1, pDevModeOutput, pDevModeInput, fMode);
	}
	byte [] pDeviceName1 = pDeviceName == null ? null : pDeviceName.bytes;
	return DocumentPropertiesA (hWnd, hPrinter, pDeviceName1, pDevModeOutput, pDevModeInput, fMode);
}

public static final int DragQueryFile (int /*long*/ hDrop, int iFile, TCHAR lpszFile, int cch) {
	if (IsUnicode) {
		char [] lpszFile1 = lpszFile == null ? null : lpszFile.chars;
		return DragQueryFileW (hDrop, iFile, lpszFile1, cch);
	}
	byte [] lpszFile1 = lpszFile == null ? null : lpszFile.bytes;
	return DragQueryFileA (hDrop, iFile, lpszFile1, cch);
}

public static final int DrawText (int /*long*/ hDC, TCHAR lpString, int nCount, RECT lpRect, int uFormat) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return DrawTextW (hDC, lpString1, nCount, lpRect, uFormat);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return DrawTextA (hDC, lpString1, nCount, lpRect, uFormat);
}

public static final int EnumFontFamilies (int /*long*/ hdc, TCHAR lpszFamily, int /*long*/ lpEnumFontFamProc, int /*long*/ lParam) {
	if (IsUnicode) {
		char [] lpszFamily1 = lpszFamily == null ? null : lpszFamily.chars;
		return EnumFontFamiliesW (hdc, lpszFamily1, lpEnumFontFamProc, lParam);
	}
	byte [] lpszFamily1 = lpszFamily == null ? null : lpszFamily.bytes;
	return EnumFontFamiliesA (hdc, lpszFamily1, lpEnumFontFamProc, lParam);
}

public static final boolean EnumSystemLocales (int /*long*/ lpLocaleEnumProc, int dwFlags) {
	if (IsUnicode) return EnumSystemLocalesW (lpLocaleEnumProc, dwFlags);
	return EnumSystemLocalesA (lpLocaleEnumProc, dwFlags);
}

public static final boolean EnumSystemLanguageGroups (int /*long*/ pLangGroupEnumProc, int dwFlags, int /*long*/ lParam) {
	if (IsUnicode) return EnumSystemLanguageGroupsW (pLangGroupEnumProc, dwFlags, lParam);
	return EnumSystemLanguageGroupsA (pLangGroupEnumProc, dwFlags, lParam);
}

public static final int ExpandEnvironmentStrings (TCHAR lpSrc, TCHAR lpDst, int nSize) {
	if (IsUnicode) {
		char [] lpSrc1 = lpSrc == null ? null : lpSrc.chars;
		char [] lpDst1 = lpDst == null ? null : lpDst.chars;
		return ExpandEnvironmentStringsW (lpSrc1, lpDst1, nSize);
	}
	byte [] lpSrc1 = lpSrc == null ? null : lpSrc.bytes;
	byte [] lpDst1 = lpDst == null ? null : lpDst.bytes;
	return ExpandEnvironmentStringsA (lpSrc1, lpDst1, nSize);
}

public static final int ExtractIconEx (TCHAR lpszFile, int nIconIndex, int /*long*/ [] phiconLarge, int /*long*/ [] phiconSmall, int nIcons) {
	if (IsUnicode) {
		char [] lpszFile1 = lpszFile == null ? null : lpszFile.chars;
		return ExtractIconExW (lpszFile1, nIconIndex, phiconLarge, phiconSmall, nIcons);
	}
	byte [] lpszFile1 = lpszFile == null ? null : lpszFile.bytes;
	return ExtractIconExA (lpszFile1, nIconIndex, phiconLarge, phiconSmall, nIcons);
}

public static final boolean ExtTextOut(int /*long*/ hdc, int X, int Y, int fuOptions, RECT lprc, TCHAR lpString, int cbCount, int[] lpDx) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return ExtTextOutW (hdc, X, Y, fuOptions, lprc, lpString1, cbCount, lpDx);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return ExtTextOutA (hdc, X, Y, fuOptions, lprc, lpString1, cbCount, lpDx);
}

public static final int FormatMessage (int dwFlags, int /*long*/ lpSource, int dwMessageId, int dwLanguageId, int /*long*/ [] lpBuffer, int nSize, int /*long*/ Arguments) {
	if (IsUnicode) {
		return FormatMessageW (dwFlags, lpSource, dwMessageId, dwLanguageId, lpBuffer, nSize, Arguments);
	}
	return FormatMessageA (dwFlags, lpSource, dwMessageId, dwLanguageId, lpBuffer, nSize, Arguments);
}

public static final boolean GetCharABCWidths (int /*long*/ hdc, int iFirstChar, int iLastChar, int [] lpabc) {
	if (IsUnicode) return GetCharABCWidthsW (hdc,iFirstChar, iLastChar, lpabc);
	return GetCharABCWidthsA (hdc,iFirstChar, iLastChar, lpabc);
}

public static final int GetCharacterPlacement (int /*long*/ hdc, TCHAR lpString, int nCount, int nMaxExtent, GCP_RESULTS lpResults, int dwFlags) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return GetCharacterPlacementW (hdc, lpString1, nCount, nMaxExtent, lpResults, dwFlags);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return GetCharacterPlacementA (hdc, lpString1, nCount, nMaxExtent, lpResults, dwFlags);
}

public static final boolean GetCharWidth (int /*long*/ hdc, int iFirstChar, int iLastChar, int [] lpabc) {
	if (IsUnicode) return GetCharWidthW (hdc,iFirstChar, iLastChar, lpabc);
	return GetCharWidthA (hdc,iFirstChar, iLastChar, lpabc);
}

public static final boolean GetClassInfo (int /*long*/ hInstance, TCHAR lpClassName, WNDCLASS lpWndClass) {
	if (IsUnicode) {
		char [] lpClassName1 = lpClassName == null ? null : lpClassName.chars;
		return GetClassInfoW (hInstance, lpClassName1, lpWndClass);
	}
	byte [] lpClassName1 = lpClassName == null ? null : lpClassName.bytes;
	return GetClassInfoA (hInstance, lpClassName1, lpWndClass);
}

public static final int GetClassName (int /*long*/ hWnd, TCHAR lpClassName, int nMaxCount) {
	if (IsUnicode) {
		char [] lpClassName1 = lpClassName == null ? null : lpClassName.chars;
		return GetClassNameW (hWnd, lpClassName1, nMaxCount);
	}
	byte [] lpClassName1 = lpClassName == null ? null : lpClassName.bytes;
	return GetClassNameA (hWnd, lpClassName1, nMaxCount);
}

public static final int GetClipboardFormatName (int format, TCHAR lpszFormatName, int cchMaxCount) {
	if (IsUnicode) {
		char [] lpszFormatName1 = lpszFormatName == null ? null : lpszFormatName.chars;
		return GetClipboardFormatNameW (format, lpszFormatName1, cchMaxCount);
	}
	byte [] lpszFormatName1 = lpszFormatName == null ? null : lpszFormatName.bytes;
	return GetClipboardFormatNameA (format, lpszFormatName1, cchMaxCount);
}

public static final int GetLocaleInfo (int Locale, int LCType, TCHAR lpLCData, int cchData) {
	if (IsUnicode) {
		char [] lpLCData1 = lpLCData == null ? null : lpLCData.chars;
		return GetLocaleInfoW (Locale, LCType, lpLCData1, cchData);
	}
	byte [] lpLCData1 = lpLCData == null ? null : lpLCData.bytes;
	return GetLocaleInfoA (Locale, LCType, lpLCData1, cchData);
}

public static final boolean GetMenuItemInfo (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii) {
	if (IsUnicode) return GetMenuItemInfoW (hMenu, uItem, fByPosition, lpmii);
	return GetMenuItemInfoA (hMenu, uItem, fByPosition, lpmii);
}

public static final boolean GetMessage (MSG lpMsg, int /*long*/ hWnd, int wMsgFilterMin, int wMsgFilterMax) {
	if (IsUnicode) return GetMessageW (lpMsg, hWnd, wMsgFilterMin, wMsgFilterMax);
	return GetMessageA (lpMsg, hWnd, wMsgFilterMin, wMsgFilterMax);
}

public static final int GetModuleFileName (int /*long*/ hModule, TCHAR lpFilename, int inSize) {
	if (IsUnicode) {
		char [] lpFilename1 = lpFilename == null ? null : lpFilename.chars;
		return GetModuleFileNameW (hModule, lpFilename1, inSize);
	}
	byte [] lpFilename1 = lpFilename == null ? null : lpFilename.bytes;
	return GetModuleFileNameA (hModule, lpFilename1, inSize);
}

public static final int /*long*/ GetModuleHandle (TCHAR lpModuleName) {
	if (IsUnicode) {
		char [] lpModuleName1 = lpModuleName == null ? null : lpModuleName.chars;
		return GetModuleHandleW (lpModuleName1);
	}
	byte [] lpModuleName1 = lpModuleName == null ? null : lpModuleName.bytes;
	return GetModuleHandleA (lpModuleName1);
}

public static final boolean GetMonitorInfo (int /*long*/ hmonitor, MONITORINFO lpmi) {
	if (IsUnicode) return GetMonitorInfoW (hmonitor, lpmi);
	return GetMonitorInfoA (hmonitor, lpmi);
}

public static final int GetObject (int /*long*/ hgdiobj, int cbBuffer, BITMAP lpvObject) {
	if (IsUnicode) return GetObjectW (hgdiobj, cbBuffer, lpvObject);
	return GetObjectA (hgdiobj, cbBuffer, lpvObject);
}

public static final int GetObject (int /*long*/ hgdiobj, int cbBuffer, DIBSECTION lpvObject) {
	if (IsUnicode) return GetObjectW (hgdiobj, cbBuffer, lpvObject);
	return GetObjectA (hgdiobj, cbBuffer, lpvObject);
}

public static final int GetObject (int /*long*/ hgdiobj, int cbBuffer, LOGBRUSH lpvObject) {
	if (IsUnicode) return GetObjectW (hgdiobj, cbBuffer, lpvObject);
	return GetObjectA (hgdiobj, cbBuffer, lpvObject);
}

public static final int GetObject (int /*long*/ hgdiobj, int cbBuffer, LOGFONT lpvObject) {
	if (IsUnicode) return GetObjectW (hgdiobj, cbBuffer, (LOGFONTW)lpvObject);
	return GetObjectA (hgdiobj, cbBuffer, (LOGFONTA)lpvObject);
}

public static final int GetObject (int /*long*/ hgdiobj, int cbBuffer, int /*long*/ lpvObject) {
	if (IsUnicode) return GetObjectW (hgdiobj, cbBuffer, lpvObject);
	return GetObjectA (hgdiobj, cbBuffer, lpvObject);
}

public static final boolean GetOpenFileName (OPENFILENAME lpofn) {
	if (IsUnicode) return GetOpenFileNameW (lpofn);
	return GetOpenFileNameA (lpofn);
}

public static final int GetOutlineTextMetrics (int /*long*/ hdc, int cbData,  OUTLINETEXTMETRIC lpOTM) {
	if (IsUnicode) return GetOutlineTextMetricsW (hdc, cbData, (OUTLINETEXTMETRICW)lpOTM);
	return GetOutlineTextMetricsA (hdc, cbData, (OUTLINETEXTMETRICA)lpOTM);
}

public static final int GetProfileString (TCHAR lpAppName, TCHAR lpKeyName, TCHAR lpDefault, TCHAR lpReturnedString, int nSize) {
	if (IsUnicode) {
		char [] lpAppName1 = lpAppName == null ? null : lpAppName.chars;
		char [] lpKeyName1 = lpKeyName == null ? null : lpKeyName.chars;
		char [] lpDefault1 = lpDefault == null ? null : lpDefault.chars;
		char [] lpReturnedString1 = lpReturnedString == null ? null : lpReturnedString.chars;
		return GetProfileStringW (lpAppName1, lpKeyName1, lpDefault1, lpReturnedString1, nSize);
	}
	byte [] lpAppName1 = lpAppName == null ? null : lpAppName.bytes;
	byte [] lpKeyName1 = lpKeyName == null ? null : lpKeyName.bytes;
	byte [] lpDefault1 = lpDefault == null ? null : lpDefault.bytes;
	byte [] lpReturnedString1 = lpReturnedString == null ? null : lpReturnedString.bytes;
	return GetProfileStringA (lpAppName1, lpKeyName1, lpDefault1, lpReturnedString1, nSize);
}

public static int /*long*/ GetProp (int /*long*/ hWnd, int /*long*/ lpString) {
	if (IsUnicode) return GetPropW (hWnd, lpString);
	return GetPropA (hWnd, lpString);
}

public static final boolean GetSaveFileName (OPENFILENAME lpofn) {
	if (IsUnicode) return GetSaveFileNameW (lpofn);
	return GetSaveFileNameA (lpofn);
}

public static final void GetStartupInfo (STARTUPINFO lpStartupInfo) {
	if (IsUnicode) {
		GetStartupInfoW (lpStartupInfo);
	} else {
		GetStartupInfoA (lpStartupInfo);
	}
}

public static final boolean GetTextExtentPoint32 (int /*long*/ hdc, TCHAR lpString, int cbString, SIZE lpSize) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return GetTextExtentPoint32W (hdc, lpString1, cbString, lpSize);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return GetTextExtentPoint32A (hdc, lpString1, cbString, lpSize);
}

public static final boolean GetTextMetrics (int /*long*/ hdc, TEXTMETRIC lptm) {
	if (IsUnicode) return GetTextMetricsW (hdc, (TEXTMETRICW)lptm);
	return GetTextMetricsA (hdc, (TEXTMETRICA)lptm);
}

public static final int GetWindowLong (int /*long*/ hWnd, int nIndex) {
	if (IsUnicode) return GetWindowLongW (hWnd, nIndex);
	return GetWindowLongA (hWnd, nIndex);
}

public static final int /*long*/ GetWindowLongPtr (int /*long*/ hWnd, int nIndex) {
	if (IsUnicode) return GetWindowLongPtrW (hWnd, nIndex);
	return GetWindowLongPtrA (hWnd, nIndex);
}

public static final int GetWindowText (int /*long*/ hWnd, TCHAR lpString, int nMaxCount) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return GetWindowTextW (hWnd, lpString1, nMaxCount);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return GetWindowTextA (hWnd, lpString1, nMaxCount);
}

public static final int GetWindowTextLength (int /*long*/ hWnd) {
	if (IsUnicode) return GetWindowTextLengthW (hWnd);
	return GetWindowTextLengthA (hWnd);
}

public static final int GlobalAddAtom (TCHAR lpString) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return GlobalAddAtomW (lpString1);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return GlobalAddAtomA (lpString1);
}

public static final boolean ImmGetCompositionFont (int /*long*/ hIMC, LOGFONT lplf) {
	if (IsUnicode) return ImmGetCompositionFontW (hIMC, (LOGFONTW)lplf);
	return ImmGetCompositionFontA (hIMC, (LOGFONTA)lplf);
}

public static final boolean ImmSetCompositionFont (int /*long*/ hIMC, LOGFONT lplf) {
	if (IsUnicode) return ImmSetCompositionFontW (hIMC, (LOGFONTW)lplf);
	return ImmSetCompositionFontA (hIMC, (LOGFONTA)lplf);
}

public static final int ImmGetCompositionString (int /*long*/ hIMC, int dwIndex, byte [] lpBuf, int dwBufLen) {
	if (IsUnicode) {
		return ImmGetCompositionStringW (hIMC, dwIndex, lpBuf, dwBufLen);
	}
	return ImmGetCompositionStringA (hIMC, dwIndex, lpBuf, dwBufLen);
}

public static final int /*long*/ ImmEscape (int /*long*/ hKL,int /*long*/ hIMC, int uEscape, TCHAR lpData) {
	if (IsUnicode) {
		char [] lpData1 = lpData == null ? null : lpData.chars;
		return ImmEscapeW (hKL, hIMC, uEscape, lpData1);
	}
	byte [] lpData1 = lpData == null ? null : lpData.bytes;
	return ImmEscapeA (hKL, hIMC, uEscape, lpData1);
}

public static final int ImmGetCompositionString (int /*long*/ hIMC, int dwIndex, int [] lpBuf, int dwBufLen) {
	if (IsUnicode) {
		return ImmGetCompositionStringW (hIMC, dwIndex, lpBuf, dwBufLen);
	}
	return ImmGetCompositionStringA (hIMC, dwIndex, lpBuf, dwBufLen);
}

public static final int ImmGetCompositionString (int /*long*/ hIMC, int dwIndex, TCHAR lpBuf, int dwBufLen) {
	if (IsUnicode) {
		char [] lpBuf1 = lpBuf == null ? null : lpBuf.chars;
		return ImmGetCompositionStringW (hIMC, dwIndex, lpBuf1, dwBufLen);
	}
	byte [] lpBuf1 = lpBuf == null ? null : lpBuf.bytes;
	return ImmGetCompositionStringA (hIMC, dwIndex, lpBuf1, dwBufLen);
}

public static final boolean InternetGetCookie (TCHAR lpszUrl, TCHAR lpszCookieName, TCHAR lpszCookieData, int[] lpdwSize) {
	if (IsUnicode) {
		char [] url = lpszUrl == null ? null : lpszUrl.chars;
		char [] cookieName = lpszCookieName == null ? null : lpszCookieName.chars;
		char [] cookieData = lpszCookieData == null ? null : lpszCookieData.chars;
		return InternetGetCookieW (url, cookieName, cookieData, lpdwSize);
	}
	byte [] url = lpszUrl == null ? null : lpszUrl.bytes;
	byte [] cookieName = lpszCookieName == null ? null : lpszCookieName.bytes;
	byte [] cookieData = lpszCookieData == null ? null : lpszCookieData.bytes;
	return InternetGetCookieA (url, cookieName, cookieData, lpdwSize);
}

public static final boolean InternetSetCookie (TCHAR lpszUrl, TCHAR lpszCookieName, TCHAR lpszCookieData) {
	if (IsUnicode) {
		char [] url = lpszUrl == null ? null : lpszUrl.chars;
		char [] cookieName = lpszCookieName == null ? null : lpszCookieName.chars;
		char [] cookieData = lpszCookieData == null ? null : lpszCookieData.chars;
		return InternetSetCookieW (url, cookieName, cookieData);
	}
	byte [] url = lpszUrl == null ? null : lpszUrl.bytes;
	byte [] cookieName = lpszCookieName == null ? null : lpszCookieName.bytes;
	byte [] cookieData = lpszCookieData == null ? null : lpszCookieData.bytes;
	return InternetSetCookieA (url, cookieName, cookieData);
}

public static final boolean InsertMenuItem (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii) {
	if (IsUnicode) return InsertMenuItemW (hMenu, uItem, fByPosition, lpmii);
	return InsertMenuItemA (hMenu, uItem, fByPosition, lpmii);
}

public static final int /*long*/ LoadBitmap (int /*long*/ hInstance, int /*long*/ lpBitmapName) {
	if (IsUnicode) return LoadBitmapW (hInstance, lpBitmapName);
	return LoadBitmapA (hInstance, lpBitmapName);
}

public static final int /*long*/ LoadCursor (int /*long*/ hInstance, int /*long*/ lpCursorName) {
	if (IsUnicode) return LoadCursorW (hInstance, lpCursorName);
	return LoadCursorA (hInstance, lpCursorName);
}

public static final int /*long*/ LoadIcon (int /*long*/ hInstance, int /*long*/ lpIconName) {
	if (IsUnicode) return LoadIconW (hInstance, lpIconName);
	return LoadIconA (hInstance, lpIconName);
}

public static final int /*long*/ LoadImage (int /*long*/ hinst, int /*long*/ lpszName, int uType, int cxDesired, int cyDesired, int fuLoad) {
	if (IsUnicode) return LoadImageW (hinst, lpszName, uType, cxDesired, cyDesired, fuLoad);
	return LoadImageA (hinst, lpszName, uType, cxDesired, cyDesired, fuLoad);
}

public static final int MapVirtualKey (int uCode, int uMapType) {
	if (IsUnicode) return MapVirtualKeyW (uCode, uMapType);
	return MapVirtualKeyA (uCode, uMapType);
}

public static final int MessageBox (int /*long*/ hWnd, TCHAR lpText, TCHAR lpCaption, int uType) {
	if (IsUnicode) {
		char [] lpText1 = lpText == null ? null : lpText.chars;
		char [] lpCaption1 = lpCaption == null ? null : lpCaption.chars;
		return MessageBoxW (hWnd, lpText1, lpCaption1, uType);
	}
	byte [] lpText1 = lpText == null ? null : lpText.bytes;
	byte [] lpCaption1 = lpCaption == null ? null : lpCaption.bytes;
	return MessageBoxA (hWnd, lpText1, lpCaption1, uType);
}

public static final void MoveMemory (int /*long*/ Destination, TCHAR Source, int Length) {
	if (IsUnicode) {
		char [] Source1 = Source == null ? null : Source.chars;
		MoveMemory (Destination, Source1, Length);
	} else {
		byte [] Source1 = Source == null ? null : Source.bytes;
		MoveMemory (Destination, Source1, Length);
	}
}

public static final void MoveMemory (TCHAR Destination, int /*long*/ Source, int Length) {
	if (IsUnicode) {
		char [] Destination1 = Destination == null ? null : Destination.chars;
		MoveMemory (Destination1, Source, Length);
	} else {
		byte [] Destination1 = Destination == null ? null : Destination.bytes;
		MoveMemory (Destination1, Source, Length);
	}
}

public static final void MoveMemory (int /*long*/ Destination, DEVMODE Source, int Length) {
	if (IsUnicode) {
		MoveMemory (Destination, (DEVMODEW)Source, Length);
	} else {
		MoveMemory (Destination, (DEVMODEA)Source, Length);
	}
}

public static final void MoveMemory (DEVMODE Destination, int /*long*/ Source, int Length) {
	if (IsUnicode) {
		MoveMemory ((DEVMODEW)Destination, Source, Length);
	} else {
		MoveMemory ((DEVMODEA)Destination, Source, Length);
	}
}

public static final void MoveMemory (int /*long*/ Destination, LOGFONT Source, int Length) {
	if (IsUnicode) {
		MoveMemory (Destination, (LOGFONTW)Source, Length);
	} else {
		MoveMemory (Destination, (LOGFONTA)Source, Length);
	}
}

public static final void MoveMemory (LOGFONT Destination, int /*long*/ Source, int Length) {
	if (IsUnicode) {
		MoveMemory ((LOGFONTW)Destination, Source, Length);
	} else {
		MoveMemory ((LOGFONTA)Destination, Source, Length);
	}
}

public static final void MoveMemory (int /*long*/ Destination, NMTTDISPINFO Source, int Length) {
	if (IsUnicode) {
		MoveMemory (Destination, (NMTTDISPINFOW)Source, Length);
	} else {
		MoveMemory (Destination, (NMTTDISPINFOA)Source, Length);
	}
}

public static final void MoveMemory (NMTTDISPINFO Destination, int /*long*/ Source, int Length) {
	if (IsUnicode) {
		MoveMemory ((NMTTDISPINFOW)Destination, Source, Length);
	} else {
		MoveMemory ((NMTTDISPINFOA)Destination, Source, Length);
	}
}

public static final void MoveMemory (TEXTMETRIC Destination, int /*long*/ Source, int Length) {
	if (IsUnicode) {
		MoveMemory ((TEXTMETRICW)Destination, Source, Length);
	} else {
		MoveMemory ((TEXTMETRICA)Destination, Source, Length);
	}
}

public static final boolean OpenPrinter (TCHAR pPrinterName, int /*long*/ [] phPrinter, int /*long*/ pDefault) {
	if (IsUnicode) {
		char [] pPrinterName1 = pPrinterName == null ? null : pPrinterName.chars;
		return OpenPrinterW (pPrinterName1, phPrinter, pDefault);
	}
	byte [] pPrinterName1 = pPrinterName == null ? null : pPrinterName.bytes;
	return OpenPrinterA (pPrinterName1, phPrinter, pDefault);
}

public static final boolean PeekMessage (MSG lpMsg, int /*long*/ hWnd, int wMsgFilterMin, int wMsgFilterMax, int wRemoveMsg) {
	if (IsUnicode) return PeekMessageW (lpMsg, hWnd, wMsgFilterMin, wMsgFilterMax, wRemoveMsg);
	return PeekMessageA (lpMsg, hWnd, wMsgFilterMin, wMsgFilterMax, wRemoveMsg);
}

public static final boolean PostMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam) {
	if (IsUnicode) return PostMessageW (hWnd, Msg, wParam, lParam);
	return PostMessageA (hWnd, Msg, wParam, lParam);
}

public static final boolean PostThreadMessage (int idThread, int Msg, int /*long*/ wParam, int /*long*/ lParam) {
	if (IsUnicode) return PostThreadMessageW (idThread, Msg, wParam, lParam);
	return PostThreadMessageA (idThread, Msg, wParam, lParam);
}

public static final boolean PrintDlg (PRINTDLG lppd) {
	if (IsUnicode) return PrintDlgW (lppd);
	return PrintDlgA (lppd);
}

public static final int RegCreateKeyEx (int /*long*/ hKey, TCHAR lpSubKey, int Reserved, TCHAR lpClass, int dwOptions, int samDesired, int /*long*/ lpSecurityAttributes, int /*long*/[] phkResult, int /*long*/[] lpdwDisposition) {
	if (IsUnicode) {
		char [] lpClass1 = lpClass == null ? null : lpClass.chars;
		char [] lpSubKey1 = lpSubKey == null ? null : lpSubKey.chars;
		return RegCreateKeyExW (hKey, lpSubKey1, Reserved, lpClass1, dwOptions, samDesired, lpSecurityAttributes, phkResult, lpdwDisposition);
	}
	byte [] lpClass1 = lpClass == null ? null : lpClass.bytes;
	byte [] lpSubKey1 = lpSubKey == null ? null : lpSubKey.bytes;
	return RegCreateKeyExA (hKey, lpSubKey1, Reserved, lpClass1, dwOptions, samDesired, lpSecurityAttributes, phkResult, lpdwDisposition);
}

public static final int RegDeleteValue (int /*long*/ hKey, TCHAR lpValueName) {
	if (IsUnicode) {
		char [] lpValueName1 = lpValueName == null ? null : lpValueName.chars;
		return RegDeleteValueW (hKey, lpValueName1);
	}
	byte [] lpValueName1 = lpValueName == null ? null : lpValueName.bytes;
	return RegDeleteValueA (hKey, lpValueName1);
}

public static final int RegEnumKeyEx (int /*long*/ hKey, int dwIndex, TCHAR lpName, int [] lpcName, int [] lpReserved, TCHAR lpClass, int [] lpcClass, FILETIME lpftLastWriteTime) {
	if (IsUnicode) {
		char [] lpName1 = lpName == null ? null : lpName.chars;
		char [] lpClass1 = lpClass == null ? null : lpClass.chars;
		return RegEnumKeyExW (hKey, dwIndex, lpName1, lpcName, lpReserved, lpClass1, lpcClass, lpftLastWriteTime);
	}
	byte [] lpName1 = lpName == null ? null : lpName.bytes;
	byte [] lpClass1 = lpClass == null ? null : lpClass.bytes;
	return RegEnumKeyExA (hKey, dwIndex, lpName1, lpcName, lpReserved, lpClass1, lpcClass, lpftLastWriteTime);
}

public static final int RegisterClass (WNDCLASS lpWndClass) {
	if (IsUnicode) return RegisterClassW (lpWndClass);
	return RegisterClassA (lpWndClass);
}

public static final int RegisterClipboardFormat (TCHAR lpszFormat) {
	if (IsUnicode) {
		char [] lpszFormat1 = lpszFormat == null ? null : lpszFormat.chars;
		return RegisterClipboardFormatW (lpszFormat1);
	}
	byte [] lpszFormat1 = lpszFormat == null ? null : lpszFormat.bytes;
	return RegisterClipboardFormatA (lpszFormat1);
}

public static final int RegisterWindowMessage (TCHAR lpString) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return RegisterWindowMessageW (lpString1);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return RegisterWindowMessageA (lpString1);
}

public static final int RegOpenKeyEx (int /*long*/ hKey, TCHAR lpSubKey, int ulOptions, int samDesired, int /*long*/[] phkResult) {
	if (IsUnicode) {
		char [] lpSubKey1 = lpSubKey == null ? null : lpSubKey.chars;
		return RegOpenKeyExW (hKey, lpSubKey1, ulOptions, samDesired, phkResult);
	}
	byte [] lpSubKey1 = lpSubKey == null ? null : lpSubKey.bytes;
	return RegOpenKeyExA (hKey, lpSubKey1, ulOptions, samDesired, phkResult);
}

public static final int RegQueryValueEx (int /*long*/ hKey, TCHAR lpValueName, int /*long*/ lpReserved, int[] lpType, TCHAR lpData, int[] lpcbData) {
	if (IsUnicode) {
		char [] lpValueName1 = lpValueName == null ? null : lpValueName.chars;
		char [] lpData1 = lpData == null ? null : lpData.chars;
		return RegQueryValueExW (hKey, lpValueName1, lpReserved, lpType, lpData1, lpcbData);
	}
	byte [] lpValueName1 = lpValueName == null ? null : lpValueName.bytes;
	byte [] lpData1 = lpData == null ? null : lpData.bytes;
	return RegQueryValueExA (hKey, lpValueName1, lpReserved, lpType, lpData1, lpcbData);
}

public static final int RegQueryValueEx (int /*long*/ hKey, TCHAR lpValueName, int /*long*/ lpReserved, int[] lpType, int [] lpData, int[] lpcbData) {
	if (IsUnicode) {
		char [] lpValueName1 = lpValueName == null ? null : lpValueName.chars;
		return RegQueryValueExW (hKey, lpValueName1, lpReserved, lpType, lpData, lpcbData);
	}
	byte [] lpValueName1 = lpValueName == null ? null : lpValueName.bytes;
	return RegQueryValueExA (hKey, lpValueName1, lpReserved, lpType, lpData, lpcbData);
}

public static final int RegSetValueEx (int /*long*/ hKey, TCHAR lpValueName, int Reserved, int dwType, int[] lpData, int cbData) {
	if (IsUnicode) {
		char [] lpValueName1 = lpValueName == null ? null : lpValueName.chars;
		return RegSetValueExW (hKey, lpValueName1, Reserved, dwType, lpData, cbData);
	}
	byte [] lpValueName1 = lpValueName == null ? null : lpValueName.bytes;
	return RegSetValueExA (hKey, lpValueName1, Reserved, dwType, lpData, cbData);
}

public static final int /*long*/ RemoveProp  (int /*long*/ hWnd, int /*long*/ lpString){
	if (IsUnicode) return RemovePropW (hWnd, lpString);
	return RemovePropA (hWnd, lpString);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TCHAR lParam) {
	if (IsUnicode) {
		char [] lParam1 = lParam == null ? null : lParam.chars;
		return SendMessageW (hWnd, Msg, wParam, lParam1);
	}
	byte [] lParam1 = lParam == null ? null : lParam.bytes;
	return SendMessageA (hWnd, Msg, wParam, lParam1);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int [] wParam, int [] lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SIZE lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ [] wParam, int /*long*/ lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int [] lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, char [] lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, short [] lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LITEM lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVCOLUMN lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVHITTESTINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVITEM lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVINSERTMARK lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, MARGINS lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, POINT lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, MCHITTESTINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, REBARBANDINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, RECT lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SYSTEMTIME lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SHDRAGIMAGE lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TBBUTTON lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TBBUTTONINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TCITEM lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TCHITTESTINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TOOLINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVHITTESTINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVINSERTSTRUCT lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVITEM lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVSORTCB lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, UDACCEL lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDHITTESTINFO lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDITEM lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDLAYOUT lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final int /*long*/ SendMessage (int /*long*/ hWnd, int Msg, int /*long*/ wParam, BUTTON_IMAGELIST lParam) {
	if (IsUnicode) return SendMessageW (hWnd, Msg, wParam, lParam);
	return SendMessageA (hWnd, Msg, wParam, lParam);
}

public static final boolean SetMenuItemInfo (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii) {
	if (IsUnicode) return SetMenuItemInfoW (hMenu, uItem, fByPosition, lpmii);
	return SetMenuItemInfoA (hMenu, uItem, fByPosition, lpmii);
}

public static final boolean SetDllDirectory (TCHAR lpPathName) {
	if (IsUnicode) {
		char [] lpPathName1 = lpPathName == null ? null : lpPathName.chars;
		return SetDllDirectoryW (lpPathName1);
	}
	byte [] lpPathName1 = lpPathName == null ? null : lpPathName.bytes;
	return SetDllDirectoryA (lpPathName1);
}

public static boolean SetProp (int /*long*/ hWnd, int /*long*/ lpString, int /*long*/ hData) {
	if (IsUnicode) return SetPropW (hWnd, lpString, hData);
	return SetPropA (hWnd, lpString, hData);
}

public static final int SetWindowLong (int /*long*/ hWnd, int nIndex, int dwNewLong) {
	if (IsUnicode) return SetWindowLongW (hWnd, nIndex, dwNewLong);
	return SetWindowLongA (hWnd, nIndex, dwNewLong);
}

public static final int /*long*/ SetWindowLongPtr (int /*long*/ hWnd, int nIndex, int /*long*/ dwNewLong) {
	if (IsUnicode) return SetWindowLongPtrW (hWnd, nIndex, dwNewLong);
	return SetWindowLongPtrA (hWnd, nIndex, dwNewLong);
}

public static final int /*long*/ SetWindowsHookEx (int idHook, int /*long*/ lpfn, int /*long*/ hMod, int dwThreadId) {
	if (IsUnicode) return SetWindowsHookExW (idHook, lpfn, hMod, dwThreadId);
	return SetWindowsHookExA (idHook, lpfn, hMod, dwThreadId);
}

public static final boolean SetWindowText (int /*long*/ hWnd, TCHAR lpString) {
	if (IsUnicode) {
		char [] lpString1 = lpString == null ? null : lpString.chars;
		return SetWindowTextW (hWnd, lpString1);
	}
	byte [] lpString1 = lpString == null ? null : lpString.bytes;
	return SetWindowTextA (hWnd, lpString1);
}

public static final int /*long*/ SHBrowseForFolder (BROWSEINFO lpbi) {
	if (IsUnicode) return SHBrowseForFolderW (lpbi);
	return SHBrowseForFolderA (lpbi);
}

public static final boolean ShellExecuteEx (SHELLEXECUTEINFO lpExecInfo) {
	if (IsUnicode) return ShellExecuteExW (lpExecInfo);
	return ShellExecuteExA (lpExecInfo);
}

public static int /*long*/ SHGetFileInfo (TCHAR pszPath, int dwFileAttributes, SHFILEINFO psfi, int cbFileInfo, int uFlags) {
	if (IsUnicode) {
		char [] pszPath1 = pszPath == null ? null : pszPath.chars;
		return SHGetFileInfoW (pszPath1, dwFileAttributes, (SHFILEINFOW) psfi, cbFileInfo, uFlags);
	}
	byte [] pszPath1 = pszPath == null ? null : pszPath.bytes;
	return SHGetFileInfoA (pszPath1, dwFileAttributes, (SHFILEINFOA) psfi, cbFileInfo, uFlags);
}

public static final boolean Shell_NotifyIcon (int dwMessage, NOTIFYICONDATA lpData) {
	if (IsUnicode) return Shell_NotifyIconW (dwMessage, (NOTIFYICONDATAW)lpData);
	return Shell_NotifyIconA (dwMessage, (NOTIFYICONDATAA)lpData);
}

public static final boolean SHGetPathFromIDList (int /*long*/ pidl, TCHAR pszPath) {
	if (IsUnicode) {
		char [] pszPath1 = pszPath == null ? null : pszPath.chars;
		return SHGetPathFromIDListW (pidl, pszPath1);
	}
	byte [] pszPath1 = pszPath == null ? null : pszPath.bytes;
	return SHGetPathFromIDListA (pidl, pszPath1);
}

public static final int StartDoc (int /*long*/ hdc, DOCINFO lpdi) {
	if (IsUnicode) return StartDocW (hdc, lpdi);
	return StartDocA (hdc, lpdi);
}

public static final boolean SystemParametersInfo (int uiAction, int uiParam, RECT pvParam, int fWinIni) {
	if (IsUnicode) return SystemParametersInfoW (uiAction, uiParam, pvParam, fWinIni);
	return SystemParametersInfoA (uiAction, uiParam, pvParam, fWinIni);
}

public static final boolean SystemParametersInfo (int uiAction, int uiParam, HIGHCONTRAST pvParam, int fWinIni) {
	if (IsUnicode) return SystemParametersInfoW (uiAction, uiParam, pvParam, fWinIni);
	return SystemParametersInfoA (uiAction, uiParam, pvParam, fWinIni);
}

public static final boolean SystemParametersInfo (int uiAction, int uiParam, NONCLIENTMETRICS pvParam, int fWinIni) {
	if (IsUnicode) return SystemParametersInfoW (uiAction, uiParam, (NONCLIENTMETRICSW)pvParam, fWinIni);
	return SystemParametersInfoA (uiAction, uiParam, (NONCLIENTMETRICSA)pvParam, fWinIni);
}

public static final boolean SystemParametersInfo (int uiAction, int uiParam, int [] pvParam, int fWinIni) {
	if (IsUnicode) return SystemParametersInfoW (uiAction, uiParam, pvParam, fWinIni);
	return SystemParametersInfoA (uiAction, uiParam, pvParam, fWinIni);
}

public static final int TranslateAccelerator (int /*long*/ hWnd, int /*long*/ hAccTable, MSG lpMsg) {
	if (IsUnicode) return TranslateAcceleratorW (hWnd, hAccTable, lpMsg);
	return TranslateAcceleratorA (hWnd, hAccTable, lpMsg);
}

public static final boolean UnregisterClass (TCHAR lpClassName, int /*long*/ hInstance) {
	if (IsUnicode) {
		char [] lpClassName1 = lpClassName == null ? null : lpClassName.chars;
		return UnregisterClassW (lpClassName1, hInstance);
	}
	byte [] lpClassName1 = lpClassName == null ? null : lpClassName.bytes;
	return UnregisterClassA (lpClassName1, hInstance);
}

public static final int UrlCreateFromPath (TCHAR pszPath, TCHAR pszURL, int[] pcchUrl, int flags) {
	if (IsUnicode) {
		char [] path = pszPath == null ? null : pszPath.chars;
		char [] url = pszURL == null ? null : pszURL.chars;
		return UrlCreateFromPathW (path, url, pcchUrl, flags);
	}
	byte [] path = pszPath == null ? null : pszPath.bytes;
	byte [] url = pszURL == null ? null : pszURL.bytes;
	return UrlCreateFromPathA (path, url, pcchUrl, flags);
}

public static final short VkKeyScan (short ch) {
	if (IsUnicode) return VkKeyScanW (ch);
	return VkKeyScanA (ch);
}

/** Natives */

/** @param hdc cast=(HDC) */
public static final native int AbortDoc (int /*long*/ hdc);
/**
 * @method flags=dynamic
 * @param lpCookie cast=(ULONG_PTR*)
 */
public static final native boolean ActivateActCtx (int /*long*/ hActCtx, int /*long*/ [] lpCookie);
/** @param hkl cast=(HKL) */
public static final native int /*long*/ ActivateKeyboardLayout(int /*long*/ hkl, int Flags);
/** @method flags=dynamic */
public static final native int AddFontResourceExW(char[] lpszFilename, int fl, int /*long*/ pdv);
/** @method flags=dynamic */
public static final native int AddFontResourceExA(byte[] lpszFilename, int fl, int /*long*/ pdv);
public static final native boolean AdjustWindowRectEx (RECT lpRect, int dwStyle, boolean bMenu, int dwExStyle);
/** @method flags=dynamic */
public static final native boolean AllowSetForegroundWindow (int dwProcessId);
/**
 * @method flags=dynamic
 * @param blendFunction flags=struct
 */
public static final native boolean AlphaBlend(int /*long*/ hdcDest, int nXOriginDest, int nYOriginDest, int nWidthDest, int nHeightDest, int /*long*/ hdcSrc, int nXOriginSrc, int nYOriginSrc, int nWidthSrc, int nHeightSrc, BLENDFUNCTION blendFunction);
/** @param hdc cast=(HDC) */
public static final native boolean Arc (int /*long*/ hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nXStartArc, int nYStartArc, int nXEndArc, int nYEndArc);
/** @method flags=dynamic */
public static final native int AssocQueryStringA(int flags, int str, byte[] pszAssoc, byte[] pszExtra, byte[] pszOut, int[] pcchOut);
/** @method flags=dynamic */
public static final native int AssocQueryStringW(int flags, int str, char[] pszAssoc, char[] pszExtra, char[] pszOut, int[] pcchOut);
/**
 * @method flags=dynamic
 * @param hdcTarget cast=(HDC)
 * @param phdc cast=(HDC*)
 */
public static final native int /*long*/ BeginBufferedPaint (int /*long*/ hdcTarget, RECT prcTarget, int dwFormat, BP_PAINTPARAMS pPaintParams, int /*long*/ [] phdc);
public static final native int /*long*/ BeginDeferWindowPos (int nNumWindows);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ BeginPaint (int /*long*/ hWnd, PAINTSTRUCT lpPaint);
/** @param hdc cast=(HDC) */
public static final native boolean BeginPath(int /*long*/ hdc);
/**
 * @param hdcDest cast=(HDC)
 * @param hdcSrc cast=(HDC)
 */
public static final native boolean BitBlt (int /*long*/ hdcDest, int nXDest, int nYDest, int nWidth, int nHeight, int /*long*/ hdcSrc, int nXSrc, int nYSrc, int dwRop);
/** @param hWnd cast=(HWND) */
public static final native boolean BringWindowToTop (int /*long*/ hWnd);
/** @method flags=dynamic */
public static final native int BufferedPaintInit ();
/** @method flags=dynamic */
public static final native int BufferedPaintUnInit ();
/**
 * @param hhk cast=(HHOOK)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ CallNextHookEx(int /*long*/ hhk, int nCode, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param lpPrevWndFunc cast=(WNDPROC)
 * @param hWnd cast=(HWND)
 */
public static final native int /*long*/ CallWindowProcW (int /*long*/ lpPrevWndFunc, int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param lpPrevWndFunc cast=(WNDPROC)
 * @param hWnd cast=(HWND)
 */
public static final native int /*long*/ CallWindowProcA (int /*long*/ lpPrevWndFunc, int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param pName cast=(PCERT_NAME_BLOB)
 * @param psz cast=(LPWSTR)
 */
public static final native int CertNameToStrW(int dwCertEncodingType, CERT_NAME_BLOB pName, int dwStrType, char[] psz, int csz);
/**
 * @param pName cast=(PCERT_NAME_BLOB)
 * @param psz cast=(LPSTR)
 */
public static final native int CertNameToStrA(int dwCertEncodingType, CERT_NAME_BLOB pName, int dwStrType, byte[] psz, int csz);
/** @param ch cast=(LPWSTR) */
public static final native int /*long*/ CharLowerW (int /*long*/ ch);
/** @param ch cast=(LPSTR) */
public static final native int /*long*/ CharLowerA (int /*long*/ ch);
/** @param ch cast=(LPWSTR) */
public static final native int /*long*/ CharUpperW (int /*long*/ ch);
/** @param ch cast=(LPSTR) */
public static final native int /*long*/ CharUpperA (int /*long*/ ch);
/** @param lpcc cast=(LPCHOOSECOLORW) */
public static final native boolean ChooseColorW (CHOOSECOLOR lpcc);
public static final native boolean ChooseColorA (CHOOSECOLOR lpcc);
/** @param chooseFont cast=(LPCHOOSEFONTW) */
public static final native boolean ChooseFontW (CHOOSEFONT chooseFont);
public static final native boolean ChooseFontA (CHOOSEFONT chooseFont);
/** @param hWnd cast=(HWND) */
public static final native boolean ClientToScreen (int /*long*/ hWnd, POINT lpPoint);
public static final native boolean CloseClipboard ();
/** @param hdc cast=(HDC) */
public static final native int /*long*/ CloseEnhMetaFile (int /*long*/ hdc);
/**
 * @method flags=dynamic
 * @param hGesture cast=(HGESTUREINFO)
 */
public static final native int /*long*/ CloseGestureInfoHandle (int /*long*/ hGesture);
/** @param hObject cast=(HANDLE) */
public static final native boolean CloseHandle (int /*long*/ hObject);
/** @param hPrinter cast=(HANDLE) */
public static final native boolean ClosePrinter (int /*long*/ hPrinter);
/**
 * @method flags=dynamic
 * @param hTheme cast=(HTHEME)
 */
public static final native int CloseThemeData (int /*long*/ hTheme);
/**
 * @method flags=dynamic
 * @param hTouchInput cast=(HTOUCHINPUT)
 */
public static final native boolean CloseTouchInputHandle(int /*long*/ hTouchInput);
/**
 * @param rclsid cast=(REFCLSID)
 * @param pUnkOuter cast=(LPUNKNOWN)
 * @param riid cast=(REFIID)
 * @param ppv cast=(LPVOID *)
 */
public static final native int CoCreateInstance (byte[] rclsid, int /*long*/ pUnkOuter, int dwClsContext, byte[] riid, int /*long*/[] ppv);
/** @method flags=dynamic */
public static final native int CoInternetIsFeatureEnabled (int FeatureEntry, int dwFlags);
/**
 * @method flags=dynamic
 * @param fEnable cast=(BOOL)
 */
public static final native int CoInternetSetFeatureEnabled (int FeatureEntry, int dwFlags, boolean fEnable);
/**
 * @param hrgnDest cast=(HRGN)
 * @param hrgnSrc1 cast=(HRGN)
 * @param hrgnSrc2 cast=(HRGN)
 */
public static final native int CombineRgn (int /*long*/ hrgnDest, int /*long*/ hrgnSrc1, int /*long*/ hrgnSrc2, int fnCombineMode);
public static final native int CommDlgExtendedError ();
/** @param hImage cast=(HANDLE) */
public static final native int /*long*/ CopyImage (int /*long*/ hImage, int uType, int cxDesired, int cyDesired, int fuFlags);
/** @param cb cast=(ULONG) */
public static final native int /*long*/ CoTaskMemAlloc(int cb);
/** @param pv cast=(LPVOID) */
public static final native void CoTaskMemFree(int /*long*/ pv);
/** @param lpaccl cast=(LPACCEL) */
public static final native int /*long*/ CreateAcceleratorTableW (byte [] lpaccl, int cEntries);
/** @param lpaccl cast=(LPACCEL) */
public static final native int /*long*/ CreateAcceleratorTableA (byte [] lpaccl, int cEntries);
/**
 * @method flags=dynamic
 * @param pActCtx flags=no_out
 */
public static final native int /*long*/ CreateActCtxW (ACTCTX pActCtx);
/**
 * @method flags=dynamic
 * @param pActCtx flags=no_out
 */
public static final native int /*long*/ CreateActCtxA (ACTCTX pActCtx);
/** @param lpvBits cast=(CONST VOID *),flags=no_out critical */
public static final native int /*long*/ CreateBitmap (int nWidth, int nHeight, int cPlanes, int cBitsPerPel, byte [] lpvBits);
/**
 * @param hWnd cast=(HWND)
 * @param hBitmap cast=(HBITMAP)
 */
public static final native boolean CreateCaret (int /*long*/ hWnd, int /*long*/ hBitmap, int nWidth, int nHeight);
/** @param hdc cast=(HDC) */
public static final native int /*long*/ CreateCompatibleBitmap (int /*long*/ hdc, int nWidth, int nHeight);
/** @param hdc cast=(HDC) */
public static final native int /*long*/ CreateCompatibleDC (int /*long*/ hdc);
/**
 * @param hInst cast=(HINSTANCE)
 * @param pvANDPlane cast=(CONST VOID *),flags=no_out critical
 * @param pvXORPlane cast=(CONST VOID *),flags=no_out critical
 */
public static final native int /*long*/ CreateCursor (int /*long*/ hInst, int xHotSpot, int yHotSpot, int nWidth, int nHeight, byte [] pvANDPlane, byte [] pvXORPlane);
/**
 * @param lpszDriver cast=(LPWSTR)
 * @param lpszDevice cast=(LPWSTR)
 * @param lpszOutput cast=(LPWSTR)
 * @param lpInitData cast=(CONST DEVMODEW *)
 */
public static final native int /*long*/ CreateDCW (char [] lpszDriver, char [] lpszDevice, int /*long*/ lpszOutput, int /*long*/ lpInitData);
/**
 * @param lpszDriver cast=(LPSTR)
 * @param lpszDevice cast=(LPSTR)
 * @param lpszOutput cast=(LPSTR)
 * @param lpInitData cast=(CONST DEVMODE *)
 */
public static final native int /*long*/ CreateDCA (byte [] lpszDriver, byte [] lpszDevice, int /*long*/ lpszOutput, int /*long*/ lpInitData);
/**
 * @param hdc cast=(HDC)
 * @param pbmi cast=(BITMAPINFO *),flags=no_out critical
 * @param ppvBits cast=(VOID **),flags=no_in critical
 * @param hSection cast=(HANDLE)
 */
public static final native int /*long*/ CreateDIBSection(int /*long*/ hdc, byte[] pbmi, int iUsage, int /*long*/[] ppvBits, int /*long*/ hSection, int dwOffset);
/**
 * @param hdc cast=(HDC)
 * @param pbmi cast=(BITMAPINFO *),flags=no_out critical
 * @param ppvBits cast=(VOID **),flags=no_in critical
 * @param hSection cast=(HANDLE)
 */
public static final native int /*long*/ CreateDIBSection(int /*long*/ hdc, int /*long*/ pbmi, int iUsage, int /*long*/[] ppvBits, int /*long*/ hSection, int dwOffset);
/**
 * @param hdcRef cast=(HDC)
 * @param lpFilename cast=(LPCWSTR)
 * @param lpDescription cast=(LPCWSTR)
 */
public static final native int /*long*/ CreateEnhMetaFileW(int /*long*/ hdcRef, char[] lpFilename, RECT lpRect, char[] lpDescription);
/**
 * @param hdcRef cast=(HDC)
 * @param lpFilename cast=(LPCSTR)
 * @param lpDescription cast=(LPCSTR)
 */
public static final native int /*long*/ CreateEnhMetaFileA(int /*long*/ hdcRef, byte[] lpFilename, RECT lpRect, byte[] lpDescription);
/** @param lplf cast=(LPLOGFONTW) */
public static final native int /*long*/ CreateFontIndirectW (int /*long*/ lplf);
/** @param lplf cast=(LPLOGFONTA) */
public static final native int /*long*/ CreateFontIndirectA (int /*long*/ lplf);
/** @param lplf flags=no_out */
public static final native int /*long*/ CreateFontIndirectW (LOGFONTW lplf);
/** @param lplf flags=no_out */
public static final native int /*long*/ CreateFontIndirectA (LOGFONTA lplf);
/** @param lplf flags=no_out */
public static final native int /*long*/ CreateIconIndirect (ICONINFO lplf);
public static final native int /*long*/ CreateMenu ();
/** @param logPalette cast=(LOGPALETTE *),flags=no_out critical */
public static final native int /*long*/ CreatePalette (byte[] logPalette);
/** @param hbmp cast=(HBITMAP) */
public static final native int /*long*/ CreatePatternBrush (int /*long*/ hbmp);
/** @param crColor cast=(COLORREF) */
public static final native int /*long*/ CreatePen (int fnPenStyle, int nWidth, int crColor);
/** @param lppt cast=(CONST POINT *) */
public static final native int /*long*/ CreatePolygonRgn(int[] lppt, int cPoints, int fnPolyFillMode);
public static final native int /*long*/ CreatePopupMenu ();
/**
 * @param lpApplicationName cast=(LPCWSTR)
 * @param lpCommandLine cast=(LPWSTR)
 * @param lpProcessAttributes cast=(LPSECURITY_ATTRIBUTES)
 * @param lpThreadAttributes cast=(LPSECURITY_ATTRIBUTES)
 * @param lpEnvironment cast=(LPVOID)
 * @param lpCurrentDirectory cast=(LPWSTR)
 * @param lpStartupInfo cast=(LPSTARTUPINFOW)
 * @param lpProcessInformation cast=(LPPROCESS_INFORMATION)
 */
public static final native boolean CreateProcessW (int /*long*/ lpApplicationName, int /*long*/ lpCommandLine, int /*long*/ lpProcessAttributes, int /*long*/ lpThreadAttributes, boolean bInheritHandles, int dwCreationFlags, int /*long*/ lpEnvironment, int /*long*/ lpCurrentDirectory, STARTUPINFO lpStartupInfo, PROCESS_INFORMATION lpProcessInformation);
/**
 * @param lpApplicationName cast=(LPCSTR)
 * @param lpCommandLine cast=(LPSTR)
 * @param lpProcessAttributes cast=(LPSECURITY_ATTRIBUTES)
 * @param lpThreadAttributes cast=(LPSECURITY_ATTRIBUTES)
 * @param lpEnvironment cast=(LPVOID)
 * @param lpCurrentDirectory cast=(LPSTR)
 * @param lpStartupInfo cast=(LPSTARTUPINFOA)
 * @param lpProcessInformation cast=(LPPROCESS_INFORMATION)
 */
public static final native boolean CreateProcessA (int /*long*/ lpApplicationName, int /*long*/ lpCommandLine, int /*long*/ lpProcessAttributes, int /*long*/ lpThreadAttributes, boolean bInheritHandles, int dwCreationFlags, int /*long*/ lpEnvironment, int /*long*/ lpCurrentDirectory, STARTUPINFO lpStartupInfo, PROCESS_INFORMATION lpProcessInformation);
public static final native int /*long*/ CreateRectRgn (int left, int top, int right, int bottom);
/** @param colorRef cast=(COLORREF) */
public static final native int /*long*/ CreateSolidBrush (int colorRef);
/**
 * @param hGlobal cast=(HGLOBAL)
 * @param fDeleteOnRelease cast=(BOOL)
 * @param ppstm cast=(LPSTREAM *)
 */
public static final native int CreateStreamOnHGlobal(int /*long*/ hGlobal, boolean fDeleteOnRelease, int /*long*/[] ppstm);
/**
 * @param lpClassName cast=(LPWSTR)
 * @param lpWindowName cast=(LPWSTR)
 * @param hWndParent cast=(HWND)
 * @param hMenu cast=(HMENU)
 * @param hInstance cast=(HINSTANCE)
 */
public static final native int /*long*/ CreateWindowExW (int dwExStyle, char [] lpClassName, char [] lpWindowName, int dwStyle, int X, int Y, int nWidth, int nHeight, int /*long*/ hWndParent, int /*long*/ hMenu, int /*long*/ hInstance, CREATESTRUCT lpParam);
/**
 * @param lpClassName cast=(LPSTR)
 * @param hWndParent cast=(HWND)
 * @param hMenu cast=(HMENU)
 * @param hInstance cast=(HINSTANCE)
 */
public static final native int /*long*/ CreateWindowExA (int dwExStyle, byte [] lpClassName, byte [] lpWindowName, int dwStyle, int X, int Y, int nWidth, int nHeight, int /*long*/ hWndParent, int /*long*/ hMenu, int /*long*/ hInstance, CREATESTRUCT lpParam);
/**
 * @param hWinPosInfo cast=(HDWP)
 * @param hWnd cast=(HWND)
 * @param hWndInsertAfter cast=(HWND)
 */
public static final native int /*long*/ DeferWindowPos (int /*long*/ hWinPosInfo, int /*long*/ hWnd, int /*long*/ hWndInsertAfter, int X, int Y, int cx, int cy, int uFlags);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ DefMDIChildProcW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ DefMDIChildProcA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param hWndMDIClient cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ DefFrameProcW (int /*long*/ hWnd, int /*long*/ hWndMDIClient, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param hWndMDIClient cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ DefFrameProcA (int /*long*/ hWnd, int /*long*/ hWndMDIClient, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ DefWindowProcW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ DefWindowProcA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/** @param hdc cast=(HDC) */
public static final native boolean DeleteDC (int /*long*/ hdc);
/** @param hemf cast=(HENHMETAFILE) */
public static final native boolean DeleteEnhMetaFile (int /*long*/ hemf);
/** @param hMenu cast=(HMENU) */
public static final native boolean DeleteMenu (int /*long*/ hMenu, int uPosition, int uFlags);
/** @param hGdiObj cast=(HGDIOBJ) */
public static final native boolean DeleteObject (int /*long*/ hGdiObj);
/** @param hAccel cast=(HACCEL) */
public static final native boolean DestroyAcceleratorTable (int /*long*/ hAccel);
public static final native boolean DestroyCaret ();
/** @param hCursor cast=(HCURSOR) */
public static final native boolean DestroyCursor (int /*long*/ hCursor);
/** @param hIcon cast=(HICON) */
public static final native boolean DestroyIcon (int /*long*/ hIcon);
/** @param hMenu cast=(HMENU) */
public static final native boolean DestroyMenu (int /*long*/ hMenu);
/** @param hWnd cast=(HWND) */
public static final native boolean DestroyWindow (int /*long*/ hWnd);
public static final native int /*long*/ DispatchMessageW (MSG lpmsg);
public static final native int /*long*/ DispatchMessageA (MSG lpmsg);
/**
 * @param hWnd cast=(HWND)
 * @param hPrinter cast=(HANDLE)
 * @param pDeviceName cast=(LPWSTR)
 * @param pDevModeOutput cast=(PDEVMODEW)
 * @param pDevModeInput cast=(PDEVMODEW)
 */
public static final native int DocumentPropertiesW (int /*long*/ hWnd, int /*long*/ hPrinter, char[] pDeviceName, int /*long*/ pDevModeOutput, int /*long*/ pDevModeInput, int fMode);
/**
 * @param hWnd cast=(HWND)
 * @param hPrinter cast=(HANDLE)
 * @param pDeviceName cast=(LPTSTR)
 * @param pDevModeOutput cast=(PDEVMODE)
 * @param pDevModeInput cast=(PDEVMODE)
 */
public static final native int DocumentPropertiesA (int /*long*/ hWnd, int /*long*/ hPrinter, byte[] pDeviceName, int /*long*/ pDevModeOutput, int /*long*/ pDevModeInput, int fMode);
/**
 * @param hwnd cast=(HWND)
 * @param pt flags=struct
 */
public static final native boolean DragDetect (int /*long*/ hwnd, POINT pt);
/** @param hDrop cast=(HDROP) */
public static final native void DragFinish (int /*long*/ hDrop);
/**
 * @param hDrop cast=(HDROP)
 * @param lpszFile cast=(LPTSTR)
 */
public static final native int DragQueryFileA (int /*long*/ hDrop, int iFile, byte[] lpszFile, int cch);
/**
 * @param hDrop cast=(HDROP)
 * @param lpszFile cast=(LPWSTR)
 */
public static final native int DragQueryFileW (int /*long*/ hDrop, int iFile, char[] lpszFile, int cch);
/** @param hdc cast=(HDC) */
public static final native boolean DrawEdge (int /*long*/ hdc, RECT qrc, int edge, int grfFlags);
/** @param hDC cast=(HDC) */
public static final native boolean DrawFocusRect (int /*long*/ hDC, RECT lpRect);
/** @param hdc cast=(HDC) */
public static final native boolean DrawFrameControl (int /*long*/ hdc, RECT lprc, int uType, int uState);
/**
 * @param hdc cast=(HDC)
 * @param hIcon cast=(HICON)
 * @param hbrFlickerFreeDraw cast=(HBRUSH)
 */
public static final native boolean DrawIconEx (int /*long*/ hdc, int xLeft, int yTop, int /*long*/ hIcon, int cxWidth, int cyWidth, int istepIfAniCur, int /*long*/ hbrFlickerFreeDraw, int diFlags);
/** @param hWnd cast=(HWND) */
public static final native boolean DrawMenuBar (int /*long*/ hWnd);
/**
 * @param hDC cast=(HDC)
 * @param lpString cast=(LPWSTR),flags=no_out critical
 */
public static final native int DrawTextW (int /*long*/ hDC, char [] lpString, int nCount, RECT lpRect, int uFormat);
/**
 * @param hDC cast=(HDC)
 * @param lpString cast=(LPSTR),flags=no_out critical
 */
public static final native int DrawTextA (int /*long*/ hDC, byte [] lpString, int nCount, RECT lpRect, int uFormat);
/**
 * @method flags=dynamic
 * @param hTheme cast=(HTHEME)
 * @param hdc cast=(HDC)
 * @param pRect cast=(const RECT *)
 * @param pClipRect cast=(const RECT *)
 */
public static final native int DrawThemeBackground (int /*long*/ hTheme, int /*long*/ hdc, int iPartId, int iStateId, RECT pRect, RECT pClipRect);
/** @method flags=dynamic */
public static final native int DrawThemeText (int /*long*/ hTheme, int /*long*/ hdc, int iPartId, int iStateId, char[] pszText, int iCharCount, int dwTextFlags, int dwTextFlags2, RECT pRect);
/** @param hdc cast=(HDC) */
public static final native boolean Ellipse (int /*long*/ hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);
/** @param hMenu cast=(HMENU) */
public static final native boolean EnableMenuItem (int /*long*/ hMenu, int uIDEnableItem, int uEnable);
/** @param hWnd cast=(HWND) */
public static final native boolean EnableScrollBar (int /*long*/ hWnd, int wSBflags, int wArrows);
/** @param hWnd cast=(HWND) */
public static final native boolean EnableWindow (int /*long*/ hWnd, boolean bEnable);
/**
 * @method flags=dynamic
 * @param pLangGroupEnumProc cast=(LANGUAGEGROUP_ENUMPROCW)
 * @param lParam cast=(LONG_PTR)
 */
public static final native boolean EnumSystemLanguageGroupsW(int /*long*/ pLangGroupEnumProc, int dwFlags, int /*long*/ lParam);
/**
 * @method flags=dynamic
 * @param pLangGroupEnumProc cast=(LANGUAGEGROUP_ENUMPROCA)
 * @param lParam cast=(LONG_PTR)
 */
public static final native boolean EnumSystemLanguageGroupsA(int /*long*/ pLangGroupEnumProc, int dwFlags, int /*long*/ lParam);
/** @param lpLocaleEnumProc cast=(LOCALE_ENUMPROCW) */
public static final native boolean EnumSystemLocalesW (int /*long*/ lpLocaleEnumProc, int dwFlags);
/** @param lpLocaleEnumProc cast=(LOCALE_ENUMPROCA) */
public static final native boolean EnumSystemLocalesA (int /*long*/ lpLocaleEnumProc, int dwFlags);
/** @param hWinPosInfo cast=(HDWP) */
public static final native boolean EndDeferWindowPos (int /*long*/ hWinPosInfo);
/**
 * @method flags=dynamic
 * @param hBufferedPaint cast=(HPAINTBUFFER)
 */
public static final native int EndBufferedPaint (int /*long*/ hBufferedPaint, boolean fUpdateTarget);
/** @param hdc cast=(HDC) */
public static final native int EndDoc (int /*long*/ hdc);
/** @param hdc cast=(HDC) */
public static final native int EndPage (int /*long*/ hdc);
/** @param hWnd cast=(HWND) */
public static final native int EndPaint (int /*long*/ hWnd, PAINTSTRUCT lpPaint);
/**
 * @method flags=dynamic
 * @param hdc cast=(HDC)
 * @param lprcClip cast=(LPCRECT)
 * @param lpfnEnum cast=(MONITORENUMPROC)
 * @param dwData cast=(LPARAM)
 */
public static final native boolean EnumDisplayMonitors (int /*long*/ hdc, RECT lprcClip, int /*long*/ lpfnEnum, int dwData);
/**
 * @param hdc cast=(HDC)
 * @param hemf cast=(HENHMETAFILE)
 * @param lpEnhMetaFunc cast=(ENHMFENUMPROC)
 * @param lpData cast=(LPVOID)
 */
public static final native boolean EnumEnhMetaFile(int /*long*/ hdc, int /*long*/ hemf, int /*long*/ lpEnhMetaFunc, int /*long*/ lpData, RECT lpRect);
/**
 * @param hdc cast=(HDC)
 * @param lpszFamily cast=(LPCWSTR)
 * @param lpEnumFontFamProc cast=(FONTENUMPROCW)
 * @param lParam cast=(LPARAM)
 */
public static final native int EnumFontFamiliesW (int /*long*/ hdc, char [] lpszFamily, int /*long*/ lpEnumFontFamProc, int /*long*/ lParam);
/**
 * @param hdc cast=(HDC)
 * @param lpszFamily cast=(LPSTR)
 * @param lpEnumFontFamProc cast=(FONTENUMPROC)
 * @param lParam cast=(LPARAM)
 */
public static final native int EnumFontFamiliesA (int /*long*/ hdc, byte [] lpszFamily, int /*long*/ lpEnumFontFamProc, int /*long*/ lParam);
/**
 * @param lprc1 cast=(CONST RECT *),flags=no_out
 * @param lprc2 cast=(CONST RECT *),flags=no_out
 */
public static final native boolean EqualRect (RECT lprc1, RECT lprc2);
/** @param hdc cast=(HDC) */
public static final native int ExcludeClipRect (int /*long*/ hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);
public static final native int ExpandEnvironmentStringsW (char [] lpSrc, char [] lsDst, int nSize);
public static final native int ExpandEnvironmentStringsA (byte [] lpSrc, byte [] lsDst, int nSize);
/**
 * @param lplb cast=(CONST LOGBRUSH *)
 * @param lpStyle cast=(CONST DWORD *)
 */
public static final native int /*long*/ ExtCreatePen (int dwPenStyle, int dwWidth, LOGBRUSH lplb, int dwStyleCount, int[] lpStyle);
/**
 * @param lpXform cast=(XFORM *)
 * @param lpRgnData cast=(CONST RGNDATA *)
 */
public static final native int /*long*/ ExtCreateRegion (float[] lpXform, int nCount, int[] lpRgnData);
/**
 * @param hdc cast=(HDC)
 * @param lprc flags=no_out
 * @param lpString cast=(LPWSTR),flags=no_out critical
 * @param lpDx cast=(CONST INT *),flags=no_out critical
 */
public static final native boolean ExtTextOutW (int /*long*/ hdc, int X, int Y, int fuOptions, RECT lprc, char[] lpString, int cbCount, int[] lpDx);
/**
 * @param hdc cast=(HDC)
 * @param lprc flags=no_out
 * @param lpString cast=(LPSTR),flags=no_out critical
 * @param lpDx cast=(CONST INT *),flags=no_out critical
 */
public static final native boolean ExtTextOutA (int /*long*/ hdc, int X, int Y, int fuOptions, RECT lprc, byte[] lpString, int cbCount, int[] lpDx);
/**
 * @param lpszFile cast=(LPWSTR)
 * @param phiconLarge cast=(HICON FAR *)
 * @param phiconSmall cast=(HICON FAR *)
 */
public static final native int ExtractIconExW (char [] lpszFile, int nIconIndex, int /*long*/ [] phiconLarge, int /*long*/ [] phiconSmall, int nIcons);
/**
 * @param lpszFile cast=(LPSTR)
 * @param phiconLarge cast=(HICON FAR *)
 * @param phiconSmall cast=(HICON FAR *)
 */
public static final native int ExtractIconExA (byte [] lpszFile, int nIconIndex, int /*long*/ [] phiconLarge, int /*long*/ [] phiconSmall, int nIcons);
public static final native boolean FileTimeToSystemTime (FILETIME lpFileTime, SYSTEMTIME lpSystemTime);
/**
 * @param hDC cast=(HDC)
 * @param lprc flags=no_out
 * @param hbr cast=(HBRUSH)
 */
public static final native int FillRect (int /*long*/ hDC, RECT lprc, int /*long*/ hbr);
/**
 * @param lpSource cast=(LPCVOID)
 * @param lpBuffer cast=(LPSTR)
 * @param Arguments cast=(va_list*)
 */
public static final native int FormatMessageA (int dwFlags, int /*long*/ lpSource, int dwMessageId, int dwLanguageId, int /*long*/ [] lpBuffer, int nSize, int /*long*/ Arguments);
/**
 * @param lpSource cast=(LPCVOID)
 * @param lpBuffer cast=(LPWSTR)
 * @param Arguments cast=(va_list*)
 */
public static final native int FormatMessageW (int dwFlags, int /*long*/ lpSource, int dwMessageId, int dwLanguageId, int /*long*/ [] lpBuffer, int nSize, int /*long*/ Arguments);
/** @param dwLimit cast=(DWORD) */
public static final native int GdiSetBatchLimit (int dwLimit);
public static final native int GET_WHEEL_DELTA_WPARAM(int /*long*/ wParam);
public static final native int GET_X_LPARAM(int /*long*/ lp);
public static final native int GET_Y_LPARAM(int /*long*/ lp);
public static final native int GetACP ();
public static final native int /*long*/ GetActiveWindow ();
/** @param hDC cast=(HDC) */
public static final native int GetBkColor (int /*long*/ hDC);
public static final native int /*long*/ GetCapture ();
public static final native boolean GetCaretPos (POINT lpPoint);
/**
 * @param hdc cast=(HDC)
 * @param lpabc cast=(LPABC),flags=no_in critical
 */
public static final native boolean GetCharABCWidthsA (int /*long*/ hdc, int iFirstChar, int iLastChar, int [] lpabc);
/**
 * @param hdc cast=(HDC)
 * @param lpabc cast=(LPABC),flags=no_in critical
 */
public static final native boolean GetCharABCWidthsW (int /*long*/ hdc, int iFirstChar, int iLastChar, int [] lpabc);
/**
 * @param hdc cast=(HDC)
 * @param lpString cast=(LPWSTR),flags=no_out critical
 * @param lpResults cast=(LPGCP_RESULTSW)
 */
public static final native int GetCharacterPlacementW (int /*long*/ hdc, char[] lpString, int nCount, int nMaxExtent, GCP_RESULTS lpResults, int dwFlags);
/**
 * @param hdc cast=(HDC)
 * @param lpString cast=(LPSTR),flags=no_out critical
 */
public static final native int GetCharacterPlacementA (int /*long*/ hdc, byte[] lpString, int nCount, int nMaxExtent, GCP_RESULTS lpResults, int dwFlags);
/**
 * @param hdc cast=(HDC)
 * @param lpBuffer cast=(LPINT),flags=no_in critical
 */
public static final native boolean GetCharWidthA (int /*long*/ hdc, int iFirstChar, int iLastChar, int [] lpBuffer);
/**
 * @param hdc cast=(HDC)
 * @param lpBuffer cast=(LPINT),flags=no_in critical
 */
public static final native boolean GetCharWidthW (int /*long*/ hdc, int iFirstChar, int iLastChar, int [] lpBuffer);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpClassName cast=(LPWSTR)
 * @param lpWndClass cast=(LPWNDCLASSW)
 */
public static final native boolean GetClassInfoW (int /*long*/ hInstance, char [] lpClassName, WNDCLASS lpWndClass);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpClassName cast=(LPSTR)
 */
public static final native boolean GetClassInfoA (int /*long*/ hInstance, byte [] lpClassName, WNDCLASS lpWndClass);
/** @param hWnd cast=(HWND) */
public static final native int GetClassNameW (int /*long*/ hWnd, char [] lpClassName, int nMaxCount);
/** @param hWnd cast=(HWND) */
public static final native int GetClassNameA (int /*long*/ hWnd, byte [] lpClassName, int nMaxCount);
/** @param hWnd cast=(HWND) */
public static final native boolean GetClientRect (int /*long*/ hWnd, RECT lpRect);
public static final native int /*long*/ GetClipboardData (int uFormat);
public static final native int GetClipboardFormatNameA (int format, byte[] lpszFormatName, int cchMaxCount);
/** @param lpszFormatName cast=(LPWSTR) */
public static final native int GetClipboardFormatNameW (int format, char[] lpszFormatName, int cchMaxCount);
/** @param hdc cast=(HDC) */
public static final native int GetClipBox (int /*long*/ hdc, RECT lprc);
/**
 * @param hdc cast=(HDC)
 * @param hrgn cast=(HRGN)
 */
public static final native int GetClipRgn (int /*long*/ hdc, int /*long*/ hrgn);
/**
 * @method flags=dynamic
 * @param hwndCombo cast=(HWND)
 */
public static final native boolean GetComboBoxInfo (int /*long*/ hwndCombo, COMBOBOXINFO pcbi);
/** @param hdc cast=(HDC) */
public static final native int /*long*/ GetCurrentObject (int /*long*/ hdc, int uObjectType);
public static final native int GetCurrentProcessId ();
public static final native int GetCurrentThreadId ();
/** @method flags=dynamic */
public static final native int GetCurrentProcessExplicitAppUserModelID(int /*long*/[] AppID);
public static final native int /*long*/ GetCursor ();
public static final native boolean GetCursorPos (POINT lpPoint);
/** @param hwnd cast=(HWND) */
public static final native int /*long*/ GetDC (int /*long*/ hwnd);
/**
 * @param hWnd cast=(HWND)
 * @param hrgnClip cast=(HRGN)
 */
public static final native int /*long*/ GetDCEx (int /*long*/ hWnd, int /*long*/ hrgnClip, int flags);
public static final native int /*long*/ GetDesktopWindow ();
/** @param hdc cast=(HDC) */
public static final native int GetDeviceCaps (int /*long*/ hdc, int nIndex);
public static final native int GetDialogBaseUnits ();
/**
 * @param hdc cast=(HDC)
 * @param pColors cast=(RGBQUAD *),flags=no_in critical
 */
public static final native int GetDIBColorTable (int /*long*/ hdc, int uStartIndex, int cEntries, byte[] pColors);
/**
 * @param hdc cast=(HDC)
 * @param hbmp cast=(HBITMAP)
 * @param lpvBits cast=(LPVOID),flags=critical
 * @param lpbi cast=(LPBITMAPINFO),flags=critical
 */
public static final native int GetDIBits (int /*long*/ hdc, int /*long*/ hbmp, int uStartScan, int cScanLines, byte[] lpvBits, byte[] lpbi, int uUsage);
/** @param hDlg cast=(HWND) */
public static final native int /*long*/ GetDlgItem (int /*long*/ hDlg, int nIDDlgItem);
public static final native int GetDoubleClickTime ();
/** @method flags=dynamic */
public static final native int GetDpiForMonitor (int /*long*/ hmonitor, int dpiType, int [] dpiX, int [] dpiY);
public static final native int /*long*/ GetFocus ();
/** @param hdc cast=(HDC) */
public static final native int GetFontLanguageInfo (int /*long*/ hdc);
public static final native int /*long*/ GetForegroundWindow ();
/**
 * @method flags=dynamic
 * @param hGestureInfo cast=(HGESTUREINFO)
 * @param pGestureInfo cast=(PGESTUREINFO)
 */
public static final native boolean GetGestureInfo(int /*long*/ hGestureInfo, GESTUREINFO pGestureInfo);
/** @param hdc cast=(HDC) */
public static final native int GetGraphicsMode (int /*long*/ hdc);
/**
 * @param hdc cast=(HDC)
 * @param pgi cast=(LPWORD)
 */
public static final native int GetGlyphIndicesW(int /*long*/ hdc, char[] lpstr, int c, short[] pgi, int fl);
/**
 * @param idThread cast=(DWORD)
 * @param lpgui cast=(LPGUITHREADINFO)
 */
public static final native boolean GetGUIThreadInfo (int idThread, GUITHREADINFO lpgui);
/**
 * @param hIcon cast=(HICON)
 * @param piconinfo flags=no_in
 */
public static final native boolean GetIconInfo (int /*long*/ hIcon, ICONINFO piconinfo);
/** @param lpList cast=(HKL FAR *) */
public static final native int GetKeyboardLayoutList (int nBuff, int /*long*/ [] lpList);
public static final native int /*long*/ GetKeyboardLayout (int idThread);
public static final native short GetKeyState (int nVirtKey);
/** @param lpKeyState cast=(PBYTE) */
public static final native boolean GetKeyboardState (byte [] lpKeyState);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetLastActivePopup (int /*long*/ hWnd);
public static final native int GetLastError ();
/**
 * @method flags=dynamic
 * @param hwnd cast=(HWND)
 */
public static final native boolean GetLayeredWindowAttributes (int /*long*/ hwnd, int [] pcrKey, byte [] pbAlpha, int [] pdwFlags);
/**
 * @method flags=dynamic
 * @param hdc cast=(HDC)
 */
public static final native int GetLayout (int /*long*/ hdc);
/* returns the instance handle to the swt library */
/** @method flags=no_gen */
public static final native int /*long*/ GetLibraryHandle ();
/** @param lpLCData cast=(LPWSTR) */
public static final native int GetLocaleInfoW (int Locale, int LCType, char [] lpLCData, int cchData);
/** @param lpLCData cast=(LPSTR) */
public static final native int GetLocaleInfoA (int Locale, int LCType, byte [] lpLCData, int cchData);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetMenu (int /*long*/ hWnd);
/** @method flags=dynamic */
public static final native boolean GetMenuBarInfo (int /*long*/ hWnd, int idObject, int idItem, MENUBARINFO pmbi);
/** @param hMenu cast=(HMENU) */
public static final native int GetMenuDefaultItem (int /*long*/ hMenu, int fByPos, int gmdiFlags);
/**
 * @method flags=dynamic
 * @param hmenu cast=(HMENU)
 */
public static final native boolean GetMenuInfo (int /*long*/ hmenu, MENUINFO lpcmi);
/** @param hMenu cast=(HMENU) */
public static final native int GetMenuItemCount (int /*long*/ hMenu);
/**
 * @param hMenu cast=(HMENU)
 * @param lpmii cast=(LPMENUITEMINFOW)
 */
public static final native boolean GetMenuItemInfoW (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii);
/** @param hMenu cast=(HMENU) */
public static final native boolean GetMenuItemInfoA (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii);
/**
 * @param hWnd cast=(HWND)
 * @param hMenu cast=(HMENU)
 */
public static final native boolean GetMenuItemRect (int /*long*/ hWnd, int /*long*/ hMenu, int uItem, RECT lprcItem);
/** @param hWnd cast=(HWND) */
public static final native boolean GetMessageW (MSG lpMsg, int /*long*/ hWnd, int wMsgFilterMin, int wMsgFilterMax);
/** @param hWnd cast=(HWND) */
public static final native boolean GetMessageA (MSG lpMsg, int /*long*/ hWnd, int wMsgFilterMin, int wMsgFilterMax);
public static final native int GetMessagePos ();
public static final native int GetMessageTime ();
/**
 * @param hdc cast=(HDC)
 * @param hrgn cast=(HRGN)
 */
public static final native int GetMetaRgn (int /*long*/ hdc, int /*long*/ hrgn);
/**
 * @method flags=dynamic
 * @param prc flags=no_out
 * @param psz flags=no_in
 */
public static final native int GetThemePartSize(int /*long*/ hTheme, int /*long*/ hdc, int iPartId, int iStateId, RECT prc, int eSize, SIZE psz);
/** @method flags=dynamic */
public static final native int GetThemeTextExtent (int /*long*/ hTheme, int /*long*/ hdc, int iPartId, int iStateId, char[] pszText, int iCharCount, int dwTextFlags, RECT pBoundingRect, RECT pExtentRect);
/**
 * @param hModule cast=(HMODULE)
 * @param lpFilename cast=(LPWSTR)
 */
public static final native int GetModuleFileNameW (int /*long*/ hModule, char [] lpFilename, int inSize);
/**
 * @param hModule cast=(HMODULE)
 * @param lpFilename cast=(LPSTR)
 */
public static final native int GetModuleFileNameA (int /*long*/ hModule, byte [] lpFilename, int inSize);
/** @param lpModuleName cast=(LPWSTR) */
public static final native int /*long*/ GetModuleHandleW (char [] lpModuleName);
/** @param lpModuleName cast=(LPSTR) */
public static final native int /*long*/ GetModuleHandleA (byte [] lpModuleName);
/**
 * @method flags=dynamic
 * @param hmonitor cast=(HMONITOR)
 * @param lpmi cast=(LPMONITORINFO)
 */
public static final native boolean GetMonitorInfoW (int /*long*/ hmonitor, MONITORINFO lpmi);
/**
 * @method flags=dynamic
 * @param hmonitor cast=(HMONITOR)
 * @param lpmi cast=(LPMONITORINFO)
 */
public static final native boolean GetMonitorInfoA (int /*long*/ hmonitor, MONITORINFO lpmi);
/**
 * @param hPal cast=(HPALETTE)
 * @param crColor cast=(COLORREF)
 */
public static final native int GetNearestPaletteIndex (int /*long*/ hPal, int crColor);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectA (int /*long*/ hgdiobj, int cbBuffer, BITMAP lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectW (int /*long*/ hgdiobj, int cbBuffer, BITMAP lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectA (int /*long*/ hgdiobj, int cbBuffer, DIBSECTION lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectW (int /*long*/ hgdiobj, int cbBuffer, DIBSECTION lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectA (int /*long*/ hgdiobj, int cbBuffer, LOGBRUSH lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectW (int /*long*/ hgdiobj, int cbBuffer, LOGBRUSH lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectA (int /*long*/ hgdiobj, int cbBuffer, LOGFONTA lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject flags=no_in
 */
public static final native int GetObjectW (int /*long*/ hgdiobj, int cbBuffer, LOGFONTW lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject cast=(LPVOID),flags=no_in
 */
public static final native int GetObjectA (int /*long*/ hgdiobj, int cbBuffer, int /*long*/ lpvObject);
/**
 * @param hgdiobj cast=(HGDIOBJ)
 * @param lpvObject cast=(LPVOID),flags=no_in
 */
public static final native int GetObjectW (int /*long*/ hgdiobj, int cbBuffer, int /*long*/ lpvObject);
/** @param lpofn cast=(LPOPENFILENAMEW) */
public static final native boolean GetOpenFileNameW (OPENFILENAME lpofn);
public static final native boolean GetOpenFileNameA (OPENFILENAME lpofn);
/** @param hdc cast=(HDC) */
public static final native int GetOutlineTextMetricsW (int /*long*/ hdc, int cbData, OUTLINETEXTMETRICW lpOTM);
/** @param hdc cast=(HDC) */
public static final native int GetOutlineTextMetricsA (int /*long*/ hdc, int cbData, OUTLINETEXTMETRICA lpOTM);
/**
 * @param hPalette cast=(HPALETTE)
 * @param logPalette cast=(LPPALETTEENTRY),flags=no_in critical
 */
public static final native int GetPaletteEntries (int /*long*/ hPalette, int iStartIndex, int nEntries, byte[] logPalette);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetParent (int /*long*/ hWnd);
/** @param hdc cast=(HDC) */
public static final native int GetPixel (int /*long*/ hdc, int x, int y);
/** @param hdc cast=(HDC) */
public static final native int GetPolyFillMode (int /*long*/ hdc);
/**
 * @param pPrinterName cast=(LPWSTR)
 * @param phPrinter cast=(LPHANDLE)
 * @param pDefault cast=(LPPRINTER_DEFAULTSW)
 */
public static final native boolean OpenPrinterW (char[] pPrinterName, int /*long*/ [] phPrinter, int /*long*/ pDefault);
/**
 * @param pPrinterName cast=(LPTSTR)
 * @param phPrinter cast=(LPHANDLE)
 * @param pDefault cast=(LPPRINTER_DEFAULTS)
 */
public static final native boolean OpenPrinterA (byte[] pPrinterName, int /*long*/ [] phPrinter, int /*long*/ pDefault);
public static final native int /*long*/ GetProcessHeap ();
/**
 * @param lpAppName cast=(LPWSTR)
 * @param lpKeyName cast=(LPWSTR)
 * @param lpDefault cast=(LPWSTR)
 * @param lpReturnedString cast=(LPWSTR)
 */
public static final native int GetProfileStringW (char [] lpAppName, char [] lpKeyName, char [] lpDefault, char [] lpReturnedString, int nSize);
/**
 * @param lpAppName cast=(LPSTR)
 * @param lpKeyName cast=(LPSTR)
 * @param lpDefault cast=(LPSTR)
 * @param lpReturnedString cast=(LPSTR)
 */
public static final native int GetProfileStringA (byte [] lpAppName, byte [] lpKeyName, byte [] lpDefault, byte [] lpReturnedString, int nSize);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPCWSTR)
 */
public static final native int /*long*/ GetPropW (int /*long*/ hWnd, int /*long*/ lpString);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPCTSTR)
 */
public static final native int /*long*/ GetPropA (int /*long*/ hWnd, int /*long*/ lpString);
/**
 * @param hdc cast=(HDC)
 * @param hrgn cast=(HRGN)
 */
public static final native int GetRandomRgn (int /*long*/ hdc, int /*long*/ hrgn, int iNum);
/**
 * @param hRgn cast=(HRGN)
 * @param lpRgnData cast=(RGNDATA *),flags=no_in critical
 */
public static final native int GetRegionData (int /*long*/ hRgn, int dwCount, int [] lpRgnData);
/**
 * @param hrgn cast=(HRGN)
 * @param lprc flags=no_in
 */
public static final native int GetRgnBox (int /*long*/ hrgn, RECT lprc);
/** @param hdc cast=(HDC) */
public static final native int GetROP2 (int /*long*/ hdc);
/** @param lpofn cast=(LPOPENFILENAMEW) */
public static final native boolean GetSaveFileNameW (OPENFILENAME lpofn);
public static final native boolean GetSaveFileNameA (OPENFILENAME lpofn);
/** @param hwnd cast=(HWND) */
public static final native boolean GetScrollBarInfo (int /*long*/ hwnd, int idObject, SCROLLBARINFO psbi);
/** @param hwnd cast=(HWND) */
public static final native boolean GetScrollInfo (int /*long*/ hwnd, int flags, SCROLLINFO info);
/** @param lpStartupInfo cast=(LPSTARTUPINFOW) */
public static final native void GetStartupInfoW (STARTUPINFO lpStartupInfo);
/** @param lpStartupInfo cast=(LPSTARTUPINFOA) */
public static final native void GetStartupInfoA (STARTUPINFO lpStartupInfo);
public static final native int /*long*/ GetStockObject (int fnObject);
public static final native int GetSysColor (int nIndex);
public static final native int /*long*/ GetSysColorBrush (int nIndex);
/** @method flags=dynamic */
public static final native short GetSystemDefaultUILanguage ();
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetSystemMenu (int /*long*/ hWnd, boolean bRevert);
public static final native int GetSystemMetrics (int nIndex);
/**
 * @param hdc cast=(HDC)
 * @param iStartIndex cast=(UINT)
 * @param nEntries cast=(UINT)
 * @param lppe cast=(LPPALETTEENTRY),flags=no_in critical
 */
public static final native int GetSystemPaletteEntries (int /*long*/ hdc, int iStartIndex, int nEntries, byte[] lppe);
/** @param hDC cast=(HDC) */
public static final native int GetTextColor (int /*long*/ hDC);
/**
 * @param hdc cast=(HDC)
 * @param lpString cast=(LPWSTR),flags=no_out critical
 * @param lpSize flags=no_in
 */
public static final native boolean GetTextExtentPoint32W (int /*long*/ hdc, char [] lpString, int cbString, SIZE lpSize);
/**
 * @param hdc cast=(HDC)
 * @param lpString cast=(LPSTR),flags=no_out critical
 * @param lpSize flags=no_in
 */
public static final native boolean GetTextExtentPoint32A (int /*long*/ hdc, byte [] lpString, int cbString, SIZE lpSize);
/**
 * @param hdc cast=(HDC)
 * @param lptm flags=no_in
 */
public static final native boolean GetTextMetricsW (int /*long*/ hdc, TEXTMETRICW lptm);
/**
 * @param hdc cast=(HDC)
 * @param lptm flags=no_in
 */
public static final native boolean GetTextMetricsA (int /*long*/ hdc, TEXTMETRICA lptm);
/**
 * @method flags=dynamic
 * @param hTouchInput cast=(HTOUCHINPUT)
 * @param cInputs cast=(UINT)
 * @param pTouchInputs cast=(PTOUCHINPUT)
 */
public static final native boolean GetTouchInputInfo(int /*long*/ hTouchInput, int cInputs, int /*long*/ pTouchInputs, int cbSize);
/**
 * @param hWnd cast=(HWND)
 * @param lpRect cast=(LPRECT)
 * @param bErase cast=(BOOL)
 */
public static final native boolean GetUpdateRect (int /*long*/ hWnd, RECT lpRect, boolean bErase);
/**
 * @param hWnd cast=(HWND)
 * @param hRgn cast=(HRGN)
 */
public static final native int GetUpdateRgn (int /*long*/ hWnd, int /*long*/ hRgn, boolean bErase);
public static final native int GetVersion ();
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetWindow (int /*long*/ hWnd, int uCmd);
/** @param hWnd cast=(HWND) */
public static final native int GetWindowLongW (int /*long*/ hWnd, int nIndex);
/** @param hWnd cast=(HWND) */
public static final native int GetWindowLongA (int /*long*/ hWnd, int nIndex);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetWindowLongPtrW (int /*long*/ hWnd, int nIndex);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetWindowLongPtrA (int /*long*/ hWnd, int nIndex);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ GetWindowDC (int /*long*/ hWnd);
/** @param hdc cast=(HDC) */
public static final native boolean GetWindowOrgEx (int /*long*/ hdc, POINT lpPoint);
/** @param hWnd cast=(HWND) */
public static final native boolean GetWindowPlacement (int /*long*/ hWnd, WINDOWPLACEMENT lpwndpl);
/** @param hWnd cast=(HWND) */
public static final native boolean GetWindowRect (int /*long*/ hWnd, RECT lpRect);
/**
 * @param hWnd cast=(HWND)
 * @param hRgn cast=(HRGN)
 */
public static final native int GetWindowRgn (int /*long*/ hWnd, int /*long*/ hRgn);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPWSTR)
 */
public static final native int GetWindowTextW (int /*long*/ hWnd, char [] lpString, int nMaxCount);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPSTR)
 */
public static final native int GetWindowTextA (int /*long*/ hWnd, byte [] lpString, int nMaxCount);
/** @param hWnd cast=(HWND) */
public static final native int GetWindowTextLengthW (int /*long*/ hWnd);
/** @param hWnd cast=(HWND) */
public static final native int GetWindowTextLengthA (int /*long*/ hWnd);
/**
 * @param hWnd cast=(HWND)
 * @param lpdwProcessId cast=(LPDWORD)
 */
public static final native int GetWindowThreadProcessId (int /*long*/ hWnd, int [] lpdwProcessId);
public static final native double GID_ROTATE_ANGLE_FROM_ARGUMENT(long dwArgument);
/** @param lpString cast=(LPCWSTR) */
public static final native int GlobalAddAtomW (char [] lpString);
/** @param lpString cast=(LPCTSTR) */
public static final native int GlobalAddAtomA (byte [] lpString);
public static final native int /*long*/ GlobalAlloc (int uFlags, int dwBytes);
/** @param hMem cast=(HANDLE) */
public static final native int /*long*/ GlobalFree (int /*long*/ hMem);
/** @param hMem cast=(HANDLE) */
public static final native int /*long*/ GlobalLock (int /*long*/ hMem);
/** @param hMem cast=(HANDLE) */
public static final native int GlobalSize (int /*long*/ hMem);
/** @param hMem cast=(HANDLE) */
public static final native boolean GlobalUnlock (int /*long*/ hMem);
/**
 * @method flags=dynamic
 * @param hdc cast=(HDC)
 * @param pVertex cast=(PTRIVERTEX)
 * @param dwNumVertex cast=(ULONG)
 * @param pMesh cast=(PVOID)
 * @param dwNumMesh cast=(ULONG)
 * @param dwMode cast=(ULONG)
 */
public static final native boolean GradientFill (int /*long*/ hdc, int /*long*/ pVertex, int dwNumVertex, int /*long*/ pMesh, int dwNumMesh, int dwMode);
public static final native int HIWORD(int /*long*/ l);
/** @param hHeap cast=(HANDLE) */
public static final native int /*long*/ HeapAlloc (int /*long*/ hHeap, int dwFlags, int dwBytes);
/**
 * @param hHeap cast=(HANDLE)
 * @param lpMem cast=(LPVOID)
 */
public static final native boolean HeapFree (int /*long*/ hHeap, int dwFlags, int /*long*/ lpMem);
/** @param hWnd cast=(HWND) */
public static final native boolean HideCaret (int /*long*/ hWnd);
/**
 * @param lpsz cast=(LPOLESTR)
 * @param lpiid cast=(LPIID)
 */
public static final native int IIDFromString (char[] lpsz, byte[] lpiid);
/**
 * @param himl cast=(HIMAGELIST)
 * @param hbmImage cast=(HBITMAP)
 * @param hbmMask cast=(HBITMAP)
 */
public static final native int ImageList_Add (int /*long*/ himl, int /*long*/ hbmImage, int /*long*/ hbmMask);
/**
 * @param himl cast=(HIMAGELIST)
 * @param hbmImage cast=(HBITMAP)
 * @param crMask cast=(COLORREF)
 */
public static final native int ImageList_AddMasked (int /*long*/ himl, int /*long*/ hbmImage, int crMask);
/** @param himl cast=(HIMAGELIST) */
public static final native boolean ImageList_BeginDrag (int /*long*/ himl, int iTrack, int dxHotspot, int dyHotspot);
public static final native int /*long*/ ImageList_Create (int cx, int cy, int flags, int cInitial, int cGrow);
/** @param himl cast=(HIMAGELIST) */
public static final native boolean ImageList_Destroy (int /*long*/ himl);
/** @param hwndLock cast=(HWND) */
public static final native boolean ImageList_DragEnter (int /*long*/ hwndLock, int x, int y);
/** @param hwndLock cast=(HWND) */
public static final native boolean ImageList_DragLeave (int /*long*/ hwndLock);
public static final native boolean ImageList_DragMove (int x, int y);
/** @param fShow cast=(BOOL) */
public static final native boolean ImageList_DragShowNolock (boolean fShow);
public static final native void ImageList_EndDrag ();
/**
 * @param himl cast=(HIMAGELIST)
 * @param cx cast=(int *)
 * @param cy cast=(int *)
 */
public static final native boolean ImageList_GetIconSize (int /*long*/ himl, int [] cx, int [] cy);
/** @param himl cast=(HIMAGELIST) */
public static final native int ImageList_GetImageCount (int /*long*/ himl);
/** @param himl cast=(HIMAGELIST) */
public static final native boolean ImageList_Remove (int /*long*/ himl, int i);
/**
 * @param himl cast=(HIMAGELIST)
 * @param hbmImage cast=(HBITMAP)
 * @param hbmMask cast=(HBITMAP)
 */
public static final native boolean ImageList_Replace (int /*long*/ himl, int i, int /*long*/ hbmImage, int /*long*/ hbmMask);
/**
 * @param himl cast=(HIMAGELIST)
 * @param hicon cast=(HICON)
 */
public static final native int ImageList_ReplaceIcon (int /*long*/ himl, int i, int /*long*/ hicon);
/** @param himl cast=(HIMAGELIST) */
public static final native boolean ImageList_SetIconSize (int /*long*/ himl, int cx, int cy);
/**
 * @param hWnd cast=(HWND)
 * @param hIMC cast=(HIMC)
 */
public static final native int /*long*/ ImmAssociateContext (int /*long*/ hWnd, int /*long*/ hIMC);
public static final native int /*long*/ ImmCreateContext ();
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmDestroyContext (int /*long*/ hIMC);
/**
 * @param hKL cast=(HKL)
 * @param hIMC cast=(HIMC)
 * @param lpData cast=(LPVOID)
 */
public static final native int /*long*/ ImmEscapeW(int /*long*/ hKL, int /*long*/ hIMC, int uEscape, char[] lpData);
/**
 * @param hKL cast=(HKL)
 * @param hIMC cast=(HIMC)
 * @param lpData cast=(LPVOID)
 */
public static final native int /*long*/ ImmEscapeA(int /*long*/ hKL, int /*long*/ hIMC, int uEscape, byte[] lpData);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmGetCompositionFontW (int /*long*/ hIMC, LOGFONTW lplf);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmGetCompositionFontA (int /*long*/ hIMC, LOGFONTA lplf);
/**
 * @param hIMC cast=(HIMC)
 * @param lpBuf cast=(LPWSTR)
 */
public static final native int ImmGetCompositionStringW (int /*long*/ hIMC, int dwIndex, char [] lpBuf, int dwBufLen);
/**
 * @param hIMC cast=(HIMC)
 * @param lpBuf cast=(LPSTR)
 */
public static final native int ImmGetCompositionStringA (int /*long*/ hIMC, int dwIndex, byte [] lpBuf, int dwBufLen);
/**
 * @param hIMC cast=(HIMC)
 * @param lpBuf cast=(LPWSTR)
 */
public static final native int ImmGetCompositionStringW (int /*long*/ hIMC, int dwIndex, int [] lpBuf, int dwBufLen);
/**
 * @param hIMC cast=(HIMC)
 * @param lpBuf cast=(LPWSTR)
 */
public static final native int ImmGetCompositionStringA (int /*long*/ hIMC, int dwIndex, int [] lpBuf, int dwBufLen);
/**
 * @param hIMC cast=(HIMC)
 * @param lpBuf cast=(LPWSTR)
 */
public static final native int ImmGetCompositionStringW (int /*long*/ hIMC, int dwIndex, byte [] lpBuf, int dwBufLen);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ ImmGetContext (int /*long*/ hWnd);
/**
 * @param hIMC cast=(HIMC)
 * @param lpfdwConversion cast=(LPDWORD)
 * @param lpfdwSentence cast=(LPDWORD)
 */
public static final native boolean ImmGetConversionStatus (int /*long*/ hIMC, int [] lpfdwConversion, int [] lpfdwSentence);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ ImmGetDefaultIMEWnd (int /*long*/ hWnd);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmGetOpenStatus (int /*long*/ hIMC);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmNotifyIME (int /*long*/ hIMC, int dwAction, int dwIndex, int dwValue);
/**
 * @param hWnd cast=(HWND)
 * @param hIMC cast=(HIMC)
 */
public static final native boolean ImmReleaseContext (int /*long*/ hWnd, int /*long*/ hIMC);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmSetCompositionFontW (int /*long*/ hIMC, LOGFONTW lplf);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmSetCompositionFontA (int /*long*/ hIMC, LOGFONTA lplf);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmSetCompositionWindow (int /*long*/ hIMC, COMPOSITIONFORM lpCompForm);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmSetCandidateWindow (int /*long*/ hIMC, CANDIDATEFORM lpCandidate);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmSetConversionStatus (int /*long*/ hIMC, int fdwConversion, int dwSentence);
/** @param hIMC cast=(HIMC) */
public static final native boolean ImmSetOpenStatus (int /*long*/ hIMC, boolean fOpen);
public static final native void InitCommonControls ();
public static final native boolean InitCommonControlsEx (INITCOMMONCONTROLSEX lpInitCtrls);
/**
 * @param hMenu cast=(HMENU)
 * @param lpmii cast=(LPMENUITEMINFOW)
 */
public static final native boolean InsertMenuItemW (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii);
/** @param hMenu cast=(HMENU) */
public static final native boolean InsertMenuItemA (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii);
/**
 * @param lpszUrl cast=(LPCTSTR)
 * @param lpszCookieName cast=(LPCTSTR)
 * @param lpszCookieData cast=(LPSTR)
 * @param lpdwSize cast=(LPDWORD)
 */
public static final native boolean InternetGetCookieA (byte[] lpszUrl, byte[] lpszCookieName, byte[] lpszCookieData, int[] lpdwSize);
/**
 * @param lpszUrl cast=(LPCWSTR)
 * @param lpszCookieName cast=(LPCWSTR)
 * @param lpszCookieData cast=(LPWSTR)
 * @param lpdwSize cast=(LPDWORD)
 */
public static final native boolean InternetGetCookieW (char[] lpszUrl, char[] lpszCookieName, char[] lpszCookieData, int[] lpdwSize);
/**
 * @param lpszUrl cast=(LPCTSTR)
 * @param lpszCookieName cast=(LPCTSTR)
 * @param lpszCookieData cast=(LPCTSTR)
 */
public static final native boolean InternetSetCookieA (byte[] lpszUrl, byte[] lpszCookieName, byte[] lpszCookieData);
/**
 * @param lpszUrl cast=(LPCWSTR)
 * @param lpszCookieName cast=(LPCWSTR)
 * @param lpszCookieData cast=(LPCWSTR)
 */
public static final native boolean InternetSetCookieW (char[] lpszUrl, char[] lpszCookieName, char[] lpszCookieData);
/**
 * @param hInternet cast=(HINTERNET)
 * @param lpBuffer cast=(LPVOID)
 */
public static final native boolean InternetSetOption (int /*long*/ hInternet, int dwOption, int /*long*/ lpBuffer, int dwBufferLength);
/** @param hdc cast=(HDC) */
public static final native int IntersectClipRect (int /*long*/ hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);
/**
 * @param lprcDst flags=no_in
 * @param lprcSrc1 flags=no_out
 * @param lprcSrc2 flags=no_out
 */
public static final native boolean IntersectRect (RECT lprcDst, RECT lprcSrc1, RECT lprcSrc2);
/** @param hWnd cast=(HWND) */
public static final native boolean InvalidateRect (int /*long*/ hWnd, RECT lpRect, boolean bErase);
/**
 * @param hWnd cast=(HWND)
 * @param hRgn cast=(HRGN)
 */
public static final native boolean InvalidateRgn (int /*long*/ hWnd, int /*long*/ hRgn, boolean bErase);
/** @method flags=dynamic */
public static final native boolean IsAppThemed ();
/**
 * @method flags=dynamic
 * @param hWnd cast=(HWND)
 */
public static final native boolean IsHungAppWindow (int /*long*/ hWnd);
/** @param hWnd cast=(HWND) */
public static final native boolean IsIconic (int /*long*/ hWnd);
/**
 * @method flags=dynamic
 * @param hWnd cast=(HWND)
 * @param outFlags cast=(PULONG)
 */
public static final native boolean IsTouchWindow (int /*long*/ hWnd, long[] outFlags);
/** @param hWnd cast=(HWND) */
public static final native boolean IsWindowEnabled (int /*long*/ hWnd);
/** @param hWnd cast=(HWND) */
public static final native boolean IsWindowVisible (int /*long*/ hWnd);
/** @param hWnd cast=(HWND) */
public static final native boolean IsZoomed (int /*long*/ hWnd);
/** @param hWnd cast=(HWND) */
public static final native boolean KillTimer (int /*long*/ hWnd, int /*long*/ uIDEvent);
/** @param hdc cast=(HDC) */
public static final native boolean LineTo (int /*long*/ hdc, int x1, int x2);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpBitmapName cast=(LPWSTR)
 */
public static final native int /*long*/ LoadBitmapW (int /*long*/ hInstance, int /*long*/ lpBitmapName);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpBitmapName cast=(LPSTR)
 */
public static final native int /*long*/ LoadBitmapA (int /*long*/ hInstance, int /*long*/ lpBitmapName);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpCursorName cast=(LPWSTR)
 */
public static final native int /*long*/ LoadCursorW (int /*long*/ hInstance, int /*long*/ lpCursorName);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpCursorName cast=(LPSTR)
 */
public static final native int /*long*/ LoadCursorA (int /*long*/ hInstance, int /*long*/ lpCursorName);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpIconName cast=(LPWSTR)
 */
public static final native int /*long*/ LoadIconW (int /*long*/ hInstance, int /*long*/ lpIconName);
/**
 * @param hInstance cast=(HINSTANCE)
 * @param lpIconName cast=(LPSTR)
 */
public static final native int /*long*/ LoadIconA (int /*long*/ hInstance, int /*long*/ lpIconName);
/**
 * @param hinst cast=(HINSTANCE)
 * @param lpszName cast=(LPWSTR)
 */
public static final native int /*long*/ LoadImageW (int /*long*/ hinst, int /*long*/ lpszName, int uType, int cxDesired, int cyDesired, int fuLoad);
/**
 * @param hinst cast=(HINSTANCE)
 * @param lpszName cast=(LPSTR)
 */
public static final native int /*long*/ LoadImageA (int /*long*/ hinst, int /*long*/ lpszName, int uType, int cxDesired, int cyDesired, int fuLoad);
/** @param hMem cast=(HLOCAL) */
public static final native int /*long*/ LocalFree (int /*long*/ hMem);
public static final native int LODWORD (long l);
public static final native int LOWORD (int /*long*/ l);
/** @param hdc cast=(HDC) */
public static final native boolean LPtoDP (int /*long*/ hdc, POINT lpPoints, int nCount);
public static final native int MAKEWORD(int l, int h);
public static final native int /*long*/ MAKEWPARAM(int l, int h);
public static final native int /*long*/ MAKELPARAM(int l, int h);
public static final native int /*long*/ MAKELRESULT(int l, int h);
public static final native int MapVirtualKeyW (int uCode, int uMapType);
public static final native int MapVirtualKeyA (int uCode, int uMapType);
/**
 * @param hWndFrom cast=(HWND)
 * @param hWndTo cast=(HWND)
 * @param lpPoints cast=(LPPOINT)
 */
public static final native int MapWindowPoints (int /*long*/ hWndFrom, int /*long*/ hWndTo, POINT lpPoints, int cPoints);
/**
 * @param hWndFrom cast=(HWND)
 * @param hWndTo cast=(HWND)
 * @param lpPoints cast=(LPPOINT)
 */
public static final native int MapWindowPoints (int /*long*/ hWndFrom, int /*long*/ hWndTo, RECT lpPoints, int cPoints);
public static final native boolean MessageBeep (int uType);
/**
 * @param hWnd cast=(HWND)
 * @param lpText cast=(LPWSTR)
 * @param lpCaption cast=(LPWSTR)
 */
public static final native int MessageBoxW (int /*long*/ hWnd, char [] lpText, char [] lpCaption, int uType);
/**
 * @param hWnd cast=(HWND)
 * @param lpText cast=(LPSTR)
 * @param lpCaption cast=(LPSTR)
 */
public static final native int MessageBoxA (int /*long*/ hWnd, byte [] lpText, byte [] lpCaption, int uType);
/**
 * @param hdc cast=(HDC)
 * @param lpXform cast=(XFORM *)
 */
public static final native boolean ModifyWorldTransform(int /*long*/ hdc, float [] lpXform, int iMode);
/** @method flags=dynamic */
public static final native int /*long*/ MonitorFromWindow (int /*long*/ hwnd, int dwFlags);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (char[] Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (byte [] Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (byte [] Destination, ACCEL Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (byte [] Destination, BITMAPINFOHEADER Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (int [] Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (long [] Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (double[] Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (float[] Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in critical
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (short[] Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (int /*long*/ Destination, byte [] Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (int /*long*/ Destination, char [] Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (int /*long*/ Destination, int [] Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (int /*long*/ Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, DEVMODEW Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, DEVMODEA Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, DOCHOSTUIINFO Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, GRADIENT_RECT Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, LOGFONTW Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, LOGFONTA Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, MEASUREITEMSTRUCT Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, MINMAXINFO Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, MSG Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, UDACCEL Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, NMTTDISPINFOW Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, NMTTDISPINFOA Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (int /*long*/ Destination, OPENFILENAME Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, RECT Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, SAFEARRAY Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (SAFEARRAY Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, TRIVERTEX Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, WINDOWPOS Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (BITMAPINFOHEADER Destination, byte [] Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (BITMAPINFOHEADER Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (CERT_CONTEXT Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (CERT_INFO Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (DEVMODEW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (DEVMODEA Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (DOCHOSTUIINFO Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (DRAWITEMSTRUCT Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (FLICK_DATA Destination, int /*long*/ [] Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (FLICK_POINT Destination, int /*long*/ [] Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (HDITEM Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (HELPINFO Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (LOGFONTW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (LOGFONTA Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (MEASUREITEMSTRUCT Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (MINMAXINFO Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (OFNOTIFY Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (OPENFILENAME Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (POINT Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (POINT Destination, long[] Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMHDR Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMCUSTOMDRAW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMLVCUSTOMDRAW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTBCUSTOMDRAW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTBHOTITEM Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTREEVIEW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTVCUSTOMDRAW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTVITEMCHANGE Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMUPDOWN Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, NMLVCUSTOMDRAW Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, NMTBCUSTOMDRAW Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, NMTVCUSTOMDRAW Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, NMLVDISPINFO Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, NMTVDISPINFO Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMLVDISPINFO Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTVDISPINFO Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMLVODSTATECHANGE Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMHEADER Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMLINK Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMLISTVIEW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMREBARCHILDSIZE Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMREBARCHEVRON Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTOOLBAR Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTTCUSTOMDRAW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTTDISPINFOW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (NMTTDISPINFOA Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (EMR Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (EMREXTCREATEFONTINDIRECTW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, SHDRAGIMAGE Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (TEXTMETRICW Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (TEXTMETRICA Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (TOUCHINPUT Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (WINDOWPOS Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (MSG Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param Source cast=(CONST VOID *)
 */
public static final native void MoveMemory (UDACCEL Destination, int /*long*/ Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, DROPFILES Source, int Length);
/**
 * @param DestinationPtr cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (int /*long*/ DestinationPtr, double[] Source, int Length);
/**
 * @param DestinationPtr cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (int /*long*/ DestinationPtr, float[] Source, int Length);
/**
 * @param DestinationPtr cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (int /*long*/ DestinationPtr, long[] Source, int Length);
/**
 * @param DestinationPtr cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out critical
 */
public static final native void MoveMemory (int /*long*/ DestinationPtr, short[] Source, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (SCRIPT_ITEM Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (SCRIPT_LOGATTR Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID),flags=no_in
 * @param SourcePtr cast=(CONST VOID *)
 */
public static final native void MoveMemory (SCRIPT_PROPERTIES Destination, int /*long*/ SourcePtr, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, KEYBDINPUT Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, MOUSEINPUT Source, int Length);
/**
 * @param Destination cast=(PVOID)
 * @param Source cast=(CONST VOID *),flags=no_out
 */
public static final native void MoveMemory (int /*long*/ Destination, GESTURECONFIG Source, int Length);
/**
 * @param hdc cast=(HDC)
 * @param lPoint cast=(LPPOINT)
 */
public static final native boolean MoveToEx (int /*long*/ hdc, int x1, int x2, int /*long*/ lPoint);
/**
 * @param lpMultiByteStr cast=(LPCSTR),flags=no_out critical
 * @param lpWideCharStr cast=(LPWSTR),flags=no_in critical
 */
public static final native int MultiByteToWideChar (int CodePage, int dwFlags, byte [] lpMultiByteStr, int cchMultiByte, char [] lpWideCharStr, int cchWideChar);
/**
 * @param lpMultiByteStr cast=(LPCSTR)
 * @param lpWideCharStr cast=(LPWSTR),flags=no_in critical
 */
public static final native int MultiByteToWideChar (int CodePage, int dwFlags, int /*long*/ lpMultiByteStr, int cchMultiByte, char [] lpWideCharStr, int cchWideChar);
/**
 * @method flags=dynamic
 * @param event cast=(DWORD)
 * @param hwnd cast=(HWND)
 * @param idObject cast=(LONG)
 * @param idChild cast=(LONG)
 */
public static final native void NotifyWinEvent (int event, int /*long*/ hwnd, int idObject, int idChild);
public static final native boolean OffsetRect (RECT lprc, int dx, int dy);
/** @param hrgn cast=(HRGN) */
public static final native int OffsetRgn (int /*long*/ hrgn, int nXOffset, int nYOffset);
/** @param pvReserved cast=(LPVOID) */
public static final native int OleInitialize (int /*long*/ pvReserved);
public static final native void OleUninitialize ();
/** @param hWndNewOwner cast=(HWND) */
public static final native boolean OpenClipboard (int /*long*/ hWndNewOwner);
/**
 * @method flags=dynamic
 * @param hwnd cast=(HWND)
 * @param pszClassList cast=(LPCWSTR)
 */
public static final native int /*long*/ OpenThemeData (int /*long*/ hwnd, char[] pszClassList);
/** @param hdc cast=(HDC) */
public static final native boolean PatBlt (int /*long*/ hdc, int x1, int x2, int w, int h, int rop);
/** @param szfile cast=(LPCWSTR) */
public static final native boolean PathIsExe (int /*long*/ szfile);
/** @param hWnd cast=(HWND) */
public static final native boolean PeekMessageW (MSG lpMsg, int /*long*/ hWnd, int wMsgFilterMin, int wMsgFilterMax, int wRemoveMsg);
/** @param hWnd cast=(HWND) */
public static final native boolean PeekMessageA (MSG lpMsg, int /*long*/ hWnd, int wMsgFilterMin, int wMsgFilterMax, int wRemoveMsg);
/** @param hdc cast=(HDC) */
public static final native boolean Pie (int /*long*/ hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nXStartArc, int nYStartArc, int nXEndArc, int nYEndArc);
/** @param pt flags=struct */
public static final native void POINTSTOPOINT(POINT pt, int /*long*/ pts);
/**
 * @param hdc cast=(HDC)
 * @param points cast=(CONST POINT *),flags=no_out critical
 */
public static final native boolean Polygon (int /*long*/ hdc, int [] points, int nPoints);
/**
 * @param hdc cast=(HDC)
 * @param points cast=(CONST POINT *),flags=no_out critical
 */
public static final native boolean Polyline (int /*long*/ hdc, int[] points, int nPoints);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native boolean PostMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native boolean PostMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native boolean PostThreadMessageW (int idThread, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native boolean PostThreadMessageA (int idThread, int Msg, int /*long*/ wParam, int /*long*/ lParam);
public static final native short PRIMARYLANGID (int lgid);
/** @param lppd cast=(LPPRINTDLGW) */
public static final native boolean PrintDlgW (PRINTDLG lppd);
public static final native boolean PrintDlgA (PRINTDLG lppd);
/**
 * @method flags=dynamic
 * @param hwnd cast=(HWND)
 * @param hdcBlt cast=(HDC)
 */
public static final native boolean PrintWindow (int /*long*/ hwnd, int /*long*/ hdcBlt, int nFlags);
/** @method flags=dynamic */
public static final native int PSPropertyKeyFromString (char[] pszString, PROPERTYKEY pkey);
/**
 * @param rect flags=no_out
 * @param pt flags=no_out struct
 */
public static final native boolean PtInRect (RECT rect, POINT pt);
/** @param hrgn cast=(HRGN) */
public static final native boolean PtInRegion (int /*long*/ hrgn, int X, int Y);
/** @param hDC cast=(HDC) */
public static final native int RealizePalette (int /*long*/ hDC);
/** @param hdc cast=(HDC) */
public static final native boolean Rectangle (int /*long*/ hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);
/**
 * @param hrgn cast=(HRGN)
 * @param lprc flags=no_out
 */
public static final native boolean RectInRegion (int /*long*/ hrgn, RECT lprc);
/**
 * @param hWnd cast=(HWND)
 * @param hrgnUpdate cast=(HRGN)
 */
public static final native boolean RedrawWindow (int /*long*/ hWnd, RECT lprcUpdate, int /*long*/ hrgnUpdate, int flags);
/** @param hKey cast=(HKEY) */
public static final native int RegCloseKey (int /*long*/ hKey);
/**
 * @param hKey cast=(HKEY)
 * @param lpSubKey cast=(LPWSTR)
 * @param lpClass cast=(LPWSTR)
 * @param lpSecurityAttributes cast=(LPSECURITY_ATTRIBUTES)
 * @param phkResult cast=(PHKEY)
 * @param lpdwDisposition cast=(LPDWORD)
 */
public static final native int RegCreateKeyExW (int /*long*/ hKey, char[] lpSubKey, int Reserved, char[] lpClass, int dwOptions, int samDesired, int /*long*/ lpSecurityAttributes, int /*long*/[] phkResult, int /*long*/[] lpdwDisposition);
/**
 * @param hKey cast=(HKEY)
 * @param lpSubKey cast=(LPSTR)
 * @param lpClass cast=(LPTSTR)
 * @param lpSecurityAttributes cast=(LPSECURITY_ATTRIBUTES)
 * @param phkResult cast=(PHKEY)
 * @param lpdwDisposition cast=(LPDWORD)
 */
public static final native int RegCreateKeyExA (int /*long*/ hKey, byte[] lpSubKey, int Reserved, byte[] lpClass, int dwOptions, int samDesired, int /*long*/ lpSecurityAttributes, int /*long*/[] phkResult, int /*long*/[] lpdwDisposition);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPWSTR)
 */
public static final native int RegDeleteValueW (int /*long*/ hKey, char[] lpValueName);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPSTR)
 */
public static final native int RegDeleteValueA (int /*long*/ hKey, byte[] lpValueName);
/**
 * @param hKey cast=(HKEY)
 * @param lpName cast=(LPWSTR)
 * @param lpcName cast=(LPDWORD)
 * @param lpReserved cast=(LPDWORD)
 * @param lpClass cast=(LPWSTR)
 * @param lpcClass cast=(LPDWORD)
 */
public static final native int RegEnumKeyExW (int /*long*/ hKey, int dwIndex, char [] lpName, int [] lpcName, int [] lpReserved, char [] lpClass, int [] lpcClass, FILETIME lpftLastWriteTime);
/**
 * @param hKey cast=(HKEY)
 * @param lpName cast=(LPSTR)
 * @param lpcName cast=(LPDWORD)
 * @param lpReserved cast=(LPDWORD)
 * @param lpClass cast=(LPSTR)
 * @param lpcClass cast=(LPDWORD)
 */
public static final native int RegEnumKeyExA (int /*long*/ hKey, int dwIndex, byte [] lpName, int [] lpcName, int [] lpReserved, byte [] lpClass, int [] lpcClass, FILETIME lpftLastWriteTime);
/** @param lpWndClass cast=(LPWNDCLASSW) */
public static final native int RegisterClassW (WNDCLASS lpWndClass);
public static final native int RegisterClassA (WNDCLASS lpWndClass);
/**
 * @method flags=dynamic
 * @param hWnd cast=(HWND)
 * @param ulFlags cast=(ULONG)
 */
public static final native boolean RegisterTouchWindow(int /*long*/ hWnd, int ulFlags);
/** @param lpString cast=(LPWSTR) */
public static final native int RegisterWindowMessageW (char [] lpString);
/** @param lpString cast=(LPTSTR) */
public static final native int RegisterWindowMessageA (byte [] lpString);
/** @param lpszFormat cast=(LPTSTR) */
public static final native int RegisterClipboardFormatA (byte[] lpszFormat);
/** @param lpszFormat cast=(LPWSTR) */
public static final native int RegisterClipboardFormatW (char[] lpszFormat);
/**
 * @param hKey cast=(HKEY)
 * @param lpSubKey cast=(LPWSTR)
 * @param phkResult cast=(PHKEY)
 */
public static final native int RegOpenKeyExW (int /*long*/ hKey, char[] lpSubKey, int ulOptions, int samDesired, int /*long*/[] phkResult);
/**
 * @param hKey cast=(HKEY)
 * @param lpSubKey cast=(LPSTR)
 * @param phkResult cast=(PHKEY)
 */
public static final native int RegOpenKeyExA (int /*long*/ hKey, byte[] lpSubKey, int ulOptions, int samDesired, int /*long*/[] phkResult);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPWSTR)
 * @param lpReserved cast=(LPDWORD)
 * @param lpType cast=(LPDWORD)
 * @param lpData cast=(LPBYTE)
 * @param lpcbData cast=(LPDWORD)
 */
public static final native int RegQueryValueExW (int /*long*/ hKey, char[] lpValueName, int /*long*/ lpReserved, int[] lpType, char [] lpData, int[] lpcbData);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPWSTR)
 * @param lpReserved cast=(LPDWORD)
 * @param lpType cast=(LPDWORD)
 * @param lpData cast=(LPBYTE)
 * @param lpcbData cast=(LPDWORD)
 */
public static final native int RegQueryValueExW (int /*long*/ hKey, char[] lpValueName, int /*long*/ lpReserved, int[] lpType, int [] lpData, int[] lpcbData);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPSTR)
 * @param lpReserved cast=(LPDWORD)
 * @param lpType cast=(LPDWORD)
 * @param lpData cast=(LPBYTE)
 * @param lpcbData cast=(LPDWORD)
 */
public static final native int RegQueryValueExA (int /*long*/ hKey, byte[] lpValueName, int /*long*/ lpReserved, int[] lpType, byte [] lpData, int[] lpcbData);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPWSTR)
 * @param lpData cast=(const BYTE*)
 */
public static final native int RegSetValueExW (int /*long*/ hKey, char[] lpValueName, int Reserved, int dwType, int[] lpData, int cbData);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPSTR)
 * @param lpData cast=(const BYTE*)
 */
public static final native int RegSetValueExA (int /*long*/ hKey, byte[] lpValueName, int Reserved, int dwType, int[] lpData, int cbData);
/**
 * @param hKey cast=(HKEY)
 * @param lpValueName cast=(LPSTR)
 * @param lpReserved cast=(LPDWORD)
 * @param lpType cast=(LPDWORD)
 * @param lpData cast=(LPBYTE)
 * @param lpcbData cast=(LPDWORD)
 */
public static final native int RegQueryValueExA (int /*long*/ hKey, byte[] lpValueName, int /*long*/ lpReserved, int[] lpType, int [] lpData, int[] lpcbData);
public static final native boolean ReleaseCapture ();
/**
 * @param hWnd cast=(HWND)
 * @param hDC cast=(HDC)
 */
public static final native int ReleaseDC (int /*long*/ hWnd, int /*long*/ hDC);
/** @param hMenu cast=(HMENU) */
public static final native boolean RemoveMenu (int /*long*/ hMenu, int uPosition, int uFlags);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPCTSTR)
 */
public static final native int /*long*/ RemovePropA (int /*long*/ hWnd, int /*long*/ lpString);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPCWSTR)
 */
public static final native int /*long*/ RemovePropW (int /*long*/ hWnd, int /*long*/ lpString);
public static final native boolean ReplyMessage (int /*long*/ lResult);
/**
 * @param hdc cast=(HDC)
 * @param nSavedDC cast=(int)
 */
public static final native boolean RestoreDC (int /*long*/ hdc, int nSavedDC);
/** @param hdc cast=(HDC) */
public static final native boolean RoundRect (int /*long*/ hdc, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect, int nWidth, int nHeight);
/** @param hdc cast=(HDC) */
public static final native int SaveDC (int /*long*/ hdc);
/** @param hWnd cast=(HWND) */
public static final native boolean ScreenToClient (int /*long*/ hWnd, POINT lpPoint);
/**
 * @param psds cast=(const SCRIPT_DIGITSUBSTITUTE*)
 * @param psc cast=(SCRIPT_CONTROL*)
 * @param pss cast=(SCRIPT_STATE*)
 */
public static final native int ScriptApplyDigitSubstitution (SCRIPT_DIGITSUBSTITUTE psds, SCRIPT_CONTROL psc, SCRIPT_STATE pss);
/**
 * @param pwcChars cast=(const WCHAR *)
 * @param psa cast=(const SCRIPT_ANALYSIS *)
 * @param psla cast=(SCRIPT_LOGATTR *)
 */
public static final native int ScriptBreak (char[] pwcChars, int cChars, SCRIPT_ANALYSIS psa, int /*long*/ psla);
/**
 * @param ppSp cast=(const SCRIPT_PROPERTIES ***)
 * @param piNumScripts cast=(int *)
 */
public static final native int ScriptGetProperties (int /*long*/[] ppSp, int[] piNumScripts);
/**
 * @param hdc cast=(HDC)
 * @param psc cast=(SCRIPT_CACHE *)
 * @param tmHeight cast=(long *)
 */
public static final native int ScriptCacheGetHeight (int /*long*/ hdc, int /*long*/ psc, int[] tmHeight);
/**
 * @param pwLogClust cast=(const WORD *)
 * @param psva cast=(const SCRIPT_VISATTR *)
 * @param piAdvance cast=(const int *)
 * @param psa cast=(const SCRIPT_ANALYSIS *)
 * @param piX cast=(int *)
 */
public static final native int ScriptCPtoX (int iCP, boolean fTrailing, int cChars, int cGlyphs, int /*long*/ pwLogClust, int /*long*/ psva, int /*long*/ piAdvance, SCRIPT_ANALYSIS psa, int[] piX);
/** @param psc cast=(SCRIPT_CACHE *) */
public static final native int ScriptFreeCache (int /*long*/ psc);
/**
 * @param hdc cast=(HDC)
 * @param psc cast=(SCRIPT_CACHE *)
 * @param sfp cast=(SCRIPT_FONTPROPERTIES *)
 */
public static final native int ScriptGetFontProperties (int /*long*/ hdc, int /*long*/ psc, SCRIPT_FONTPROPERTIES sfp);
/**
 * @param psa cast=(const SCRIPT_ANALYSIS *)
 * @param piGlyphWidth cast=(const int *)
 * @param pwLogClust cast=(const WORD *)
 * @param psva cast=(const SCRIPT_VISATTR *)
 * @param piDx cast=(int *)
 */
public static final native int ScriptGetLogicalWidths (SCRIPT_ANALYSIS psa, int cChars, int cGlyphs, int /*long*/ piGlyphWidth, int /*long*/ pwLogClust, int /*long*/ psva, int[] piDx);
/**
 * @param pwcInChars cast=(const WCHAR *)
 * @param psControl cast=(const SCRIPT_CONTROL *)
 * @param psState cast=(const SCRIPT_STATE *)
 * @param pItems cast=(SCRIPT_ITEM *)
 * @param pcItems cast=(int *)
 */
public static final native int ScriptItemize (char[] pwcInChars, int cInChars, int cMaxItems, SCRIPT_CONTROL psControl, SCRIPT_STATE psState, int /*long*/ pItems, int[] pcItems);
/**
 * @param psva cast=(SCRIPT_VISATTR *)
 * @param piAdvance cast=(const int *)
 * @param piJustify cast=(int *)
 */
public static final native int ScriptJustify (int /*long*/ psva, int /*long*/ piAdvance, int cGlyphs, int iDx, int iMinKashida, int /*long*/ piJustify);
/**
 * @param pbLevel cast=(const BYTE *)
 * @param piVisualToLogical cast=(int *)
 * @param piLogicalToVisual cast=(int *)
 */
public static final native int ScriptLayout (int cRuns, byte[] pbLevel, int[] piVisualToLogical, int[] piLogicalToVisual);
/**
 * @param hdc cast=(HDC)
 * @param psc cast=(SCRIPT_CACHE *)
 * @param pwGlyphs cast=(const WORD *)
 * @param psva cast=(const SCRIPT_VISATTR *)
 * @param psa cast=(SCRIPT_ANALYSIS *)
 * @param piAdvance cast=(int *)
 * @param pGoffset cast=(GOFFSET *)
 * @param pABC cast=(ABC *)
 */
public static final native int ScriptPlace (int /*long*/ hdc, int /*long*/ psc, int /*long*/ pwGlyphs, int cGlyphs, int /*long*/ psva, SCRIPT_ANALYSIS psa, int /*long*/ piAdvance, int /*long*/ pGoffset, int[] pABC);
/**
 * @param Locale cast=(LCID)
 * @param psds cast=(SCRIPT_DIGITSUBSTITUTE*)
 */
public static final native int ScriptRecordDigitSubstitution (int Locale, SCRIPT_DIGITSUBSTITUTE psds);
/**
 * @param hdc cast=(HDC)
 * @param psc cast=(SCRIPT_CACHE *)
 * @param pwcChars cast=(const WCHAR *)
 * @param pwOutGlyphs cast=(WORD*)
 */
public static final native int ScriptGetCMap (int /*long*/ hdc, int /*long*/ psc, char[] pwcChars, int cChars, int dwFlags, short[] pwOutGlyphs);
/**
 * @param hdc cast=(HDC)
 * @param psc cast=(SCRIPT_CACHE *)
 * @param pwcChars cast=(const WCHAR *)
 * @param psa cast=(SCRIPT_ANALYSIS *)
 * @param pwOutGlyphs cast=(WORD *)
 * @param pwLogClust cast=(WORD *)
 * @param psva cast=(SCRIPT_VISATTR *)
 * @param pcGlyphs cast=(int *)
 */
public static final native int ScriptShape (int /*long*/ hdc, int /*long*/ psc, char[] pwcChars, int cChars, int cMaxGlyphs, SCRIPT_ANALYSIS psa, int /*long*/ pwOutGlyphs, int /*long*/ pwLogClust, int /*long*/ psva, int[] pcGlyphs);
/**
 * @param hdc cast=(HDC)
 * @param pString cast=(const void*)
 * @param piDx cast=(const int*)
 * @param pTabdef cast=(SCRIPT_TABDEF*)
 * @param pbInClass cast=(const BYTE*)
 * @param pssa cast=(SCRIPT_STRING_ANALYSIS*)
 */
public static final native int ScriptStringAnalyse (int /*long*/ hdc, char[] pString, int cString, int cGlyphs, int iCharset, int dwFlags, int iReqWidth, SCRIPT_CONTROL psControl, SCRIPT_STATE psState, int /*long*/ piDx, int /*long*/ pTabdef, int /*long*/ pbInClass, int /*long*/ pssa);
/** @param ssa cast=(SCRIPT_STRING_ANALYSIS*),flags=struct */
public static final native int ScriptStringOut(int /*long*/ ssa, int iX, int iY, int uOptions, RECT prc, int iMinSel, int iMaxSel, boolean fDisabled);
/** @param pssa cast=(SCRIPT_STRING_ANALYSIS*) */
public static final native int ScriptStringFree(int /*long*/ pssa);
/**
 * @param hdc cast=(const HDC)
 * @param psc cast=(SCRIPT_CACHE *)
 * @param lprc cast=(const RECT *)
 * @param psa cast=(const SCRIPT_ANALYSIS *)
 * @param pwcReserved cast=(const WCHAR *)
 * @param pwGlyphs cast=(const WORD *)
 * @param piAdvance cast=(const int *)
 * @param piJustify cast=(const int *)
 * @param pGoffset cast=(const GOFFSET *)
 */
public static final native int ScriptTextOut (int /*long*/ hdc, int /*long*/ psc, int x, int y, int fuOptions, RECT lprc, SCRIPT_ANALYSIS psa, int /*long*/ pwcReserved, int iReserved, int /*long*/ pwGlyphs, int cGlyphs, int /*long*/ piAdvance, int /*long*/ piJustify, int /*long*/ pGoffset);
/**
 * @param pwLogClust cast=(const WORD *)
 * @param psva cast=(const SCRIPT_VISATTR *)
 * @param piAdvance cast=(const int *)
 * @param psa cast=(const SCRIPT_ANALYSIS *)
 * @param piCP cast=(int *)
 * @param piTrailing cast=(int *)
 */
public static final native int ScriptXtoCP (int iX, int cChars, int cGlyphs, int /*long*/ pwLogClust, int /*long*/ psva, int /*long*/ piAdvance, SCRIPT_ANALYSIS psa, int[] piCP, int[] piTrailing);
/**
 * @param hWnd cast=(HWND)
 * @param hrgnUpdate cast=(HRGN)
 */
public static final native int ScrollWindowEx (int /*long*/ hWnd, int dx, int dy, RECT prcScroll, RECT prcClip, int /*long*/ hrgnUpdate, RECT prcUpdate, int flags);
/**
 * @param hdc cast=(HDC)
 * @param hrgn cast=(HRGN)
 */
public static final native int SelectClipRgn (int /*long*/ hdc, int /*long*/ hrgn);
/**
 * @param hDC cast=(HDC)
 * @param HGDIObj cast=(HGDIOBJ)
 */
public static final native int /*long*/ SelectObject (int /*long*/ hDC, int /*long*/ HGDIObj);
/**
 * @param hDC cast=(HDC)
 * @param hpal cast=(HPALETTE)
 */
public static final native int /*long*/ SelectPalette (int /*long*/ hDC, int /*long*/ hpal, boolean bForceBackground);
/** @param pInputs cast=(LPINPUT) */
public static final native int SendInput (int nInputs, int /*long*/ pInputs, int cbSize);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int [] wParam, int [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ [] wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, char [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, short [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVCOLUMN lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVINSERTMARK lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, MARGINS lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, MCHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, POINT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, REBARBANDINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, RECT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SYSTEMTIME lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SHDRAGIMAGE lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TBBUTTON lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TBBUTTONINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TCITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TCHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TOOLINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVINSERTSTRUCT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVSORTCB lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, UDACCEL lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDLAYOUT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, BUTTON_IMAGELIST lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageW (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SIZE lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int [] wParam, int [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ [] wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, byte [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, short [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, char [] lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, int /*long*/ lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVCOLUMN lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVINSERTMARK lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, LVITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, MARGINS lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, MCHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, POINT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, REBARBANDINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, RECT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SYSTEMTIME lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SHDRAGIMAGE lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TBBUTTON lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TBBUTTONINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TCITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TCHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TOOLINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVINSERTSTRUCT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, TVSORTCB lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, UDACCEL lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDHITTESTINFO lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDITEM lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, HDLAYOUT lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, BUTTON_IMAGELIST lParam);
/**
 * @param hWnd cast=(HWND)
 * @param wParam cast=(WPARAM)
 * @param lParam cast=(LPARAM)
 */
public static final native int /*long*/ SendMessageA (int /*long*/ hWnd, int Msg, int /*long*/ wParam, SIZE lParam);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ SetActiveWindow (int /*long*/ hWnd);
/**
 * @param hdc cast=(HDC)
 * @param colorRef cast=(COLORREF)
 */
public static final native int SetBkColor (int /*long*/ hdc, int colorRef);
/** @param hdc cast=(HDC) */
public static final native int SetBkMode (int /*long*/ hdc, int mode);
/**
 * @param hdc cast=(HDC)
 * @param lppt cast=(LPPOINT)
 */
public static final native boolean SetBrushOrgEx (int /*long*/ hdc, int nXOrg, int nYOrg, POINT lppt);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ SetCapture (int /*long*/ hWnd);
public static final native boolean SetCaretPos (int X, int Y);
/** @method flags=dynamic */
public static final native int SetCurrentProcessExplicitAppUserModelID (char[] AppID);
/** @param hCursor cast=(HCURSOR) */
public static final native int /*long*/ SetCursor (int /*long*/ hCursor);
public static final native boolean SetCursorPos (int X, int Y);
/**
 * @param hdc cast=(HDC)
 * @param pColors cast=(RGBQUAD *),flags=no_out critical
 */
public static final native int SetDIBColorTable (int /*long*/ hdc, int uStartIndex, int cEntries, byte[] pColors);
/**
 * @method flags=dynamic
 * @param lpString cast=(LPSTR)
 */
public static final native boolean SetDllDirectoryA (byte [] lpString);
/**
 * @method flags=dynamic
 * @param lpString cast=(LPWSTR)
 */
public static final native boolean SetDllDirectoryW (char [] lpString);
public static final native int SetErrorMode (int uMode);
/** @param hWnd cast=(HWND) */
public static final native int /*long*/ SetFocus (int /*long*/ hWnd);
/** @param hWnd cast=(HWND) */
public static final native boolean SetForegroundWindow (int /*long*/ hWnd);
/**
 * @method flags=dynamic
 * @param hwnd cast=(HWND)
 * @param pGestureConfig cast=(PGESTURECONFIG)
 */
public static final native boolean SetGestureConfig(int /*long*/ hwnd, int dwReserved, int cIDs, int /*long*/ pGestureConfig, int cbSize);
/** @param hdc cast=(HDC) */
public static final native int SetGraphicsMode (int /*long*/ hdc, int iMode);
/**
 * @method flags=dynamic
 * @param hwnd cast=(HWND)
 */
public static final native boolean SetLayeredWindowAttributes(int /*long*/ hwnd, int crKey, byte bAlpha, int dwFlags);
/**
 * @method flags=dynamic
 * @param hdc cast=(HDC)
 * @param dwLayout cast=(DWORD)
 */
public static final native int SetLayout (int /*long*/ hdc, int dwLayout);
/**
 * @param hWnd cast=(HWND)
 * @param hMenu cast=(HMENU)
 */
public static final native boolean SetMenu (int /*long*/ hWnd, int /*long*/ hMenu);
/** @param hMenu cast=(HMENU) */
public static final native boolean SetMenuDefaultItem (int /*long*/ hMenu, int uItem, int fByPos);
/**
 * @method flags=dynamic
 * @param hmenu cast=(HMENU)
 */
public static final native boolean SetMenuInfo (int /*long*/ hmenu, MENUINFO lpcmi);
/**
 * @param hMenu cast=(HMENU)
 * @param lpmii cast=(LPMENUITEMINFOW)
 */
public static final native boolean SetMenuItemInfoW (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii);
/** @param hMenu cast=(HMENU) */
public static final native boolean SetMenuItemInfoA (int /*long*/ hMenu, int uItem, boolean fByPosition, MENUITEMINFO lpmii);
/** @param hdc cast=(HDC) */
public static final native int SetMetaRgn (int /*long*/ hdc);
/**
 * @param hPal cast=(HPALETTE)
 * @param lppe cast=(PALETTEENTRY *),flags=no_out critical
 */
public static final native int SetPaletteEntries (int /*long*/ hPal, int iStart, int cEntries, byte[] lppe);
/**
 * @param hWndChild cast=(HWND)
 * @param hWndNewParent cast=(HWND)
 */
public static final native int /*long*/ SetParent (int /*long*/ hWndChild, int /*long*/ hWndNewParent);
/** @param hdc cast=(HDC) */
public static final native int SetPixel (int /*long*/ hdc, int X, int Y, int crColor);
/** @param hdc cast=(HDC) */
public static final native int SetPolyFillMode (int /*long*/ hdc, int iPolyFillMode);
/** @method flags=dynamic */
public static final native boolean SetProcessDPIAware ();
/** @param lprc flags=no_in */
public static final native boolean SetRect (RECT lprc, int xLeft, int yTop, int xRight, int yBottom);
/** @param hrgn cast=(HRGN) */
public static final native boolean SetRectRgn (int /*long*/ hrgn, int nLeftRect, int nTopRect, int nRightRect, int nBottomRect);
/** @param hdc cast=(HDC) */
public static final native int SetROP2 (int /*long*/ hdc, int fnDrawMode);
/** @param hwnd cast=(HWND) */
public static final native boolean SetScrollInfo (int /*long*/ hwnd, int flags, SCROLLINFO info, boolean fRedraw);
/** @param hdc cast=(HDC) */
public static final native int SetStretchBltMode (int /*long*/ hdc, int iStretchMode);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPCWSTR)
 * @param hData cast=(HANDLE)
 */
public static final native boolean SetPropW (int /*long*/ hWnd, int /*long*/ lpString, int /*long*/ hData);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPCTSTR)
 * @param hData cast=(HANDLE)
 */
public static final native boolean SetPropA (int /*long*/ hWnd, int /*long*/ lpString, int /*long*/ hData);
/**
 * @param hdc cast=(HDC)
 * @param colorRef cast=(COLORREF)
 */
public static final native int SetTextColor (int /*long*/ hdc, int colorRef);
/**
 * @param hWnd cast=(HWND)
 * @param lpTimerFunc cast=(TIMERPROC)
 */
public static final native int /*long*/ SetTimer (int /*long*/ hWnd, int /*long*/ nIDEvent, int Elapse, int /*long*/ lpTimerFunc);
/** @param hWnd cast=(HWND) */
public static final native int SetWindowLongW (int /*long*/ hWnd, int nIndex, int dwNewLong);
/** @param hWnd cast=(HWND) */
public static final native int SetWindowLongA (int /*long*/ hWnd, int nIndex, int dwNewLong);
/**
 * @param hWnd cast=(HWND)
 * @param dwNewLong cast=(LONG_PTR)
 */
public static final native int /*long*/ SetWindowLongPtrW (int /*long*/ hWnd, int nIndex, int /*long*/ dwNewLong);
/**
 * @param hWnd cast=(HWND)
 * @param dwNewLong cast=(LONG_PTR)
 */
public static final native int /*long*/ SetWindowLongPtrA (int /*long*/ hWnd, int nIndex, int /*long*/ dwNewLong);
/** @param hdc cast=(HDC) */
public static final native boolean SetWindowOrgEx (int /*long*/ hdc, int X, int Y, POINT lpPoint);
/** @param hWnd cast=(HWND) */
public static final native boolean SetWindowPlacement (int /*long*/ hWnd, WINDOWPLACEMENT lpwndpl);
/**
 * @param hWnd cast=(HWND)
 * @param hWndInsertAfter cast=(HWND)
 */
public static final native boolean SetWindowPos(int /*long*/ hWnd, int /*long*/ hWndInsertAfter, int X, int Y, int cx, int cy, int uFlags);
/**
 * @param hWnd cast=(HWND)
 * @param hRgn cast=(HRGN)
 */
public static final native int SetWindowRgn (int /*long*/ hWnd, int /*long*/ hRgn, boolean bRedraw);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPWSTR)
 */
public static final native boolean SetWindowTextW (int /*long*/ hWnd, char [] lpString);
/**
 * @param hWnd cast=(HWND)
 * @param lpString cast=(LPSTR)
 */
public static final native boolean SetWindowTextA (int /*long*/ hWnd, byte [] lpString);
/**
 * @method flags=dynamic
 * @param hwnd cast=(HWND)
 * @param pszSubAppName cast=(LPCWSTR)
 * @param pszSubIdList cast=(LPCWSTR)
 */
public static final native int SetWindowTheme (int /*long*/ hwnd, char [] pszSubAppName, char [] pszSubIdList);
/**
 * @param lpfn cast=(HOOKPROC)
 * @param hMod cast=(HINSTANCE)
 */
public static final native int /*long*/ SetWindowsHookExW (int idHook, int /*long*/ lpfn,  int /*long*/ hMod,  int dwThreadId);
/**
 * @param lpfn cast=(HOOKPROC)
 * @param hMod cast=(HINSTANCE)
 */
public static final native int /*long*/ SetWindowsHookExA (int idHook, int /*long*/ lpfn,  int /*long*/ hMod,  int dwThreadId);
/**
 * @param hdc cast=(HDC)
 * @param lpXform cast=(XFORM *)
 */
public static final native boolean SetWorldTransform(int /*long*/ hdc, float[] lpXform);
/** @param lpbi cast=(LPBROWSEINFOW) */
public static final native int /*long*/ SHBrowseForFolderW (BROWSEINFO lpbi);
public static final native int /*long*/ SHBrowseForFolderA (BROWSEINFO lpbi);
/**
 * @param pszPath cast=(LPCWSTR)
 * @param psfi cast=(SHFILEINFOW *)
 */
public static final native int /*long*/ SHGetFileInfoW (char [] pszPath, int dwFileAttributes, SHFILEINFOW psfi, int cbFileInfo, int uFlags);
/**
 * @param pszPath cast=(LPCSTR)
 * @param psfi cast=(SHFILEINFOA *)
 */
public static final native int /*long*/ SHGetFileInfoA (byte [] pszPath, int dwFileAttributes, SHFILEINFOA psfi, int cbFileInfo, int uFlags);
/** @param lpExecInfo cast=(LPSHELLEXECUTEINFOW) */
public static final native boolean ShellExecuteExW (SHELLEXECUTEINFO lpExecInfo);
public static final native boolean ShellExecuteExA (SHELLEXECUTEINFO lpExecInfo);
public static final native boolean Shell_NotifyIconA (int dwMessage, NOTIFYICONDATAA lpData);
public static final native boolean Shell_NotifyIconW (int dwMessage, NOTIFYICONDATAW lpData);
/** @param ppMalloc cast=(LPMALLOC *) */
public static final native int SHGetMalloc (int /*long*/ [] ppMalloc);
/**
 * @param pidl cast=(LPCITEMIDLIST)
 * @param pszPath cast=(LPWSTR)
 */
public static final native boolean SHGetPathFromIDListW (int /*long*/ pidl, char [] pszPath);
/**
 * @param pidl cast=(LPCITEMIDLIST)
 * @param pszPath cast=(LPSTR)
 */
public static final native boolean SHGetPathFromIDListA (int /*long*/ pidl, byte [] pszPath);
/** @method flags=dynamic */
public static final native int SHCreateItemInKnownFolder (byte [] kfid, int dwKFFlags, char [] pszItem, byte [] riid, int /*long*/ [] ppv);
/** @method flags=dynamic */
public static final native int SHCreateItemFromRelativeName (int /*long*/ psiParent, char [] pszName, int /*long*/ pbc, byte [] riid, int /*long*/ [] ppv);
/** @method flags=dynamic */
public static final native int SHCreateItemFromParsingName (char [] pszName, int /*long*/ pbc, byte [] riid, int /*long*/ [] ppv);
/** @param hWnd cast=(HWND) */
public static final native boolean ShowCaret (int /*long*/ hWnd);
/** @param hWnd cast=(HWND) */
public static final native boolean ShowOwnedPopups (int /*long*/ hWnd, boolean fShow);
/** @param hWnd cast=(HWND) */
public static final native boolean ShowScrollBar (int /*long*/ hWnd, int wBar, boolean bShow);
/** @param hWnd cast=(HWND) */
public static final native boolean ShowWindow (int /*long*/ hWnd, int nCmdShow);
/**
 * @param hdc cast=(HDC)
 * @param lpdi cast=(LPDOCINFOW)
 */
public static final native int StartDocW (int /*long*/ hdc, DOCINFO lpdi);
/** @param hdc cast=(HDC) */
public static final native int StartDocA (int /*long*/ hdc, DOCINFO lpdi);
/** @param hdc cast=(HDC) */
public static final native int StartPage (int /*long*/ hdc);
/**
 * @param hdcDest cast=(HDC)
 * @param hdcSrc cast=(HDC)
 */
public static final native boolean StretchBlt (int /*long*/ hdcDest, int nXOriginDest, int nYOriginDest, int nWidthDest, int nHeightDest, int /*long*/ hdcSrc, int nXOriginSrc, int nYOriginSrc, int nWidthSrc, int nHeightSrc, int dwRop);
/** @param hdc cast=(HDC) */
public static final native boolean StrokePath (int /*long*/ hdc);
public static final native boolean SystemParametersInfoW (int uiAction, int uiParam, HIGHCONTRAST pvParam, int fWinIni);
public static final native boolean SystemParametersInfoA (int uiAction, int uiParam, HIGHCONTRAST pvParam, int fWinIni);
public static final native boolean SystemParametersInfoW (int uiAction, int uiParam, RECT pvParam, int fWinIni);
public static final native boolean SystemParametersInfoA (int uiAction, int uiParam, RECT pvParam, int fWinIni);
public static final native boolean SystemParametersInfoW (int uiAction, int uiParam, NONCLIENTMETRICSW pvParam, int fWinIni);
public static final native boolean SystemParametersInfoA (int uiAction, int uiParam, NONCLIENTMETRICSA pvParam, int fWinIni);
public static final native boolean SystemParametersInfoW (int uiAction, int uiParam, int [] pvParam, int fWinIni);
public static final native boolean SystemParametersInfoA (int uiAction, int uiParam, int [] pvParam, int fWinIni);
/**
 * @param lpKeyState cast=(PBYTE)
 * @param lpChar cast=(LPWORD)
 */
public static final native int ToAscii (int uVirtKey, int uScanCode, byte [] lpKeyState, short [] lpChar, int uFlags);
/**
 * @param lpKeyState cast=(PBYTE)
 * @param pwszBuff cast=(LPWSTR)
 */
public static final native int ToUnicode (int wVirtKey, int wScanCode, byte [] lpKeyState, char [] pwszBuff, int cchBuff, int wFlags);
public static final native long TOUCH_COORD_TO_PIXEL(long touchCoord);
/**
 * @param hwndTV cast=(HWND)
 * @param hitem cast=(HTREEITEM)
 */
public static final native boolean TreeView_GetItemRect (int /*long*/ hwndTV, int /*long*/ hitem, RECT prc, boolean fItemRect);
public static final native boolean TrackMouseEvent (TRACKMOUSEEVENT lpEventTrack);
/**
 * @param hMenu cast=(HMENU)
 * @param hWnd cast=(HWND)
 */
public static final native boolean TrackPopupMenu (int /*long*/ hMenu, int uFlags, int x, int y, int nReserved, int /*long*/ hWnd, RECT prcRect);
/**
 * @param hWnd cast=(HWND)
 * @param hAccTable cast=(HACCEL)
 */
public static final native int TranslateAcceleratorW (int /*long*/ hWnd, int /*long*/ hAccTable, MSG lpMsg);
/**
 * @param hWnd cast=(HWND)
 * @param hAccTable cast=(HACCEL)
 */
public static final native int TranslateAcceleratorA (int /*long*/ hWnd, int /*long*/ hAccTable, MSG lpMsg);
/**
 * @param lpSrc cast=(DWORD *)
 * @param lpCs cast=(LPCHARSETINFO)
 */
public static final native boolean TranslateCharsetInfo (int /*long*/ lpSrc, int [] lpCs, int dwFlags);
/**
 * @param hWndClient cast=(HWND)
 * @param lpMsg cast=(LPMSG)
 */
public static final native boolean TranslateMDISysAccel (int /*long*/ hWndClient, MSG lpMsg);
public static final native boolean TranslateMessage (MSG lpmsg);
/** @method flags=dynamic */
public static final native boolean TransparentBlt (int /*long*/ hdcDest, int nXOriginDest, int nYOriginDest, int nWidthDest, int hHeightDest, int /*long*/ hdcSrc, int nXOriginSrc, int nYOriginSrc, int nWidthSrc, int nHeightSrc, int crTransparent);
/** @param hhk cast=(HHOOK) */
public static final native boolean UnhookWindowsHookEx (int /*long*/ hhk);
/**
 * @param lpClassName cast=(LPWSTR)
 * @param hInstance cast=(HINSTANCE)
 */
public static final native boolean UnregisterClassW (char [] lpClassName, int /*long*/ hInstance);
/**
 * @param lpClassName cast=(LPSTR)
 * @param hInstance cast=(HINSTANCE)
 */
public static final native boolean UnregisterClassA (byte [] lpClassName, int /*long*/ hInstance);
/**
 * @method flags=dynamic
 * @param hwnd cast=(HWND)
 */
public static final native boolean UnregisterTouchWindow (int /*long*/ hwnd);
/** @param hWnd cast=(HWND) */
public static final native boolean UpdateWindow (int /*long*/ hWnd);
/**
 * @param pszPath cast=(LPCSTR)
 * @param pszURL cast=(LPSTR)
 */
public static final native int UrlCreateFromPathA (byte[] pszPath, byte[] pszURL, int[] pcchUrl, int flags);
/**
 * @param pszPath cast=(LPCWSTR)
 * @param pszURL cast=(LPWSTR)
 */
public static final native int UrlCreateFromPathW (char[] pszPath, char[] pszURL, int[] pcchUrl, int flags);
/** @param hWnd cast=(HWND) */
public static final native boolean ValidateRect (int /*long*/ hWnd, RECT lpRect);
/** @param ch cast=(WCHAR) */
public static final native short VkKeyScanW (short ch);
/** @param ch cast=(TCHAR) */
public static final native short VkKeyScanA (short ch);
/** @method flags=trycatch */
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl);

public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0);

public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, int arg2, int[] arg3);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1, int arg2, int[] arg3);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, int arg2, long[] arg3);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, long arg1, int arg2, long[] arg3);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1, int arg2, long[] arg3);

public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, char[] arg0, int arg1, int arg2, int[] arg3, int[] arg4);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, short arg0, byte[] arg1, byte[] arg2, byte[] arg3);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int[] arg0);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long[] arg0);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, byte[] arg0, int[] arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, byte[] arg0, long[] arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, int /*long*/[] arg1, int[] arg2);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, int[] arg1, int[] arg2);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, long[] arg1, long[] arg2);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, TF_DISPLAYATTRIBUTE arg0);

public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, int arg0, long arg1, long arg2);
public static final native int VtblCall(int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1, long arg2);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, int arg2);

public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, long arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, long arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int[] arg0, byte[] arg1, int[] arg2);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int[] arg0, byte[] arg1, long[] arg2);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, char[] arg0);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, char[] arg0, int arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, char[] arg0, long arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, PROPERTYKEY arg0, int arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, PROPERTYKEY arg0, long arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, int arg1, char[] arg2, char[] arg3, int arg4);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, int arg1, char[] arg2, char[] arg3, long arg4);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, int[] arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, long arg0, int[] arg1);
public static final native int VtblCall (int fnNumber, int /*long*/ ppVtbl, int arg0, long[] arg1);

public static final native boolean WaitMessage ();
/**
 * @param lpWideCharStr cast=(LPCWSTR),flags=no_out critical
 * @param lpMultiByteStr cast=(LPSTR),flags=no_in critical
 * @param lpDefaultChar cast=(LPCSTR)
 * @param lpUsedDefaultChar cast=(LPBOOL)
 */
public static final native int WideCharToMultiByte (int CodePage, int dwFlags, char [] lpWideCharStr, int cchWideChar, byte [] lpMultiByteStr, int cchMultiByte, byte [] lpDefaultChar, boolean [] lpUsedDefaultChar);
/**
 * @param lpWideCharStr cast=(LPCWSTR),flags=no_out critical
 * @param lpMultiByteStr cast=(LPSTR)
 * @param lpDefaultChar cast=(LPCSTR)
 * @param lpUsedDefaultChar cast=(LPBOOL)
 */
public static final native int WideCharToMultiByte (int CodePage, int dwFlags, char [] lpWideCharStr, int cchWideChar, int /*long*/ lpMultiByteStr, int cchMultiByte, byte [] lpDefaultChar, boolean [] lpUsedDefaultChar);
/** @param hDC cast=(HDC) */
public static final native int /*long*/ WindowFromDC (int /*long*/ hDC);
/** @param lpPoint flags=struct */
public static final native int /*long*/ WindowFromPoint (POINT lpPoint);
/** @param string cast=(const wchar_t *) */
public static final native int wcslen (int /*long*/ string);

/** @param hFileMappingObject cast=(HANDLE)
 *  @param dwDesiredAccess cast=(DWORD)
 *  @param dwFileOffsetHigh cast=(DWORD)
 *  @param dwFileOffsetLow cast=(DWORD)
 */
public static final native int /*long*/ MapViewOfFile(int /*long*/ hFileMappingObject, int dwDesiredAccess, int dwFileOffsetHigh, int dwFileOffsetLow, int dwNumberOfBytesToMap);
/** @param lpBaseAddress cast=(LPCVOID) */
public static final native boolean UnmapViewOfFile(int /*long*/ lpBaseAddress);

public static final int PROCESS_DUP_HANDLE = 0x0040;
public static final int PROCESS_VM_READ = 0x0010;
public static final int DUPLICATE_SAME_ACCESS = 2;

/**
 * @param dwDesiredAccess cast=(DWORD)
 * @param dwProcessId cast=(DWORD)
 */
public static final native int /*long*/ OpenProcess(int dwDesiredAccess, boolean bInheritHandle, int dwProcessId);

public static final native int /*long*/ GetCurrentProcess();

/**
 * @param hSourceProcessHandle cast=(HANDLE)
 * @param hSourceHandle cast=(HANDLE)
 * @param hTargetProcessHandle cast=(HANDLE)
 * @param lpTargetHandle cast=(LPHANDLE)
 * @param dwDesiredAccess cast=(DWORD)
 * @param dwOptions cast=(DWORD)
 */
public static final native boolean DuplicateHandle(int /*long*/ hSourceProcessHandle, int /*long*/ hSourceHandle, int /*long*/ hTargetProcessHandle,
		int /*long*/ [] lpTargetHandle, int dwDesiredAccess, boolean b, int dwOptions);

}
