/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.parser;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.mylyn.wikitext.parser.markup.DefaultIdGenerationStrategy;
import org.eclipse.mylyn.wikitext.parser.markup.IdGenerationStrategy;

public class IdGenerator {
    private static final DefaultIdGenerationStrategy DEFAULT_ID_GENERATION_STRATEGY = new DefaultIdGenerationStrategy();
    private final Map<String, Integer> idGenerators = new HashMap<String, Integer>();
    private final Set<String> anchorNames = new HashSet<String>();
    private IdGenerationStrategy generationStrategy = DEFAULT_ID_GENERATION_STRATEGY;

    public boolean reserveId(String id) {
        return this.anchorNames.add(id);
    }

    public String newId(String type, String text) {
        Integer current;
        if (type == null) {
            type = "";
        }
        if ((current = this.idGenerators.get(type)) == null) {
            current = 0;
        }
        current = current + 1;
        this.idGenerators.put(type, current);
        String id = null;
        if (text != null) {
            id = this.generationStrategy.generateId(text.trim());
            if (id == null || id.length() == 0) {
                id = type + '-' + current;
            }
        } else {
            id = type + '-' + current;
        }
        String template = id;
        int suffix = 1;
        while (!this.anchorNames.add(id)) {
            id = template + ++suffix;
        }
        return id;
    }

    public Set<String> getAnchorNames() {
        return Collections.unmodifiableSet(this.anchorNames);
    }

    public boolean hasAnchorNames() {
        return !this.anchorNames.isEmpty();
    }

    public IdGenerationStrategy getGenerationStrategy() {
        return this.generationStrategy;
    }

    public void setGenerationStrategy(IdGenerationStrategy generationStrategy) {
        this.generationStrategy = (IdGenerationStrategy)Preconditions.checkNotNull((Object)generationStrategy, (Object)"Must provide a generationStrategy");
    }
}

