/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.emfstore.internal.client.ui.controller;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.Callable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.emfstore.client.ESServer;
import org.eclipse.emf.emfstore.internal.client.model.ESWorkspaceProviderImpl;
import org.eclipse.emf.emfstore.internal.client.model.ProjectSpace;
import org.eclipse.emf.emfstore.internal.client.model.ServerInfo;
import org.eclipse.emf.emfstore.internal.client.model.Usersession;
import org.eclipse.emf.emfstore.internal.client.model.Workspace;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESServerImpl;
import org.eclipse.emf.emfstore.internal.client.model.impl.api.ESWorkspaceImpl;
import org.eclipse.emf.emfstore.internal.client.ui.common.RunInUI;
import org.eclipse.emf.emfstore.internal.client.ui.controller.AbstractEMFStoreUIController;
import org.eclipse.emf.emfstore.internal.client.ui.controller.Messages;
import org.eclipse.emf.emfstore.server.exceptions.ESException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UIRemoveServerController
extends AbstractEMFStoreUIController<Void> {
    private final ServerInfo serverInfo;

    public UIRemoveServerController(Shell shell, ESServer server) {
        super(shell);
        this.serverInfo = (ServerInfo)((ESServerImpl)server).toInternalAPI();
    }

    @Override
    public Void doRun(IProgressMonitor monitor) throws ESException {
        boolean shouldDelete = MessageDialog.openQuestion((Shell)this.getShell(), (String)Messages.UIRemoveServerController_Confirmation, (String)String.format(Messages.UIRemoveServerController_DeleteProject_Prompt, this.serverInfo.getName()));
        if (!shouldDelete) {
            return null;
        }
        final ESWorkspaceImpl workspace = ESWorkspaceProviderImpl.getInstance().getWorkspace();
        EList projectSpaces = ((Workspace)workspace.toInternalAPI()).getProjectSpaces();
        ArrayList projectSpacesInUse = Lists.newArrayList();
        for (ProjectSpace projectSpace : projectSpaces) {
            if (!UIRemoveServerController.projectSpaceIsInUse(projectSpace, this.serverInfo)) continue;
            projectSpacesInUse.add(projectSpace);
        }
        if (!projectSpacesInUse.isEmpty()) {
            this.showWarning(projectSpacesInUse);
            return null;
        }
        RunInUI.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((Workspace)ESWorkspaceProviderImpl.getInstance().getWorkspace().toInternalAPI()).getServerInfos().remove((Object)UIRemoveServerController.this.serverInfo);
                return null;
            }
        });
        final LinkedHashSet<Usersession> invalidSessions = new LinkedHashSet<Usersession>();
        for (Usersession session : ESWorkspaceProviderImpl.getInstance().getInternalWorkspace().getUsersessions()) {
            if (session.getServerInfo() != this.serverInfo) continue;
            invalidSessions.add(session);
        }
        RunInUI.run(new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                ((Workspace)workspace.toInternalAPI()).getUsersessions().removeAll((Collection)invalidSessions);
                ((Workspace)workspace.toInternalAPI()).save();
                return null;
            }
        });
        return null;
    }

    private void showWarning(ArrayList<ProjectSpace> projectSpacesInUse) {
        StringBuilder message = new StringBuilder();
        for (ProjectSpace projectSpace : projectSpacesInUse) {
            message.append(String.valueOf(Messages.UIRemoveServerController_Newline) + projectSpace.getProjectName());
        }
        MessageDialog.openError((Shell)this.getShell(), (String)Messages.UIRemoveServerController_ErrorDelete_Title, (String)String.format(String.valueOf(Messages.UIRemoveServerController_ErrorDelete_Message) + message.toString(), this.serverInfo.getName()));
    }

    private static boolean projectSpaceIsInUse(ProjectSpace projectSpace, ServerInfo serverInfo) {
        return projectSpace.getUsersession() != null && projectSpace.getUsersession().getServerInfo().equals(serverInfo);
    }
}

