/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.datatools.sqltools.common.ui.resource;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Iterator;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.datatools.sqltools.common.ui.internal.Activator;
import org.eclipse.datatools.sqltools.common.ui.resource.Messages;
import org.eclipse.datatools.sqltools.common.ui.resource.ResourceAndContainerGroup;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.internal.ide.dialogs.CreateLinkedResourceGroup;

public class WizardNewFileCreationPage
extends WizardPage
implements Listener {
    private static final int _SIZING_CONTAINER_GROUP_HEIGHT = 200;
    private static final int _SIZING_CONTAINER_GROUP_MEDIAM_HEIGHT = 100;
    private static final int _SIZING_CONTAINER_GROUP_SMALL_HEIGHT = 60;
    private IStructuredSelection _currentSelection;
    private IFile _newFile;
    private IPath _linkTargetPath;
    private ResourceAndContainerGroup _resourceGroup;
    private Button _advancedButton;
    private CreateLinkedResourceGroup _linkedResourceGroup;
    private Composite _linkedResourceParent;
    private Composite _linkedResourceComposite;
    private String _initialFileName;
    private IPath _initialContainerFullPath;
    private int _linkedResourceGroupHeight = -1;
    private boolean _firstLinkCheck = true;

    public WizardNewFileCreationPage(String pageName, IStructuredSelection selection) {
        super(pageName);
        this.setPageComplete(false);
        this._currentSelection = selection;
    }

    protected void createAdvancedControls(Composite parent) {
        Preferences preferences = ResourcesPlugin.getPlugin().getPluginPreferences();
        if (!preferences.getBoolean("description.disableLinking")) {
            this._linkedResourceParent = new Composite(parent, 0);
            this._linkedResourceParent.setFont(parent.getFont());
            this._linkedResourceParent.setLayoutData((Object)new GridData(768));
            GridLayout layout = new GridLayout();
            layout.marginHeight = 0;
            layout.marginWidth = 0;
            this._linkedResourceParent.setLayout((Layout)layout);
            this._advancedButton = new Button(this._linkedResourceParent, 8);
            this._advancedButton.setFont(this._linkedResourceParent.getFont());
            this._advancedButton.setText(Messages.showAdvanced);
            GridData data = this.setButtonLayoutData(this._advancedButton);
            data.horizontalAlignment = 1;
            this._advancedButton.setLayoutData((Object)data);
            this._advancedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    WizardNewFileCreationPage.this.handleAdvancedButtonSelect();
                }
            });
        }
        this._linkedResourceGroup = new CreateLinkedResourceGroup(1, new Listener(){

            public void handleEvent(Event e) {
                WizardNewFileCreationPage.this.setPageComplete(WizardNewFileCreationPage.this.validatePage());
                WizardNewFileCreationPage.this._firstLinkCheck = false;
            }
        }, null);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite topLevel = new Composite(parent, 0);
        topLevel.setLayout((Layout)new GridLayout());
        topLevel.setLayoutData((Object)new GridData(272));
        topLevel.setFont(parent.getFont());
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)topLevel, "org.eclipse.ui.ide.new_file_wizard_page_context");
        this.createPageControl(topLevel);
        this.validatePage();
        this.setErrorMessage(null);
        this.setMessage(null);
        this.setControl((Control)topLevel);
    }

    protected void createPageControl(Composite parent) {
        int height = 200;
        int screenHeight = Display.getDefault().getBounds().height;
        if (screenHeight <= 600) {
            height = 60;
        } else if (screenHeight <= 768) {
            height = 100;
        }
        this._resourceGroup = new ResourceAndContainerGroup(parent, this, this.getNewFileLabel(), Messages.WizardNewFileCreationPage_file, false, height);
        this._resourceGroup.setAllowExistingResources(false);
        this.initialPopulateContainerNameField();
        this.createAdvancedControls(parent);
        if (this._initialFileName != null) {
            this._resourceGroup.setResource(this._initialFileName);
        }
    }

    protected void createFile(IFile fileHandle, InputStream contents, IProgressMonitor monitor) throws CoreException {
        if (contents == null) {
            contents = new ByteArrayInputStream(new byte[0]);
        }
        try {
            if (this._linkTargetPath != null) {
                fileHandle.createLink(this._linkTargetPath, 16, monitor);
            } else {
                fileHandle.create(contents, false, monitor);
            }
        }
        catch (CoreException e) {
            if (e.getStatus().getCode() == 374) {
                fileHandle.refreshLocal(0, null);
            }
            throw e;
        }
        if (monitor.isCanceled()) {
            throw new OperationCanceledException();
        }
    }

    protected IFile createFileHandle(IPath filePath) {
        return ResourcesPlugin.getWorkspace().getRoot().getFile(filePath);
    }

    protected void createLinkTarget() {
        try {
            Method getLinkTarget = CreateLinkedResourceGroup.class.getMethod("getLinkTarget", null);
            String linkTarget = (String)getLinkTarget.invoke((Object)this._linkedResourceGroup, null);
            this._linkTargetPath = linkTarget != null ? new Path(linkTarget) : null;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                Method getLinkTargetURI = CreateLinkedResourceGroup.class.getMethod("getLinkTargetURI", null);
                URI linkTargetURI = (URI)getLinkTargetURI.invoke((Object)this._linkedResourceGroup, null);
                if (linkTargetURI != null) {
                    this._linkTargetPath = URIUtil.toPath((URI)linkTargetURI);
                }
                this._linkTargetPath = null;
            }
            catch (Exception ee) {
                Activator.getDefault().log(NLS.bind((String)Messages.WizardNewFileCreationPage_internalErrorMessage, (Object)((Object)((Object)this)).getClass().getName(), (Object)ee));
            }
        }
        catch (Exception e) {
            Activator.getDefault().log(NLS.bind((String)Messages.WizardNewFileCreationPage_internalErrorMessage, (Object)((Object)((Object)this)).getClass().getName(), (Object)e));
        }
    }

    public IFile createNewFile() {
        if (this._newFile != null) {
            return this._newFile;
        }
        final IPath containerPath = this._resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this._resourceGroup.getResource());
        final IFile newFileHandle = this.createFileHandle(newFilePath);
        final InputStream initialContents = this.getInitialContents();
        this.createLinkTarget();
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(null){

            protected void execute(IProgressMonitor monitor) throws CoreException, InterruptedException {
                try {
                    monitor.beginTask(Messages.WizardNewFileCreationPage_progress, 2000);
                    ContainerGenerator generator = new ContainerGenerator(containerPath);
                    generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    WizardNewFileCreationPage.this.createFile(newFileHandle, initialContents, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                finally {
                    monitor.done();
                }
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof CoreException) {
                ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.WizardNewFileCreationPage_errorTitle, null, (IStatus)((CoreException)e.getTargetException()).getStatus());
            } else {
                Activator.getDefault().log(NLS.bind((String)Messages.WizardNewFileCreationPage_error_create_file, (Object)((Object)((Object)this)).getClass().getName(), (Object)e.getTargetException()));
                MessageDialog.openError((Shell)this.getContainer().getShell(), (String)Messages.WizardNewFileCreationPage_internalErrorTitle, (String)NLS.bind((String)Messages.WizardNewFileCreationPage_internalErrorMessage, (Object)e.getTargetException().getMessage()));
            }
            return null;
        }
        this._newFile = newFileHandle;
        return this._newFile;
    }

    public IPath getContainerFullPath() {
        return this._resourceGroup.getContainerFullPath();
    }

    public String getFileName() {
        if (this._resourceGroup == null) {
            return this._initialFileName;
        }
        return this._resourceGroup.getResource();
    }

    protected InputStream getInitialContents() {
        return null;
    }

    protected String getNewFileLabel() {
        return Messages.WizardNewFileCreationPage_fileLabel;
    }

    protected void handleAdvancedButtonSelect() {
        Shell shell = this.getShell();
        Point shellSize = shell.getSize();
        Composite composite = (Composite)this.getControl();
        if (this._linkedResourceComposite != null) {
            this._linkedResourceComposite.dispose();
            this._linkedResourceComposite = null;
            composite.layout();
            shell.setSize(shellSize.x, shellSize.y - this._linkedResourceGroupHeight);
            this._advancedButton.setText(Messages.showAdvanced);
        } else {
            this._linkedResourceComposite = this._linkedResourceGroup.createContents(this._linkedResourceParent);
            if (this._linkedResourceGroupHeight == -1) {
                Point groupSize = this._linkedResourceComposite.computeSize(-1, -1, true);
                this._linkedResourceGroupHeight = groupSize.y;
            }
            shell.setSize(shellSize.x, shellSize.y + this._linkedResourceGroupHeight);
            composite.layout();
            this._advancedButton.setText(Messages.hideAdvanced);
        }
    }

    public void handleEvent(Event event) {
        this.setPageComplete(this.validatePage());
    }

    protected void initialPopulateContainerNameField() {
        if (this._initialContainerFullPath != null) {
            this._resourceGroup.setContainerFullPath(this._initialContainerFullPath);
        } else {
            Iterator i = this._currentSelection.iterator();
            if (i.hasNext()) {
                Object object = i.next();
                IResource selectedResource = null;
                if (object instanceof IResource) {
                    selectedResource = (IResource)object;
                } else if (object instanceof IAdaptable) {
                    selectedResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
                }
                if (selectedResource != null) {
                    if (selectedResource.getType() == 1) {
                        selectedResource = selectedResource.getParent();
                    }
                    if (selectedResource.isAccessible()) {
                        this._resourceGroup.setContainerFullPath(selectedResource.getFullPath());
                    }
                }
            }
        }
    }

    public void setContainerFullPath(IPath path) {
        if (this._resourceGroup == null) {
            this._initialContainerFullPath = path;
        } else {
            this._resourceGroup.setContainerFullPath(path);
        }
    }

    public void setFileName(String value) {
        if (this._resourceGroup == null) {
            this._initialFileName = value;
        } else {
            this._resourceGroup.setResource(value);
        }
    }

    protected IStatus validateLinkedResource() {
        IPath containerPath = this._resourceGroup.getContainerFullPath();
        IPath newFilePath = containerPath.append(this._resourceGroup.getResource());
        IFile newFileHandle = this.createFileHandle(newFilePath);
        IStatus status = this._linkedResourceGroup.validateLinkLocation((IResource)newFileHandle);
        if (status.getSeverity() == 4) {
            if (this._firstLinkCheck) {
                this.setMessage(status.getMessage());
            } else {
                this.setErrorMessage(status.getMessage());
            }
        } else if (status.getSeverity() == 2) {
            this.setMessage(status.getMessage(), 2);
            this.setErrorMessage(null);
        }
        return status;
    }

    protected boolean validatePage() {
        boolean valid = true;
        if (!this._resourceGroup.areAllValuesValid()) {
            if (this._resourceGroup.getProblemType() == 1 || this._resourceGroup.getProblemType() == 5) {
                this.setMessage(this._resourceGroup.getProblemMessage());
                this.setErrorMessage(null);
            } else {
                this.setErrorMessage(this._resourceGroup.getProblemMessage());
            }
            valid = false;
        }
        String resourceName = this._resourceGroup.getResource();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IStatus result = workspace.validateName(resourceName, 1);
        if (!result.isOK()) {
            this.setErrorMessage(result.getMessage());
            return false;
        }
        IStatus linkedResourceStatus = null;
        if (valid && (linkedResourceStatus = this.validateLinkedResource()).getSeverity() == 4) {
            valid = false;
        }
        if (valid && (linkedResourceStatus == null || linkedResourceStatus.isOK())) {
            this.setMessage(null);
            this.setErrorMessage(null);
        }
        return valid;
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this._resourceGroup.setFocus();
        }
    }
}

