/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.stack.immutable;

import org.eclipse.collections.api.factory.stack.ImmutableStackFactory;
import org.eclipse.collections.api.stack.ImmutableStack;
import org.eclipse.collections.impl.stack.immutable.ImmutableEmptyStack;
import org.eclipse.collections.impl.stack.immutable.ImmutableNotEmptyStack;
import org.eclipse.collections.impl.utility.Iterate;

public class ImmutableStackFactoryImpl
implements ImmutableStackFactory {
    public static final ImmutableStackFactory INSTANCE = new ImmutableStackFactoryImpl();

    public <T> ImmutableStack<T> empty() {
        return ImmutableEmptyStack.INSTANCE;
    }

    public <T> ImmutableStack<T> of() {
        return this.empty();
    }

    public <T> ImmutableStack<T> with() {
        return this.empty();
    }

    public <T> ImmutableStack<T> of(T element) {
        return this.with(element);
    }

    public <T> ImmutableStack<T> with(T element) {
        return new ImmutableNotEmptyStack<T>(element, this.empty());
    }

    public <T> ImmutableStack<T> of(T ... elements) {
        return this.with(elements);
    }

    public <T> ImmutableStack<T> with(T ... elements) {
        ImmutableStack result = this.empty();
        for (T element : elements) {
            result = result.push(element);
        }
        return result;
    }

    public <T> ImmutableStack<T> ofAll(Iterable<? extends T> items) {
        return this.withAll(items);
    }

    public <T> ImmutableStack<T> withAll(Iterable<? extends T> items) {
        ImmutableStack result = this.empty();
        for (T item : items) {
            result = result.push(item);
        }
        return result;
    }

    public <T> ImmutableStack<T> ofReversed(T ... elements) {
        return this.withReversed(elements);
    }

    public <T> ImmutableStack<T> withReversed(T ... elements) {
        ImmutableStack result = this.empty();
        for (int i = elements.length - 1; i >= 0; --i) {
            T element = elements[i];
            result = result.push(element);
        }
        return result;
    }

    public <T> ImmutableStack<T> ofAllReversed(Iterable<? extends T> items) {
        return this.withAllReversed(items);
    }

    public <T> ImmutableStack<T> withAllReversed(Iterable<? extends T> items) {
        return this.withReversed(Iterate.toArray(items));
    }
}

