/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.evaluation.join;

import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.rdf4j.common.iteration.CloseableIteration;
import org.eclipse.rdf4j.common.iteration.LookAheadIteration;
import org.eclipse.rdf4j.federated.evaluation.FederationEvalStrategy;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelExecutor;
import org.eclipse.rdf4j.federated.evaluation.concurrent.ParallelTaskBase;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.QueryEvaluationException;
import org.eclipse.rdf4j.query.algebra.LeftJoin;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.eclipse.rdf4j.query.algebra.evaluation.ValueExprEvaluationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParallelLeftJoinTask
extends ParallelTaskBase<BindingSet> {
    static final Logger log = LoggerFactory.getLogger(ParallelLeftJoinTask.class);
    protected final FederationEvalStrategy strategy;
    protected final LeftJoin join;
    protected final BindingSet leftBindings;
    protected final ParallelExecutor<BindingSet> joinControl;

    public ParallelLeftJoinTask(ParallelExecutor<BindingSet> joinControl, FederationEvalStrategy strategy, LeftJoin join, BindingSet leftBindings) {
        this.strategy = strategy;
        this.join = join;
        this.leftBindings = leftBindings;
        this.joinControl = joinControl;
    }

    @Override
    protected CloseableIteration<BindingSet> performTaskInternal() throws Exception {
        return new FedXLeftJoinIteration(this.strategy, this.join, this.leftBindings);
    }

    @Override
    public ParallelExecutor<BindingSet> getControl() {
        return this.joinControl;
    }

    static class FedXLeftJoinIteration
    extends LookAheadIteration<BindingSet> {
        protected final FederationEvalStrategy strategy;
        private final BindingSet leftBindings;
        private final LeftJoin join;
        private final Set<String> scopeBindingNames;
        private CloseableIteration<BindingSet> rightIter;
        private final AtomicBoolean exhausted = new AtomicBoolean(false);

        public FedXLeftJoinIteration(FederationEvalStrategy strategy, LeftJoin join, BindingSet leftBindings) {
            this.strategy = strategy;
            this.join = join;
            this.leftBindings = leftBindings;
            this.scopeBindingNames = join.getBindingNames();
        }

        protected BindingSet getNextElement() throws QueryEvaluationException {
            if (this.rightIter == null) {
                this.rightIter = this.strategy.evaluate(this.join.getRightArg(), this.leftBindings);
                if (!this.rightIter.hasNext() && !this.exhausted.getAndSet(true)) {
                    this.rightIter.close();
                    return this.leftBindings;
                }
            }
            if (this.rightIter.hasNext()) {
                while (this.rightIter.hasNext()) {
                    BindingSet rightBindings = (BindingSet)this.rightIter.next();
                    try {
                        if (this.join.getCondition() == null) {
                            return rightBindings;
                        }
                        QueryBindingSet scopeBindings = new QueryBindingSet(rightBindings);
                        scopeBindings.retainAll(this.scopeBindingNames);
                        if (!this.strategy.isTrue(this.join.getCondition(), (BindingSet)scopeBindings)) continue;
                        return rightBindings;
                    }
                    catch (ValueExprEvaluationException valueExprEvaluationException) {
                    }
                }
                if (this.leftBindings != null) {
                    return this.leftBindings;
                }
            }
            this.rightIter.close();
            return null;
        }

        protected void handleClose() throws QueryEvaluationException {
            if (this.rightIter != null) {
                this.rightIter.close();
            }
        }
    }
}

