/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.federated.algebra;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.eclipse.rdf4j.federated.algebra.BoundFiltersNode;
import org.eclipse.rdf4j.federated.algebra.BoundJoinTupleExpr;
import org.eclipse.rdf4j.federated.algebra.ConjunctiveFilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterExpr;
import org.eclipse.rdf4j.federated.algebra.FilterTuple;
import org.eclipse.rdf4j.federated.algebra.FilterValueExpr;
import org.eclipse.rdf4j.federated.algebra.NodeFactory;
import org.eclipse.rdf4j.federated.algebra.StatementSource;
import org.eclipse.rdf4j.federated.algebra.StatementTupleExpr;
import org.eclipse.rdf4j.federated.structures.QueryInfo;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.algebra.AbstractQueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelNode;
import org.eclipse.rdf4j.query.algebra.QueryModelVisitor;
import org.eclipse.rdf4j.query.algebra.StatementPattern;
import org.eclipse.rdf4j.query.algebra.Var;
import org.eclipse.rdf4j.query.algebra.evaluation.QueryBindingSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FedXStatementPattern
extends StatementPattern
implements StatementTupleExpr,
FilterTuple,
BoundJoinTupleExpr {
    private static final Logger log = LoggerFactory.getLogger(FedXStatementPattern.class);
    private static final long serialVersionUID = 6588020780262348806L;
    protected final List<StatementSource> statementSources = new ArrayList<StatementSource>();
    protected final String id;
    protected final QueryInfo queryInfo;
    protected final List<String> freeVars = new ArrayList<String>(3);
    protected FilterValueExpr filterExpr = null;
    protected QueryBindingSet boundFilters = null;
    protected long upperLimit = -1L;

    public FedXStatementPattern(StatementPattern node, QueryInfo queryInfo) {
        super(node.getScope(), node.getSubjectVar().clone(), node.getPredicateVar().clone(), node.getObjectVar().clone(), node.getContextVar() != null ? node.getContextVar().clone() : null);
        this.id = NodeFactory.getNextId();
        this.queryInfo = queryInfo;
        this.initFreeVars();
    }

    @Override
    public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        super.visitChildren(visitor);
        for (StatementSource s : this.sort(this.statementSources)) {
            s.visit(visitor);
        }
        if (this.boundFilters != null) {
            BoundFiltersNode.visit(visitor, this.boundFilters);
        }
        if (this.upperLimit > 0L) {
            new UpperLimitNode(this.upperLimit).visit(visitor);
        }
        if (this.filterExpr != null) {
            this.filterExpr.visit(visitor);
        }
    }

    @Override
    public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
        visitor.meetOther(this);
    }

    protected void initFreeVars() {
        if (this.getSubjectVar().getValue() == null) {
            this.freeVars.add(this.getSubjectVar().getName());
        }
        if (this.getPredicateVar().getValue() == null) {
            this.freeVars.add(this.getPredicateVar().getName());
        }
        if (this.getObjectVar().getValue() == null) {
            this.freeVars.add(this.getObjectVar().getName());
        }
    }

    @Override
    public int getFreeVarCount() {
        return this.freeVars.size();
    }

    @Override
    public List<String> getFreeVars() {
        return this.freeVars;
    }

    @Override
    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public boolean hasFreeVarsFor(BindingSet bindings) {
        for (String var : this.freeVars) {
            if (bindings.hasBinding(var)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<StatementSource> getStatementSources() {
        return this.statementSources;
    }

    public int getSourceCount() {
        return this.statementSources.size();
    }

    @Override
    public FilterValueExpr getFilterExpr() {
        return this.filterExpr;
    }

    @Override
    public BindingSet getBoundFilters() {
        return this.boundFilters;
    }

    @Override
    public boolean hasFilter() {
        return this.filterExpr != null;
    }

    @Override
    public void addFilterExpr(FilterExpr expr) {
        if (this.filterExpr == null) {
            this.filterExpr = expr;
        } else if (this.filterExpr instanceof ConjunctiveFilterExpr) {
            ((ConjunctiveFilterExpr)this.filterExpr).addExpression(expr);
        } else if (this.filterExpr instanceof FilterExpr) {
            this.filterExpr = new ConjunctiveFilterExpr((FilterExpr)this.filterExpr, expr);
        } else {
            throw new RuntimeException("Unexpected type: " + this.filterExpr.getClass().getCanonicalName());
        }
    }

    @Override
    public void addBoundFilter(String varName, Value value) {
        Var var;
        if (!this.freeVars.contains(varName)) {
            log.debug("Invalid call to addBoundFilter: variable " + varName + " is not known as a free variable");
            return;
        }
        if (this.boundFilters == null) {
            this.boundFilters = new QueryBindingSet();
        }
        if (this.getSubjectVar().getName().equals(varName)) {
            var = this.getSubjectVar();
            var.replaceWith(new Var(var.getName(), value, var.isAnonymous(), var.isConstant()));
        }
        if (this.getPredicateVar().getName().equals(varName)) {
            var = this.getPredicateVar();
            var.replaceWith(new Var(var.getName(), value, var.isAnonymous(), var.isConstant()));
        }
        if (this.getObjectVar().getName().equals(varName)) {
            var = this.getObjectVar();
            var.replaceWith(new Var(var.getName(), value, var.isAnonymous(), var.isConstant()));
        }
        this.boundFilters.addBinding(varName, value);
        this.freeVars.remove(varName);
    }

    public void setUpperLimit(long upperLimit) {
        this.upperLimit = upperLimit;
    }

    public long getUpperLimit() {
        return this.upperLimit;
    }

    private List<StatementSource> sort(List<StatementSource> stmtSources) {
        ArrayList<StatementSource> res = new ArrayList<StatementSource>(stmtSources);
        res.sort(Comparator.comparing(o -> o.id));
        return res;
    }

    static class UpperLimitNode
    extends AbstractQueryModelNode {
        private static final long serialVersionUID = -1331709574582152474L;
        private final long upperLimit;

        public UpperLimitNode(long upperLimit) {
            this.upperLimit = upperLimit;
        }

        @Override
        public String getSignature() {
            return "Upper Limit: " + this.upperLimit;
        }

        @Override
        public <X extends Exception> void visit(QueryModelVisitor<X> visitor) throws X {
            visitor.meetOther(this);
        }

        @Override
        public <X extends Exception> void visitChildren(QueryModelVisitor<X> visitor) throws X {
        }

        @Override
        public void replaceChildNode(QueryModelNode current, QueryModelNode replacement) {
            throw new IllegalArgumentException("Node is not a child node: " + String.valueOf(current));
        }
    }
}

