/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.eclipse.collections.api.block.procedure.primitive.ObjectLongProcedure;
import org.eclipse.collections.api.map.primitive.ImmutableObjectLongMap;
import org.eclipse.collections.api.map.primitive.ObjectLongMap;
import org.eclipse.collections.impl.block.procedure.checked.primitive.CheckedObjectLongProcedure;
import org.eclipse.collections.impl.map.mutable.primitive.ObjectLongHashMap;

public abstract class AbstractImmutableObjectLongMap<V>
implements ImmutableObjectLongMap<V> {

    protected static class ImmutableObjectLongMapSerializationProxy<V>
    implements Externalizable {
        private static final long serialVersionUID = 1L;
        private ObjectLongMap<V> map;

        public ImmutableObjectLongMapSerializationProxy() {
        }

        protected ImmutableObjectLongMapSerializationProxy(ObjectLongMap<V> map) {
            this.map = map;
        }

        @Override
        public void writeExternal(final ObjectOutput out) throws IOException {
            out.writeInt(this.map.size());
            try {
                this.map.forEachKeyValue((ObjectLongProcedure)new CheckedObjectLongProcedure<V>(){

                    @Override
                    public void safeValue(V key, long value) throws IOException {
                        out.writeObject(key);
                        out.writeLong(value);
                    }
                });
            }
            catch (RuntimeException e) {
                if (e.getCause() instanceof IOException) {
                    throw (IOException)e.getCause();
                }
                throw e;
            }
        }

        @Override
        public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
            int size = in.readInt();
            ObjectLongHashMap deserializedMap = new ObjectLongHashMap();
            for (int i = 0; i < size; ++i) {
                deserializedMap.put(in.readObject(), in.readLong());
            }
            this.map = deserializedMap;
        }

        protected Object readResolve() {
            return this.map.toImmutable();
        }
    }
}

