/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.ui.player;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Widget;

public class EventBuilder {
    private Event e;
    private static int lastStamp = -1;

    public EventBuilder(int type) {
        this.e = new Event();
        this.e.type = type;
    }

    public EventBuilder(Event event) {
        this.e = event;
    }

    public void send(Widget widget) {
        this.e.widget = widget;
        if (this.e.time == 0) {
            this.e.time = (int)System.currentTimeMillis();
        }
        if (this.e.time == lastStamp) {
            ++this.e.time;
        }
        lastStamp = this.e.time;
        this.e.widget.notifyListeners(this.e.type, this.e);
    }

    public EventBuilder button(int button) {
        this.e.button = button;
        return this;
    }

    public EventBuilder x(int x) {
        this.e.x = x;
        return this;
    }

    public EventBuilder y(int y) {
        this.e.y = y;
        return this;
    }

    public EventBuilder xy(int x, int y) {
        this.e.x = x;
        this.e.y = y;
        return this;
    }

    public EventBuilder xy(Point point) {
        this.e.x = point.x;
        this.e.y = point.y;
        return this;
    }

    public EventBuilder widget(Widget widget) {
        this.e.widget = widget;
        return this;
    }

    public EventBuilder item(Widget item) {
        this.e.item = item;
        return this;
    }

    public EventBuilder type(int type) {
        this.e.type = type;
        return this;
    }

    public EventBuilder stateMask(int stateMask) {
        this.e.stateMask = stateMask;
        return this;
    }

    public EventBuilder detail(int detail) {
        this.e.detail = detail;
        return this;
    }

    public EventBuilder doit(boolean doit) {
        this.e.doit = doit;
        return this;
    }

    public EventBuilder data(Object data) {
        this.e.data = data;
        return this;
    }
}

