/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.manipulation.JavaManipulation;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.util.CodeFormatterUtil;

public class JavaPreferencesSettings {
    public static CodeGenerationSettings getCodeGenerationSettings(IJavaProject project) {
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.createComments = Boolean.parseBoolean(JavaManipulation.getPreference("org.eclipse.jdt.ui.javadoc", project));
        res.useKeywordThis = Boolean.parseBoolean(JavaManipulation.getPreference("org.eclipse.jdt.ui.keywordthis", project));
        res.overrideAnnotation = Boolean.parseBoolean(JavaManipulation.getPreference("org.eclipse.jdt.ui.overrideannotation", project));
        res.importIgnoreLowercase = Boolean.parseBoolean(JavaManipulation.getPreference("org.eclipse.jdt.ui.ignorelowercasenames", project));
        res.tabWidth = CodeFormatterUtil.getTabWidth(project);
        res.indentWidth = CodeFormatterUtil.getIndentWidth(project);
        return res;
    }

    public static CodeGenerationSettings getCodeGenerationSettings(ICompilationUnit cu) {
        CodeGenerationSettings res = new CodeGenerationSettings();
        res.createComments = Boolean.parseBoolean(JavaPreferencesSettings.getPreference("org.eclipse.jdt.ui.javadoc", cu));
        res.useKeywordThis = Boolean.parseBoolean(JavaPreferencesSettings.getPreference("org.eclipse.jdt.ui.keywordthis", cu));
        res.overrideAnnotation = Boolean.parseBoolean(JavaPreferencesSettings.getPreference("org.eclipse.jdt.ui.overrideannotation", cu));
        res.importIgnoreLowercase = Boolean.parseBoolean(JavaPreferencesSettings.getPreference("org.eclipse.jdt.ui.ignorelowercasenames", cu));
        res.tabWidth = CodeFormatterUtil.getTabWidth(cu);
        res.indentWidth = CodeFormatterUtil.getIndentWidth(cu);
        return res;
    }

    private static String getPreference(String key, ICompilationUnit cu) {
        if (cu != null) {
            String val = cu.getCustomOptions().getOrDefault(key, null);
            if (val != null) {
                return val;
            }
            return JavaManipulation.getPreference(key, cu.getJavaProject());
        }
        return JavaManipulation.getPreference(key, null);
    }

    private JavaPreferencesSettings() {
    }
}

