/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ui.wizards.plain;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.observable.ChangeEvent;
import org.eclipse.core.databinding.observable.IChangeListener;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.core.databinding.observable.value.WritableValue;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.jface.databinding.swt.typed.WidgetProperties;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.rcptt.core.Scenarios;
import org.eclipse.rcptt.core.model.IContext;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7Folder;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.ITestCase;
import org.eclipse.rcptt.core.model.IVerification;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.persistence.IPersistenceModel;
import org.eclipse.rcptt.core.persistence.PersistenceManager;
import org.eclipse.rcptt.core.persistence.plain.IPlainConstants;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.core.workspace.RcpttCore;
import org.eclipse.rcptt.ecl.core.Script;
import org.eclipse.rcptt.internal.core.model.Q7Folder;
import org.eclipse.rcptt.internal.core.model.Q7ResourceInfo;
import org.eclipse.rcptt.internal.core.model.ReferencedProjectScope;
import org.eclipse.rcptt.internal.ui.Messages;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.rcptt.ui.wizards.LocationSelectionDialog;
import org.eclipse.rcptt.ui.wizards.plain.DestinationsBox;
import org.eclipse.rcptt.util.FileUtil;
import org.eclipse.rcptt.util.StringUtils;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class Q7PortableFormatImportPage
extends WizardPage
implements IPlainConstants {
    private static final String CONTEXTS_PREFIX = "/contexts/";
    private static final String VERIFICATIONS_PREFIX = "/verifications/";
    private DestinationsBox destinations;
    private DataBindingContext dbc = new DataBindingContext();
    private WritableValue<String> previewValue = new WritableValue((Object)"", String.class);
    private boolean isValid = false;
    private WritableValue<String> locationValue = new WritableValue((Object)"", String.class);
    private WritableValue<String> testcaseNameValue = new WritableValue((Object)"", String.class);
    private IContainer initialContainer;

    protected Q7PortableFormatImportPage(String pageName, IContainer container) {
        super(pageName);
        this.setDescription("Select the source to import test case from");
        this.setTitle("RCPTT Portable Format");
        this.initialContainer = container;
        if (this.initialContainer != null) {
            this.locationValue.setValue((Object)this.initialContainer.getFullPath().toString());
        }
    }

    public void createControl(Composite parent) {
        Composite cp = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().applyTo(cp);
        Composite infoGroup = new Composite(cp, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)infoGroup);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(infoGroup);
        Label label = new Label(infoGroup, 16384);
        label.setText(Messages.WizardExecutablePage_LocationLabel);
        Text locationText = new Text(infoGroup, 2048);
        GridDataFactory.fillDefaults().align(4, 0x1000000).grab(true, false).applyTo((Control)locationText);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)locationText), this.locationValue);
        Button browse = new Button(infoGroup, 8);
        browse.setText(Messages.WizardExecutablePage_BrowseButton);
        browse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Q7PortableFormatImportPage.this.browseLocation();
            }
        });
        this.setButtonLayoutData(browse);
        Label l = new Label(infoGroup, 0);
        l.setText("Testcase name:");
        Text testCaseName = new Text(infoGroup, 2048);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)testCaseName);
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)testCaseName), this.testcaseNameValue);
        this.destinations = new DestinationsBox(this.dbc){

            @Override
            protected String getFileTitle() {
                return "Import from File";
            }

            @Override
            protected String getClipboardTitle() {
                return "Import from Clipboard";
            }

            @Override
            protected int getFileKind() {
                return 4096;
            }
        };
        this.destinations.create(cp);
        Group preview = new Group(cp, 0);
        preview.setText("Preview");
        GridDataFactory.fillDefaults().hint(200, 200).grab(true, true).applyTo((Control)preview);
        GridLayoutFactory.swtDefaults().applyTo((Composite)preview);
        StyledText text = new StyledText((Composite)preview, 2824);
        text.setCaret(null);
        FontData dt = new FontData("monospace", 10, 0);
        Font font = new Font((Device)text.getDisplay(), dt);
        text.setFont(font);
        text.addDisposeListener(ignored -> font.dispose());
        this.dbc.bindValue((IObservableValue)WidgetProperties.text((int)24).observe((Widget)text), this.previewValue);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)text);
        this.setControl((Control)cp);
        this.updateImport();
        this.locationValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                Q7PortableFormatImportPage.this.validate();
            }
        });
        this.testcaseNameValue.addChangeListener(new IChangeListener(){

            public void handleChange(ChangeEvent event) {
                Q7PortableFormatImportPage.this.validate();
            }
        });
        this.destinations.addChangeListener(new Runnable(){

            @Override
            public void run() {
                DestinationsBox.Selection kind = Q7PortableFormatImportPage.this.destinations.getKind();
                switch (kind) {
                    case Clipboard: {
                        Q7PortableFormatImportPage.this.setErrorMessage(null);
                        Q7PortableFormatImportPage.this.setPageComplete(true);
                        Q7PortableFormatImportPage.this.updateImport();
                        break;
                    }
                    case Filesystem: {
                        String path = Q7PortableFormatImportPage.this.destinations.getFileSystemPath();
                        if (path == null || path.trim().length() == 0 || new File(path).isDirectory() || !new File(path).exists()) {
                            Q7PortableFormatImportPage.this.setErrorMessage("Please specify correct file name to import testcase");
                            Q7PortableFormatImportPage.this.setPageComplete(false);
                            break;
                        }
                        Q7PortableFormatImportPage.this.setPageComplete(true);
                        Q7PortableFormatImportPage.this.setErrorMessage(null);
                        Q7PortableFormatImportPage.this.updateImport();
                        break;
                    }
                }
            }
        });
    }

    protected void browseLocation() {
        LocationSelectionDialog dialog = new LocationSelectionDialog(this.getShell());
        dialog.setLocation((String)this.locationValue.getValue());
        if (dialog.open() == 0) {
            this.locationValue.setValue((Object)dialog.getLocation());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void updateImport() {
        switch (this.destinations.getKind()) {
            case Clipboard: {
                Clipboard clipboard = new Clipboard(Display.getCurrent());
                Object contents = clipboard.getContents((Transfer)TextTransfer.getInstance());
                if (contents != null && contents instanceof String) {
                    this.previewValue.setValue((Object)((String)contents));
                }
                clipboard.dispose();
                break;
            }
            case Filesystem: {
                File file = new File(this.destinations.getFileSystemPath());
                if (!file.exists() || !file.isFile()) break;
                try {
                    byte[] content = FileUtil.getStreamContent((InputStream)new BufferedInputStream(new FileInputStream(file)));
                    if (content == null) break;
                    this.previewValue.setValue((Object)new String(content, "utf-8"));
                }
                catch (Exception e) {
                    Q7UIPlugin.log(e);
                }
                break;
            }
        }
        if (this.previewValue.getValue() == null) {
            this.isValid = false;
            return;
        }
        Throwable throwable = null;
        Object var2_3 = null;
        try {
            IPersistenceModel model;
            Q7ResourceInfo info;
            block21: {
                info = new Q7ResourceInfo("--- RCPTT testcase ---", URI.createURI((String)"__compare__"));
                model = PersistenceManager.getInstance().getModel(StringUtils.getUtf8Bytes((String)((String)this.previewValue.getValue())), info.getResource());
                if (model != null) break block21;
                this.isValid = false;
                this.validate();
                if (info == null) return;
                info.close();
                return;
            }
            try {
                InputStream ecl;
                block23: {
                    Scenario element;
                    block22: {
                        this.isValid = false;
                        info.load(null);
                        element = (Scenario)info.getNamedElement();
                        if (element != null) break block22;
                        this.validate();
                        if (info == null) return;
                        info.close();
                        return;
                    }
                    this.testcaseNameValue.setValue((Object)element.getName());
                    ecl = model.read(".content");
                    if (ecl != null || element.getTeslaContent() == null && element.getContent() == null) break block23;
                    this.setErrorMessage("Specified content is not valid RCPTT testcase");
                    this.setPageComplete(false);
                    if (info == null) return;
                    info.close();
                    return;
                }
                try {
                    FileUtil.safeClose((Closeable)ecl);
                    model.dispose();
                    this.isValid = true;
                }
                catch (ModelException modelException) {
                    // empty catch block
                }
                this.validate();
                return;
            }
            finally {
                if (info != null) {
                    info.close();
                }
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    private void validate() {
        List<String> names;
        IFolder folder;
        Path containerPath = new Path((String)this.locationValue.getValue());
        IProject project = this.getProject();
        if (project == null || !Path.EMPTY.isValidPath(containerPath.toString())) {
            this.setErrorMessage(Messages.WizardExecutablePage_EmptyParentMsg);
            this.setPageComplete(false);
            return;
        }
        IPath path = containerPath.removeFirstSegments(1);
        if (!path.isEmpty() && !(folder = project.getFolder(path)).exists()) {
            this.setErrorMessage(Messages.WizardExecutablePage_NotExistingFolderMsg);
            this.setPageComplete(false);
            return;
        }
        if (!this.isValid) {
            this.setErrorMessage("Specified content is not valid RCPTT testcase");
            this.setPageComplete(false);
            return;
        }
        String testName = (String)this.testcaseNameValue.getValue();
        if (testName.trim().length() == 0) {
            this.setErrorMessage("Please specify testcase name");
            this.setPageComplete(false);
            return;
        }
        IQ7Folder folder2 = this.getFolder();
        if (folder2 != null && (names = Arrays.asList(Q7SearchCore.findAllNames((ISearchScope)new ReferencedProjectScope(folder2.getQ7Project())))).contains(testName)) {
            this.setErrorMessage("Testcase with same name already exists");
            this.setPageComplete(false);
            return;
        }
        this.setErrorMessage(null);
        this.setPageComplete(true);
    }

    private IProject getProject() {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path((String)this.locationValue.getValue()));
        if (member != null && member.exists()) {
            return member.getProject();
        }
        if (this.initialContainer != null) {
            return this.initialContainer.getProject();
        }
        return null;
    }

    private IQ7Folder getFolder() {
        IResource member = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path((String)this.locationValue.getValue()));
        IQ7Element el = RcpttCore.create((IResource)member);
        if (el != null && el instanceof IQ7Folder) {
            return (IQ7Folder)el;
        }
        if (el instanceof IQ7Project) {
            return ((IQ7Project)el).getRootFolder();
        }
        return null;
    }

    public void dispose() {
        this.dbc.dispose();
        super.dispose();
    }

    public boolean finish() {
        try {
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IQ7Folder folder = Q7PortableFormatImportPage.this.getFolder();
                    WriteAccessChecker writeAccessChecker = new WriteAccessChecker(Q7PortableFormatImportPage.this.getShell());
                    if (!writeAccessChecker.makeResourceWritable(folder.getResource())) {
                        return;
                    }
                    if (folder != null) {
                        IContainer cl = (IContainer)folder.getResource();
                        IFile newFile = ((Q7Folder)folder).getNewFile(cl, (String)Q7PortableFormatImportPage.this.testcaseNameValue.getValue(), "test");
                        newFile.create((InputStream)new ByteArrayInputStream(StringUtils.getUtf8Bytes((String)((String)Q7PortableFormatImportPage.this.previewValue.getValue()))), true, monitor);
                        IQ7NamedElement newEl = (IQ7NamedElement)RcpttCore.create((IResource)newFile);
                        ITestCase copy = (ITestCase)newEl.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                        try {
                            try {
                                IPersistenceModel model;
                                block35: {
                                    do {
                                        copy.setID(EcoreUtil.generateUUID());
                                    } while (folder.haveIDConflict(copy.getID()));
                                    copy.setElementName((String)Q7PortableFormatImportPage.this.testcaseNameValue.getValue());
                                    model = copy.getPersistenceModel();
                                    InputStream ecl = model.read(".content");
                                    if (ecl != null) {
                                        try {
                                            try {
                                                String streamContent = new String(FileUtil.getStreamContent((InputStream)ecl), "utf-8");
                                                Script ecl2 = Scenarios.getEcl((ITestCase)copy);
                                                if (!streamContent.equals(ecl2.getContent())) {
                                                    Scenarios.setEclContent((Scenario)((Scenario)copy.getNamedElement()), (String)streamContent);
                                                }
                                            }
                                            catch (IOException e) {
                                                Q7UIPlugin.log(e);
                                                FileUtil.safeClose((Closeable)ecl);
                                                break block35;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            FileUtil.safeClose((Closeable)ecl);
                                            throw throwable;
                                        }
                                        FileUtil.safeClose((Closeable)ecl);
                                    }
                                }
                                String[] names = model.getNames();
                                HashMap<String, String> contextIDUpdateMap = new HashMap<String, String>();
                                HashMap<String, String> verificationIDUpdateMap = new HashMap<String, String>();
                                ArrayList<IContext> requiredIDUpdate = new ArrayList<IContext>();
                                String[] stringArray = names;
                                int n = names.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    String name = stringArray[n2];
                                    if (name.startsWith(Q7PortableFormatImportPage.CONTEXTS_PREFIX)) {
                                        id = name.substring(Q7PortableFormatImportPage.CONTEXTS_PREFIX.length());
                                        IQ7NamedElement[] ctx = Q7SearchCore.findById((String)id, (ISearchScope)new ReferencedProjectScope(folder.getQ7Project()), (IProgressMonitor)monitor);
                                        boolean extractContext = false;
                                        if (ctx.length == 0) {
                                            extractContext = true;
                                        } else {
                                            try {
                                                file = (IFile)ctx[0].getResource();
                                                content = FileUtil.getStreamContent((InputStream)new BufferedInputStream(file.getContents()));
                                                includedContent = FileUtil.getStreamContent((InputStream)model.read(name));
                                                extractContext = !Arrays.equals(content, includedContent);
                                            }
                                            catch (Exception e) {
                                                Q7UIPlugin.log(e);
                                                extractContext = true;
                                            }
                                        }
                                        if (extractContext) {
                                            this.doCreateContext(model.read(name), folder, contextIDUpdateMap, requiredIDUpdate);
                                        }
                                        model.delete(name);
                                    } else if (name.startsWith(Q7PortableFormatImportPage.VERIFICATIONS_PREFIX)) {
                                        id = name.substring(Q7PortableFormatImportPage.VERIFICATIONS_PREFIX.length());
                                        IQ7NamedElement[] verification = Q7SearchCore.findById((String)id, (ISearchScope)new ReferencedProjectScope(folder.getQ7Project()), (IProgressMonitor)monitor);
                                        boolean extractVerification = false;
                                        if (verification.length == 0) {
                                            extractVerification = true;
                                        } else {
                                            try {
                                                file = (IFile)verification[0].getResource();
                                                content = FileUtil.getStreamContent((InputStream)new BufferedInputStream(file.getContents()));
                                                includedContent = FileUtil.getStreamContent((InputStream)model.read(name));
                                                extractVerification = !Arrays.equals(content, includedContent);
                                            }
                                            catch (Exception e) {
                                                Q7UIPlugin.log(e);
                                                extractVerification = true;
                                            }
                                        }
                                        if (extractVerification) {
                                            this.doCreateVerification(model.read(name), folder, verificationIDUpdateMap);
                                        }
                                        model.delete(name);
                                    }
                                    ++n2;
                                }
                                List<String> newIds = Q7PortableFormatImportPage.this.updateIds(contextIDUpdateMap, Arrays.asList(copy.getContexts()));
                                if (newIds != null) {
                                    copy.setContexts(newIds.toArray(new String[newIds.size()]));
                                }
                                if ((newIds = Q7PortableFormatImportPage.this.updateIds(verificationIDUpdateMap, Arrays.asList(copy.getVerifications()))) != null) {
                                    copy.setVerifications(newIds.toArray(new String[newIds.size()]));
                                }
                                for (IContext cx : requiredIDUpdate) {
                                    IQ7NamedElement cxCopy = cx.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                                    try {
                                        GroupContext group = (GroupContext)cxCopy.getNamedElement();
                                        List<String> newGRCtxs = Q7PortableFormatImportPage.this.updateIds(contextIDUpdateMap, (List<String>)group.getContextReferences());
                                        if (newGRCtxs == null) continue;
                                        group.getContextReferences().clear();
                                        group.getContextReferences().addAll(newGRCtxs);
                                        cxCopy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                    finally {
                                        cxCopy.discardWorkingCopy();
                                    }
                                }
                                copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                            }
                            catch (ModelException e) {
                                Q7UIPlugin.log(e);
                                copy.discardWorkingCopy();
                            }
                        }
                        finally {
                            copy.discardWorkingCopy();
                        }
                    }
                }

                private void doCreateVerification(InputStream read, IQ7Folder folder, Map<String, String> verificationIDUpdateMap) {
                    block16: {
                        IVerification copy = null;
                        try {
                            try {
                                IContainer cl = (IContainer)folder.getResource();
                                IFile newFile = ((Q7Folder)folder).getNewFile(cl, (String)Q7PortableFormatImportPage.this.testcaseNameValue.getValue() + "_imported", "verification");
                                newFile.create(read, true, (IProgressMonitor)new NullProgressMonitor());
                                FileUtil.safeClose((Closeable)read);
                                IVerification newEl = (IVerification)RcpttCore.create((IResource)newFile);
                                copy = (IVerification)newEl.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                                String oldID = copy.getID();
                                while (folder.haveIDConflict(copy.getID())) {
                                    copy.setID(EcoreUtil.generateUUID());
                                }
                                List<String> names = Arrays.asList(Q7SearchCore.findAllNames((ISearchScope)new ReferencedProjectScope(folder.getQ7Project())));
                                Object name = copy.getElementName();
                                int i = 2;
                                while (names.contains(name)) {
                                    name = copy.getElementName() + "(" + i + ")";
                                    ++i;
                                }
                                copy.setElementName((String)name);
                                if (copy.hasUnsavedChanges()) {
                                    verificationIDUpdateMap.put(oldID, copy.getID());
                                    WriteAccessChecker writeAccessChecker = new WriteAccessChecker(Q7PortableFormatImportPage.this.getShell());
                                    if (writeAccessChecker.makeResourceWritable(new IQ7Element[]{copy})) {
                                        copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                }
                            }
                            catch (Exception e) {
                                Q7UIPlugin.log(e);
                                if (copy == null) break block16;
                                try {
                                    copy.discardWorkingCopy();
                                }
                                catch (ModelException e2) {
                                    Q7UIPlugin.log(e2);
                                }
                            }
                        }
                        finally {
                            if (copy != null) {
                                try {
                                    copy.discardWorkingCopy();
                                }
                                catch (ModelException e) {
                                    Q7UIPlugin.log(e);
                                }
                            }
                        }
                    }
                }

                private void doCreateContext(InputStream read, IQ7Folder folder, Map<String, String> contextIDUpdateMap, List<IContext> requiredIDUpdate) {
                    block17: {
                        IContext copy = null;
                        try {
                            try {
                                IContainer cl = (IContainer)folder.getResource();
                                IFile newFile = ((Q7Folder)folder).getNewFile(cl, (String)Q7PortableFormatImportPage.this.testcaseNameValue.getValue() + "_imported", "ctx");
                                newFile.create(read, true, (IProgressMonitor)new NullProgressMonitor());
                                FileUtil.safeClose((Closeable)read);
                                IContext newEl = (IContext)RcpttCore.create((IResource)newFile);
                                copy = (IContext)newEl.getWorkingCopy((IProgressMonitor)new NullProgressMonitor());
                                String oldID = copy.getID();
                                while (folder.haveIDConflict(copy.getID())) {
                                    copy.setID(EcoreUtil.generateUUID());
                                }
                                List<String> names = Arrays.asList(Q7SearchCore.findAllNames((ISearchScope)new ReferencedProjectScope(folder.getQ7Project())));
                                Object name = copy.getElementName();
                                int i = 2;
                                while (names.contains(name)) {
                                    name = copy.getElementName() + "(" + i + ")";
                                    ++i;
                                }
                                copy.setElementName((String)name);
                                if (copy.getNamedElement() instanceof GroupContext) {
                                    requiredIDUpdate.add(newEl);
                                }
                                if (copy.hasUnsavedChanges()) {
                                    contextIDUpdateMap.put(oldID, copy.getID());
                                    WriteAccessChecker writeAccessChecker = new WriteAccessChecker(Q7PortableFormatImportPage.this.getShell());
                                    if (writeAccessChecker.makeResourceWritable(new IQ7Element[]{copy})) {
                                        copy.commitWorkingCopy(true, (IProgressMonitor)new NullProgressMonitor());
                                    }
                                }
                            }
                            catch (Exception e) {
                                Q7UIPlugin.log(e);
                                if (copy == null) break block17;
                                try {
                                    copy.discardWorkingCopy();
                                }
                                catch (ModelException e2) {
                                    Q7UIPlugin.log(e2);
                                }
                            }
                        }
                        finally {
                            if (copy != null) {
                                try {
                                    copy.discardWorkingCopy();
                                }
                                catch (ModelException e) {
                                    Q7UIPlugin.log(e);
                                }
                            }
                        }
                    }
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            return true;
        }
        catch (CoreException e) {
            Q7UIPlugin.log(e);
            return false;
        }
    }

    private List<String> updateIds(Map<String, String> idUpdateMap, List<String> ids) {
        boolean changed = false;
        ArrayList<String> newIds = new ArrayList<String>();
        for (String id : ids) {
            String newcx = idUpdateMap.get(id);
            if (newcx != null) {
                changed = true;
                newIds.add(newcx);
                continue;
            }
            newIds.add(id);
        }
        if (changed) {
            return newIds;
        }
        return null;
    }
}

