/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.ui;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.rcptt.core.model.IQ7Element;
import org.eclipse.rcptt.core.model.IQ7NamedElement;
import org.eclipse.rcptt.core.model.IQ7Project;
import org.eclipse.rcptt.core.model.IQ7ProjectMetadata;
import org.eclipse.rcptt.core.model.search.ISearchScope;
import org.eclipse.rcptt.core.model.search.Q7SearchCore;
import org.eclipse.rcptt.core.scenario.GroupContext;
import org.eclipse.rcptt.core.scenario.NamedElement;
import org.eclipse.rcptt.core.scenario.Scenario;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.internal.core.model.OneProjectScope;
import org.eclipse.rcptt.ui.dialogs.RemoveAllProjectReferencesDialog;
import org.eclipse.rcptt.ui.utils.WriteAccessChecker;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ProjectContextReferencesUpdateJob
extends Job {
    private IQ7Project project;
    private static final ISchedulingRule DO_NOT_SHOW_MULTIPLE_DIALOGS_AT_ONCE = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule == this;
        }
    };

    public ProjectContextReferencesUpdateJob(IQ7Project project) {
        super("Update Project Context/Verification references");
        this.project = project;
        this.setRule((ISchedulingRule)new MultiRule(new ISchedulingRule[]{DO_NOT_SHOW_MULTIPLE_DIALOGS_AT_ONCE, project.getProject()}));
    }

    public boolean belongsTo(Object family) {
        return super.belongsTo(family);
    }

    private static Collection<IQ7NamedElement> filterOutProjectMetadata(IQ7NamedElement[] elements) {
        return Collections2.filter(Arrays.asList(elements), (Predicate)new Predicate<IQ7NamedElement>(){

            public boolean apply(IQ7NamedElement input) {
                return input.getElementType() != IQ7Element.HandleType.ProjectMetadata;
            }
        });
    }

    protected IStatus run(IProgressMonitor monitor) {
        try {
            String[] verifications;
            String[] contexts;
            if (RemoveAllProjectReferencesDialog.isNever()) {
                return Status.OK_STATUS;
            }
            SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (int)3);
            IQ7ProjectMetadata metadata = this.project.getMetadata();
            HashSet<IQ7NamedElement> elementsToProceed = new HashSet<IQ7NamedElement>();
            OneProjectScope scope = new OneProjectScope(this.project);
            String[] stringArray = contexts = metadata.exists() ? metadata.getContexts() : new String[]{};
            int n = contexts.length;
            int n2 = 0;
            while (n2 < n) {
                String el = stringArray[n2];
                IQ7NamedElement[] elements = Q7SearchCore.findContextUsage((String)el, (ISearchScope)scope, (IProgressMonitor)sm.split(1));
                if (elements != null) {
                    elementsToProceed.addAll(ProjectContextReferencesUpdateJob.filterOutProjectMetadata(elements));
                }
                ++n2;
            }
            String[] stringArray2 = verifications = metadata.getVerifications();
            int n3 = verifications.length;
            n = 0;
            while (n < n3) {
                String el = stringArray2[n];
                IQ7NamedElement[] elements = Q7SearchCore.findVerificationUsage((String)el, (ISearchScope)scope, (IProgressMonitor)sm.split(1));
                if (elements != null) {
                    elementsToProceed.addAll(ProjectContextReferencesUpdateJob.filterOutProjectMetadata(elements));
                }
                ++n;
            }
            Shell shell = null;
            ArrayList<IQ7NamedElement> copy = new ArrayList<IQ7NamedElement>(elementsToProceed);
            if (elementsToProceed.size() > 0) {
                shell = ProjectContextReferencesUpdateJob.computeInDisplay(PlatformUI.getWorkbench().getDisplay(), () -> {
                    Shell shell2 = PlatformUI.getWorkbench().getWorkbenchWindows()[0].getShell();
                    if (RemoveAllProjectReferencesDialog.open(shell2, this.project, copy)) {
                        return shell2;
                    }
                    return null;
                });
            }
            if (shell != null) {
                return ProjectContextReferencesUpdateJob.removeDefaultReferences(this.project, copy, shell, (IProgressMonitor)sm.split(1));
            }
        }
        catch (Exception e) {
            RcpttPlugin.log((Throwable)e);
        }
        return Status.OK_STATUS;
    }

    private static <T> T computeInDisplay(Display display, Callable<T> supplier) throws Exception {
        Object[] result = new Object[1];
        Exception[] error = new Exception[1];
        display.syncExec(() -> {
            try {
                objectArray[0] = supplier.call();
            }
            catch (Exception e) {
                exceptionArray[0] = e;
            }
        });
        if (error[0] != null) {
            throw error[0];
        }
        return (T)result[0];
    }

    private static IStatus removeDefaultReferences(IQ7Project project, final List<IQ7NamedElement> references, final Shell shell, IProgressMonitor monitorArg) {
        final IStatus[] status = new IStatus[]{Status.OK_STATUS};
        try {
            IQ7ProjectMetadata metadata = project.getMetadata();
            if (metadata == null || !metadata.exists()) {
                return status[0];
            }
            String[] defaultContexts = metadata.getContexts();
            String[] defaultVerifications = metadata.getVerifications();
            if (defaultContexts.length == 0 && defaultVerifications.length == 0) {
                return status[0];
            }
            final List<String> contextsToRemove = Arrays.asList(defaultContexts);
            final List<String> verificationsToRemove = Arrays.asList(defaultVerifications);
            final WriteAccessChecker writeAccessChecker = new WriteAccessChecker(shell);
            ResourcesPlugin.getWorkspace().run(new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    SubMonitor sm = SubMonitor.convert((IProgressMonitor)monitor, (String)"Remove project context/verification references", (int)(references.size() * 2));
                    try {
                        boolean result = ProjectContextReferencesUpdateJob.computeInDisplay(shell.getDisplay(), () -> writeAccessChecker.makeResourceWritable((IQ7Element[])references.toArray(new IQ7NamedElement[0])));
                        if (!result) {
                            status[0] = Status.CANCEL_STATUS;
                            return;
                        }
                    }
                    catch (Exception e) {
                        status[0] = Status.error((String)("Failed to write " + references), (Throwable)e);
                        return;
                    }
                    for (IQ7NamedElement e : references) {
                        IQ7NamedElement copy = e.getWorkingCopy((IProgressMonitor)sm.split(1));
                        try {
                            NamedElement ne = copy.getNamedElement();
                            if (ne instanceof Scenario) {
                                ((Scenario)ne).getContexts().removeAll((Collection)contextsToRemove);
                                ((Scenario)ne).getVerifications().removeAll((Collection)verificationsToRemove);
                            }
                            if (ne instanceof GroupContext) {
                                ((GroupContext)ne).getContextReferences().removeAll((Collection)contextsToRemove);
                            }
                            copy.commitWorkingCopy(false, (IProgressMonitor)sm.split(1));
                        }
                        finally {
                            copy.discardWorkingCopy();
                        }
                    }
                }
            }, (ISchedulingRule)project.getProject(), 1, monitorArg);
        }
        catch (CoreException e) {
            return e.getStatus();
        }
        return status[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.project == null ? 0 : this.project.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ProjectContextReferencesUpdateJob other = (ProjectContextReferencesUpdateJob)((Object)obj);
        return !(this.project == null ? other.project != null : !this.project.equals(other.project));
    }

    public Object getFamily() {
        return this;
    }
}

