/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.ui.internal.preferences;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.Util;
import org.eclipse.pde.api.tools.internal.problems.ApiProblemFactory;
import org.eclipse.pde.api.tools.internal.provisional.ApiPlugin;
import org.eclipse.pde.api.tools.ui.internal.SWTFactory;
import org.eclipse.pde.api.tools.ui.internal.preferences.ApiBaselinePreferencePage;
import org.eclipse.pde.api.tools.ui.internal.preferences.PreferenceMessages;
import org.eclipse.pde.internal.ui.preferences.ConfigurationBlock;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class ApiBaselinesConfigurationBlock
extends ConfigurationBlock {
    private static final Key KEY_MISSING_DEFAULT_API_PROFILE = ApiBaselinesConfigurationBlock.getApiToolsKey("missing_default_api_profile");
    private static final Key KEY_PLUGIN_MISSING_IN_BASELINE = ApiBaselinesConfigurationBlock.getApiToolsKey("missing_plugin_in_baseline");
    private static Key[] fgAllKeys = new Key[]{KEY_MISSING_DEFAULT_API_PROFILE, KEY_PLUGIN_MISSING_IN_BASELINE};
    private static final String[] SEVERITIES_LABELS = new String[]{PreferenceMessages.ApiErrorsWarningsConfigurationBlock_error, PreferenceMessages.ApiErrorsWarningsConfigurationBlock_warning, PreferenceMessages.ApiErrorsWarningsConfigurationBlock_ignore};
    private static final String[] SEVERITIES = new String[]{"Error", "Warning", "Ignore"};
    private final SelectionListener selectionlistener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent e) {
            if (e.widget instanceof Combo) {
                Combo combo = (Combo)e.widget;
                ControlData data = (ControlData)combo.getData();
                data.key.setStoredValue(ApiBaselinesConfigurationBlock.this.fLookupOrder[0], combo.getText(), ApiBaselinesConfigurationBlock.this.fManager);
                ApiBaselinesConfigurationBlock.this.fDirty = true;
                ApiBaselinePreferencePage.rebuildcount = 0;
            }
        }
    };
    private final ArrayList<Combo> fCombos = new ArrayList();
    private final ArrayList<Label> fLabels = new ArrayList();
    IScopeContext[] fLookupOrder = new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
    IWorkingCopyManager fManager = null;
    private Composite fMainComp = null;
    boolean fDirty = false;
    private Composite fParent = null;
    private boolean hasBaseline = true;

    protected static final Key getApiToolsKey(String key) {
        return new Key("org.eclipse.pde.api.tools", key);
    }

    public ApiBaselinesConfigurationBlock(IWorkbenchPreferenceContainer container) {
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
    }

    Control createControl(Composite parent) {
        this.fParent = parent;
        this.fMainComp = SWTFactory.createComposite(parent, 1, 1, 768, 0, 0);
        Group optionsProfileGroup = SWTFactory.createGroup(this.fMainComp, PreferenceMessages.ApiProfilesConfigurationBlock_options_group_title, 2, 1, 1808);
        Combo combo = this.createComboControl((Composite)optionsProfileGroup, PreferenceMessages.ApiProfilesConfigurationBlock_missing_default_api_profile_message, KEY_MISSING_DEFAULT_API_PROFILE);
        this.fCombos.add(combo);
        combo = this.createComboControl((Composite)optionsProfileGroup, PreferenceMessages.ApiProfilesConfigurationBlock_plugin_missing_in_baseline_message, KEY_PLUGIN_MISSING_IN_BASELINE);
        this.fCombos.add(combo);
        Dialog.applyDialogFont((Control)this.fMainComp);
        return this.fMainComp;
    }

    public void performOK() {
        this.save();
    }

    public void performApply() {
        this.save();
    }

    private void save() {
        if (this.fDirty) {
            try {
                ArrayList<Key> changes = new ArrayList<Key>();
                this.collectChanges(this.fLookupOrder[0], changes);
                this.filterOutChanges(changes);
                if (changes.size() == 1 && changes.get(0).equals(KEY_MISSING_DEFAULT_API_PROFILE)) {
                    String newval;
                    Key k = changes.get(0);
                    String original = k.getStoredValue(this.fLookupOrder[0], null);
                    if (original == null) {
                        original = "Error";
                    }
                    if ((newval = k.getStoredValue(this.fLookupOrder[0], this.fManager)).equals("Ignore")) {
                        this.deleteMissingBaselineMarker();
                    } else if (newval.equals("Warning")) {
                        if (original.equals("Error")) {
                            this.updateMissingBaselineMarkerSeverity(1);
                        }
                        if (original.equals("Ignore") && !this.hasBaseline) {
                            this.createMissingBaselineMarker(1);
                        }
                    } else if (newval.equals("Error")) {
                        if (original.equals("Warning")) {
                            this.updateMissingBaselineMarkerSeverity(2);
                        }
                        if (original.equals("Ignore") && !this.hasBaseline) {
                            this.createMissingBaselineMarker(2);
                        }
                    }
                    this.fDirty = false;
                    return;
                }
                if (changes.size() > 0 && ApiBaselinePreferencePage.rebuildcount < 1) {
                    int userInput;
                    ++ApiBaselinePreferencePage.rebuildcount;
                    this.fManager.applyChanges();
                    String message = PreferenceMessages.ApiErrorsWarningsConfigurationBlock_0;
                    IProject[] apiProjects = org.eclipse.pde.api.tools.internal.util.Util.getApiProjects();
                    if (apiProjects != null && (userInput = MessageDialog.open((int)3, (Shell)this.fParent.getShell(), (String)PreferenceMessages.ApiErrorsWarningsConfigurationBlock_2, (String)message, (int)0, (String[])new String[]{PreferenceMessages.ApiProfilesPreferencePage_QuestionDialog_buildButtonLabel, PreferenceMessages.ApiProfilesPreferencePage_QuestionDialog_dontBuildButtonLabel})) == 0) {
                        org.eclipse.pde.api.tools.internal.util.Util.getBuildJob((IProject[])apiProjects).schedule();
                    }
                }
                this.fDirty = false;
            }
            catch (BackingStoreException bse) {
                ApiPlugin.log((Throwable)bse);
            }
        }
    }

    private void filterOutChanges(ArrayList<Key> changes) {
        if (changes.size() == 2) {
            Key k1 = changes.get(0);
            String original1 = k1.getStoredValue(this.fLookupOrder[0], null);
            String newval1 = k1.getStoredValue(this.fLookupOrder[0], this.fManager);
            if (original1 == null && newval1 == null) {
                changes.remove(0);
            }
            if (original1 != null && newval1 != null && original1.equals(newval1)) {
                changes.remove(0);
            }
            if (changes.size() == 2) {
                Key k2 = changes.get(1);
                String original2 = k2.getStoredValue(this.fLookupOrder[0], null);
                String newval2 = k2.getStoredValue(this.fLookupOrder[0], this.fManager);
                if (original2 == null && newval2 == null) {
                    changes.remove(1);
                }
                if (original2 != null && newval2 != null && original2.equals(newval2)) {
                    changes.remove(1);
                }
            }
        }
    }

    private void updateMissingBaselineMarkerSeverity(int severity) {
        ArrayList<IMarker> marker = this.findMissingBaselineMarker();
        for (IMarker iMarker : marker) {
            try {
                iMarker.setAttribute("severity", severity);
            }
            catch (CoreException e) {
                ApiPlugin.log((Throwable)e);
            }
        }
    }

    private void deleteMissingBaselineMarker() {
        ArrayList<IMarker> marker = this.findMissingBaselineMarker();
        for (IMarker iMarker : marker) {
            try {
                iMarker.delete();
            }
            catch (CoreException e) {
                ApiPlugin.log((Throwable)e);
            }
        }
    }

    public void createMissingBaselineMarker() {
        if (this.hasBaseline) {
            return;
        }
        String newval = fgAllKeys[0].getStoredValue(this.fLookupOrder[0], this.fManager);
        if (newval == null) {
            newval = "Error";
        }
        int valueWarning = -1;
        if (newval.equals("Warning")) {
            valueWarning = 1;
        }
        if (newval.equals("Error")) {
            valueWarning = 2;
        }
        if (valueWarning < 0) {
            return;
        }
        IProject[] apiProjects = org.eclipse.pde.api.tools.internal.util.Util.getApiProjects();
        if (apiProjects == null) {
            return;
        }
        this.removeBaselineMismatchMarker();
        IProject[] iProjectArray = apiProjects;
        int n = apiProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            this.createMissingBaselineMarkerOnProject((IResource)iProject, valueWarning);
            ++n2;
        }
    }

    private void removeBaselineMismatchMarker() {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] findMarkers;
            IMarker[] iMarkerArray = findMarkers = root.findMarkers("org.eclipse.pde.api.tools.api_profile", false, 0);
            int n = findMarkers.length;
            int n2 = 0;
            while (n2 < n) {
                IMarker iMarker = iMarkerArray[n2];
                iMarker.delete();
                ++n2;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
    }

    private void createMissingBaselineMarker(int valueWarning) {
        IProject[] apiProjects = org.eclipse.pde.api.tools.internal.util.Util.getApiProjects();
        if (apiProjects == null) {
            return;
        }
        IProject[] iProjectArray = apiProjects;
        int n = apiProjects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject iProject = iProjectArray[n2];
            this.createMissingBaselineMarkerOnProject((IResource)iProject, valueWarning);
            ++n2;
        }
    }

    private void createMissingBaselineMarkerOnProject(IResource res, int valueWarning) {
        try {
            IMarker createMarker = res.createMarker("org.eclipse.pde.api.tools.api_profile");
            createMarker.setAttribute("message", (Object)PreferenceMessages.ApiBaselinesConfigurationBlock_0);
            createMarker.setAttribute("severity", valueWarning);
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
    }

    private ArrayList<IMarker> findMissingBaselineMarker() {
        int n;
        int n2;
        IMarker[] iMarkerArray;
        ArrayList<IMarker> markList = new ArrayList<IMarker>();
        int missing_plugin = ApiProblemFactory.createProblemId((int)0x50000000, (int)7, (int)3, (int)0);
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        try {
            IMarker[] findMarkers;
            iMarkerArray = findMarkers = root.findMarkers("org.eclipse.pde.api.tools.api_profile", false, 0);
            n2 = findMarkers.length;
            n = 0;
            while (n < n2) {
                IMarker iMarker = iMarkerArray[n];
                markList.add(iMarker);
                ++n;
            }
        }
        catch (CoreException e) {
            ApiPlugin.log((Throwable)e);
        }
        IProject[] apiProjects = org.eclipse.pde.api.tools.internal.util.Util.getApiProjects();
        if (apiProjects == null) {
            return markList;
        }
        iMarkerArray = apiProjects;
        n2 = apiProjects.length;
        n = 0;
        while (n < n2) {
            IMarker iProject = iMarkerArray[n];
            try {
                IMarker[] findMarkers;
                IMarker[] iMarkerArray2 = findMarkers = iProject.findMarkers("org.eclipse.pde.api.tools.api_profile", false, 0);
                int n3 = findMarkers.length;
                int n4 = 0;
                while (n4 < n3) {
                    IMarker iMarker = iMarkerArray2[n4];
                    int id = ApiProblemFactory.getProblemId((IMarker)iMarker);
                    if (id != missing_plugin) {
                        markList.add(iMarker);
                    }
                    ++n4;
                }
            }
            catch (CoreException e) {
                ApiPlugin.log((Throwable)e);
            }
            ++n;
        }
        return markList;
    }

    public void performCancel() {
    }

    public void performDefaults() {
        String defval = null;
        Key[] keyArray = fgAllKeys;
        int n = fgAllKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray[n2];
            defval = key.getStoredValue(this.fLookupOrder, true, this.fManager);
            key.setStoredValue(this.fLookupOrder[0], defval, this.fManager);
            ++n2;
        }
        this.updateCombos();
        this.fDirty = true;
    }

    private void updateCombos() {
        for (Combo combo : this.fCombos) {
            if (combo == null) continue;
            ControlData data = (ControlData)combo.getData();
            combo.select(data.getSelection(data.getKey().getStoredValue(this.fLookupOrder, false, this.fManager)));
        }
    }

    public void dispose() {
        this.fMainComp.getParent().dispose();
    }

    protected Combo createComboControl(Composite parent, String label, Key key) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(1, 2, true, false);
        lbl.setLayoutData((Object)gd);
        lbl.setText(label);
        Combo combo = new Combo(parent, 12);
        gd = new GridData(3, 2, false, false);
        combo.setLayoutData((Object)gd);
        ControlData data = new ControlData(key, SEVERITIES);
        combo.setData((Object)data);
        combo.setItems(SEVERITIES_LABELS);
        combo.addSelectionListener(this.selectionlistener);
        combo.select(data.getSelection(key.getStoredValue(this.fLookupOrder, false, this.fManager)));
        this.addHighlight(parent, lbl, combo);
        this.fLabels.add(lbl);
        return combo;
    }

    private void collectChanges(IScopeContext context, List<Key> changes) {
        String origval = null;
        String newval = null;
        boolean complete = true;
        Key[] keyArray = fgAllKeys;
        int n = fgAllKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray[n2];
            origval = key.getStoredValue(context, null);
            newval = key.getStoredValue(context, this.fManager);
            if (newval == null) {
                if (origval != null) {
                    changes.add(key);
                } else if (complete) {
                    key.setStoredValue(context, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                    changes.add(key);
                }
            } else if (!newval.equals(origval)) {
                changes.add(key);
            }
            ++n2;
        }
    }

    public static Key[] getAllKeys() {
        return fgAllKeys;
    }

    public void selectOption(int index) {
        if (this.fCombos.get(index) != null && !this.fCombos.get(index).isDisposed()) {
            this.fCombos.get(index).setFocus();
            if (this.fLabels.get(index) != null && !this.fLabels.get(index).isDisposed() && Util.isMac() && this.fLabels.get(index) != null) {
                this.highlight(this.fCombos.get(index).getParent(), this.fLabels.get(index), this.fCombos.get(index), 17);
            }
        }
    }

    public void setHasBaseline(boolean b) {
        this.hasBaseline = b;
    }

    protected static class ControlData {
        Key key;
        private final String[] values;

        public ControlData(Key key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public Key getKey() {
            return this.key;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.values[index];
        }

        public String getValue(int index) {
            return this.values[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.values.length) {
                    if (value.equals(this.values[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.values.length - 1;
        }
    }

    protected static class Key {
        private final String qualifier;
        private final String key;

        public Key(String qualifier, String key) {
            this.qualifier = qualifier;
            this.key = key;
        }

        private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = context.getNode(this.qualifier);
            if (manager != null) {
                return manager.getWorkingCopy(node);
            }
            return node;
        }

        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (node != null) {
                return node.get(this.key, null);
            }
            return null;
        }

        public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                String value = this.getStoredValue(lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (value != null) {
                node.put(this.key, value);
            } else {
                node.remove(this.key);
            }
        }

        public String toString() {
            return this.qualifier + "/" + this.key;
        }
    }
}

