/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.preferences;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.internal.resources.Project;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.util.Util;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.SWTFactory;
import org.eclipse.pde.internal.ui.preferences.ConfigurationBlock;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.events.ExpansionAdapter;
import org.eclipse.ui.forms.events.ExpansionEvent;
import org.eclipse.ui.forms.events.IExpansionListener;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.ui.preferences.IWorkingCopyManager;
import org.eclipse.ui.preferences.WorkingCopyManager;
import org.osgi.service.prefs.BackingStoreException;

public class PDECompilersConfigurationBlock
extends ConfigurationBlock {
    private static final Key KEY_P_UNRESOLVED_IMPORTS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.unresolved-import");
    private static final Key KEY_P_UNRESOLVED_EX_POINTS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.unresolved-ex-points");
    private static final Key KEY_F_UNRESOLVED_PLUGINS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.f.unresolved-plugins");
    private static final Key KEY_F_UNRESOLVED_FEATURES = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.f.unresolved-features");
    private static final Key KEY_P_UNKNOWN_ELEMENT = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.unknown-element");
    private static final Key KEY_P_UNKNOWN_ATTRIBUTE = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.unknown-attribute");
    private static final Key KEY_P_UNKNOWN_CLASS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.unknown-class");
    private static final Key KEY_P_UNKNOWN_RESOURCE = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.unknown-resource");
    private static final Key KEY_P_UNKNOWN_IDENTIFIER = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.unknown-identifier");
    private static final Key KEY_P_DISCOURAGED_CLASS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.discouraged-class");
    private static final Key KEY_P_NO_REQUIRED_ATT = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.no-required-att");
    private static final Key KEY_P_NOT_EXTERNALIZED = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.not-externalized-att");
    private static final Key KEY_P_INCOMPATIBLE_ENV = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.incompatible-environment");
    private static final Key KEY_P_MISSING_EXPORT_PKGS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.missing-packages");
    private static final Key KEY_P_DEPRECATED = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.deprecated");
    private static final Key KEY_P_INTERNAL = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.internal");
    private static final Key KEY_P_SERVICE_COMP_WITHOUT_LAZY = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.service.component.without.lazyactivation");
    private static final Key KEY_P_NO_AUTOMATIC_MODULE_NAME = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.no.automatic.module");
    private static final Key KEY_P_BUILD_SOURCE_LIBRARY = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.source.library");
    private static final Key KEY_P_BUILD_OUTPUT_LIBRARY = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.output.library");
    private static final Key KEY_P_BUILD_MISSING_OUTPUT = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.missing.output");
    private static final Key KEY_P_BUILD_SRC_INCLUDES = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.src.includes");
    private static final Key KEY_P_BUILD_BIN_INCLUDES = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.bin.includes");
    private static final Key KEY_P_BUILD_JAVA_COMPLIANCE = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.java.compliance");
    private static final Key KEY_P_BUILD_JAVA_COMPILER = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.java.compiler");
    private static final Key KEY_P_BUILD_ENCODINGS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build.encodings");
    private static final Key KEY_P_BUILD = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.build");
    private static final Key KEY_P_VERSION_EXP_PKG = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.missing-version-export-package");
    private static final Key KEY_P_VERSION_IMP_PKG = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.missing-version-import-package");
    private static final Key KEY_P_VERSION_REQ_BUNDLE = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.missing-version-require-bundle");
    private static final Key KEY_P_VERSION_EXEC_ENV_TOO_LOW = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.p.exec-env-too-low");
    private static final Key KEY_S_CREATE_DOCS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.s.create-docs");
    private static final Key KEY_S_DOC_FOLDER = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.s.doc-folder");
    private static final Key KEY_S_OPEN_TAGS = PDECompilersConfigurationBlock.getPDEPrefKey("compilers.s.open-tags");
    private static String[] SEVERITIES = new String[]{PDEUIMessages.PDECompilersConfigurationBlock_error, PDEUIMessages.PDECompilersConfigurationBlock_warning, PDEUIMessages.PDECompilersConfigurationBlock_ignore};
    private static Key[] fgAllKeys = new Key[]{KEY_F_UNRESOLVED_FEATURES, KEY_F_UNRESOLVED_PLUGINS, KEY_P_BUILD, KEY_P_BUILD_MISSING_OUTPUT, KEY_P_BUILD_SOURCE_LIBRARY, KEY_P_BUILD_OUTPUT_LIBRARY, KEY_P_BUILD_SRC_INCLUDES, KEY_P_BUILD_BIN_INCLUDES, KEY_P_BUILD_JAVA_COMPLIANCE, KEY_P_BUILD_JAVA_COMPILER, KEY_P_BUILD_ENCODINGS, KEY_P_INTERNAL, KEY_P_SERVICE_COMP_WITHOUT_LAZY, KEY_P_NO_AUTOMATIC_MODULE_NAME, KEY_P_DEPRECATED, KEY_P_DISCOURAGED_CLASS, KEY_P_INCOMPATIBLE_ENV, KEY_P_MISSING_EXPORT_PKGS, KEY_P_NO_REQUIRED_ATT, KEY_P_NOT_EXTERNALIZED, KEY_P_UNKNOWN_ATTRIBUTE, KEY_P_UNKNOWN_CLASS, KEY_P_UNKNOWN_ELEMENT, KEY_P_UNKNOWN_IDENTIFIER, KEY_P_UNKNOWN_RESOURCE, KEY_P_UNRESOLVED_EX_POINTS, KEY_P_UNRESOLVED_IMPORTS, KEY_P_VERSION_EXP_PKG, KEY_P_VERSION_IMP_PKG, KEY_P_VERSION_REQ_BUNDLE, KEY_P_VERSION_EXEC_ENV_TOO_LOW, KEY_S_CREATE_DOCS, KEY_S_DOC_FOLDER, KEY_S_OPEN_TAGS};
    private static final String SETTINGS = "pde_compiler_errorwarnings_block";
    private IScopeContext[] fLookupOrder = null;
    private IProject fProject = null;
    private IWorkingCopyManager fManager = null;
    private Composite fMainComp = null;
    private TabFolder fTabFolder = null;
    private IdentityHashMap<Key, String> fOldProjectSettings = null;
    private HashMap<Integer, HashSet<Control>> fControlMap = new HashMap(3);
    private HashMap<Combo, Label> fComboLabelMap = new HashMap();
    private ArrayList<ExpandableComposite> fExpComps = new ArrayList();
    private boolean fDirty = false;
    private int fRebuildcount = 0;
    private HashSet<String> fBuilders = new HashSet(4);
    private Composite fParent = null;
    private SelectionListener selectionlistener = SelectionListener.widgetSelectedAdapter(e -> {
        if (e.widget instanceof Combo) {
            Combo combo = (Combo)e.widget;
            ControlData data = (ControlData)combo.getData();
            data.key.setStoredValue(this.fLookupOrder[0], Integer.toString(combo.getSelectionIndex()), this.fManager);
            this.fDirty = true;
            this.fRebuildcount = 0;
        } else if (e.widget instanceof Button) {
            Button button = (Button)e.widget;
            ControlData data = (ControlData)button.getData();
            data.key.setStoredValue(this.fLookupOrder[0], Boolean.toString(button.getSelection()), this.fManager);
            this.fDirty = true;
            this.fRebuildcount = 0;
        }
        this.addBuilder((Control)e.widget);
    });
    private ModifyListener modifylistener = e -> {
        if (e.widget instanceof Text) {
            Text text = (Text)e.widget;
            ControlData data = (ControlData)text.getData();
            data.key.setStoredValue(this.fLookupOrder[0], text.getText().trim(), this.fManager);
            this.fDirty = true;
            this.fRebuildcount = 0;
        }
    };

    protected static final Key getPDEPrefKey(String key) {
        return new Key("org.eclipse.pde", key);
    }

    public static Key[] getAllKeys() {
        return fgAllKeys;
    }

    public PDECompilersConfigurationBlock(IProject project, IWorkbenchPreferenceContainer container) {
        this.fProject = project;
        this.fLookupOrder = this.fProject != null ? new IScopeContext[]{new ProjectScope(this.fProject), InstanceScope.INSTANCE, DefaultScope.INSTANCE} : new IScopeContext[]{InstanceScope.INSTANCE, DefaultScope.INSTANCE};
        this.fManager = container == null ? new WorkingCopyManager() : container.getWorkingCopyManager();
        if (this.fProject == null || this.hasProjectSpecificSettings(this.fProject)) {
            this.fOldProjectSettings = null;
        } else {
            this.fOldProjectSettings = new IdentityHashMap();
            Key[] keyArray = fgAllKeys;
            int n = fgAllKeys.length;
            int n2 = 0;
            while (n2 < n) {
                Key key = keyArray[n2];
                this.fOldProjectSettings.put(key, key.getStoredValue(this.fLookupOrder, false, this.fManager));
                ++n2;
            }
        }
        PDECore.getDefault().getPreferencesManager();
    }

    public boolean hasProjectSpecificSettings(IProject project) {
        if (project != null) {
            ProjectScope projectContext = new ProjectScope(project);
            Key[] keyArray = fgAllKeys;
            int n = fgAllKeys.length;
            int n2 = 0;
            while (n2 < n) {
                Key key = keyArray[n2];
                if (key.getStoredValue((IScopeContext)projectContext, this.fManager) != null) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public void useProjectSpecificSettings(boolean enable) {
        boolean disabled;
        boolean bl = disabled = this.fOldProjectSettings == null;
        if (enable != disabled && this.fProject != null) {
            if (enable) {
                Key[] keyArray = fgAllKeys;
                int n = fgAllKeys.length;
                int n2 = 0;
                while (n2 < n) {
                    Key key = keyArray[n2];
                    key.setStoredValue(this.fLookupOrder[0], this.fOldProjectSettings.get(key), this.fManager);
                    ++n2;
                }
                this.fOldProjectSettings = null;
                this.updateControls();
            } else {
                this.fOldProjectSettings = new IdentityHashMap();
                String old = null;
                Key[] keyArray = fgAllKeys;
                int n = fgAllKeys.length;
                int n3 = 0;
                while (n3 < n) {
                    Key key = keyArray[n3];
                    old = key.getStoredValue(this.fLookupOrder, false, this.fManager);
                    this.fOldProjectSettings.put(key, old);
                    key.setStoredValue(this.fLookupOrder[0], null, this.fManager);
                    ++n3;
                }
            }
        }
        this.fDirty = true;
        this.enableControl((Control)this.fMainComp, enable);
    }

    private void updateControls() {
        Control control = null;
        for (HashSet<Control> controls : this.fControlMap.values()) {
            if (controls == null) continue;
            for (Control controlObject : controls) {
                ControlData data;
                control = controlObject;
                if (control instanceof Combo) {
                    Combo combo = (Combo)control;
                    data = (ControlData)combo.getData();
                    int index = 0;
                    try {
                        index = Integer.parseInt(data.key.getStoredValue(this.fLookupOrder, false, this.fManager));
                    }
                    catch (Exception exception) {
                        index = Integer.parseInt(data.key.getStoredValue(this.fLookupOrder, true, this.fManager));
                    }
                    combo.select(data.getSelection(SEVERITIES[index]));
                    continue;
                }
                if (control instanceof Button) {
                    Button button = (Button)control;
                    data = (ControlData)button.getData();
                    button.setSelection(Boolean.parseBoolean(data.key.getStoredValue(this.fLookupOrder, false, this.fManager)));
                    continue;
                }
                if (!(control instanceof Text)) continue;
                Text text = (Text)control;
                data = (ControlData)text.getData();
                text.setText(data.key.getStoredValue(this.fLookupOrder, false, this.fManager));
            }
        }
    }

    private void enableControl(Control ctrl, boolean enabled) {
        ctrl.setEnabled(enabled);
        if (ctrl instanceof Composite) {
            Control[] children;
            Composite comp = (Composite)ctrl;
            Control[] controlArray = children = comp.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                Control child = controlArray[n2];
                this.enableControl(child, enabled);
                ++n2;
            }
        }
    }

    public Control createControl(Composite parent) {
        this.fParent = parent;
        this.fMainComp = SWTFactory.createComposite(parent, 1, 1, 1808, 0, 0);
        if (this.fProject == null) {
            SWTFactory.createVerticalSpacer(parent, 1);
            this.fTabFolder = new TabFolder(this.fMainComp, 0);
            GridData gd = new GridData(1808);
            gd.heightHint = 375;
            this.fTabFolder.setLayoutData((Object)gd);
        }
        Composite main = this.fTabFolder == null ? this.fMainComp : this.fTabFolder;
        this.createPage(0, main, PDEUIMessages.CompilersConfigurationBlock_plugins, PDEUIMessages.CompilersConfigurationBlock_label);
        if (this.fProject == null) {
            this.createPage(1, main, PDEUIMessages.CompilersConfigurationBlock_schemas, PDEUIMessages.CompilersConfigurationBlock_altlabel);
            this.createPage(2, main, PDEUIMessages.CompilersConfigurationBlock_features, PDEUIMessages.CompilersConfigurationBlock_label);
        }
        this.restoreExpansionState();
        Dialog.applyDialogFont((Control)this.fParent);
        return this.fMainComp;
    }

    private Composite createPage(int kind, Composite folder, String name, String description) {
        Composite page;
        Composite parent = page = SWTFactory.createComposite(folder, 1, 1, 1808);
        if (this.fProject == null) {
            TabItem tab = new TabItem((TabFolder)folder, 0);
            tab.setText(name);
            tab.setControl((Control)page);
            parent = SWTFactory.createComposite(page, 2, 1, 1808);
        }
        SWTFactory.createWrapLabel(parent, description, 2);
        SWTFactory.createVerticalSpacer(parent, 1);
        switch (kind) {
            case 0: {
                ScrolledComposite scomp = this.createScrolledComposite(parent, 1);
                Composite sbody = SWTFactory.createComposite((Composite)scomp, 1, 1, 1808);
                scomp.setContent((Control)sbody);
                Composite client = this.createExpansibleComposite(sbody, PDEUIMessages.PDECompilersConfigurationBlock_general);
                this.initializeComboControls(client, new String[]{PDEUIMessages.compilers_p_no_required_att, PDEUIMessages.CompilersConfigurationTab_incompatEnv, PDEUIMessages.compilers_p_exported_pkgs, PDEUIMessages.compilers_p_no_automatic_module_name}, new Key[]{KEY_P_NO_REQUIRED_ATT, KEY_P_INCOMPATIBLE_ENV, KEY_P_MISSING_EXPORT_PKGS, KEY_P_NO_AUTOMATIC_MODULE_NAME}, 0);
                client = this.createExpansibleComposite(sbody, PDEUIMessages.PDECompilersConfigurationBlock_build);
                this.initializeComboControls(client, new String[]{PDEUIMessages.PDECompilersConfigurationBlock_1, PDEUIMessages.PDECompilersConfigurationBlock_2, PDEUIMessages.PDECompilersConfigurationBlock_0, PDEUIMessages.PDECompilersConfigurationBlock_3, PDEUIMessages.PDECompilersConfigurationBlock_4, PDEUIMessages.PDECompilersConfigurationBlock_5, PDEUIMessages.PDECompilersConfigurationBlock_6, PDEUIMessages.PDECompilersConfigurationBlock_7, PDEUIMessages.CompilersConfigurationTab_buildPropertiesErrors}, new Key[]{KEY_P_BUILD_SOURCE_LIBRARY, KEY_P_BUILD_OUTPUT_LIBRARY, KEY_P_BUILD_MISSING_OUTPUT, KEY_P_BUILD_BIN_INCLUDES, KEY_P_BUILD_SRC_INCLUDES, KEY_P_BUILD_JAVA_COMPLIANCE, KEY_P_BUILD_JAVA_COMPILER, KEY_P_BUILD_ENCODINGS, KEY_P_BUILD}, 0);
                client = this.createExpansibleComposite(sbody, PDEUIMessages.PDECompilersConfigurationBlock_versioning);
                this.initializeComboControls(client, new String[]{PDEUIMessages.compilers_p_missing_require_bundle, PDEUIMessages.compilers_p_missing_exp_pkg, PDEUIMessages.compilers_p_missing_imp_pkg, PDEUIMessages.compilers_p_exec_env_too_low}, new Key[]{KEY_P_VERSION_REQ_BUNDLE, KEY_P_VERSION_EXP_PKG, KEY_P_VERSION_IMP_PKG, KEY_P_VERSION_EXEC_ENV_TOO_LOW}, 0);
                client = this.createExpansibleComposite(sbody, PDEUIMessages.PDECompilersConfigurationBlock_usage);
                this.initializeComboControls(client, new String[]{PDEUIMessages.compilers_p_unresolved_import, PDEUIMessages.compilers_p_unresolved_ex_points, PDEUIMessages.compilers_p_internal, PDEUIMessages.compilers_p_deprecated, PDEUIMessages.compilers_p_not_externalized_att, PDEUIMessages.compilers_p_service_component_without_lazy_act}, new Key[]{KEY_P_UNRESOLVED_IMPORTS, KEY_P_UNRESOLVED_EX_POINTS, KEY_P_INTERNAL, KEY_P_DEPRECATED, KEY_P_NOT_EXTERNALIZED, KEY_P_SERVICE_COMP_WITHOUT_LAZY}, 0);
                client = this.createExpansibleComposite(sbody, PDEUIMessages.PDECompilersConfigurationBlock_references);
                this.initializeComboControls(client, new String[]{PDEUIMessages.compilers_p_unknown_element, PDEUIMessages.compilers_p_unknown_attribute, PDEUIMessages.compilers_p_unknown_class, PDEUIMessages.compilers_p_discouraged_class, PDEUIMessages.compilers_p_unknown_resource, PDEUIMessages.compilers_p_unknown_identifier}, new Key[]{KEY_P_UNKNOWN_ELEMENT, KEY_P_UNKNOWN_ATTRIBUTE, KEY_P_UNKNOWN_CLASS, KEY_P_DISCOURAGED_CLASS, KEY_P_UNKNOWN_RESOURCE, KEY_P_UNKNOWN_IDENTIFIER}, 0);
                break;
            }
            case 1: {
                this.createCheckControl(parent, PDEUIMessages.compilers_s_create_docs, KEY_S_CREATE_DOCS, 1);
                Composite comp = SWTFactory.createComposite(parent, 2, 2, 768, 0, 0);
                this.createTextControl(comp, PDEUIMessages.compilers_s_doc_folder, KEY_S_DOC_FOLDER, 1);
                SWTFactory.createVerticalSpacer(parent, 1);
                this.initializeComboControls(parent, new String[]{PDEUIMessages.compilers_s_open_tags}, new Key[]{KEY_S_OPEN_TAGS}, 1);
                break;
            }
            case 2: {
                this.initializeComboControls(parent, new String[]{PDEUIMessages.compilers_f_unresolved_features, PDEUIMessages.compilers_f_unresolved_plugins}, new Key[]{KEY_F_UNRESOLVED_FEATURES, KEY_F_UNRESOLVED_PLUGINS}, 2);
            }
        }
        return page;
    }

    private void initializeComboControls(Composite composite, String[] labels, Key[] keys, int tabkind) {
        int i = 0;
        int max = labels.length;
        while (i < max) {
            this.createComboControl(composite, labels[i], keys[i], tabkind);
            ++i;
        }
    }

    private void createCheckControl(Composite parent, String label, Key key, int tabkind) {
        Button button = SWTFactory.createCheckButton(parent, label, null, false, 2);
        ControlData data = new ControlData(key, new String[]{Boolean.toString(false)});
        button.setData((Object)data);
        button.setSelection(Boolean.parseBoolean(data.key.getStoredValue(this.fLookupOrder, false, this.fManager)));
        button.addSelectionListener(this.selectionlistener);
        Integer mapkey = tabkind;
        HashSet<Object> controls = this.fControlMap.get(mapkey);
        if (controls == null) {
            controls = new HashSet(8);
            this.fControlMap.put(mapkey, controls);
        }
        controls.add((Control)button);
    }

    public void dispose() {
        this.fMainComp.getParent().dispose();
        this.fExpComps.clear();
        this.fControlMap.clear();
        this.fComboLabelMap.clear();
    }

    protected void createComboControl(Composite parent, String label, Key key, int tabkind) {
        Label lbl = new Label(parent, 0);
        GridData gd = new GridData(1, 2, true, false);
        lbl.setLayoutData((Object)gd);
        lbl.setText(label);
        if (key.equals(KEY_P_NO_AUTOMATIC_MODULE_NAME)) {
            lbl.setToolTipText(PDEUIMessages.PDECompilersConfigurationBlock_8);
        }
        Combo combo = new Combo(parent, 12);
        gd = new GridData(3, 2, false, false);
        ControlData data = new ControlData(key, SEVERITIES);
        combo.setData((Object)data);
        combo.setItems(SEVERITIES);
        combo.addSelectionListener(this.selectionlistener);
        int index = 0;
        String value = key.getStoredValue(this.fLookupOrder, false, this.fManager);
        if (value == null) {
            value = key.getStoredValue(this.fLookupOrder, true, this.fManager);
        }
        if (value != null) {
            index = Integer.parseInt(value);
        }
        combo.select(data.getSelection(SEVERITIES[index]));
        Integer mapkey = tabkind;
        HashSet<Object> controls = this.fControlMap.get(mapkey);
        if (controls == null) {
            controls = new HashSet(8);
            this.fControlMap.put(mapkey, controls);
        }
        controls.add((Control)combo);
        this.addHighlight(parent, lbl, combo);
        if (Util.isMac()) {
            this.fComboLabelMap.put(combo, lbl);
        }
    }

    private void createTextControl(Composite parent, String label, Key key, int tabkind) {
        SWTFactory.createLabel(parent, label, 1);
        Text text = SWTFactory.createSingleText(parent, 1);
        ControlData data = new ControlData(key, new String[0]);
        text.setData((Object)data);
        String value = data.key.getStoredValue(this.fLookupOrder, false, this.fManager);
        if (value != null) {
            text.setText(value);
        }
        text.addModifyListener(this.modifylistener);
        Integer mapkey = tabkind;
        HashSet<Object> controls = this.fControlMap.get(mapkey);
        if (controls == null) {
            controls = new HashSet(8);
            this.fControlMap.put(mapkey, controls);
        }
        controls.add((Control)text);
    }

    protected ScrolledComposite createScrolledComposite(Composite parent, int columns) {
        ScrolledComposite scomp = new ScrolledComposite(parent, 768);
        scomp.setExpandHorizontal(true);
        scomp.setExpandVertical(true);
        scomp.setLayout((Layout)new GridLayout(1, false));
        scomp.setLayoutData((Object)new GridData(4, 4, true, true));
        scomp.addListener(11, event -> this.handleExpand(this.getScrollingParent(event.widget)));
        return scomp;
    }

    private Composite createExpansibleComposite(Composite parent, String title) {
        ExpandableComposite ecomp = SWTFactory.createExpandibleComposite(parent, title, 1, 768);
        ecomp.addExpansionListener((IExpansionListener)new ExpansionAdapter(){

            public void expansionStateChanged(ExpansionEvent e) {
                Object obj = e.getSource();
                PDECompilersConfigurationBlock.this.handleExpand(PDECompilersConfigurationBlock.this.getScrollingParent(obj));
            }
        });
        ecomp.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
        this.fExpComps.add(ecomp);
        Composite client = SWTFactory.createComposite((Composite)ecomp, 2, 1, 1808);
        ecomp.setClient((Control)client);
        return client;
    }

    private ScrolledComposite getScrollingParent(Object obj) {
        if (obj instanceof ExpandableComposite) {
            ExpandableComposite ecomp = (ExpandableComposite)obj;
            Composite parent = ecomp.getParent();
            while (parent != null && !(parent instanceof ScrolledComposite)) {
                parent = parent.getParent();
            }
            if (parent != null) {
                return (ScrolledComposite)parent;
            }
        }
        if (obj instanceof ScrolledComposite) {
            return (ScrolledComposite)obj;
        }
        return null;
    }

    private void handleExpand(ScrolledComposite composite) {
        if (composite == null) {
            return;
        }
        try {
            composite.setRedraw(false);
            Composite c = (Composite)composite.getContent();
            if (c == null) {
                return;
            }
            Point newSize = c.computeSize(-1, -1);
            composite.setMinSize(newSize);
            c.layout(true);
        }
        finally {
            composite.setRedraw(true);
        }
    }

    public void performOK() {
        this.save();
        this.persistExpansionState();
    }

    public void performApply() {
        this.save();
    }

    private void save() {
        if (this.fDirty) {
            try {
                ArrayList<Key> changes = new ArrayList<Key>();
                this.collectChanges(this.fLookupOrder[0], changes);
                if (!changes.isEmpty() && this.fRebuildcount < 1) {
                    int open;
                    ++this.fRebuildcount;
                    this.fManager.applyChanges();
                    String message = PDEUIMessages.PDECompilersConfigurationBlock_settings_changed_all;
                    if (this.fProject != null) {
                        message = MessageFormat.format((String)PDEUIMessages.PDECompilersConfigurationBlock_setting_changed_project, (Object[])new Object[]{this.fProject.getName()});
                    }
                    if ((open = MessageDialog.open((int)3, (Shell)this.fParent.getShell(), (String)PDEUIMessages.PDECompilersConfigurationBlock_settings_changed, (String)message, (int)0, (String[])new String[]{PDEUIMessages.PDECompilersConfigurationBlock_buildButtonLabel, PDEUIMessages.PDECompilersConfigurationBlock_dontBuildButtonLabel})) == 0) {
                        this.doFullBuild();
                    }
                }
                this.fDirty = false;
            }
            catch (BackingStoreException bse) {
                PDEPlugin.log(bse);
            }
        }
    }

    private void collectChanges(IScopeContext context, List<Key> changes) {
        Key key = null;
        String origval = null;
        String newval = null;
        boolean complete = this.fOldProjectSettings == null && this.fProject != null;
        Key[] keyArray = fgAllKeys;
        int n = fgAllKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Key fgKey;
            key = fgKey = keyArray[n2];
            origval = key.getStoredValue(context, null);
            newval = key.getStoredValue(context, this.fManager);
            if (newval == null) {
                if (origval != null) {
                    changes.add(key);
                } else if (complete) {
                    key.setStoredValue(context, key.getStoredValue(this.fLookupOrder, true, this.fManager), this.fManager);
                    changes.add(key);
                }
            } else if (!newval.equals(origval)) {
                changes.add(key);
            }
            ++n2;
        }
    }

    public void performCancel() {
        this.persistExpansionState();
    }

    public void performDefaults() {
        String defval = null;
        Key[] keyArray = fgAllKeys;
        int n = fgAllKeys.length;
        int n2 = 0;
        while (n2 < n) {
            Key key = keyArray[n2];
            defval = key.getStoredValue(this.fLookupOrder, true, this.fManager);
            key.setStoredValue(this.fLookupOrder[0], defval, this.fManager);
            ++n2;
        }
        this.updateControls();
        this.fDirty = true;
        this.fRebuildcount = 0;
    }

    private void persistExpansionState() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().addNewSection(SETTINGS);
        int i = 0;
        while (i < this.fExpComps.size()) {
            settings.put(Integer.toString(i), this.fExpComps.get(i).isExpanded());
            ++i;
        }
    }

    private void restoreExpansionState() {
        IDialogSettings settings = PDEPlugin.getDefault().getDialogSettings().getSection(SETTINGS);
        if (settings != null) {
            int i = 0;
            while (i < this.fExpComps.size()) {
                this.fExpComps.get(i).setExpanded(settings.getBoolean(Integer.toString(i)));
                ++i;
            }
        } else {
            this.fExpComps.get(0).setExpanded(true);
        }
    }

    private void addBuilder(Control control) {
        for (Map.Entry<Integer, HashSet<Control>> entry : this.fControlMap.entrySet()) {
            Integer key = entry.getKey();
            HashSet<Control> controls = entry.getValue();
            if (controls == null || !controls.contains(control)) continue;
            switch (key) {
                case 0: {
                    this.fBuilders.add("org.eclipse.pde.ManifestBuilder");
                    break;
                }
                case 1: {
                    this.fBuilders.add("org.eclipse.pde.SchemaBuilder");
                    break;
                }
                case 2: 
                case 3: {
                    this.fBuilders.add("org.eclipse.pde.FeatureBuilder");
                }
            }
            return;
        }
    }

    private void doFullBuild() {
        Job buildJob = new Job(PDEUIMessages.CompilersConfigurationBlock_building){

            public boolean belongsTo(Object family) {
                return ResourcesPlugin.FAMILY_MANUAL_BUILD == family;
            }

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    IProject[] projects = null;
                    projects = PDECompilersConfigurationBlock.this.fProject == null ? PDEPlugin.getWorkspace().getRoot().getProjects() : new IProject[]{PDECompilersConfigurationBlock.this.fProject};
                    SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)(projects.length * 2));
                    IProject[] iProjectArray = projects;
                    int n = projects.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IProject project = iProjectArray[n2];
                        SubMonitor iterationMonitor = subMonitor.split(2).setWorkRemaining(2);
                        IProject projectToBuild = project;
                        if (projectToBuild.isOpen()) {
                            ICommand[] commands = projectToBuild.isAccessible() ? ((Project)projectToBuild).internalGetDescription().getBuildSpec(false) : null;
                            if (projectToBuild.hasNature("org.eclipse.pde.PluginNature")) {
                                if (PDECompilersConfigurationBlock.this.fBuilders.contains("org.eclipse.pde.ManifestBuilder") && this.hasBuilder(commands, "org.eclipse.pde.ManifestBuilder")) {
                                    projectToBuild.build(6, "org.eclipse.pde.ManifestBuilder", null, (IProgressMonitor)iterationMonitor.split(1));
                                }
                                if (PDECompilersConfigurationBlock.this.fBuilders.contains("org.eclipse.pde.SchemaBuilder") && this.hasBuilder(commands, "org.eclipse.pde.SchemaBuilder")) {
                                    projectToBuild.build(6, "org.eclipse.pde.SchemaBuilder", null, (IProgressMonitor)iterationMonitor.split(1));
                                }
                            } else if (projectToBuild.hasNature("org.eclipse.pde.FeatureNature") && this.hasBuilder(commands, "org.eclipse.pde.FeatureBuilder") && PDECompilersConfigurationBlock.this.fBuilders.contains("org.eclipse.pde.FeatureBuilder")) {
                                projectToBuild.build(6, "org.eclipse.pde.FeatureBuilder", null, (IProgressMonitor)iterationMonitor.split(2));
                            }
                        }
                        ++n2;
                    }
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
                catch (OperationCanceledException operationCanceledException) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            private boolean hasBuilder(ICommand[] commands, String string) {
                if (commands == null) {
                    return false;
                }
                if (commands.length == 0) {
                    return false;
                }
                ICommand[] iCommandArray = commands;
                int n = commands.length;
                int n2 = 0;
                while (n2 < n) {
                    ICommand iCommand = iCommandArray[n2];
                    if (iCommand.getBuilderName().equals(string)) {
                        return true;
                    }
                    ++n2;
                }
                return false;
            }
        };
        buildJob.setRule(ResourcesPlugin.getWorkspace().getRuleFactory().buildRule());
        buildJob.setUser(true);
        buildJob.schedule();
    }

    public void selectOption(String key, String qualifier) {
        Key[] allKeys = fgAllKeys;
        int i = 0;
        while (i < allKeys.length) {
            Key curr = allKeys[i];
            if (curr.getName().equals(key) && curr.getQualifier().equals(qualifier)) {
                this.selectOption(curr);
            }
            ++i;
        }
    }

    protected ExpandableComposite getParentExpandableComposite(Control control) {
        Composite parent = control.getParent();
        while (!(parent instanceof ExpandableComposite) && parent != null) {
            parent = parent.getParent();
        }
        if (parent instanceof ExpandableComposite) {
            return (ExpandableComposite)parent;
        }
        return null;
    }

    private void selectOption(Key key) {
        int tabId = this.findTab(key);
        if (tabId == -1) {
            return;
        }
        if (this.fTabFolder != null) {
            this.fTabFolder.setSelection(tabId);
        }
        HashSet<Control> controls = this.fControlMap.get(tabId);
        Control curr = null;
        boolean found = false;
        Iterator<Control> iterator = controls.iterator();
        while (iterator.hasNext()) {
            Control con;
            curr = con = iterator.next();
            ControlData data = (ControlData)con.getData();
            if (!key.equals(data.getKey())) continue;
            found = true;
            break;
        }
        if (found) {
            Label labelControl;
            ExpandableComposite expandable = this.getParentExpandableComposite(curr);
            if (expandable != null) {
                HashSet<Control> controls2 = this.fControlMap.get(tabId);
                for (Control con : controls2) {
                    ExpandableComposite expandableOthers = this.getParentExpandableComposite(con);
                    if (expandableOthers == null) continue;
                    expandableOthers.setExpanded(false);
                }
                expandable.setExpanded(true);
            }
            curr.setFocus();
            if (Util.isMac() && (labelControl = this.fComboLabelMap.get(curr)) != null && curr instanceof Combo) {
                this.highlight(curr.getParent(), labelControl, (Combo)curr, 17);
            }
        }
    }

    private int findTab(Key key) {
        int tabId = -1;
        int i = 0;
        while (i < 3) {
            HashSet<Control> controls = this.fControlMap.get(i);
            if (controls != null) {
                for (Control con : controls) {
                    ControlData data = (ControlData)con.getData();
                    if (!key.equals(data.getKey())) continue;
                    tabId = i;
                    break;
                }
            }
            ++i;
        }
        return tabId;
    }

    protected static class ControlData {
        private Key key;
        private String[] values;

        public ControlData(Key key, String[] values) {
            this.key = key;
            this.values = values;
        }

        public Key getKey() {
            return this.key;
        }

        public String getValue(boolean selection) {
            int index = selection ? 0 : 1;
            return this.values[index];
        }

        public String getValue(int index) {
            return this.values[index];
        }

        public int getSelection(String value) {
            if (value != null) {
                int i = 0;
                while (i < this.values.length) {
                    if (value.equals(this.values[i])) {
                        return i;
                    }
                    ++i;
                }
            }
            return this.values.length - 1;
        }
    }

    public static class Key {
        private String qualifier;
        private String key;

        public Key(String qualifier, String key) {
            this.qualifier = qualifier;
            this.key = key;
        }

        private IEclipsePreferences getNode(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = context.getNode(this.qualifier);
            if (manager != null) {
                return manager.getWorkingCopy(node);
            }
            return node;
        }

        public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (node != null) {
                return node.get(this.key, null);
            }
            return null;
        }

        public String getStoredValue(IScopeContext[] lookupOrder, boolean ignoreTopScope, IWorkingCopyManager manager) {
            int i = ignoreTopScope ? 1 : 0;
            while (i < lookupOrder.length) {
                String value = this.getStoredValue(lookupOrder[i], manager);
                if (value != null) {
                    return value;
                }
                ++i;
            }
            return null;
        }

        public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
            IEclipsePreferences node = this.getNode(context, manager);
            if (value != null) {
                node.put(this.key, value);
            } else {
                node.remove(this.key);
            }
        }

        public String toString() {
            return String.valueOf(this.qualifier) + '/' + this.key;
        }

        public Object getName() {
            return this.key;
        }

        public Object getQualifier() {
            return this.qualifier;
        }
    }
}

