/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.externaltools.internal.ui;

import java.util.ArrayList;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.externaltools.internal.ui.ExternalToolsUIMessages;
import org.eclipse.ui.externaltools.internal.ui.TreeAndListGroup;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;

public class FileSelectionDialog
extends MessageDialog {
    private IAdaptable root;
    private TreeAndListGroup selectionGroup;
    private static final int SIZING_SELECTION_WIDGET_WIDTH = 400;
    private static final int SIZING_SELECTION_WIDGET_HEIGHT = 300;
    private IStructuredSelection result = null;
    private boolean allowMultiselection = false;
    private Pattern fPattern;

    public FileSelectionDialog(Shell parentShell, IAdaptable rootElement, String message) {
        super(parentShell, ExternalToolsUIMessages.FileSelectionDialog_Choose_Location_1, null, message, 0, new String[]{ExternalToolsUIMessages.FileSelectionDialog_Ok_2, ExternalToolsUIMessages.FileSelectionDialog_Cancel_3}, 0);
        this.root = rootElement;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    public void setFileFilter(String pattern, boolean ignoreCase) {
        this.fPattern = pattern != null ? (ignoreCase ? Pattern.compile(pattern, 2) : Pattern.compile(pattern)) : null;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)shell, "org.eclipse.ui.externaltools.file_selection_dialog_context");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.initializeDialog();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        this.selectionGroup = new TreeAndListGroup(composite, this.root, this.getResourceProvider(14), (ILabelProvider)new WorkbenchLabelProvider(), (IStructuredContentProvider)this.getResourceProvider(1), (ILabelProvider)new WorkbenchLabelProvider(), 0, 400, 300, this.allowMultiselection);
        composite.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
            }

            public void controlResized(ControlEvent e) {
                TableColumn[] columns;
                TableColumn[] tableColumnArray = columns = FileSelectionDialog.this.selectionGroup.getListTable().getColumns();
                int n = columns.length;
                int n2 = 0;
                while (n2 < n) {
                    TableColumn column = tableColumnArray[n2];
                    column.pack();
                    ++n2;
                }
            }
        });
        return composite;
    }

    private ITreeContentProvider getResourceProvider(final int resourceType) {
        return new WorkbenchContentProvider(){

            public Object[] getChildren(Object o) {
                if (o instanceof IContainer) {
                    int n;
                    int n2;
                    IResource[] iResourceArray;
                    IResource[] members = null;
                    try {
                        members = ((IContainer)o).members();
                        ArrayList<IResource> accessibleMembers = new ArrayList<IResource>(members.length);
                        iResourceArray = members;
                        n2 = members.length;
                        n = 0;
                        while (n < n2) {
                            IResource resource = iResourceArray[n];
                            if (resource.isAccessible()) {
                                accessibleMembers.add(resource);
                            }
                            ++n;
                        }
                        members = accessibleMembers.toArray(new IResource[accessibleMembers.size()]);
                    }
                    catch (CoreException coreException) {
                        return new Object[0];
                    }
                    ArrayList<IResource> results = new ArrayList<IResource>();
                    iResourceArray = members;
                    n2 = members.length;
                    n = 0;
                    while (n < n2) {
                        IResource member = iResourceArray[n];
                        if ((member.getType() & resourceType) > 0 && (member.getType() != 1 || FileSelectionDialog.this.fPattern == null || FileSelectionDialog.this.fPattern.matcher(member.getName()).find())) {
                            results.add(member);
                        }
                        ++n;
                    }
                    return results.toArray();
                }
                return new Object[0];
            }
        };
    }

    private void initializeDialog() {
        this.selectionGroup.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                FileSelectionDialog.this.getButton(0).setEnabled(!FileSelectionDialog.this.selectionGroup.getListTableSelection().isEmpty());
            }
        });
        this.selectionGroup.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FileSelectionDialog.this.buttonPressed(0);
            }
        });
        this.getButton(0).setEnabled(false);
    }

    public IStructuredSelection getResult() {
        return this.result;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.result = this.selectionGroup.getListTableSelection();
        }
        super.buttonPressed(buttonId);
    }

    public void setAllowMultiselection(boolean allowMultiselection) {
        this.allowMultiselection = allowMultiselection;
    }
}

