/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.decorators;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.decorators.IProblemDecoratable;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.BaseLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.team.ui.TeamImages;

public class ProblemLabelDecorator
extends BaseLabelProvider
implements ILabelDecorator,
IResourceChangeListener {
    private final StructuredViewer viewer;
    private final ResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources());

    public ProblemLabelDecorator(StructuredViewer viewer) {
        this.viewer = viewer;
        if (this.viewer != null) {
            ResourcesPlugin.getWorkspace().addResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        this.resourceManager.dispose();
        if (this.viewer != null) {
            ResourcesPlugin.getWorkspace().removeResourceChangeListener((IResourceChangeListener)this);
        }
    }

    public Image decorateImage(Image image, Object element) {
        IProblemDecoratable decoratable = this.getProblemDecoratable(element);
        if (decoratable != null) {
            int problemSeverity = decoratable.getProblemSeverity();
            if (problemSeverity == 2) {
                return this.getDecoratedImage(image, "ovr/error_co.gif");
            }
            if (problemSeverity == 1) {
                return this.getDecoratedImage(image, "ovr/warning_co.gif");
            }
        }
        return null;
    }

    public String decorateText(String text, Object element) {
        return null;
    }

    private IProblemDecoratable getProblemDecoratable(Object element) {
        if (element instanceof IProblemDecoratable) {
            return (IProblemDecoratable)element;
        }
        return null;
    }

    private Image getDecoratedImage(Image base, String teamImageId) {
        ImageDescriptor overlay = TeamImages.getImageDescriptor((String)teamImageId);
        DecorationOverlayIcon decorated = new DecorationOverlayIcon(base, overlay, 2);
        return (Image)this.resourceManager.get((DeviceResourceDescriptor)decorated);
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IMarkerDelta[] markerDeltas;
        HashSet<IPath> paths = new HashSet<IPath>();
        IMarkerDelta[] iMarkerDeltaArray = markerDeltas = event.findMarkerDeltas("org.eclipse.core.resources.problemmarker", true);
        int n = markerDeltas.length;
        int n2 = 0;
        while (n2 < n) {
            File workTree;
            IPath path;
            RepositoryMapping mapping;
            IMarkerDelta delta = iMarkerDeltaArray[n2];
            IResource resource = delta.getResource();
            if (resource != null && (mapping = RepositoryMapping.getMapping((IResource)resource)) != null && !mapping.getRepository().isBare() && (path = resource.getLocation()) != null && (workTree = mapping.getWorkTree()) != null) {
                int n3 = new Path(workTree.getAbsolutePath()).segmentCount();
                int i = path.segmentCount();
                while (i > n3) {
                    paths.add(path);
                    path = path.removeLastSegments(1);
                    --i;
                }
            }
            ++n2;
        }
        if (!paths.isEmpty()) {
            this.updateLabels(paths);
        }
    }

    private void updateLabels(Set<IPath> changedPaths) {
        List<Object> elements = this.getAffectedElements(changedPaths);
        if (!elements.isEmpty()) {
            final Object[] updateElements = elements.toArray(new Object[0]);
            Display display = this.viewer.getControl().getDisplay();
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    ProblemLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)ProblemLabelDecorator.this, updateElements));
                }
            });
        }
    }

    private List<Object> getAffectedElements(Set<IPath> paths) {
        ArrayList<Object> result = new ArrayList<Object>();
        if (this.viewer.getContentProvider() instanceof IStructuredContentProvider) {
            IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.viewer.getContentProvider();
            this.getAffectedElements(paths, contentProvider.getElements(null), contentProvider, result);
        }
        return result;
    }

    private void getAffectedElements(Set<IPath> paths, Object[] elements, IStructuredContentProvider contentProvider, List<Object> result) {
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource;
            Object element = objectArray[n2];
            IPath path = (IPath)AdapterUtils.adapt((Object)element, IPath.class);
            if (path == null && (resource = (IResource)AdapterUtils.adapt((Object)element, IResource.class)) != null) {
                path = resource.getLocation();
            }
            if (path != null && paths.contains(path)) {
                result.add(element);
                if (contentProvider instanceof ITreeContentProvider) {
                    this.getAffectedElements(paths, ((ITreeContentProvider)contentProvider).getChildren(element), contentProvider, result);
                }
            }
            ++n2;
        }
    }
}

