/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.eclipse.jface.widgets.Property;
import org.eclipse.swt.widgets.Widget;

public abstract class AbstractWidgetFactory<F extends AbstractWidgetFactory<?, ?, ?>, W extends Widget, P extends Widget> {
    private Class<F> factoryClass;
    private Function<P, W> widgetCreator;
    private List<Property<W>> properties = new ArrayList<Property<W>>();

    protected AbstractWidgetFactory(Class<F> factoryClass, Function<P, W> widgetCreator) {
        this.factoryClass = factoryClass;
        this.widgetCreator = widgetCreator;
    }

    protected final F cast(AbstractWidgetFactory<F, W, P> factory) {
        return (F)((AbstractWidgetFactory)this.factoryClass.cast(factory));
    }

    public final W create(P parent) {
        Widget widget = (Widget)this.widgetCreator.apply(parent);
        this.properties.forEach(p -> p.apply(widget));
        return (W)widget;
    }

    protected final void addProperty(Property<W> property) {
        this.properties.add(property);
    }
}

