/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.actions;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.egit.core.AdapterUtils;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CompareUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.actions.RepositoryActionHandler;
import org.eclipse.egit.ui.internal.resources.ResourceStateFactory;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.handlers.HandlerUtil;

public class CompareIndexWithHeadActionHandler
extends RepositoryActionHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Repository repository = this.getRepository(true, event);
        if (repository == null) {
            return null;
        }
        Object fileOrPath = this.getSingleSelectedObject(event);
        if (fileOrPath == null) {
            return null;
        }
        try {
            this.runCompare(event, repository);
        }
        catch (Exception e) {
            Activator.handleError(UIText.CompareWithRefAction_errorOnSynchronize, e, true);
        }
        return null;
    }

    private void runCompare(ExecutionEvent event, @NonNull Repository repository) throws Exception {
        IWorkbenchPage workbenchPage = HandlerUtil.getActiveWorkbenchWindowChecked((ExecutionEvent)event).getActivePage();
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length > 0) {
            CompareUtils.compare(resources, repository, "Index", "HEAD", false, workbenchPage);
        } else {
            IPath[] locations = this.getSelectedLocations(event);
            if (locations.length == 0) {
                return;
            }
            IPath location = locations[0];
            if (location == null) {
                return;
            }
            CompareUtils.compare(location, repository, "Index", "HEAD", false, workbenchPage);
        }
    }

    private Object getSingleSelectedObject(ExecutionEvent event) throws ExecutionException {
        IResource[] resources = this.getSelectedResources(event);
        if (resources.length == 1) {
            return resources[0];
        }
        IPath[] locations = this.getSelectedLocations(event);
        if (locations.length == 1) {
            return locations[0];
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        IPath location;
        IStructuredSelection selection = this.getSelection();
        if (selection.size() != 1) {
            return false;
        }
        Repository repository = this.getRepository();
        if (repository == null) {
            return false;
        }
        Object selected = selection.getFirstElement();
        IResource resource = (IResource)AdapterUtils.adapt((Object)selected, IResource.class);
        if (resource instanceof IFile) {
            return ResourceStateFactory.getInstance().get(resource).isStaged();
        }
        if (resource == null && (location = (IPath)AdapterUtils.adapt((Object)selected, IPath.class)) != null) {
            return ResourceStateFactory.getInstance().get(location.toFile()).isStaged();
        }
        return false;
    }
}

