/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.preferences;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.team.core.IIgnoreInfo;
import org.eclipse.team.core.Team;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class IgnorePreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Table ignoreTable;
    private Button addButton;
    private Button removeButton;

    public void init(IWorkbench workbench) {
        this.setDescription(TeamUIMessages.IgnorePreferencePage_description);
    }

    protected Control createContents(Composite ancestor) {
        Composite parent = new Composite(ancestor, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 2;
        parent.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        parent.setLayoutData((Object)data);
        Label l1 = new Label(parent, 0);
        l1.setText(TeamUIMessages.IgnorePreferencePage_ignorePatterns);
        data = new GridData(2);
        data.horizontalSpan = 2;
        l1.setLayoutData((Object)data);
        this.ignoreTable = new Table(parent, 2082);
        GridData gd = new GridData(1808);
        gd.heightHint = 300;
        this.ignoreTable.setLayoutData((Object)gd);
        this.ignoreTable.addListener(13, e -> this.handleSelection());
        Composite buttons = new Composite(parent, 0);
        buttons.setLayoutData((Object)new GridData(2));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttons.setLayout((Layout)layout);
        this.addButton = new Button(buttons, 8);
        this.addButton.setText(TeamUIMessages.IgnorePreferencePage_add);
        this.addButton.addListener(13, e -> this.addIgnore());
        this.removeButton = new Button(buttons, 8);
        this.removeButton.setText(TeamUIMessages.IgnorePreferencePage_remove);
        this.removeButton.setEnabled(false);
        this.removeButton.addListener(13, e -> this.removeIgnore());
        this.fillTable(Team.getAllIgnores());
        Dialog.applyDialogFont((Control)ancestor);
        this.setButtonLayoutData(this.addButton);
        this.setButtonLayoutData(this.removeButton);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.team.ui.ignore_preference_page_context");
        return parent;
    }

    public boolean performOk() {
        int count = this.ignoreTable.getItemCount();
        String[] patterns = new String[count];
        boolean[] enabled = new boolean[count];
        TableItem[] items = this.ignoreTable.getItems();
        int i = 0;
        while (i < count) {
            patterns[i] = items[i].getText();
            enabled[i] = items[i].getChecked();
            ++i;
        }
        Team.setAllIgnores((String[])patterns, (boolean[])enabled);
        TeamUIPlugin.broadcastPropertyChange(new PropertyChangeEvent((Object)this, "org.eclipse.team.uiglobal_ignores_changed", null, null));
        return true;
    }

    protected void performDefaults() {
        super.performDefaults();
        this.ignoreTable.removeAll();
        IIgnoreInfo[] ignore = Team.getDefaultIgnores();
        this.fillTable(ignore);
    }

    private void fillTable(IIgnoreInfo[] ignore) {
        int i = 0;
        while (i < ignore.length) {
            IIgnoreInfo info = ignore[i];
            TableItem item = new TableItem(this.ignoreTable, 0);
            item.setText(TextProcessor.process((String)info.getPattern(), (String)".*"));
            item.setChecked(info.getEnabled());
            ++i;
        }
    }

    private void addIgnore() {
        InputDialog dialog = new InputDialog(this.getShell(), TeamUIMessages.IgnorePreferencePage_enterPatternShort, TeamUIMessages.IgnorePreferencePage_enterPatternLong, null, null){

            protected Control createDialogArea(Composite parent) {
                Control control = super.createDialogArea(parent);
                PlatformUI.getWorkbench().getHelpSystem().setHelp(control, "org.eclipse.team.ui.ignore_preference_page_context");
                return control;
            }
        };
        dialog.open();
        if (dialog.getReturnCode() != 0) {
            return;
        }
        String pattern = dialog.getValue();
        if (pattern.equals("")) {
            return;
        }
        TableItem[] items = this.ignoreTable.getItems();
        int i = 0;
        while (i < items.length) {
            if (items[i].getText().equals(pattern)) {
                MessageDialog.openWarning((Shell)this.getShell(), (String)TeamUIMessages.IgnorePreferencePage_patternExistsShort, (String)TeamUIMessages.IgnorePreferencePage_patternExistsLong);
                return;
            }
            ++i;
        }
        TableItem item = new TableItem(this.ignoreTable, 0);
        item.setText(TextProcessor.process((String)pattern, (String)".*"));
        item.setChecked(true);
    }

    private void removeIgnore() {
        int[] selection = this.ignoreTable.getSelectionIndices();
        this.ignoreTable.remove(selection);
    }

    private void handleSelection() {
        if (this.ignoreTable.getSelectionCount() > 0) {
            this.removeButton.setEnabled(true);
        } else {
            this.removeButton.setEnabled(false);
        }
    }
}

