/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction.java;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;

class PDESearchScope
implements IJavaSearchScope {
    private final IPath[] fEnclosingPaths;

    public static IJavaSearchScope create() {
        IPath[] workspacePaths = SearchEngine.createWorkspaceScope().enclosingProjectsAndJars();
        LinkedHashSet<IPath> allPaths = new LinkedHashSet<IPath>(Arrays.asList(workspacePaths));
        IPluginModelBase[] activeModels = PluginRegistry.getActiveModels();
        int i = 0;
        while (i < activeModels.length) {
            PDESearchScope.addPaths(allPaths, activeModels[i]);
            ++i;
        }
        return new PDESearchScope(allPaths.toArray(new IPath[0]));
    }

    private static void addPaths(Collection<IPath> allPaths, IPluginModelBase model) {
        IResource resource = model.getUnderlyingResource();
        if (resource != null && resource.isAccessible()) {
            return;
        }
        ArrayList pluginClasspathEntries = new ArrayList();
        ClasspathUtilCore.addLibraries((IPluginModelBase)model, pluginClasspathEntries);
        for (IClasspathEntry classpathEntry : pluginClasspathEntries) {
            allPaths.add(classpathEntry.getPath());
        }
    }

    private PDESearchScope(IPath[] paths) {
        this.fEnclosingPaths = paths;
    }

    public boolean encloses(String resourcePath) {
        return true;
    }

    public boolean encloses(IJavaElement element) {
        return true;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.fEnclosingPaths;
    }

    @Deprecated
    public boolean includesBinaries() {
        return true;
    }

    @Deprecated
    public boolean includesClasspaths() {
        return true;
    }

    @Deprecated
    public void setIncludesBinaries(boolean includesBinaries) {
    }

    @Deprecated
    public void setIncludesClasspaths(boolean includesClasspaths) {
    }
}

