/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.transport.sshd;

import java.io.IOException;
import java.net.SocketAddress;
import java.security.Key;
import java.security.PublicKey;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionImpl;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.util.Readable;
import org.eclipse.jgit.errors.InvalidPatternException;
import org.eclipse.jgit.fnmatch.FileNameMatcher;
import org.eclipse.jgit.internal.transport.sshd.JGitSshClient;
import org.eclipse.jgit.internal.transport.sshd.ServerKeyLookup;
import org.eclipse.jgit.internal.transport.sshd.SshdText;
import org.eclipse.jgit.internal.transport.sshd.proxy.StatefulProxyConnector;
import org.eclipse.jgit.transport.CredentialsProvider;

public class JGitClientSession
extends ClientSessionImpl {
    private HostConfigEntry hostConfig;
    private CredentialsProvider credentialsProvider;
    private StatefulProxyConnector proxyHandler;

    public JGitClientSession(ClientFactoryManager manager, IoSession session) throws Exception {
        super(manager, session);
    }

    public HostConfigEntry getHostConfigEntry() {
        return this.hostConfig;
    }

    public void setHostConfigEntry(HostConfigEntry hostConfig) {
        this.hostConfig = hostConfig;
    }

    public void setCredentialsProvider(CredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    public CredentialsProvider getCredentialsProvider() {
        return this.credentialsProvider;
    }

    public void setProxyHandler(StatefulProxyConnector handler) {
        this.proxyHandler = handler;
    }

    protected IoWriteFuture sendIdentification(String ident) throws IOException {
        return null;
    }

    protected byte[] sendKexInit() throws IOException {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            try {
                proxy.runWhenDone(() -> {
                    this.sendStartSsh();
                    return null;
                });
                return null;
            }
            catch (IOException e) {
                throw e;
            }
            catch (Exception other) {
                throw new IOException(other.getLocalizedMessage(), other);
            }
        }
        return this.sendStartSsh();
    }

    private byte[] sendStartSsh() throws IOException {
        super.sendIdentification(this.clientVersion);
        return super.sendKexInit();
    }

    public void messageReceived(Readable buffer) throws Exception {
        StatefulProxyConnector proxy = this.proxyHandler;
        if (proxy != null) {
            proxy.messageReceived(this.getIoSession(), buffer);
        } else {
            super.messageReceived(buffer);
        }
    }

    protected void checkKeys() throws SshException {
        PublicKey serverKey;
        SocketAddress remoteAddress;
        ServerKeyVerifier serverKeyVerifier = this.getServerKeyVerifier();
        if (!serverKeyVerifier.verifyServerKey((ClientSession)this, remoteAddress = this.getConnectAddress(), serverKey = this.getKex().getServerKey())) {
            throw new SshException(9, SshdText.get().kexServerKeyInvalid);
        }
    }

    protected String resolveAvailableSignaturesProposal(FactoryManager manager) {
        ServerKeyVerifier verifier;
        LinkedHashSet<String> defaultSignatures = new LinkedHashSet<String>();
        defaultSignatures.addAll(this.getSignatureFactoriesNames());
        HostConfigEntry config = (HostConfigEntry)this.resolveAttribute(JGitSshClient.HOST_CONFIG_ENTRY);
        String hostKeyAlgorithms = config.getProperty("HostKeyAlgorithms");
        if (hostKeyAlgorithms != null && !hostKeyAlgorithms.isEmpty()) {
            char first = hostKeyAlgorithms.charAt(0);
            if (first == '+') {
                return String.join((CharSequence)",", defaultSignatures);
            }
            if (first == '-') {
                this.removeFromList(defaultSignatures, "HostKeyAlgorithms", hostKeyAlgorithms.substring(1));
                if (defaultSignatures.isEmpty()) {
                    this.log.warn(MessageFormat.format(SshdText.get().configNoRemainingHostKeyAlgorithms, hostKeyAlgorithms));
                }
                return String.join((CharSequence)",", defaultSignatures);
            }
            List<String> newNames = this.filteredList(defaultSignatures, hostKeyAlgorithms);
            if (newNames.isEmpty()) {
                this.log.warn(MessageFormat.format(SshdText.get().configNoKnownHostKeyAlgorithms, hostKeyAlgorithms));
            } else {
                return String.join((CharSequence)",", newNames);
            }
        }
        if ((verifier = this.getServerKeyVerifier()) instanceof ServerKeyLookup) {
            SocketAddress remoteAddress = this.resolvePeerAddress((SocketAddress)this.resolveAttribute(JGitSshClient.ORIGINAL_REMOTE_ADDRESS));
            List<KnownHostsServerKeyVerifier.HostEntryPair> allKnownKeys = ((ServerKeyLookup)verifier).lookup((ClientSession)this, remoteAddress);
            LinkedHashSet<String> reordered = new LinkedHashSet<String>();
            for (KnownHostsServerKeyVerifier.HostEntryPair h : allKnownKeys) {
                String keyType;
                PublicKey key = h.getServerKey();
                if (key == null || (keyType = KeyUtils.getKeyType((Key)key)) == null) continue;
                reordered.add(keyType);
            }
            reordered.addAll(defaultSignatures);
            return String.join((CharSequence)",", reordered);
        }
        return String.join((CharSequence)",", defaultSignatures);
    }

    private void removeFromList(Set<String> current, String key, String patterns) {
        String[] stringArray = patterns.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String toRemove = stringArray[n2];
            if (toRemove.indexOf(42) < 0 && toRemove.indexOf(63) < 0) {
                current.remove(toRemove);
            } else {
                try {
                    FileNameMatcher matcher = new FileNameMatcher(toRemove, null);
                    Iterator<String> i = current.iterator();
                    while (i.hasNext()) {
                        matcher.reset();
                        matcher.append(i.next());
                        if (!matcher.isMatch()) continue;
                        i.remove();
                    }
                }
                catch (InvalidPatternException e) {
                    this.log.warn(MessageFormat.format(SshdText.get().configInvalidPattern, key, toRemove));
                }
            }
            ++n2;
        }
    }

    private List<String> filteredList(Set<String> known, String values) {
        ArrayList<String> newNames = new ArrayList<String>();
        String[] stringArray = values.split("\\s*,\\s*");
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String newValue = stringArray[n2];
            if (known.contains(newValue)) {
                newNames.add(newValue);
            }
            ++n2;
        }
        return newNames;
    }
}

