/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.internal.launching.rap.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.ui.launcher.AbstractLauncherTab;
import org.eclipse.rcptt.internal.launching.ext.Q7ExtLaunchingPlugin;
import org.eclipse.rcptt.internal.launching.rap.ui.AUTLocationBlock;
import org.eclipse.rcptt.internal.launching.rap.ui.Activator;
import org.eclipse.rcptt.internal.launching.rap.ui.DataLocationBlock;
import org.eclipse.rcptt.internal.launching.rap.ui.RcpttRapTabGroup;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfig;
import org.eclipse.rcptt.launching.rap.RAPLaunchConfigValidator;
import org.eclipse.rcptt.launching.target.ITargetPlatformHelper;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class RapAUTMainTab
extends AbstractLauncherTab {
    private static final int MIN_PORT_NUMBER = 0;
    private static final int MAX_PORT_NUMBER = 65535;
    private static final int MIN_SESSION_TIMEOUT = 0;
    private static final int MAX_SESSION_TIMEOUT = Integer.MAX_VALUE;
    private static final String BROWSER_PREFERENCE_PAGE = "org.eclipse.ui.browser.preferencePage";
    static final String SLASH = "/";
    private static final String PROTOCOL = "http";
    private static final String HOST = "127.0.0.1";
    private final SelectionListener selectionListener;
    private final GridDataFactory fillHorizontal;
    private final Image fImage;
    private final ModifyListener modifyListener;
    private AUTLocationBlock fLocationBlock;
    private ITargetPlatformHelper currentTargetPlatform;
    private Button internalBrowserRadioButton;
    private Button externalBrowserRadioButton;
    private Text servletPathTextField;
    private Text applicationUrlTextField;
    private Spinner portSpinner;
    private Button useSessionTimeoutCheckBox;
    private Spinner sessionTimeoutSpinner;
    private Button useFixedPortCheckBox;
    private Button contextPathCheckBox;
    private Text contextPathTextField;
    private DataLocationBlock dataLocationBlock;
    private ILaunchConfigurationListener launchConfigListener;

    public RapAUTMainTab(RcpttRapTabGroup group) {
        GridData gridData = new GridData(4, 0x1000000, true, false);
        this.fillHorizontal = GridDataFactory.createFrom((GridData)gridData);
        this.selectionListener = this.createDialogSelectionListener();
        this.modifyListener = this.createDialogModifyListener();
        this.fImage = PDEPluginImages.DESC_MAIN_TAB.createImage();
        this.createLocationBlock();
        this.addLaunchConfigListener();
    }

    public Image getImage() {
        return this.fImage;
    }

    private ModifyListener createDialogModifyListener() {
        ModifyListener result = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                RapAUTMainTab.this.updateLaunchConfigurationDialog();
            }
        };
        return result;
    }

    public void dispose() {
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.removeLaunchConfigurationListener(this.launchConfigListener);
        super.dispose();
    }

    private void createLocationBlock() {
        this.fLocationBlock = new AUTLocationBlock(this);
    }

    public void createControl(Composite parent) {
        final ScrolledComposite scrollContainer = new ScrolledComposite(parent, 512);
        scrollContainer.setLayoutData((Object)new GridData(768));
        Composite composite = new Composite((Composite)scrollContainer, 0);
        scrollContainer.setContent((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        this.fLocationBlock.createControl(composite);
        this.createBrowserModeSection(composite);
        this.createRuntimeSettingsSection(composite);
        this.createDataLocationSection(composite);
        Listener listener = new Listener(){

            public void handleEvent(Event e) {
                Control child = (Control)e.widget;
                Rectangle bounds = child.getBounds();
                Rectangle area = scrollContainer.getClientArea();
                Point origin = scrollContainer.getOrigin();
                if (origin.x > bounds.x) {
                    origin.x = Math.max(0, bounds.x);
                }
                if (origin.y > bounds.y) {
                    origin.y = Math.max(0, bounds.y);
                }
                if (origin.x + area.width < bounds.x + bounds.width) {
                    origin.x = Math.max(0, bounds.x + bounds.width - area.width);
                }
                if (origin.y + area.height < bounds.y + bounds.height) {
                    origin.y = Math.max(0, bounds.y + bounds.height - area.height);
                }
                scrollContainer.setOrigin(origin);
            }
        };
        Control[] controls = composite.getChildren();
        int i = 0;
        while (i < controls.length) {
            controls[i].addListener(26, listener);
            ++i;
        }
        Dialog.applyDialogFont((Control)composite);
        composite.setSize(composite.computeSize(-1, -1));
        scrollContainer.setExpandHorizontal(true);
        this.setControl((Control)scrollContainer);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.pde.doc.user.launcher_basic");
    }

    public void initializeFrom(ILaunchConfiguration config) {
        try {
            this.fLocationBlock.initializeFrom(config);
            RAPLaunchConfig rapConfig = new RAPLaunchConfig(config);
            this.servletPathTextField.setText(rapConfig.getServletPath());
            this.useFixedPortCheckBox.setSelection(rapConfig.getUseManualPort());
            this.portSpinner.setSelection(rapConfig.getPort());
            this.contextPathCheckBox.setSelection(rapConfig.getUseManualContextPath());
            this.contextPathTextField.setText(rapConfig.getContextPath());
            boolean openBrowser = rapConfig.getOpenBrowser();
            this.internalBrowserRadioButton.setEnabled(openBrowser);
            this.externalBrowserRadioButton.setEnabled(openBrowser);
            if (RAPLaunchConfig.BrowserMode.EXTERNAL.equals(rapConfig.getBrowserMode())) {
                this.externalBrowserRadioButton.setSelection(true);
                this.internalBrowserRadioButton.setSelection(false);
            } else {
                this.externalBrowserRadioButton.setSelection(false);
                this.internalBrowserRadioButton.setSelection(true);
            }
            this.useSessionTimeoutCheckBox.setSelection(rapConfig.getUseSessionTimeout());
            this.sessionTimeoutSpinner.setSelection(rapConfig.getSessionTimeout());
            this.dataLocationBlock.initializeFrom(rapConfig);
        }
        catch (CoreException e) {
            Activator.log(e);
        }
    }

    void setStatus(final IStatus status) {
        Shell shell;
        if (!status.isOK() && !status.matches(8)) {
            Q7ExtLaunchingPlugin.log((IStatus)status);
        }
        if ((shell = this.getShell()) == null) {
            return;
        }
        if (shell.getDisplay() != null) {
            shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (status.isOK()) {
                        RapAUTMainTab.this.setErrorMessage(null);
                        RapAUTMainTab.this.setMessage(null);
                    } else if (status.matches(4)) {
                        RapAUTMainTab.this.setMessage(null);
                        RapAUTMainTab.this.setErrorMessage(status.getMessage());
                    } else {
                        RapAUTMainTab.this.setMessage(status.getMessage());
                        RapAUTMainTab.this.setErrorMessage(null);
                    }
                }
            });
        }
    }

    public void validateTab() {
        if (this.getErrorMessage() == null) {
            this.setStatus(this.fLocationBlock.getStatus());
        }
    }

    public void performApply(ILaunchConfigurationWorkingCopy config) {
        try {
            this.fLocationBlock.performApply(config);
            RAPLaunchConfig rapConfig = new RAPLaunchConfig((ILaunchConfiguration)config);
            rapConfig.setServletPath(this.servletPathTextField.getText());
            rapConfig.setOpenBrowser(true);
            rapConfig.setBrowserMode(this.getBrowserMode());
            this.portSpinner.setEnabled(this.useFixedPortCheckBox.getSelection());
            rapConfig.setUseManualPort(this.useFixedPortCheckBox.getSelection());
            rapConfig.setPort(this.portSpinner.getSelection());
            this.contextPathTextField.setEnabled(this.contextPathCheckBox.getSelection());
            rapConfig.setUseManualContextPath(this.contextPathCheckBox.getSelection());
            rapConfig.setContextPath(this.contextPathTextField.getText());
            this.sessionTimeoutSpinner.setEnabled(this.useSessionTimeoutCheckBox.getSelection());
            rapConfig.setUseSessionTimeout(this.useSessionTimeoutCheckBox.getSelection());
            rapConfig.setSessionTimeout(this.sessionTimeoutSpinner.getSelection());
            rapConfig.setDataLocation(this.dataLocationBlock.getLocation());
            boolean useDefaultDataLocation = this.dataLocationBlock.getUseDefaultDataLocation();
            rapConfig.setUseDefaultDataLocation(useDefaultDataLocation);
            rapConfig.setDoClearDataLocation(this.dataLocationBlock.getDoClearDataLocation());
            rapConfig.setAskClearDataLocation(false);
            this.setDirty(true);
        }
        catch (CoreException e) {
            this.setStatus(e.getStatus());
        }
    }

    private void validate(RAPLaunchConfig config) {
        IStatus locationStatus = this.fLocationBlock.getStatus();
        if (!locationStatus.isOK()) {
            this.setStatus(locationStatus);
            return;
        }
        RAPLaunchConfigValidator validator = new RAPLaunchConfigValidator(config);
        IStatus[] states = validator.validate();
        String infoMessage = RapAUTMainTab.findMessage(states, 1);
        String warnMessage = RapAUTMainTab.findMessage(states, 2);
        String errorMessage = RapAUTMainTab.findMessage(states, 4);
        if (warnMessage != null) {
            this.setMessage(warnMessage);
        } else {
            this.setMessage(infoMessage);
        }
        this.setErrorMessage(errorMessage);
    }

    private static String findMessage(IStatus[] states, int severity) {
        String result = null;
        int i = 0;
        while (result == null && i < states.length) {
            if (states[i].matches(severity)) {
                result = states[i].getMessage();
            }
            ++i;
        }
        return result;
    }

    private RAPLaunchConfig.BrowserMode getBrowserMode() {
        boolean selection = this.externalBrowserRadioButton.getSelection();
        return selection ? RAPLaunchConfig.BrowserMode.EXTERNAL : RAPLaunchConfig.BrowserMode.INTERNAL;
    }

    public void setCurrentTargetPlatform(ITargetPlatformHelper info) {
        this.currentTargetPlatform = info;
    }

    public ITargetPlatformHelper getTarget() {
        return this.currentTargetPlatform;
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        RAPLaunchConfig.setDefaults((ILaunchConfigurationWorkingCopy)config);
    }

    public String getName() {
        return "&Main";
    }

    public void createBrowserModeSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText("Open in Browser");
        group.setLayout((Layout)new GridLayout());
        this.createBrowserActivationPart((Composite)group);
        this.createServletPathPart((Composite)group);
    }

    private void createBrowserActivationPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.fillHorizontal.span(2, 1).create());
        GridLayout layout = new GridLayout(2, false);
        layout.horizontalSpacing = 10;
        layout.verticalSpacing = 0;
        composite.setLayout((Layout)layout);
        Link browserPrefsLink = this.createBrowserPrefsLink(composite);
        browserPrefsLink.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        Composite modePart = this.createBrowserModePart(composite);
        modePart.setLayoutData((Object)GridDataFactory.fillDefaults().span(2, 1).indent(17, 0).create());
    }

    private Link createBrowserPrefsLink(Composite composite) {
        Link link = new Link(composite, 0);
        link.setText("<a>Configure Browsers...</a>");
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                RapAUTMainTab.this.openBrowserPrefs();
            }
        });
        return link;
    }

    private void openBrowserPrefs() {
        PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)this.getShell(), (String)BROWSER_PREFERENCE_PAGE, null, null);
        dialog.open();
        dialog.close();
    }

    private Composite createBrowserModePart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new RowLayout(256));
        this.internalBrowserRadioButton = new Button(composite, 16);
        this.internalBrowserRadioButton.setText("I&nternal web  browser");
        this.internalBrowserRadioButton.addSelectionListener(this.selectionListener);
        this.externalBrowserRadioButton = new Button(composite, 16);
        this.externalBrowserRadioButton.setText("E&xternal web  browser");
        this.externalBrowserRadioButton.addSelectionListener(this.selectionListener);
        return composite;
    }

    private void createServletPathPart(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.fillHorizontal.create());
        composite.setLayout((Layout)new GridLayout(2, false));
        Label lblServletPath = new Label(composite, 0);
        lblServletPath.setText("&Servlet path:");
        this.servletPathTextField = new Text(composite, 2048);
        this.servletPathTextField.addModifyListener(this.modifyListener);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.servletPathTextField);
        Label finalUrlLabel = new Label(composite, 0);
        finalUrlLabel.setText("Application URL:");
        this.applicationUrlTextField = new Text(composite, 12);
        this.applicationUrlTextField.setBackground(this.applicationUrlTextField.getParent().getBackground());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.applicationUrlTextField);
    }

    private SelectionAdapter createDialogSelectionListener() {
        SelectionAdapter result = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RapAUTMainTab.this.updateLaunchConfigurationDialog();
            }
        };
        return result;
    }

    private void createRuntimeSettingsSection(Composite parent) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)this.fillHorizontal.create());
        group.setText("Server Settings");
        group.setLayout((Layout)new GridLayout(4, false));
        this.useFixedPortCheckBox = new Button((Composite)group, 32);
        this.useFixedPortCheckBox.setText("Use a fixed &port:");
        this.useFixedPortCheckBox.addSelectionListener(this.selectionListener);
        this.portSpinner = new Spinner((Composite)group, 2048);
        this.portSpinner.setLayoutData((Object)new GridData(4, -1, true, false));
        this.portSpinner.setMinimum(0);
        this.portSpinner.setMaximum(65535);
        this.portSpinner.addModifyListener(this.modifyListener);
        this.useSessionTimeoutCheckBox = new Button((Composite)group, 32);
        GridDataFactory.fillDefaults().indent(25, 0).applyTo((Control)this.useSessionTimeoutCheckBox);
        this.useSessionTimeoutCheckBox.setText("Session &timeout [s]:");
        this.useSessionTimeoutCheckBox.addSelectionListener(this.selectionListener);
        this.sessionTimeoutSpinner = new Spinner((Composite)group, 2048);
        this.sessionTimeoutSpinner.setLayoutData((Object)new GridData(4, -1, true, false));
        this.sessionTimeoutSpinner.setMinimum(0);
        this.sessionTimeoutSpinner.setMaximum(Integer.MAX_VALUE);
        this.sessionTimeoutSpinner.addModifyListener(this.modifyListener);
        this.contextPathCheckBox = new Button((Composite)group, 32);
        this.contextPathCheckBox.setText("Context pat&h:");
        this.contextPathCheckBox.addSelectionListener(this.selectionListener);
        this.contextPathTextField = new Text((Composite)group, 2052);
        GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.contextPathTextField);
        this.contextPathTextField.addModifyListener(this.modifyListener);
    }

    private void createDataLocationSection(Composite container) {
        this.dataLocationBlock = new DataLocationBlock(this);
        Control blockControl = this.dataLocationBlock.createControl(container);
        blockControl.setLayoutData((Object)new GridData(768));
    }

    private void addLaunchConfigListener() {
        this.launchConfigListener = this.getLaunchConfigListener();
        ILaunchManager launchManager = this.getLaunchManager();
        launchManager.addLaunchConfigurationListener(this.launchConfigListener);
    }

    private ILaunchConfigurationListener getLaunchConfigListener() {
        ILaunchConfigurationListener result = new ILaunchConfigurationListener(){

            public void launchConfigurationChanged(ILaunchConfiguration configuration) {
                RAPLaunchConfig rapConfig = new RAPLaunchConfig(configuration);
                RapAUTMainTab.this.validate(rapConfig);
                RapAUTMainTab.this.updateApplicationUrl(rapConfig);
            }

            public void launchConfigurationAdded(ILaunchConfiguration configuration) {
            }

            public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
            }
        };
        return result;
    }

    private void updateApplicationUrl(RAPLaunchConfig config) {
        String applicationUrl;
        try {
            applicationUrl = this.getApplicationUrl(config);
        }
        catch (Exception e) {
            this.setErrorMessage(e.getMessage());
            applicationUrl = "";
        }
        this.udpateApplicationUrlTextField(applicationUrl);
    }

    private String getApplicationUrl(RAPLaunchConfig config) throws CoreException {
        String result;
        if (config.getUseManualPort()) {
            int port = config.getPort();
            result = RapAUTMainTab.fromLaunchConfig(config, Integer.toString(port), false);
        } else {
            result = RapAUTMainTab.fromLaunchConfig(config, "<PORT>", false);
        }
        return result;
    }

    private void udpateApplicationUrlTextField(final String finalApplicationUrl) {
        if (this.applicationUrlTextField != null && !this.applicationUrlTextField.isDisposed()) {
            this.applicationUrlTextField.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    if (!finalApplicationUrl.equals(RapAUTMainTab.this.applicationUrlTextField.getText())) {
                        RapAUTMainTab.this.applicationUrlTextField.setText(finalApplicationUrl);
                    }
                }
            });
        }
    }

    public static String fromLaunchConfig(RAPLaunchConfig config, String port, boolean testMode) throws CoreException {
        String path = RapAUTMainTab.getUrlPath(config);
        return "http://127.0.0.1:" + port + path;
    }

    private static String getUrlPath(RAPLaunchConfig config) throws CoreException {
        String contextPath = RapAUTMainTab.getContextPath(config);
        String servletPath = RapAUTMainTab.getServletPath(config);
        StringBuffer buffer = new StringBuffer();
        buffer.append(SLASH);
        if (!"".equals(contextPath)) {
            buffer.append(contextPath);
            buffer.append(SLASH);
        }
        buffer.append(servletPath);
        return buffer.toString();
    }

    private static String getServletPath(RAPLaunchConfig config) throws CoreException {
        String servletPath = config.getServletPath();
        return RapAUTMainTab.stripLeadingAndTrailingSlashes(servletPath);
    }

    private static String getContextPath(RAPLaunchConfig config) throws CoreException {
        String contextPath = "";
        if (config.getUseManualContextPath()) {
            contextPath = config.getContextPath();
        }
        return RapAUTMainTab.stripLeadingAndTrailingSlashes(contextPath);
    }

    private static String stripLeadingAndTrailingSlashes(String input) {
        String result = input;
        if (result.startsWith(SLASH)) {
            result = result.substring(1);
        }
        if (result.endsWith(SLASH)) {
            result = result.substring(0, result.length() - 1);
        }
        return result;
    }
}

