/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.search.dependencies.UnusedImportsDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListDialog;

public class ShowResultsAction
extends Action {
    private IPluginModelBase fModel;
    Object[] fUnusedImports;
    private boolean fReadOnly;

    public ShowResultsAction(IPluginModelBase model, Object[] unused, boolean readOnly) {
        this.fModel = model;
        this.fUnusedImports = unused;
        this.fReadOnly = readOnly;
    }

    public void run() {
        if (this.fUnusedImports.length == 0) {
            MessageDialog.openInformation((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEUIMessages.UnusedDependencies_title, (String)PDEUIMessages.UnusedDependencies_notFound);
        } else {
            Object dialog;
            if (this.fReadOnly) {
                dialog = this.getUnusedDependeciesInfoDialog();
            } else {
                dialog = new UnusedImportsDialog(PDEPlugin.getActiveWorkbenchShell(), this.fModel, this.fUnusedImports);
                dialog.create();
            }
            dialog.getShell().setText(PDEUIMessages.UnusedDependencies_title);
            dialog.open();
        }
    }

    private Dialog getUnusedDependeciesInfoDialog() {
        ListDialog dialog = new ListDialog(PDEPlugin.getActiveWorkbenchShell());
        dialog.setAddCancelButton(false);
        dialog.setContentProvider(new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return ShowResultsAction.this.fUnusedImports;
            }
        });
        dialog.setLabelProvider((ILabelProvider)PDEPlugin.getDefault().getLabelProvider());
        dialog.setInput((Object)this);
        dialog.create();
        dialog.getTableViewer().setComparator((ViewerComparator)new UnusedImportsDialog.Comparator());
        return dialog;
    }
}

