/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source.inlined;

import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.inlined.AbstractInlinedAnnotation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;

public class LineContentAnnotation
extends AbstractInlinedAnnotation {
    private int width;
    private int redrawnCharacterWidth;

    public LineContentAnnotation(Position position, ISourceViewer viewer) {
        super(position, viewer);
    }

    public final int getWidth() {
        return this.width;
    }

    @Override
    public final void draw(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        this.width = this.drawAndComputeWidth(gc, textWidget, offset, length, color, x, y);
    }

    protected int drawAndComputeWidth(GC gc, StyledText textWidget, int offset, int length, Color color, int x, int y) {
        super.draw(gc, textWidget, offset, length, color, x, y);
        return gc.stringExtent((String)this.getText()).x + 2 * gc.getFontMetrics().getAverageCharWidth();
    }

    int getRedrawnCharacterWidth() {
        return this.redrawnCharacterWidth;
    }

    void setRedrawnCharacterWidth(int redrawnCharacterWidth) {
        this.redrawnCharacterWidth = redrawnCharacterWidth;
    }

    @Override
    boolean contains(int x, int y) {
        return x >= this.fX && x <= this.fX + this.width && y >= this.fY && y <= this.fY + this.getTextWidget().getLineHeight();
    }
}

