/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.JDTQuickMenuCreator;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.javaeditor.JavaTextSelection;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IPartService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowPulldownDelegate2;
import org.eclipse.ui.actions.RetargetAction;

public class OccurrencesSearchMenuAction
implements IWorkbenchWindowPulldownDelegate2 {
    private static Action NO_ACTION_AVAILABLE = new Action(ActionMessages.OccurrencesSearchMenuAction_no_entries_available){

        public boolean isEnabled() {
            return false;
        }
    };
    private Menu fMenu;
    private IPartService fPartService;
    private RetargetAction[] fRetargetActions;

    public Menu getMenu(Menu parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu(this.fMenu);
        return this.fMenu;
    }

    public Menu getMenu(Control parent) {
        this.setMenu(new Menu(parent));
        this.fillMenu(this.fMenu);
        this.initMenu(this.fMenu);
        return this.fMenu;
    }

    protected void initMenu(Menu menu) {
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent e) {
                Menu m = (Menu)e.widget;
                MenuItem[] items = m.getItems();
                int i = 0;
                while (i < items.length) {
                    items[i].dispose();
                    ++i;
                }
                OccurrencesSearchMenuAction.this.fillMenu(m);
            }
        });
    }

    public void dispose() {
        this.setMenu(null);
        this.disposeSubmenuActions();
    }

    private RetargetAction createSubmenuAction(IPartService partService, String actionID, String text, String actionDefinitionId) {
        RetargetAction action = new RetargetAction(actionID, text);
        action.setActionDefinitionId(actionDefinitionId);
        partService.addPartListener((IPartListener)action);
        IWorkbenchPart activePart = partService.getActivePart();
        if (activePart != null) {
            action.partActivated(activePart);
        }
        return action;
    }

    private void disposeSubmenuActions() {
        if (this.fPartService != null && this.fRetargetActions != null) {
            int i = 0;
            while (i < this.fRetargetActions.length) {
                this.fPartService.removePartListener((IPartListener)this.fRetargetActions[i]);
                this.fRetargetActions[i].dispose();
                ++i;
            }
        }
        this.fRetargetActions = null;
        this.fPartService = null;
    }

    public void init(IWorkbenchWindow window) {
        this.disposeSubmenuActions();
        if (window != null) {
            this.fPartService = window.getPartService();
            if (this.fPartService != null) {
                this.fRetargetActions = new RetargetAction[]{this.createSubmenuAction(this.fPartService, "org.eclipse.jdt.ui.actions.OccurrencesInFile", ActionMessages.OccurrencesSearchMenuAction_occurrences_in_file_label, "org.eclipse.jdt.ui.edit.text.java.search.occurrences.in.file"), this.createSubmenuAction(this.fPartService, "org.eclipse.jdt.ui.actions.ImplementOccurrences", ActionMessages.OccurrencesSearchMenuAction_implementing_methods_label, "org.eclipse.jdt.ui.edit.text.java.search.implement.occurrences"), this.createSubmenuAction(this.fPartService, "org.eclipse.jdt.ui.actions.ExceptionOccurrences", ActionMessages.OccurrencesSearchMenuAction_throwing_exception_label, "org.eclipse.jdt.ui.edit.text.java.search.exception.occurrences"), this.createSubmenuAction(this.fPartService, "org.eclipse.jdt.ui.actions.MethodExitOccurrences", ActionMessages.OccurrencesSearchMenuAction_method_exits_label, "org.eclipse.jdt.ui.edit.text.java.search.method.exits"), this.createSubmenuAction(this.fPartService, "org.eclipse.jdt.ui.actions.BreakContinueTargetOccurrences", ActionMessages.OccurrencesSearchMenuAction_break_continue_target_label, "org.eclipse.jdt.ui.edit.text.java.search.return.continue.targets")};
            }
        }
    }

    public void run(IAction a) {
        JavaEditor editor;
        ISelection selection;
        if (this.fRetargetActions == null) {
            return;
        }
        IWorkbenchPart activePart = JavaPlugin.getActivePage().getActivePart();
        if (activePart instanceof JavaEditor) {
            selection = this.getEditorSelection((JavaEditor)activePart);
            if (selection == null) {
                return;
            }
            editor = selection instanceof ITextSelection ? (JavaEditor)activePart : null;
        } else {
            editor = null;
            selection = activePart.getSite().getSelectionProvider().getSelection();
        }
        final ArrayList<IAction> activeActions = new ArrayList<IAction>(this.fRetargetActions.length);
        int i = 0;
        while (i < this.fRetargetActions.length) {
            RetargetAction action = this.fRetargetActions[i];
            IAction actionHandler = action.getActionHandler();
            if (actionHandler instanceof SelectionDispatchAction) {
                ((SelectionDispatchAction)actionHandler).update(selection);
                if (actionHandler.isEnabled()) {
                    activeActions.add(actionHandler);
                }
            }
            ++i;
        }
        if (activeActions.size() == 1) {
            ((IAction)activeActions.get(0)).run();
        } else {
            new JDTQuickMenuCreator(editor){

                protected void fillMenu(IMenuManager menu) {
                    OccurrencesSearchMenuAction.this.fillQuickMenu(menu, activeActions);
                }
            }.createMenu();
        }
    }

    private void updateActions() {
        IWorkbenchPart activePart = JavaPlugin.getActivePage().getActivePart();
        if (!(activePart instanceof JavaEditor)) {
            return;
        }
        ISelection javaSelection = this.getEditorSelection((JavaEditor)activePart);
        if (javaSelection == null) {
            return;
        }
        int i = 0;
        while (i < this.fRetargetActions.length) {
            RetargetAction action = this.fRetargetActions[i];
            IAction actionHandler = action.getActionHandler();
            if (actionHandler instanceof SelectionDispatchAction) {
                ((SelectionDispatchAction)actionHandler).update(javaSelection);
            }
            ++i;
        }
    }

    private ISelection getEditorSelection(JavaEditor editor) {
        ITypeRoot element = SelectionConverter.getInput(editor);
        if (element == null) {
            return null;
        }
        if (editor.isBreadcrumbActive()) {
            return editor.getBreadcrumb().getSelectionProvider().getSelection();
        }
        ITextSelection textSelection = (ITextSelection)editor.getSelectionProvider().getSelection();
        IDocument document = JavaUI.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        return new JavaTextSelection(element, document, textSelection.getOffset(), textSelection.getLength());
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void fillQuickMenu(IMenuManager manager, List<IAction> activeActions) {
        if (activeActions.isEmpty()) {
            manager.add((IAction)NO_ACTION_AVAILABLE);
        } else {
            int i = 0;
            while (i < activeActions.size()) {
                manager.add(activeActions.get(i));
                ++i;
            }
        }
    }

    public void fillMenu(Menu menu) {
        if (this.fRetargetActions != null) {
            this.updateActions();
            int i = 0;
            while (i < this.fRetargetActions.length) {
                ActionContributionItem item = new ActionContributionItem((IAction)this.fRetargetActions[i]);
                item.fill(menu, -1);
                ++i;
            }
        } else {
            ActionContributionItem item = new ActionContributionItem((IAction)NO_ACTION_AVAILABLE);
            item.fill(menu, -1);
        }
    }

    private void setMenu(Menu menu) {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
        this.fMenu = menu;
    }
}

