/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.target;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.pde.core.target.ITargetDefinition;
import org.eclipse.pde.core.target.ITargetHandle;
import org.eclipse.pde.core.target.ITargetPlatformService;
import org.eclipse.pde.internal.core.TargetPlatformHelper;
import org.eclipse.pde.internal.core.target.TargetDefinition;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionContentPage;
import org.eclipse.pde.internal.ui.wizards.target.TargetDefinitionPage;

public class EditTargetDefinitionWizard
extends Wizard {
    private ITargetDefinition fDefinition;

    public EditTargetDefinitionWizard(ITargetDefinition definition, boolean createWorkingCopy) {
        this.setTargetDefinition(definition, createWorkingCopy);
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        HashMap targetFlagMap = TargetPlatformHelper.getTargetDefinitionMap();
        for (Map.Entry entry : targetFlagMap.entrySet()) {
            if (!((ITargetHandle)entry.getKey()).equals(this.fDefinition.getHandle())) continue;
            List targets = (List)targetFlagMap.get(this.fDefinition.getHandle());
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                TargetDefinition target = (TargetDefinition)iterator.next();
                if (target.equals(this.fDefinition)) continue;
                iterator.remove();
            }
        }
        return true;
    }

    public boolean performCancel() {
        HashMap targetFlagMap = TargetPlatformHelper.getTargetDefinitionMap();
        for (Map.Entry entry : targetFlagMap.entrySet()) {
            if (!((ITargetHandle)entry.getKey()).equals(this.fDefinition.getHandle())) continue;
            List targets = (List)targetFlagMap.get(this.fDefinition.getHandle());
            Iterator iterator = targets.iterator();
            while (iterator.hasNext()) {
                TargetDefinition target = (TargetDefinition)iterator.next();
                if (!target.equals(this.fDefinition)) continue;
                iterator.remove();
            }
        }
        return true;
    }

    public void addPages() {
        this.addPage((IWizardPage)new TargetDefinitionContentPage(this.fDefinition));
    }

    public void setTargetDefinition(ITargetDefinition definition, boolean createWorkingCopy) {
        ITargetDefinition workingCopy = null;
        if (createWorkingCopy) {
            try {
                ITargetPlatformService service = TargetDefinitionPage.getTargetService();
                if (service != null) {
                    workingCopy = definition.getHandle().exists() ? definition.getHandle().getTargetDefinition() : service.newTarget();
                    service.copyTargetDefinition(definition, workingCopy);
                }
            }
            catch (CoreException e) {
                PDEPlugin.log(e);
            }
        } else {
            workingCopy = definition;
        }
        this.fDefinition = workingCopy;
        IWizardPage[] pages = this.getPages();
        int i = 0;
        while (i < pages.length) {
            ((TargetDefinitionPage)pages[i]).targetChanged(workingCopy);
            ++i;
        }
    }

    public ITargetDefinition getTargetDefinition() {
        return this.fDefinition;
    }
}

