/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IBaseModel;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractPDEMarkerResolution;

public class RemoveStaticProjectReferences
extends AbstractPDEMarkerResolution {
    public RemoveStaticProjectReferences(int type) {
        super(type);
    }

    @Override
    public String getDescription() {
        return PDEUIMessages.RemoveBuildOrderEntries_desc;
    }

    public String getLabel() {
        return PDEUIMessages.RemoveBuildOrderEntries_label;
    }

    @Override
    public void run(IMarker marker) {
        try {
            IProject project = marker.getResource().getProject();
            if (project == null) {
                return;
            }
            IProjectDescription projDesc = project.getDescription();
            if (projDesc == null) {
                return;
            }
            projDesc.setReferencedProjects(new IProject[0]);
            project.setDescription(projDesc, null);
        }
        catch (CoreException coreException) {}
    }

    @Override
    protected void createChange(IBaseModel model) {
    }
}

