/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.api.tools.internal.search;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.internal.core.util.ILRUCacheable;
import org.eclipse.pde.api.tools.internal.search.IReferenceCollection;
import org.eclipse.pde.api.tools.internal.search.IReferenceDescriptor;

public class UseScanReferences
implements ILRUCacheable,
IReferenceCollection {
    Map<String, List<IReferenceDescriptor>> fReferencesMap = new HashMap<String, List<IReferenceDescriptor>>();

    @Override
    public void add(String type, IReferenceDescriptor refDesc) {
        List<IReferenceDescriptor> refDescList = this.fReferencesMap.get(type);
        if (refDescList == null) {
            refDescList = new ArrayList<IReferenceDescriptor>();
            this.fReferencesMap.put(type, refDescList);
        }
        if (!refDescList.contains(refDesc)) {
            refDescList.add(refDesc);
        }
    }

    @Override
    public boolean hasReferencesTo(String type) {
        List<IReferenceDescriptor> refDescList = this.fReferencesMap.get(type);
        return refDescList != null && refDescList.size() > 0;
    }

    @Override
    public IReferenceDescriptor[] getExternalDependenciesTo(String[] types) {
        if (types == null || types.length == 0) {
            return new IReferenceDescriptor[0];
        }
        ArrayList<IReferenceDescriptor> referenceDescriptorList = new ArrayList<IReferenceDescriptor>();
        String[] stringArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            String type = stringArray[n2];
            List<IReferenceDescriptor> refDescs = this.fReferencesMap.get(type);
            if (refDescs != null && refDescs.size() != 0) {
                referenceDescriptorList.addAll(refDescs);
            }
            ++n2;
        }
        return referenceDescriptorList.toArray(new IReferenceDescriptor[referenceDescriptorList.size()]);
    }

    @Override
    public IReferenceDescriptor[] getAllExternalDependencies() {
        ArrayList<IReferenceDescriptor> allRefDescs = new ArrayList<IReferenceDescriptor>();
        for (List<IReferenceDescriptor> refDescList : this.fReferencesMap.values()) {
            allRefDescs.addAll(refDescList);
        }
        return allRefDescs.toArray(new IReferenceDescriptor[allRefDescs.size()]);
    }

    public int getCacheFootprint() {
        return this.fReferencesMap.size();
    }

    @Override
    public void clear() {
        this.fReferencesMap.clear();
    }
}

