/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.synchronize.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.egit.core.synchronize.GitCommitsModelCache;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelBlob;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObjectContainer;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelTree;
import org.eclipse.jgit.lib.Repository;

class TreeBuilder {
    TreeBuilder() {
    }

    public static GitModelObject[] build(GitModelObjectContainer root, Repository repo, Map<String, GitCommitsModelCache.Change> changes, FileModelFactory fileFactory, TreeModelFactory treeFactory) {
        if (changes == null || changes.isEmpty()) {
            return new GitModelObject[0];
        }
        Path rootPath = new Path(repo.getWorkTree().getAbsolutePath());
        ArrayList<GitModelBlob> rootChildren = new ArrayList<GitModelBlob>();
        HashMap<Path, Node> nodes = new HashMap<Path, Node>();
        for (Map.Entry<String, GitCommitsModelCache.Change> entry : changes.entrySet()) {
            String repoRelativePath = entry.getKey();
            GitCommitsModelCache.Change change = entry.getValue();
            GitModelObjectContainer parent = root;
            List<GitModelTree> children = rootChildren;
            Path path = rootPath;
            String[] segments = repoRelativePath.split("/");
            int i = 0;
            while (i < segments.length) {
                boolean fileNode;
                path = path.append(segments[i]);
                boolean bl = fileNode = i == segments.length - 1;
                if (!fileNode) {
                    Node node = (Node)nodes.get(path);
                    if (node == null) {
                        GitModelTree tree = treeFactory.createTreeModel(parent, (IPath)path, change.getKind());
                        node = new Node(tree);
                        nodes.put(path, node);
                        children.add(tree);
                    }
                    parent = node.tree;
                    children = node.children;
                } else {
                    GitModelBlob file = fileFactory.createFileModel(parent, repo, change, (IPath)path);
                    children.add((GitModelTree)((Object)file));
                }
                ++i;
            }
        }
        for (Node object : nodes.values()) {
            GitModelTree tree = object.tree;
            tree.setChildren(object.children);
        }
        return rootChildren.toArray(new GitModelObject[rootChildren.size()]);
    }

    static interface FileModelFactory {
        public GitModelBlob createFileModel(GitModelObjectContainer var1, Repository var2, GitCommitsModelCache.Change var3, IPath var4);

        public boolean isWorkingTree();
    }

    private static class Node {
        private final GitModelTree tree;
        private final List<GitModelObject> children = new ArrayList<GitModelObject>();

        public Node(GitModelTree tree) {
            this.tree = tree;
        }
    }

    static interface TreeModelFactory {
        public GitModelTree createTreeModel(GitModelObjectContainer var1, IPath var2, int var3);
    }
}

