/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.icu.text;

import com.ibm.icu.impl.ICUBinary;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.CharacterIterator;

class BreakCTDictionary {
    private CompactTrieHeader fData;
    private CompactTrieNodes[] nodes;
    private static final int DATA_FORMAT_ID = 1416774755;

    private CompactTrieNodes getCompactTrieNode(int node) {
        return this.nodes[node];
    }

    public BreakCTDictionary(ByteBuffer bytes) throws IOException {
        ICUBinary.readHeader(bytes, 1416774755, null);
        this.fData = new CompactTrieHeader();
        this.fData.size = bytes.getInt();
        this.fData.magic = bytes.getInt();
        this.fData.nodeCount = bytes.getShort();
        this.fData.root = bytes.getShort();
        this.loadBreakCTDictionary(bytes);
    }

    private void loadBreakCTDictionary(ByteBuffer bytes) throws IOException {
        int i = 0;
        while (i < this.fData.nodeCount) {
            bytes.getInt();
            ++i;
        }
        this.nodes = new CompactTrieNodes[this.fData.nodeCount];
        this.nodes[0] = new CompactTrieNodes();
        int j = 1;
        while (j < this.fData.nodeCount) {
            this.nodes[j] = new CompactTrieNodes();
            this.nodes[j].flagscount = bytes.getShort();
            int count = this.nodes[j].flagscount & 0xFFF;
            if (count != 0) {
                boolean isVerticalNode;
                boolean bl = isVerticalNode = (this.nodes[j].flagscount & 0x1000) != 0;
                if (isVerticalNode) {
                    this.nodes[j].vnode = new CompactTrieVerticalNode();
                    this.nodes[j].vnode.equal = bytes.getShort();
                    this.nodes[j].vnode.chars = new char[count];
                    int l = 0;
                    while (l < count) {
                        this.nodes[j].vnode.chars[l] = bytes.getChar();
                        ++l;
                    }
                } else {
                    this.nodes[j].hnode = new CompactTrieHorizontalNode[count];
                    int n = 0;
                    while (n < count) {
                        this.nodes[j].hnode[n] = new CompactTrieHorizontalNode(bytes.getChar(), bytes.getShort());
                        ++n;
                    }
                }
            }
            ++j;
        }
    }

    public int matches(CharacterIterator text, int maxLength, int[] lengths, int[] count, int limit) {
        CompactTrieNodes node = this.getCompactTrieNode(this.fData.root);
        int mycount = 0;
        char uc = text.current();
        int i = 0;
        boolean exitFlag = false;
        block0: while (node != null) {
            int nodeCount;
            if (limit > 0 && (node.flagscount & 0x2000) != 0) {
                lengths[mycount++] = i;
                --limit;
            }
            if (i >= maxLength || (nodeCount = node.flagscount & 0xFFF) == 0) break;
            if ((node.flagscount & 0x1000) != 0) {
                CompactTrieVerticalNode vnode = node.vnode;
                int j = 0;
                while (j < nodeCount && i < maxLength) {
                    if (uc != vnode.chars[j]) {
                        exitFlag = true;
                        break;
                    }
                    text.next();
                    uc = text.current();
                    ++i;
                    ++j;
                }
                if (exitFlag) break;
                node = this.getCompactTrieNode(vnode.equal);
                continue;
            }
            CompactTrieHorizontalNode[] hnode = node.hnode;
            int low = 0;
            int high = nodeCount - 1;
            node = null;
            while (high >= low) {
                int middle = high + low >>> 1;
                if (uc == hnode[middle].ch) {
                    node = this.getCompactTrieNode(hnode[middle].equal);
                    text.next();
                    uc = text.current();
                    ++i;
                    continue block0;
                }
                if (uc < hnode[middle].ch) {
                    high = middle - 1;
                    continue;
                }
                low = middle + 1;
            }
        }
        count[0] = mycount;
        return i;
    }

    static class CompactTrieHeader {
        int size = 0;
        int magic = 0;
        int nodeCount = 0;
        int root = 0;
        int[] offset = null;

        CompactTrieHeader() {
        }
    }

    static class CompactTrieHorizontalNode {
        char ch;
        int equal;

        CompactTrieHorizontalNode(char newCh, int newEqual) {
            this.ch = newCh;
            this.equal = newEqual;
        }
    }

    static final class CompactTrieNodeFlags {
        static final int kVerticalNode = 4096;
        static final int kParentEndsWord = 8192;
        static final int kReservedFlag1 = 16384;
        static final int kReservedFlag2 = 32768;
        static final int kCountMask = 4095;
        static final int kFlagMask = 61440;

        CompactTrieNodeFlags() {
        }
    }

    static class CompactTrieNodes {
        short flagscount = 0;
        CompactTrieHorizontalNode[] hnode = null;
        CompactTrieVerticalNode vnode = null;

        CompactTrieNodes() {
        }
    }

    static class CompactTrieVerticalNode {
        int equal = 0;
        char[] chars = null;

        CompactTrieVerticalNode() {
        }
    }
}

