/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.swt.util;

import org.eclipse.rcptt.tesla.internal.ui.player.PlayerTextUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.PlayerWrapUtils;
import org.eclipse.rcptt.tesla.internal.ui.player.SWTUIElement;
import org.eclipse.rcptt.tesla.jface.TeslaWindowManager;
import org.eclipse.rcptt.tesla.swt.events.TeslaEventManager;
import org.eclipse.rcptt.tesla.swt.util.IndexUtil;
import org.eclipse.swt.widgets.Shell;

public class GetWindowUtil {
    public static String encodeFrom(String from) {
        return "-from/" + from;
    }

    public static String encodeClass(String klass) {
        return "-class/" + klass;
    }

    public static String decodeFrom(String[] path) {
        if (path == null || path.length != 2) {
            return null;
        }
        return path[0].equals("-from") ? path[1] : null;
    }

    public static String decodeClass(String[] path) {
        if (path == null || path.length != 2) {
            return null;
        }
        return path[0].equals("-class") ? path[1] : null;
    }

    public static String getShellCreationMethodName(Shell shell) {
        return TeslaEventManager.getManager().getShellCreationMethod(shell);
    }

    public static String getWindowClassName(Shell shell) {
        return TeslaWindowManager.getInstance().getWindowClassNameByShell(shell);
    }

    public static IndexUtil.Criterion byFrom(final String methodName) {
        return new IndexUtil.Criterion(){

            @Override
            public boolean fits(SWTUIElement uiElem) {
                return methodName.equals(GetWindowUtil.getShellCreationMethodName((Shell)PlayerWrapUtils.unwrapWidget(uiElem)));
            }
        };
    }

    public static IndexUtil.Criterion byClass(final String className) {
        return new IndexUtil.Criterion(){

            @Override
            public boolean fits(SWTUIElement uiElem) {
                return className.equals(GetWindowUtil.getWindowClassName((Shell)PlayerWrapUtils.unwrapWidget(uiElem)));
            }
        };
    }

    public static IndexUtil.Criterion byText(final String pattern) {
        return new IndexUtil.Criterion(){

            @Override
            public boolean fits(SWTUIElement uie) {
                if (pattern == null) {
                    return true;
                }
                String text = PlayerTextUtils.getText(uie);
                if (text == null) {
                    return false;
                }
                return (text = PlayerTextUtils.removeAcceleratorFromText(text)) != null && (text.equals(pattern) || PlayerTextUtils.safeMatches(text, pattern));
            }
        };
    }
}

