/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.part;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.TransferData;

public class MarkerTransfer
extends ByteArrayTransfer {
    private static final MarkerTransfer instance = new MarkerTransfer();
    private static final String TYPE_NAME = "marker-transfer-format" + System.currentTimeMillis() + ":" + ((Object)((Object)instance)).hashCode();
    private static final int TYPEID = MarkerTransfer.registerType((String)TYPE_NAME);
    private IWorkspace workspace;

    private MarkerTransfer() {
    }

    private IMarker findMarker(String pathString, long id) {
        Path path = new Path(pathString);
        IResource resource = this.workspace.getRoot().findMember((IPath)path);
        if (resource != null) {
            return resource.getMarker(id);
        }
        return null;
    }

    public static MarkerTransfer getInstance() {
        return instance;
    }

    protected int[] getTypeIds() {
        return new int[]{TYPEID};
    }

    protected String[] getTypeNames() {
        return new String[]{TYPE_NAME};
    }

    protected void javaToNative(Object object, TransferData transferData) {
        Object[] markers = (Object[])object;
        this.lazyInit(markers);
        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
        DataOutputStream out = new DataOutputStream(byteOut);
        byte[] bytes = null;
        try {
            out.writeInt(markers.length);
            int i = 0;
            while (i < markers.length) {
                this.writeMarker((IMarker)markers[i], out);
                ++i;
            }
            out.close();
            bytes = byteOut.toByteArray();
        }
        catch (IOException iOException) {}
        if (bytes != null) {
            super.javaToNative(bytes, transferData);
        }
    }

    private void lazyInit(Object[] markers) {
        if (this.workspace == null && markers != null && markers.length > 0) {
            this.workspace = ((IMarker)markers[0]).getResource().getWorkspace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object nativeToJava(TransferData transferData) {
        byte[] bytes = (byte[])super.nativeToJava(transferData);
        DataInputStream in = new DataInputStream(new ByteArrayInputStream(bytes));
        try {
            int n = in.readInt();
            IMarker[] markers = new IMarker[n];
            int i = 0;
            while (true) {
                if (i >= n) {
                    return markers;
                }
                IMarker marker = this.readMarker(in);
                if (marker == null) {
                    return null;
                }
                markers[i] = marker;
                ++i;
            }
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private IMarker readMarker(DataInputStream dataIn) throws IOException {
        String path = dataIn.readUTF();
        long id = dataIn.readLong();
        return this.findMarker(path, id);
    }

    private void writeMarker(IMarker marker, DataOutputStream dataOut) throws IOException {
        dataOut.writeUTF(marker.getResource().getFullPath().toString());
        dataOut.writeLong(marker.getId());
    }
}

