/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.views.markers;

import com.ibm.icu.text.CollationKey;
import com.ibm.icu.text.Collator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.internal.ide.Policy;
import org.eclipse.ui.internal.views.markers.MarkerCategory;
import org.eclipse.ui.internal.views.markers.MarkerSupportInternalUtilities;
import org.eclipse.ui.internal.views.markers.MarkerSupportItem;
import org.eclipse.ui.views.markers.internal.MarkerMessages;
import org.eclipse.ui.views.markers.internal.MarkerTypesModel;

class MarkerEntry
extends MarkerSupportItem
implements IAdaptable {
    private static final String LOCATION_STRING = "LOCATION_STRING";
    private MarkerCategory category;
    private Map<String, Object> cache;
    private boolean stale;
    private IMarker marker;

    static {
        Platform.getAdapterManager().registerAdapters(new IAdapterFactory(){

            public <T> T getAdapter(Object adaptableObject, Class<T> adapterType) {
                if (adapterType == IMarker.class && adaptableObject instanceof MarkerEntry) {
                    return adapterType.cast(((MarkerEntry)adaptableObject).getMarker());
                }
                return null;
            }

            public Class<?>[] getAdapterList() {
                return new Class[]{IMarker.class};
            }
        }, MarkerEntry.class);
    }

    public MarkerEntry(IMarker marker) {
        this.marker = marker;
        this.stale = false;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter.equals(IMarker.class)) {
            return adapter.cast(this.marker);
        }
        return null;
    }

    @Override
    public boolean getAttributeValue(String attribute, boolean defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (Boolean)value;
    }

    @Override
    public int getAttributeValue(String attribute, int defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return (Integer)value;
    }

    Object getAttributeValue(String attribute) {
        Object value = this.getCache().get(attribute);
        if (value == null) {
            if (this.stale) {
                return value;
            }
            try {
                value = this.marker.getAttribute(attribute);
            }
            catch (CoreException coreException) {
                this.checkIfMarkerStale();
                value = null;
            }
            if (value != null) {
                this.getCache().put(attribute, value);
            }
        }
        if (value instanceof CollationKey) {
            return ((CollationKey)value).getSourceString();
        }
        return value;
    }

    @Override
    public String getAttributeValue(String attribute, String defaultValue) {
        Object value = this.getAttributeValue(attribute);
        if (value == null) {
            return defaultValue;
        }
        return value.toString();
    }

    MarkerCategory getCategory() {
        return this.category;
    }

    @Override
    MarkerSupportItem[] getChildren() {
        return MarkerSupportInternalUtilities.EMPTY_MARKER_ITEM_ARRAY;
    }

    CollationKey getCollationKey(String attribute, String defaultValue) {
        String attributeValue;
        Object value = this.getCache().get(attribute);
        if (value != null) {
            if (value instanceof CollationKey) {
                return (CollationKey)value;
            }
            attributeValue = value.toString();
        } else {
            attributeValue = this.getAttributeValue(attribute, defaultValue);
        }
        if (attributeValue.length() == 0) {
            return MarkerSupportInternalUtilities.EMPTY_COLLATION_KEY;
        }
        CollationKey key = Collator.getInstance().getCollationKey(attributeValue);
        this.getCache().put(attribute, key);
        return key;
    }

    @Override
    long getCreationTime() {
        if (this.stale) {
            return -1L;
        }
        try {
            return this.marker.getCreationTime();
        }
        catch (CoreException e) {
            this.checkIfMarkerStale();
            Policy.handle(e);
            return -1L;
        }
    }

    @Override
    String getDescription() {
        return this.getAttributeValue("message", MarkerSupportInternalUtilities.UNKNOWN_ATRRIBTE_VALUE_STRING);
    }

    @Override
    long getID() {
        return this.marker.getId();
    }

    @Override
    public String getLocation() {
        if (this.stale || this.checkIfMarkerStale()) {
            return MarkerSupportInternalUtilities.UNKNOWN_ATRRIBTE_VALUE_STRING;
        }
        if (this.getCache().containsKey(LOCATION_STRING)) {
            Object value = this.getCache().get(LOCATION_STRING);
            if (value instanceof CollationKey) {
                return ((CollationKey)value).getSourceString();
            }
            return (String)value;
        }
        String locationString = this.getAttributeValue("location", "");
        if (locationString.length() > 0) {
            this.getCache().put(LOCATION_STRING, locationString);
            return locationString;
        }
        int lineNumber = this.getAttributeValue("lineNumber", -1);
        String lineNumberString = lineNumber < 0 ? MarkerMessages.Unknown : NLS.bind((String)MarkerMessages.label_lineNumber, (Object)Integer.toString(lineNumber));
        this.getCache().put(LOCATION_STRING, lineNumberString);
        return lineNumberString;
    }

    @Override
    public IMarker getMarker() {
        return this.marker;
    }

    @Override
    String getMarkerTypeName() {
        if (this.stale) {
            return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
        }
        try {
            return MarkerTypesModel.getInstance().getType(this.marker.getType()).getLabel();
        }
        catch (CoreException e) {
            this.checkIfMarkerStale();
            Policy.handle(e);
            return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
        }
    }

    String getMarkerTypeId() {
        if (this.stale) {
            return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
        }
        try {
            return this.marker.getType();
        }
        catch (CoreException e) {
            this.checkIfMarkerStale();
            Policy.handle(e);
            return NLS.bind((String)MarkerMessages.FieldMessage_WrongType, (Object)this.marker.toString());
        }
    }

    @Override
    MarkerSupportItem getParent() {
        return this.category;
    }

    @Override
    public String getPath() {
        String folder = this.getAttributeValue("org.eclipse.ui.views.markers.path", null);
        if (folder != null) {
            return folder;
        }
        if (this.stale || this.checkIfMarkerStale()) {
            return MarkerSupportInternalUtilities.UNKNOWN_ATRRIBTE_VALUE_STRING;
        }
        IPath path = this.marker.getResource().getFullPath();
        int n = path.segmentCount() - 1;
        if (n <= 0) {
            return super.getPath();
        }
        folder = path.removeLastSegments(1).removeTrailingSeparator().toString();
        this.getCache().put("org.eclipse.ui.views.markers.path", folder);
        return folder;
    }

    @Override
    boolean isConcrete() {
        return true;
    }

    void setCategory(MarkerCategory markerCategory) {
        this.category = markerCategory;
    }

    void setMarker(IMarker marker) {
        this.marker = marker;
        this.stale = false;
        this.clearCache();
    }

    Map<String, Object> getCache() {
        if (this.cache == null) {
            this.cache = new HashMap<String, Object>(2);
        }
        return this.cache;
    }

    @Override
    void clearCache() {
        this.cache = null;
    }

    boolean checkIfMarkerStale() {
        if (this.stale) {
            return true;
        }
        if (this.marker == null || !this.marker.exists()) {
            this.stale = true;
        }
        return this.stale;
    }

    boolean getStaleState() {
        return this.stale;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.marker == null ? 0 : this.marker.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MarkerEntry)) {
            return false;
        }
        MarkerEntry other = (MarkerEntry)obj;
        return !(this.marker == null ? other.marker != null : !this.marker.equals((Object)other.marker));
    }
}

