/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.wizards.site;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.core.site.WorkspaceSiteModel;
import org.eclipse.pde.internal.core.util.CoreUtility;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.part.ISetSelectionTarget;

public class NewSiteProjectCreationOperation
extends WorkspaceModifyOperation {
    private Display fDisplay;
    private IProject fProject;
    private IPath fPath;
    private String fWebLocation;

    public NewSiteProjectCreationOperation(Display display, IProject project, IPath path, String webLocation) {
        this.fDisplay = display;
        this.fProject = project;
        this.fPath = path;
        this.fWebLocation = webLocation;
    }

    protected void execute(IProgressMonitor monitor) throws CoreException, InvocationTargetException, InterruptedException {
        int numUnits = this.fWebLocation == null ? 3 : 4;
        monitor.beginTask(PDEUIMessages.NewSiteWizard_creatingProject, numUnits);
        CoreUtility.createProject((IProject)this.fProject, (IPath)this.fPath, (IProgressMonitor)monitor);
        this.fProject.open(monitor);
        CoreUtility.addNatureToProject((IProject)this.fProject, (String)"org.eclipse.pde.UpdateSiteNature", (IProgressMonitor)monitor);
        monitor.worked(1);
        if (this.fWebLocation != null) {
            CoreUtility.createFolder((IFolder)this.fProject.getFolder(this.fWebLocation));
            this.createXSLFile();
            this.createCSSFile();
            this.createHTMLFile();
            monitor.worked(1);
        }
        monitor.subTask(PDEUIMessages.NewSiteWizard_creatingManifest);
        IFile file = this.createSiteManifest();
        monitor.worked(1);
        this.openFile(file);
        monitor.worked(1);
    }

    private IFile createSiteManifest() throws CoreException {
        IFile file = this.fProject.getFile("site.xml");
        if (file.exists()) {
            return file;
        }
        WorkspaceSiteModel model = new WorkspaceSiteModel(file);
        model.getSite();
        model.save();
        model.dispose();
        IDE.setDefaultEditor((IFile)file, (String)"org.eclipse.pde.ui.siteEditor");
        return file;
    }

    private void openFile(final IFile file) {
        this.fDisplay.asyncExec(new Runnable(){

            @Override
            public void run() {
                IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
                if (ww == null) {
                    return;
                }
                IWorkbenchPage page = ww.getActivePage();
                if (page == null || !file.exists()) {
                    return;
                }
                IWorkbenchPart focusPart = page.getActivePart();
                if (focusPart instanceof ISetSelectionTarget) {
                    StructuredSelection selection = new StructuredSelection((Object)file);
                    ((ISetSelectionTarget)focusPart).selectReveal((ISelection)selection);
                }
                try {
                    page.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.pde.ui.siteEditor");
                }
                catch (PartInitException partInitException) {}
            }
        });
    }

    private void createHTMLFile() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("<html>");
        writer.println("<head>");
        writer.println("<title>" + this.fProject.getName() + "</title>");
        writer.println("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\">");
        writer.println("<style>@import url(\"" + this.fWebLocation + "/site.css\");</style>");
        writer.println("<script type=\"text/javascript\">");
        writer.println("\tvar returnval = 0;");
        writer.println("\tvar stylesheet, xmlFile, cache, doc;");
        writer.println("\tfunction init(){");
        writer.println("\t\t// NSCP 7.1+ / Mozilla 1.4.1+ / Safari");
        writer.println("\t\t// Use the standard DOM Level 2 technique, if it is supported");
        writer.println("\t\tif (document.implementation && document.implementation.createDocument) {");
        writer.println("\t\t\txmlFile = document.implementation.createDocument(\"\", \"\", null);");
        writer.println("\t\t\tstylesheet = document.implementation.createDocument(\"\", \"\", null);");
        writer.println("\t\t\tif (xmlFile.load){");
        writer.println("\t\t\t\txmlFile.load(\"site.xml\");");
        writer.println("\t\t\t\tstylesheet.load(\"" + this.fWebLocation + "/site.xsl\");");
        writer.println("\t\t\t} else {");
        writer.println("\t\t\t\talert(\"" + PDEUIMessages.SiteHTML_loadError + "\");");
        writer.println("\t\t\t}");
        writer.println("\t\t\txmlFile.addEventListener(\"load\", transform, false);");
        writer.println("\t\t\tstylesheet.addEventListener(\"load\", transform, false);");
        writer.println("\t\t}");
        writer.println("\t\t//IE 6.0+ solution");
        writer.println("\t\telse if (window.ActiveXObject) {");
        writer.println("\t\t\txmlFile = new ActiveXObject(\"msxml2.DOMDocument.3.0\");");
        writer.println("\t\t\txmlFile.async = false;");
        writer.println("\t\t\txmlFile.load(\"site.xml\");");
        writer.println("\t\t\tstylesheet = new ActiveXObject(\"msxml2.FreeThreadedDOMDocument.3.0\");");
        writer.println("\t\t\tstylesheet.async = false;");
        writer.println("\t\t\tstylesheet.load(\"" + this.fWebLocation + "/site.xsl\");");
        writer.println("\t\t\tcache = new ActiveXObject(\"msxml2.XSLTemplate.3.0\");");
        writer.println("\t\t\tcache.stylesheet = stylesheet;");
        writer.println("\t\t\ttransformData();");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println("\t// separate transformation function for IE 6.0+");
        writer.println("\tfunction transformData(){");
        writer.println("\t\tvar processor = cache.createProcessor();");
        writer.println("\t\tprocessor.input = xmlFile;");
        writer.println("\t\tprocessor.transform();");
        writer.println("\t\tdata.innerHTML = processor.output;");
        writer.println("\t}");
        writer.println("\t// separate transformation function for NSCP 7.1+ and Mozilla 1.4.1+ ");
        writer.println("\tfunction transform(){");
        writer.println("\t\treturnval+=1;");
        writer.println("\t\tif (returnval==2){");
        writer.println("\t\t\tvar processor = new XSLTProcessor();");
        writer.println("\t\t\tprocessor.importStylesheet(stylesheet); ");
        writer.println("\t\t\tdoc = processor.transformToDocument(xmlFile);");
        writer.println("\t\t\tdocument.getElementById(\"data\").innerHTML = doc.documentElement.innerHTML;");
        writer.println("\t\t}");
        writer.println("\t}");
        writer.println("</script>");
        writer.println("</head>");
        writer.println("<body onload=\"init();\">");
        writer.println("<!--[insert static HTML here]-->");
        writer.println("<div id=\"data\"><!-- this is where the transformed data goes --></div>");
        writer.println("</body>");
        writer.println("</html>");
        writer.flush();
        this.writeFile(this.fProject.getFile("index.html"), swriter);
    }

    private void createCSSFile() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("<STYLE type=\"text/css\">");
        writer.println("td.spacer {padding-bottom: 10px; padding-top: 10px;}");
        writer.println(".title { font-family: sans-serif; color: #99AACC;}");
        writer.println(".bodyText { font-family: sans-serif; font-size: 9pt; color:#000000;  }");
        writer.println(".sub-header { font-family: sans-serif; font-style: normal; font-weight: bold; font-size: 9pt; color: white;}");
        writer.println(".log-text {font-family: sans-serif; font-style: normal; font-weight: lighter; font-size: 8pt; color:black;}");
        writer.println(".big-header { font-family: sans-serif; font-style: normal; font-weight: bold; font-size: 9pt; color: white; border-top:10px solid white;}");
        writer.println(".light-row {background:#FFFFFF}");
        writer.println(".dark-row {background:#EEEEFF}");
        writer.println(".header {background:#99AADD}");
        writer.println("#indent {word-wrap : break-word;width :300px;text-indent:10px;}");
        writer.println("</STYLE>");
        writer.flush();
        this.writeFile(this.fProject.getFile(String.valueOf(this.fWebLocation) + "/site.css"), swriter);
    }

    private void createXSLFile() {
        StringWriter swriter = new StringWriter();
        PrintWriter writer = new PrintWriter(swriter);
        writer.println("<xsl:stylesheet version = '1.0' xmlns:xsl='http://www.w3.org/1999/XSL/Transform' xmlns:msxsl=\"urn:schemas-microsoft-com:xslt\">");
        writer.println("<xsl:output method=\"html\" encoding=\"UTF-8\"/>");
        writer.println("<xsl:key name=\"cat\" match=\"category\" use=\"@name\"/>");
        writer.println("<xsl:template match=\"/\">");
        writer.println("<xsl:for-each select=\"site\">");
        writer.println("\t<html>");
        writer.println("\t<head>");
        writer.println("\t<title>" + this.fProject.getName() + "</title>");
        writer.println("\t<style>@import url(\"" + this.fWebLocation + "/site.css\");</style>");
        writer.println("\t</head>");
        writer.println("\t<body>");
        writer.println("\t<h1 class=\"title\">" + this.fProject.getName() + "</h1>");
        writer.println("\t<p class=\"bodyText\"><xsl:value-of select=\"description\"/></p>");
        writer.println("\t<table width=\"100%\" border=\"0\" cellspacing=\"1\" cellpadding=\"2\">");
        writer.println("\t<xsl:for-each select=\"category-def\">");
        writer.println("\t\t<xsl:sort select=\"@label\" order=\"ascending\" case-order=\"upper-first\"/>");
        writer.println("\t\t<xsl:sort select=\"@name\" order=\"ascending\" case-order=\"upper-first\"/>");
        writer.println("\t<xsl:if test=\"count(key('cat',@name)) != 0\">");
        writer.println("\t\t\t<tr class=\"header\">");
        writer.println("\t\t\t\t<td class=\"sub-header\" width=\"30%\">");
        writer.println("\t\t\t\t\t<xsl:value-of select=\"@name\"/>");
        writer.println("\t\t\t\t</td>");
        writer.println("\t\t\t\t<td class=\"sub-header\" width=\"70%\">");
        writer.println("\t\t\t\t\t<xsl:value-of select=\"@label\"/>");
        writer.println("\t\t\t\t</td>");
        writer.println("\t\t\t</tr>");
        writer.println("\t\t\t<xsl:for-each select=\"key('cat',@name)\">");
        writer.println("\t\t\t<xsl:sort select=\"ancestor::feature//@version\" order=\"ascending\"/>");
        writer.println("\t\t\t<xsl:sort select=\"ancestor::feature//@id\" order=\"ascending\" case-order=\"upper-first\"/>");
        writer.println("\t\t\t<tr>");
        writer.println("\t\t\t\t<xsl:choose>");
        writer.println("\t\t\t\t<xsl:when test=\"(position() mod 2 = 1)\">");
        writer.println("\t\t\t\t\t<xsl:attribute name=\"class\">dark-row</xsl:attribute>");
        writer.println("\t\t\t\t</xsl:when>");
        writer.println("\t\t\t\t<xsl:otherwise>");
        writer.println("\t\t\t\t\t<xsl:attribute name=\"class\">light-row</xsl:attribute>");
        writer.println("\t\t\t\t</xsl:otherwise>");
        writer.println("\t\t\t\t</xsl:choose>");
        writer.println("\t\t\t\t<td class=\"log-text\" id=\"indent\">");
        writer.println("\t\t\t\t\t\t<xsl:choose>");
        writer.println("\t\t\t\t\t\t<xsl:when test=\"ancestor::feature//@label\">");
        writer.println("\t\t\t\t\t\t\t<a href=\"{ancestor::feature//@url}\"><xsl:value-of select=\"ancestor::feature//@label\"/></a>");
        writer.println("\t\t\t\t\t\t\t<br/>");
        writer.println("\t\t\t\t\t\t\t<div id=\"indent\">");
        writer.println("\t\t\t\t\t\t\t(<xsl:value-of select=\"ancestor::feature//@id\"/> - <xsl:value-of select=\"ancestor::feature//@version\"/>)");
        writer.println("\t\t\t\t\t\t\t</div>");
        writer.println("\t\t\t\t\t\t</xsl:when>");
        writer.println("\t\t\t\t\t\t<xsl:otherwise>");
        writer.println("\t\t\t\t\t\t<a href=\"{ancestor::feature//@url}\"><xsl:value-of select=\"ancestor::feature//@id\"/> - <xsl:value-of select=\"ancestor::feature//@version\"/></a>");
        writer.println("\t\t\t\t\t\t</xsl:otherwise>");
        writer.println("\t\t\t\t\t\t</xsl:choose>");
        writer.println("\t\t\t\t\t\t<br />");
        writer.println("\t\t\t\t</td>");
        writer.println("\t\t\t\t<td>");
        writer.println("\t\t\t\t\t<table>");
        writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@os\">");
        writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Operating Systems:</td>");
        writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@os\"/></td>");
        writer.println("\t\t\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@ws\">");
        writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Windows Systems:</td>");
        writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@ws\"/></td>");
        writer.println("\t\t\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@nl\">");
        writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Languages:</td>");
        writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@nl\"/></td>");
        writer.println("\t\t\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t\t\t<xsl:if test=\"ancestor::feature//@arch\">");
        writer.println("\t\t\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Architecture:</td>");
        writer.println("\t\t\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"ancestor::feature//@arch\"/></td>");
        writer.println("\t\t\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t\t</table>");
        writer.println("\t\t\t\t</td>");
        writer.println("\t\t\t</tr>");
        writer.println("\t\t\t</xsl:for-each>");
        writer.println("\t\t\t<tr><td class=\"spacer\"><br/></td><td class=\"spacer\"><br/></td></tr>");
        writer.println("\t\t</xsl:if>");
        writer.println("\t</xsl:for-each>");
        writer.println("\t<xsl:if test=\"count(feature)  &gt; count(feature/category)\">");
        writer.println("\t<tr class=\"header\">");
        writer.println("\t\t<td class=\"sub-header\" colspan=\"2\">");
        writer.println("\t\tUncategorized");
        writer.println("\t\t</td>");
        writer.println("\t</tr>");
        writer.println("\t</xsl:if>");
        writer.println("\t<xsl:choose>");
        writer.println("\t<xsl:when test=\"function-available('msxsl:node-set')\">");
        writer.println("\t   <xsl:variable name=\"rtf-nodes\">");
        writer.println("\t\t<xsl:for-each select=\"feature[not(category)]\">");
        writer.println("\t\t\t<xsl:sort select=\"@id\" order=\"ascending\" case-order=\"upper-first\"/>");
        writer.println("\t\t\t<xsl:sort select=\"@version\" order=\"ascending\" />");
        writer.println("\t\t\t<xsl:value-of select=\".\"/>");
        writer.println("\t\t\t<xsl:copy-of select=\".\" />");
        writer.println("\t\t</xsl:for-each>");
        writer.println("\t   </xsl:variable>");
        writer.println("\t   <xsl:variable name=\"myNodeSet\" select=\"msxsl:node-set($rtf-nodes)/*\"/>");
        writer.println("\t<xsl:for-each select=\"$myNodeSet\">");
        writer.println("\t<tr>");
        writer.println("\t\t<xsl:choose>");
        writer.println("\t\t<xsl:when test=\"position() mod 2 = 1\">");
        writer.println("\t\t<xsl:attribute name=\"class\">dark-row</xsl:attribute>");
        writer.println("\t\t</xsl:when>");
        writer.println("\t\t<xsl:otherwise>");
        writer.println("\t\t<xsl:attribute name=\"class\">light-row</xsl:attribute>");
        writer.println("\t\t</xsl:otherwise>");
        writer.println("\t\t</xsl:choose>");
        writer.println("\t\t<td class=\"log-text\" id=\"indent\">");
        writer.println("\t\t\t<xsl:choose>");
        writer.println("\t\t\t<xsl:when test=\"@label\">");
        writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@label\"/></a>");
        writer.println("\t\t\t\t<br />");
        writer.println("\t\t\t\t<div id=\"indent\">");
        writer.println("\t\t\t\t(<xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/>)");
        writer.println("\t\t\t\t</div>");
        writer.println("\t\t\t</xsl:when>");
        writer.println("\t\t\t<xsl:otherwise>");
        writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/></a>");
        writer.println("\t\t\t</xsl:otherwise>");
        writer.println("\t\t\t</xsl:choose>");
        writer.println("\t\t\t<br /><br />");
        writer.println("\t\t</td>");
        writer.println("\t\t<td>");
        writer.println("\t\t\t<table>");
        writer.println("\t\t\t\t<xsl:if test=\"@os\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Operating Systems:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@os\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t<xsl:if test=\"@ws\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Windows Systems:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@ws\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t<xsl:if test=\"@nl\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Languages:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@nl\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t<xsl:if test=\"@arch\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Architecture:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@arch\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t</table>");
        writer.println("\t\t</td>");
        writer.println("\t</tr>");
        writer.println("\t</xsl:for-each>");
        writer.println("\t</xsl:when>");
        writer.println("\t<xsl:otherwise>");
        writer.println("\t<xsl:for-each select=\"feature[not(category)]\">");
        writer.println("\t<xsl:sort select=\"@id\" order=\"ascending\" case-order=\"upper-first\"/>");
        writer.println("\t<xsl:sort select=\"@version\" order=\"ascending\" />");
        writer.println("\t<tr>");
        writer.println("\t\t<xsl:choose>");
        writer.println("\t\t<xsl:when test=\"count(preceding-sibling::feature[not(category)]) mod 2 = 1\">");
        writer.println("\t\t<xsl:attribute name=\"class\">dark-row</xsl:attribute>");
        writer.println("\t\t</xsl:when>");
        writer.println("\t\t<xsl:otherwise>");
        writer.println("\t\t<xsl:attribute name=\"class\">light-row</xsl:attribute>");
        writer.println("\t\t</xsl:otherwise>");
        writer.println("\t\t</xsl:choose>");
        writer.println("\t\t<td class=\"log-text\" id=\"indent\">");
        writer.println("\t\t\t<xsl:choose>");
        writer.println("\t\t\t<xsl:when test=\"@label\">");
        writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@label\"/></a>");
        writer.println("\t\t\t\t<br />");
        writer.println("\t\t\t\t<div id=\"indent\">");
        writer.println("\t\t\t\t(<xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/>)");
        writer.println("\t\t\t\t</div>");
        writer.println("\t\t\t</xsl:when>");
        writer.println("\t\t\t<xsl:otherwise>");
        writer.println("\t\t\t\t<a href=\"{@url}\"><xsl:value-of select=\"@id\"/> - <xsl:value-of select=\"@version\"/></a>");
        writer.println("\t\t\t</xsl:otherwise>");
        writer.println("\t\t\t</xsl:choose>");
        writer.println("\t\t\t<br /><br />");
        writer.println("\t\t</td>");
        writer.println("\t\t<td>");
        writer.println("\t\t\t<table>");
        writer.println("\t\t\t\t<xsl:if test=\"@os\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Operating Systems:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@os\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t<xsl:if test=\"@ws\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Windows Systems:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@ws\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t<xsl:if test=\"@nl\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Languages:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@nl\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t\t<xsl:if test=\"@arch\">");
        writer.println("\t\t\t\t\t<tr><td class=\"log-text\" id=\"indent\">Architecture:</td>");
        writer.println("\t\t\t\t\t<td class=\"log-text\" id=\"indent\"><xsl:value-of select=\"@arch\"/></td>");
        writer.println("\t\t\t\t\t</tr>");
        writer.println("\t\t\t\t</xsl:if>");
        writer.println("\t\t\t</table>");
        writer.println("\t\t</td>");
        writer.println("\t</tr>");
        writer.println("\t</xsl:for-each>");
        writer.println("\t</xsl:otherwise>");
        writer.println("\t</xsl:choose>");
        writer.println("\t</table>");
        writer.println("\t</body>");
        writer.println("\t</html>");
        writer.println("</xsl:for-each>");
        writer.println("</xsl:template>");
        writer.println("</xsl:stylesheet>");
        writer.flush();
        this.writeFile(this.fProject.getFile(String.valueOf(this.fWebLocation) + "/site.xsl"), swriter);
    }

    private void writeFile(IFile file, StringWriter swriter) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(swriter.toString().getBytes("UTF8"));
            if (file.exists()) {
                file.setContents((InputStream)stream, false, false, null);
            } else {
                file.create((InputStream)stream, false, null);
            }
            stream.close();
            swriter.close();
        }
        catch (Exception e) {
            PDEPlugin.logException(e);
        }
    }
}

