/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.pde.core.IBundleClasspathResolver;
import org.eclipse.pde.internal.core.PDECore;

public class ClasspathContainerResolverManager {
    private static final String POINT_ID = "org.eclipse.pde.core.bundleClasspathResolvers";
    private static final String ATT_NATURE = "nature";
    private static final String ATT_CLASS = "class";

    public IBundleClasspathResolver[] getBundleClasspathResolvers(IProject project) {
        ArrayList<Object> result = new ArrayList<Object>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = registry.getConfigurationElementsFor(POINT_ID);
        int i = 0;
        while (i < elements.length) {
            String attrNature = elements[i].getAttribute(ATT_NATURE);
            try {
                if (project.isNatureEnabled(attrNature)) {
                    result.add(elements[i].createExecutableExtension(ATT_CLASS));
                }
            }
            catch (CoreException e) {
                PDECore.log(e.getStatus());
            }
            ++i;
        }
        return result.toArray(new IBundleClasspathResolver[result.size()]);
    }
}

