/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.repository.tree.command;

import java.io.File;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.op.GarbageCollectOperation;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.CommonUtils;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.repository.tree.RepositoryNode;
import org.eclipse.egit.ui.internal.repository.tree.command.RepositoriesViewCommandHandler;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.progress.IWorkbenchSiteProgressService;
import org.eclipse.ui.services.IServiceLocator;

public class GarbageCollectCommand
extends RepositoriesViewCommandHandler<RepositoryNode> {
    public static final String ID = "org.eclipse.egit.ui.team.GarbageCollect";

    public Object execute(ExecutionEvent event) throws ExecutionException {
        List selectedNodes;
        try {
            selectedNodes = this.getSelectedNodes(event);
            if (selectedNodes.isEmpty()) {
                return null;
            }
        }
        catch (ExecutionException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        Job job = new Job("Collecting Garbage..."){

            protected IStatus run(IProgressMonitor monitor) {
                for (RepositoryNode node : selectedNodes) {
                    Repository repo = node.getRepository();
                    String name = MessageFormat.format(UIText.GarbageCollectCommand_jobTitle, GarbageCollectCommand.this.getRepositoryName(repo));
                    this.setName(name);
                    GarbageCollectOperation op = new GarbageCollectOperation(repo);
                    try {
                        op.execute(monitor);
                    }
                    catch (CoreException e) {
                        Activator.logError(MessageFormat.format(UIText.GarbageCollectCommand_failed, repo), e);
                    }
                }
                return Status.OK_STATUS;
            }
        };
        IWorkbenchSite activeSite = HandlerUtil.getActiveSite((ExecutionEvent)event);
        IWorkbenchSiteProgressService service = CommonUtils.getService((IServiceLocator)activeSite, IWorkbenchSiteProgressService.class);
        service.schedule(job);
        return null;
    }

    private String getRepositoryName(Repository repository) {
        File directory = !repository.isBare() ? repository.getDirectory().getParentFile() : repository.getDirectory();
        StringBuilder sb = new StringBuilder();
        sb.append(directory.getName());
        sb.append(" - ");
        sb.append(directory.getAbsolutePath());
        return sb.toString();
    }
}

