/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal;

import java.io.IOException;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.clone.ProjectRecord;
import org.eclipse.egit.ui.internal.repository.tree.RefNode;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelObject;
import org.eclipse.egit.ui.internal.synchronize.model.GitModelRepository;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.jgit.lib.BranchTrackingStatus;
import org.eclipse.jgit.lib.Ref;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.lib.RepositoryState;
import org.eclipse.osgi.util.NLS;

public class GitLabels {
    private GitLabels() {
    }

    public static String getRefDescription(Ref ref) {
        String name = ref.getName();
        if (name.equals("HEAD")) {
            if (ref.isSymbolic()) {
                return UIText.GitLabelProvider_RefDescriptionHeadSymbolic;
            }
            return UIText.GitLabelProvider_RefDescriptionHead;
        }
        if (name.equals("ORIG_HEAD")) {
            return UIText.GitLabelProvider_RefDescriptionOrigHead;
        }
        if (name.equals("FETCH_HEAD")) {
            return UIText.GitLabelProvider_RefDescriptionFetchHead;
        }
        if (name.equals("refs/stash")) {
            return UIText.GitLabelProvider_RefDescriptionStash;
        }
        return null;
    }

    public static String formatBranchTrackingStatus(BranchTrackingStatus status) {
        StringBuilder sb = new StringBuilder();
        int ahead = status.getAheadCount();
        int behind = status.getBehindCount();
        if (ahead != 0) {
            sb.append('\u2191');
            sb.append(ahead);
        }
        if (behind != 0) {
            if (sb.length() != 0) {
                sb.append(' ');
            }
            sb.append('\u2193');
            sb.append(status.getBehindCount());
        }
        return sb.toString();
    }

    public static StyledString getStyledLabel(Repository repository) throws IOException {
        RepositoryUtil repositoryUtil = Activator.getDefault().getRepositoryUtil();
        StyledString string = new StyledString();
        string.append(repositoryUtil.getRepositoryName(repository));
        String branch = repositoryUtil.getShortBranch(repository);
        if (branch != null) {
            RepositoryState repositoryState;
            string.append(' ');
            string.append('[', StyledString.DECORATIONS_STYLER);
            string.append(branch, StyledString.DECORATIONS_STYLER);
            BranchTrackingStatus trackingStatus = BranchTrackingStatus.of((Repository)repository, (String)branch);
            if (trackingStatus != null && (trackingStatus.getAheadCount() != 0 || trackingStatus.getBehindCount() != 0)) {
                String formattedTrackingStatus = GitLabels.formatBranchTrackingStatus(trackingStatus);
                string.append(' ');
                string.append(formattedTrackingStatus, StyledString.DECORATIONS_STYLER);
            }
            if ((repositoryState = repository.getRepositoryState()) != RepositoryState.SAFE) {
                string.append(" - ", StyledString.DECORATIONS_STYLER);
                string.append(repositoryState.getDescription(), StyledString.DECORATIONS_STYLER);
            }
            string.append(']', StyledString.DECORATIONS_STYLER);
        }
        return string;
    }

    public static StyledString getStyledLabelSafe(Repository repository) {
        try {
            return GitLabels.getStyledLabel(repository);
        }
        catch (IOException e) {
            GitLabels.logLabelRetrievalFailure(repository, e);
            return new StyledString(GitLabels.getPlainShortLabel(repository));
        }
    }

    public static StyledString getStyledLabelExtendedSafe(Object element) {
        Repository repo = GitLabels.asRepository(element);
        if (repo != null) {
            try {
                StyledString text = GitLabels.getStyledLabel(repo);
                text.append(GitLabels.getLabelExtension(repo), StyledString.QUALIFIER_STYLER);
                return text;
            }
            catch (IOException e) {
                GitLabels.logLabelRetrievalFailure(element, e);
            }
        }
        return new StyledString(GitLabels.getPlainShortLabelExtended(element));
    }

    public static String getPlainShortLabelExtended(Object element) {
        return String.valueOf(GitLabels.getPlainShortLabel(element)) + GitLabels.getLabelExtension(element);
    }

    private static void logLabelRetrievalFailure(Object element, IOException e) {
        Activator.logError(NLS.bind((String)UIText.GitLabelProvider_UnableToRetrieveLabel, (Object)element.toString()), e);
    }

    private static String getLabelExtension(Object element) {
        Repository repo = GitLabels.asRepository(element);
        if (repo != null) {
            return " - " + GitLabels.getRepositoryAbsolutePath(repo);
        }
        return "";
    }

    public static String getPlainShortLabel(Object element) {
        if (element instanceof Repository) {
            return GitLabels.getRepositorySimpleLabel((Repository)element);
        }
        if (element instanceof RefNode) {
            return GitLabels.getRefNodeSimpleLabel((RefNode)element);
        }
        if (element instanceof Ref) {
            return ((Ref)element).getName();
        }
        if (element instanceof ProjectRecord) {
            return ((ProjectRecord)element).getProjectLabel();
        }
        if (element instanceof GitModelObject) {
            return ((GitModelObject)((Object)element)).getName();
        }
        return element != null ? element.toString() : "";
    }

    private static String getRefNodeSimpleLabel(RefNode refNode) {
        return ((Ref)refNode.getObject()).getName();
    }

    private static String getRepositorySimpleLabel(Repository repository) {
        return Activator.getDefault().getRepositoryUtil().getRepositoryName(repository);
    }

    private static String getRepositoryAbsolutePath(Repository repository) {
        return repository.getDirectory().getAbsolutePath();
    }

    private static Repository asRepository(Object element) {
        if (element instanceof Repository) {
            return (Repository)element;
        }
        if (element instanceof GitModelRepository) {
            return ((GitModelRepository)element).getRepository();
        }
        return null;
    }
}

