/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.tesla.internal.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.rcptt.tesla.core.Q7WaitUtils;
import org.eclipse.rcptt.tesla.core.context.ContextManagement;
import org.eclipse.rcptt.tesla.core.info.AdvancedInformation;
import org.eclipse.rcptt.tesla.core.info.InfoFactory;
import org.eclipse.rcptt.tesla.core.info.Q7WaitInfoRoot;
import org.eclipse.rcptt.tesla.core.protocol.ElementCommand;
import org.eclipse.rcptt.tesla.core.protocol.GetStateResponse;
import org.eclipse.rcptt.tesla.core.protocol.IElementProcessorMapper;
import org.eclipse.rcptt.tesla.core.protocol.Nop;
import org.eclipse.rcptt.tesla.core.protocol.ProtocolFactory;
import org.eclipse.rcptt.tesla.core.protocol.SelectCommand;
import org.eclipse.rcptt.tesla.core.protocol.SelectResponse;
import org.eclipse.rcptt.tesla.core.protocol.TeslaStream;
import org.eclipse.rcptt.tesla.core.protocol.raw.Command;
import org.eclipse.rcptt.tesla.core.protocol.raw.Element;
import org.eclipse.rcptt.tesla.core.protocol.raw.RawFactory;
import org.eclipse.rcptt.tesla.core.protocol.raw.Response;
import org.eclipse.rcptt.tesla.core.protocol.raw.ResponseStatus;
import org.eclipse.rcptt.tesla.internal.core.TeslaCore;
import org.eclipse.rcptt.tesla.internal.core.TeslaProcessorManager;
import org.eclipse.rcptt.tesla.internal.core.info.GeneralInformationCollector;
import org.eclipse.rcptt.tesla.internal.core.processing.ElementGenerator;
import org.eclipse.rcptt.tesla.internal.core.processing.ITeslaCommandProcessor;
import org.eclipse.rcptt.util.Exceptions;

public abstract class AbstractTeslaClient
implements IElementProcessorMapper {
    private boolean processing = false;
    private final ElementGenerator generator = new ElementGenerator();
    protected final List<Command> localQueue = new ArrayList<Command>();
    private Map<String, Set<ITeslaCommandProcessor>> elementProcessors = new HashMap<String, Set<ITeslaCommandProcessor>>();
    private final Map<Command, ITeslaCommandProcessor.PreExecuteStatus> preStatuses = new HashMap<Command, ITeslaCommandProcessor.PreExecuteStatus>();
    private final TeslaProcessorManager processors = new TeslaProcessorManager();
    private ContextManagement.Context currentContext;
    private final String id;
    private final AtomicInteger hasEvents = new AtomicInteger(-1);
    private AdvancedInformation lastFailureInformation;

    public AbstractTeslaClient(String id) {
        this.id = id;
        this.processors.initializeProcessors(this, id);
    }

    public ElementGenerator getGenerator() {
        return this.generator;
    }

    public String getID() {
        return this.id;
    }

    public void shutdown() {
        this.processors.terminate();
        this.elementProcessors = null;
    }

    public abstract boolean isActive();

    public abstract Object getSyncObject();

    public abstract boolean isClosed();

    protected abstract TeslaStream stream();

    @Override
    public void map(Element element, ITeslaCommandProcessor processor) {
        if (element != null && processor != null) {
            this.putProcessor(element, processor);
            this.processors.postSelect(element, new IElementProcessorMapper(){

                @Override
                public void map(Element element, ITeslaCommandProcessor processor) {
                    AbstractTeslaClient.this.putProcessor(element, processor);
                }
            });
        }
    }

    private void putProcessor(Element element, ITeslaCommandProcessor processor) {
        String key = this.makeKey(element);
        Set<ITeslaCommandProcessor> set = this.elementProcessors.get(key);
        if (set == null) {
            set = new LinkedHashSet<ITeslaCommandProcessor>();
        }
        LinkedHashSet<ITeslaCommandProcessor> newSet = new LinkedHashSet<ITeslaCommandProcessor>();
        newSet.add(processor);
        newSet.addAll(set);
        this.elementProcessors.put(key, newSet);
    }

    protected SelectResponse handleSelect(SelectCommand cmd) {
        String kind = cmd.getData().getKind();
        SelectResponse response = this.processors.select(cmd, this.generator, this);
        if (response == null) {
            response = ProtocolFactory.eINSTANCE.createSelectResponse();
            response.setStatus(ResponseStatus.FAILED);
            response.setMessage("No Element with kind:" + kind + " is available for selection...");
        }
        if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
            this.handleFailedResponse(cmd, response);
        }
        return response;
    }

    private String makeKey(Element uiElement) {
        return String.valueOf(uiElement.getKind()) + ":" + uiElement.getId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean processNext(ContextManagement.Context context, Q7WaitInfoRoot info) {
        if (this.isClosed()) {
            return false;
        }
        AbstractTeslaClient abstractTeslaClient = this;
        synchronized (abstractTeslaClient) {
            if (this.processing) {
                return false;
            }
        }
        if (this.isActive() && (this.hasCommand() || !this.localQueue.isEmpty()) && this.canProceed(context, info)) {
            return this.doOneCommand(context, info);
        }
        return false;
    }

    public void hasEvent(String kind, String name, Q7WaitInfoRoot info) {
        this.hasEvents.incrementAndGet();
        Q7WaitUtils.updateInfo(kind, name, info);
    }

    protected boolean canProceed(ContextManagement.Context context, Q7WaitInfoRoot info) {
        this.hasEvents.set(0);
        boolean result = this.processors.canProceed(context, info);
        if (this.hasEvents.get() > 0) {
            return false;
        }
        return result;
    }

    public void clean() {
        this.lastFailureInformation = null;
        this.processors.clean();
        for (ITeslaCommandProcessor.PreExecuteStatus status : this.preStatuses.values()) {
            status.clean();
        }
        this.preStatuses.clear();
        this.elementProcessors.clear();
    }

    protected boolean preExecute(Command command, Q7WaitInfoRoot info) {
        if (command instanceof ElementCommand) {
            Set<ITeslaCommandProcessor> processors;
            ElementCommand cmd = (ElementCommand)command;
            Element element = cmd.getElement();
            if (element != null && (processors = this.elementProcessors.get(this.makeKey(element))) != null) {
                ITeslaCommandProcessor.PreExecuteStatus preStatus = this.preStatuses.get(command);
                for (ITeslaCommandProcessor processor : processors) {
                    block8: {
                        if (processor == null) continue;
                        ITeslaCommandProcessor.PreExecuteStatus status = processor.preExecute(command, preStatus, info);
                        if (status == null) break block8;
                        this.preStatuses.put(command, status);
                        if (status.canExecute) continue;
                        return false;
                    }
                    try {
                        this.preStatuses.remove(command);
                    }
                    catch (Throwable e) {
                        TeslaCore.log(e);
                    }
                }
            }
        } else {
            ITeslaCommandProcessor.PreExecuteStatus status = this.processors.preExecute(command, this.preStatuses.get(command), info);
            if (status != null && !status.canExecute) {
                this.preStatuses.put(command, status);
                return false;
            }
        }
        return true;
    }

    public void addCommand(Command cmd) {
        this.localQueue.add(cmd);
        this.notifyUI();
    }

    public void notifyUI() {
        this.processors.notifyUI();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private boolean doOneCommand(ContextManagement.Context context, Q7WaitInfoRoot info) {
        block25: {
            block24: {
                var3_3 = this;
                synchronized (var3_3) {
                    this.processing = true;
                }
                this.currentContext = context;
                command = null;
                try {
                    block26: {
                        if (this.localQueue.isEmpty()) break block26;
                        command = this.localQueue.remove(0);
                        isLocalQueue = true;
                        ** GOTO lbl41
                    }
                    command = this.stream().readCommand();
                    if (command != null) break block24;
                    var7_5 = this;
                }
                catch (Throwable var6_10) {
                    var7_7 = this;
                    synchronized (var7_7) {
                        this.processing = false;
                    }
                    this.currentContext = null;
                    throw var6_10;
                }
                synchronized (var7_5) {
                    this.processing = false;
                }
                this.currentContext = null;
                return false;
            }
            isLocalQueue = false;
lbl41:
            // 3 sources

            if (this.preExecute(command, info)) break block25;
            if (isLocalQueue) {
                this.localQueue.add(0, command);
            } else {
                this.localQueue.add(command);
            }
            var7_6 = this;
            synchronized (var7_6) {
                this.processing = false;
            }
            this.currentContext = null;
            return false;
        }
        this.stream().writeResponse(this.execute(command));
        {
            catch (Throwable e) {
                this.logException(e);
                this.stream().writeResponse(this.createErrorResponse(e));
            }
        }
        var7_8 = this;
        synchronized (var7_8) {
            this.processing = false;
        }
        this.currentContext = null;
        return true;
    }

    private Response execute(Command command) {
        if (!(command instanceof Nop)) {
            this.lastFailureInformation = null;
        }
        if (command instanceof ElementCommand) {
            Set<ITeslaCommandProcessor> processors;
            ElementCommand cmd = (ElementCommand)command;
            Element element = cmd.getElement();
            if (element != null && (processors = this.elementProcessors.get(this.makeKey(element))) != null) {
                for (ITeslaCommandProcessor processor : processors) {
                    Response response;
                    if (processor == null || (response = processor.executeCommand(command, this)) == null) continue;
                    if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
                        this.handleFailedResponse(command, response);
                    }
                    return response;
                }
            }
        } else {
            Response response = this.processors.executeCommand(command, this, true);
            if (response != null) {
                if (response.getStatus().equals((Object)ResponseStatus.FAILED)) {
                    this.handleFailedResponse(command, response);
                }
                return response;
            }
        }
        if (command.eClass().getEPackage().equals(ProtocolFactory.eINSTANCE.getEPackage())) {
            switch (command.eClass().getClassifierID()) {
                case 2: {
                    return this.handleSelect((SelectCommand)command);
                }
                case 22: {
                    this.shutdown();
                    return RawFactory.eINSTANCE.createResponse();
                }
                case 23: {
                    return RawFactory.eINSTANCE.createResponse();
                }
                case 16: {
                    GetStateResponse res = ProtocolFactory.eINSTANCE.createGetStateResponse();
                    Element state = RawFactory.eINSTANCE.createElement();
                    String returnedState = this.currentContext.getID();
                    state.setId(returnedState);
                    state.setKind("State");
                    res.setState(state);
                    return res;
                }
                case 18: {
                    return RawFactory.eINSTANCE.createResponse();
                }
                case 19: {
                    return RawFactory.eINSTANCE.createResponse();
                }
            }
        }
        Response failed = RawFactory.eINSTANCE.createResponse();
        failed.setStatus(ResponseStatus.FAILED);
        failed.setMessage("Unsupported command");
        return failed;
    }

    private Response createErrorResponse(Throwable e) {
        Response errorResponse = RawFactory.eINSTANCE.createResponse();
        errorResponse.setStatus(ResponseStatus.FAILED);
        errorResponse.setMessage("Exception happened:\n" + Exceptions.toString((Throwable)e));
        return errorResponse;
    }

    public AdvancedInformation getLastFailureInformation() {
        return this.lastFailureInformation;
    }

    public void clearLastFailureInformation() {
        this.lastFailureInformation = null;
    }

    protected void handleFailedResponse(Command command, Response response) {
        if (response != null) {
            AdvancedInformation information;
            this.lastFailureInformation = information = this.getAdvancedInformation(command);
            response.setAdvancedInformation((AdvancedInformation)EcoreUtil.copy((EObject)information));
        }
    }

    public AdvancedInformation getAdvancedInformation(Command command) {
        AdvancedInformation information = InfoFactory.eINSTANCE.createAdvancedInformation();
        this.processors.collectInformation(information, command);
        GeneralInformationCollector.collectInformation(information);
        return information;
    }

    public void collectLastFailureInformation() {
        AdvancedInformation information;
        this.lastFailureInformation = information = this.getAdvancedInformation(null);
    }

    public abstract void logException(Throwable var1);

    public abstract boolean hasCommand();

    public <T> T getProcessor(Class<T> clazz$) {
        return this.processors.getProcessor(clazz$);
    }

    public <T> List<T> getProcessors(Class<T> clazz$) {
        return this.processors.getProcessors(clazz$);
    }
}

