/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.core.persistence.plain;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipInputStream;
import org.eclipse.rcptt.core.persistence.plain.IPlainConstants;
import org.eclipse.rcptt.internal.core.RcpttPlugin;
import org.eclipse.rcptt.util.Base64;
import org.eclipse.rcptt.util.FileUtil;

public class PlainReader
implements IPlainConstants {
    private BufferedReader reader;
    private InputStream in;
    private static final List<String> VALID_HEADERS = Arrays.asList("--- RCPTT testcase ---", "--- RCPTT project settings ---", "--- RCPTT verification ---", "--- Q7 testcase ---", "--- Q7 project settings ---", "--- Q7 verification ---");

    public PlainReader(InputStream stream) throws IOException {
        this.in = stream;
        this.reader = new BufferedReader(new InputStreamReader((InputStream)new BufferedInputStream(stream), "utf-8"));
    }

    public Map<String, String> readHeader() throws Exception {
        String header = this.reader.readLine();
        if (header == null) {
            return null;
        }
        header = header.trim();
        boolean headerOK = false;
        for (String validHeader : VALID_HEADERS) {
            if (!validHeader.equalsIgnoreCase(header)) continue;
            headerOK = true;
            break;
        }
        if (!headerOK) {
            return null;
        }
        Map<String, String> map = this.readAttributes();
        return map;
    }

    private Map<String, String> readAttributes() throws IOException, Exception {
        String line;
        HashMap<String, String> map = new HashMap<String, String>();
        while ((line = this.reader.readLine()) != null && line.trim().length() != 0) {
            int pos = line.indexOf(": ");
            if (pos != -1) {
                String key = line.substring(0, pos);
                String value = FileUtil.unescape((String)line.substring(pos + 2));
                if (map.containsKey(key)) {
                    throw new Exception("Wrong q7 plain format, duplicate attribute entry.");
                }
                map.put(key, value);
                continue;
            }
            if (line.trim().endsWith(":")) continue;
            throw new Exception("Wrong q7 plain format");
        }
        return map;
    }

    /*
     * Unable to fully structure code
     */
    public Entry readEntry() throws Exception {
        entryHeader = this.reader.readLine();
        if (entryHeader != null) ** GOTO lbl5
        return null;
lbl-1000:
        // 1 sources

        {
            entryHeader = this.reader.readLine();
lbl5:
            // 2 sources

            ** while (entryHeader != null && entryHeader.trim().length() == 0)
        }
lbl6:
        // 1 sources

        if (entryHeader == null) {
            return null;
        }
        if (entryHeader.startsWith("------=_")) {
            entry = new Entry();
            entry.attributes = this.readAttributes();
            entry.name = entry.attributes.get("Entry-Name");
            contentType = entry.attributes.get("Content-Type");
            lines = new ArrayList<String>();
            while ((line = this.reader.readLine()) != null && !line.trim().equals(String.valueOf(entryHeader) + "--")) {
                lines.add(line);
            }
            if (contentType != null && contentType.contains("text")) {
                builder = new StringBuilder();
                for (String s : lines) {
                    builder.append(s).append("\n");
                }
                resultStr = builder.toString();
                if (resultStr.endsWith("\n")) {
                    resultStr = resultStr.substring(0, resultStr.length() - "\n".length());
                }
                Entry.access$0(entry, resultStr);
            } else if (contentType != null && contentType.contains("binary")) {
                builder = new StringBuilder();
                for (String s : lines) {
                    builder.append(s);
                }
                entry.rawData = builder.toString();
            }
            return entry;
        }
        throw new Exception("Wrong q7 plain format");
    }

    public void close() {
        FileUtil.safeClose((Closeable)this.reader);
        FileUtil.safeClose((Closeable)this.in);
    }

    public static class Entry {
        public String name;
        private Object content;
        public Map<String, String> attributes;
        public String rawData;

        public Object getContent() {
            if (this.content == null && this.rawData != null) {
                byte[] decode;
                block4: {
                    decode = Base64.decode((String)this.rawData);
                    if (decode != null) break block4;
                    RcpttPlugin.log("Failed to decode Q7 file format, invalid content", null);
                    return null;
                }
                try {
                    ByteArrayInputStream bin = new ByteArrayInputStream(decode);
                    ZipInputStream zin = new ZipInputStream(bin);
                    zin.getNextEntry();
                    this.content = FileUtil.getStreamContent((InputStream)zin);
                    this.rawData = null;
                }
                catch (Exception e) {
                    RcpttPlugin.log(e);
                }
            }
            return this.content;
        }

        static /* synthetic */ void access$0(Entry entry, Object object) {
            entry.content = object;
        }
    }
}

