/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lic.internal.jface.dialogs.licensing;

import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.AllLicensesFromFolder;
import org.eclipse.passage.lic.internal.jface.dialogs.licensing.LicenseFilesControl;
import org.eclipse.passage.lic.internal.jface.i18n.ImportLicenseDialogMessages;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public final class FromLocalFileSystem
implements LicenseFilesControl {
    private Text path;

    @Override
    public void install(Composite parent, Consumer<List<Path>> onLicenses) {
        new Label(parent, 0).setText(ImportLicenseDialogMessages.ImportLicenseDialog_path_label);
        this.path = new Text(parent, 2056);
        this.path.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Button browse = new Button(parent, 8);
        browse.setText(ImportLicenseDialogMessages.ImportLicenseDialog_browse);
        browse.addListener(13, e -> this.browseAndLoad(onLicenses));
    }

    private void browseAndLoad(Consumer<List<Path>> onLicenses) {
        onLicenses.accept(this.browse());
    }

    private List<Path> browse() {
        DirectoryDialog dialog = new DirectoryDialog(this.path.getShell(), 0x10001000);
        dialog.setText(ImportLicenseDialogMessages.ImportLicenseDialog_browse_dialog_title);
        String folder = dialog.open();
        if (folder == null) {
            return Collections.emptyList();
        }
        this.path.setText(folder);
        Object licenses = new AllLicensesFromFolder(folder).get();
        this.path.setData(licenses);
        return licenses;
    }
}

