/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.workbench;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import org.eclipse.passage.lic.api.MandatoryService;
import org.eclipse.passage.loc.internal.api.ZeroOrOne;
import org.eclipse.passage.loc.internal.workbench.CreateInner;
import org.eclipse.passage.loc.internal.workbench.SelectFromDialog;
import org.eclipse.passage.loc.internal.workbench.SelectRequest;
import org.eclipse.passage.loc.internal.workbench.i18n.WorkbenchMessages;
import org.eclipse.swt.widgets.Shell;

public final class SelectInner<I, R>
implements Supplier<Optional<I>> {
    private final SelectRequest<I> inner;
    private final SelectRequest<R> root;
    private final MandatoryService context;

    public SelectInner(SelectRequest<I> inner, SelectRequest<R> root, MandatoryService context) {
        Objects.requireNonNull(inner, WorkbenchMessages.SelectRoot_e_null_inner_request);
        Objects.requireNonNull(root, WorkbenchMessages.SelectRoot_e_null_root_request);
        Objects.requireNonNull(context, WorkbenchMessages.SelectRoot_e_null_context);
        this.inner = inner;
        this.root = root;
        this.context = context;
    }

    @Override
    public final Optional<I> get() {
        return new ZeroOrOne(this.inner.input()).choose(new CreateInner<I, R>(this.context, this.root.domain(), this.inner.target(), this.root), new SelectFromDialog(() -> (Shell)this.context.get(Shell.class), this.inner.appearance()));
    }
}

