/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.panel;

import java.util.stream.StreamSupport;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.passage.loc.internal.dashboard.ui.i18n.DashboardUiMessages;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Text;

public class DashboardPanelBlock {
    private String warning;
    private String info;
    private Text text;
    private ControlDecoration decoration;
    private Link show;

    public void createControl(Composite parent, String label, Image image) {
        this.text = this.createTextBlock(parent, label, image);
        this.decoration = new ControlDecoration((Control)this.text, 16512);
        this.show = new Link(parent, 0);
        this.show.setText(DashboardUiMessages.DashboardPanelBlock_show_text);
    }

    public void configureShow(String tooltip, SelectionListener listener) {
        this.show.setToolTipText(tooltip);
        this.show.addSelectionListener(listener);
    }

    protected Text createTextBlock(Composite parent, String label, Image image) {
        Label imageLabel = new Label(parent, 0);
        imageLabel.setImage(image);
        Label blockLabel = new Label(parent, 0);
        GridData data = new GridData(4, 4, true, true);
        data.widthHint = 100;
        blockLabel.setLayoutData((Object)data);
        blockLabel.setText(label);
        Text blockText = new Text(parent, 8);
        GridData data2 = new GridData(4, 4, false, false);
        data2.widthHint = 50;
        data2.horizontalIndent = 5;
        blockText.setLayoutData((Object)data2);
        return blockText;
    }

    protected void decorateTextBlock(String warningPattern, String infoPattern, long count, ControlDecoration controlDecoration) {
        FieldDecorationRegistry registry = FieldDecorationRegistry.getDefault();
        if (count > 0L) {
            Image image = registry.getFieldDecoration("DEC_INFORMATION").getImage();
            controlDecoration.setImage(image);
            controlDecoration.setDescriptionText(String.format(infoPattern, count));
        } else {
            Image image = registry.getFieldDecoration("DEC_WARNING").getImage();
            controlDecoration.setImage(image);
            controlDecoration.setDescriptionText(String.format(warningPattern, count));
        }
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public void setWarning(String warning) {
        this.warning = warning;
    }

    public void update(Iterable<?> iterable) {
        this.update(StreamSupport.stream(iterable.spliterator(), false).count());
    }

    public void update(long count) {
        String value = String.valueOf(count);
        if (value.equals(this.text.getText())) {
            return;
        }
        this.text.setText(value);
        this.show.setEnabled(count > 0L);
        this.decorateTextBlock(this.warning, this.info, count, this.decoration);
    }
}

