/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.workbench.emfforms.renderers;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.databinding.property.value.IValueProperty;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecp.view.spi.context.ViewModelContext;
import org.eclipse.emf.ecp.view.spi.model.VControl;
import org.eclipse.emf.ecp.view.spi.model.VElement;
import org.eclipse.emfforms.spi.common.report.AbstractReport;
import org.eclipse.emfforms.spi.common.report.ReportService;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedException;
import org.eclipse.emfforms.spi.core.services.databinding.DatabindingFailedReport;
import org.eclipse.emfforms.spi.core.services.databinding.EMFFormsDatabinding;
import org.eclipse.emfforms.spi.swt.core.AbstractSWTRenderer;
import org.eclipse.emfforms.spi.swt.core.di.EMFFormsDIRendererService;

public abstract class StructuredFeatureRendererService
implements EMFFormsDIRendererService<VControl> {
    private final Class<? extends AbstractSWTRenderer<VControl>> renderer;
    private final Iterable<EStructuralFeature> features;
    private final double priority;
    private EMFFormsDatabinding databinding;
    private ReportService report;

    protected StructuredFeatureRendererService(Class<? extends AbstractSWTRenderer<VControl>> renderer, double priority, EStructuralFeature ... features) {
        this(renderer, priority, Arrays.asList(features));
    }

    protected StructuredFeatureRendererService(Class<? extends AbstractSWTRenderer<VControl>> renderer, EStructuralFeature ... features) {
        this(renderer, 10.0, features);
    }

    protected StructuredFeatureRendererService(Class<? extends AbstractSWTRenderer<VControl>> renderer, double priority, Collection<EStructuralFeature> features) {
        this.renderer = renderer;
        this.priority = priority;
        this.features = features;
    }

    public final double isApplicable(VElement vElement, ViewModelContext viewModelContext) {
        IValueProperty valueProperty;
        if (!VControl.class.isInstance(vElement)) {
            return Double.NaN;
        }
        VControl control = (VControl)vElement;
        if (control.getDomainModelReference() == null) {
            return Double.NaN;
        }
        try {
            valueProperty = this.databinding.getValueProperty(control.getDomainModelReference(), viewModelContext.getDomainModel());
        }
        catch (DatabindingFailedException ex) {
            this.report.report((AbstractReport)new DatabindingFailedReport((Throwable)ex));
            return Double.NaN;
        }
        Object valueType = valueProperty.getValueType();
        if (valueType instanceof EStructuralFeature) {
            EStructuralFeature structuralFeature = (EStructuralFeature)valueType;
            for (EStructuralFeature f : this.features) {
                if (!structuralFeature.equals(f)) continue;
                return this.priority;
            }
        }
        return Double.NaN;
    }

    public final Class<? extends AbstractSWTRenderer<VControl>> getRendererClass() {
        return this.renderer;
    }

    protected void bindEMFFormsDatabinding(EMFFormsDatabinding service) {
        this.databinding = service;
    }

    protected void unbindEMFFormsDatabinding(EMFFormsDatabinding service) {
        if (this.databinding == service) {
            this.databinding = null;
        }
    }

    protected void bindReportService(ReportService service) {
        this.report = service;
    }

    protected void unbindReportService(ReportService service) {
        if (this.report == service) {
            this.report = null;
        }
    }
}

