/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.dashboard.ui.wizards.floating;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.products.ProductVersionDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;

public final class FloatingDataPack {
    private final Optional<LicensePlanDescriptor> plan;
    private final List<UserDescriptor> users;
    private final Optional<ProductVersionDescriptor> product;

    public FloatingDataPack(Optional<LicensePlanDescriptor> plan, List<UserDescriptor> users, Optional<ProductVersionDescriptor> product) {
        this.plan = plan;
        this.users = users;
        this.product = product;
    }

    public FloatingDataPack(Optional<LicensePlanDescriptor> plan, Optional<UserDescriptor> user, Optional<ProductVersionDescriptor> product) {
        this.plan = plan;
        this.users = this.users(user);
        this.product = product;
    }

    private List<UserDescriptor> users(Optional<UserDescriptor> user) {
        if (user.isEmpty()) {
            return Collections.emptyList();
        }
        return Collections.singletonList(user.get());
    }

    public FloatingDataPack() {
        this(Optional.empty(), Collections.emptyList(), Optional.empty());
    }

    Optional<LicensePlanDescriptor> plan() {
        return this.plan;
    }

    List<UserDescriptor> users() {
        return this.users;
    }

    Optional<ProductVersionDescriptor> product() {
        return this.product;
    }
}

