/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Date;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Supplier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.passage.lic.api.LicensedProduct;
import org.eclipse.passage.lic.api.LicensingException;
import org.eclipse.passage.lic.api.ServiceInvocationResult;
import org.eclipse.passage.lic.api.diagnostic.Trouble;
import org.eclipse.passage.lic.api.diagnostic.TroubleCode;
import org.eclipse.passage.lic.base.BaseLicensedProduct;
import org.eclipse.passage.lic.base.BaseServiceInvocationResult;
import org.eclipse.passage.lic.base.io.PassageFileExtension;
import org.eclipse.passage.lic.emf.validation.ErrorMessages;
import org.eclipse.passage.lic.internal.licenses.model.AssignGrantIdentifiers;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.model.api.LicenseRequisites;
import org.eclipse.passage.lic.licenses.model.api.PersonalLicensePack;
import org.eclipse.passage.loc.internal.agreements.AgreementRegistry;
import org.eclipse.passage.loc.internal.api.IssuedLicense;
import org.eclipse.passage.loc.internal.api.OperatorLicenseEvents;
import org.eclipse.passage.loc.internal.api.OperatorProductService;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.BaseIssuedLicense;
import org.eclipse.passage.loc.internal.licenses.core.ContributedLicensePackIssueListener;
import org.eclipse.passage.loc.internal.licenses.core.LicenseAgreements;
import org.eclipse.passage.loc.internal.licenses.core.LicensePackResidence;
import org.eclipse.passage.loc.internal.licenses.core.LicenseSignature;
import org.eclipse.passage.loc.internal.licenses.core.PersistedDecoded;
import org.eclipse.passage.loc.internal.licenses.core.PersistedEncoded;
import org.eclipse.passage.loc.internal.licenses.core.ProductPassword;
import org.eclipse.passage.loc.internal.licenses.core.UpdateLicensePlan;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;
import org.eclipse.passage.loc.internal.licenses.core.issue.PersonalLicenseIssuingProtection;
import org.eclipse.passage.loc.internal.products.ProductRegistry;
import org.eclipse.passage.loc.licenses.trouble.code.LicenseAgreementsAttachFailed;
import org.eclipse.passage.loc.licenses.trouble.code.LicenseIssuingFailed;
import org.eclipse.passage.loc.licenses.trouble.code.LicenseValidationFailed;
import org.osgi.service.event.EventAdmin;

final class IssuePersonalLicense {
    private final LicenseRegistry licenses;
    private final AgreementRegistry agreements;
    private final ProductRegistry products;
    private final OperatorProductService operator;
    private final EventAdmin events;

    IssuePersonalLicense(LicenseRegistry licenses, AgreementRegistry agreements, ProductRegistry products, OperatorProductService operator, EventAdmin events) {
        this.licenses = licenses;
        this.agreements = agreements;
        this.products = products;
        this.operator = operator;
        this.events = events;
    }

    ServiceInvocationResult<IssuedLicense> issue(Supplier<PersonalLicensePack> template) {
        Path encrypted;
        Path decrypted;
        PersonalLicensePack license;
        try {
            license = new Builder(template.get()).adjusted().guarded().signed().withAgreements().get();
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseAgreementsAttachFailed(), e.getMessage(), (Exception)((Object)e)));
        }
        Optional errors = new ErrorMessages().apply((EObject)license);
        if (errors.isPresent()) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseValidationFailed(), (String)errors.get()));
        }
        try {
            new UpdateLicensePlan(this.licenses).withPersonal((PersonalLicensePack)EcoreUtil.copy((EObject)license));
        }
        catch (IOException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_error_io, (Exception)e));
        }
        Path path = new LicensePackResidence((LicenseRequisites)license.getLicense()).get();
        try {
            decrypted = this.decrypted(license, path);
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_failed_to_save_decoded, (Exception)((Object)e)));
        }
        try {
            encrypted = this.encrypted(license, (LicensedProduct)this.product(license), decrypted);
        }
        catch (LicensingException e) {
            return new BaseServiceInvocationResult(new Trouble((TroubleCode)new LicenseIssuingFailed(), LicensesCoreMessages.LicenseOperatorServiceImpl_export_error, (Exception)((Object)e)));
        }
        new ContributedLicensePackIssueListener().personal(license, path);
        return this.result(license, decrypted, encrypted);
    }

    private BaseServiceInvocationResult<IssuedLicense> result(PersonalLicensePack license, Path decrypted, Path encrypted) {
        return new BaseServiceInvocationResult((Object)new BaseIssuedLicense(license, encrypted, decrypted));
    }

    private Path encrypted(PersonalLicensePack license, LicensedProduct product, Path decrypted) throws LicensingException {
        Path encrypted = new PersistedEncoded(product, decrypted, new ProductPassword(this.products, this.operator)).write(license.getLicense().getIdentifier() + new PassageFileExtension.LicenseEncrypted().get());
        this.events.postEvent(OperatorLicenseEvents.encodedIssued((String)encrypted.toString()));
        return encrypted;
    }

    private Path decrypted(PersonalLicensePack license, Path path) throws LicensingException {
        Path decrypted = new PersistedDecoded(path, (EObject)license).write(license.getLicense().getIdentifier() + new PassageFileExtension.LicenseDecrypted().get());
        this.events.postEvent(OperatorLicenseEvents.decodedIssued((String)decrypted.toString()));
        return decrypted;
    }

    private BaseLicensedProduct product(PersonalLicensePack license) {
        return new BaseLicensedProduct(license.getLicense().getProduct().getIdentifier(), license.getLicense().getProduct().getVersion());
    }

    private final class Builder
    implements Supplier<PersonalLicensePack> {
        private final PersonalLicensePack pack;

        Builder(PersonalLicensePack template) {
            this.pack = (PersonalLicensePack)EcoreUtil.copy((EObject)template);
        }

        Builder signed() {
            new LicenseSignature().accept((LicenseRequisites)this.pack.getLicense());
            return this;
        }

        Builder withAgreements() throws LicensingException {
            new LicenseAgreements(IssuePersonalLicense.this.agreements).install(this.plan(), (LicenseRequisites)this.pack.getLicense());
            return this;
        }

        Builder adjusted() {
            this.pack.getLicense().setIdentifier(UUID.randomUUID().toString());
            this.pack.getLicense().setIssueDate(new Date());
            new AssignGrantIdentifiers().accept(this.pack);
            return this;
        }

        Builder guarded() {
            new PersonalLicenseIssuingProtection().accept(this.pack);
            return this;
        }

        @Override
        public PersonalLicensePack get() {
            return this.pack;
        }

        private LicensePlanDescriptor plan() {
            return IssuePersonalLicense.this.licenses.getLicensePlan(this.pack.getLicense().getPlan());
        }
    }
}

