/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.lbc.internal.base.acquire;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.eclipse.passage.lbc.internal.base.acquire.AvailableForUser;
import org.eclipse.passage.lbc.internal.base.acquire.LicensePacks;
import org.eclipse.passage.lbc.internal.base.api.FlsGear;
import org.eclipse.passage.lbc.internal.base.api.FlsGearAwre;
import org.eclipse.passage.lic.floating.model.api.FeatureGrant;
import org.eclipse.passage.lic.floating.model.api.FloatingLicensePack;
import org.eclipse.passage.lic.internal.api.LicensedProduct;
import org.eclipse.passage.lic.internal.api.LicensingException;

final class FeatureGrants {
    private final LicensedProduct product;
    private final String user;
    private final String feature;
    private final Supplier<Path> base;
    private final Logger log = LogManager.getLogger(this.getClass());

    FeatureGrants(LicensedProduct product, String user, String feature, Supplier<Path> base) {
        this.product = product;
        this.user = user;
        this.feature = feature;
        this.base = base;
    }

    Collection<FeatureGrant> get() {
        return new FlsGearAwre().withGear(gear -> Optional.of(this.get((FlsGear)gear))).orElse(this.failedOnGathering());
    }

    private Collection<FeatureGrant> failedOnGathering() {
        this.log.error(String.format("Failed on gathering grants for product %s", this.product));
        return Collections.emptyList();
    }

    private Collection<FeatureGrant> get(FlsGear gear) {
        try {
            return new LicensePacks(gear.keyKeper(this.product, this.base), gear.codec(this.product), this.product, this.base).get().stream().filter(new AvailableForUser(this.user)).map(this::grantForFeature).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        }
        catch (LicensingException e) {
            this.log.error((Object)e);
            return Collections.emptyList();
        }
    }

    private Optional<FeatureGrant> grantForFeature(FloatingLicensePack license) {
        return license.getFeatures().stream().filter(grant -> this.feature.equals(grant.getFeature())).findAny();
    }
}

