/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.report.internal.core.license;

import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.users.UserDescriptor;
import org.eclipse.passage.lic.users.UserLicenseDescriptor;
import org.eclipse.passage.loc.yars.internal.api.DosHandleMedia;
import org.eclipse.passage.loc.yars.internal.api.ExportData;
import org.eclipse.passage.loc.yars.internal.api.Progress;

public final class LicensePlanReport
implements ExportData<LicensePlanReport, DosHandleMedia<LicensePlanReport>> {
    private final LicensePlanDescriptor plan;
    private final int amount;
    private final Map<UserDescriptor, List<UserLicenseDescriptor>> licenses;
    private final boolean explain;
    private final SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd");

    LicensePlanReport(LicensePlanDescriptor plan, int amount, Map<UserDescriptor, List<UserLicenseDescriptor>> licenses, boolean explain) {
        this.plan = plan;
        this.amount = amount;
        this.licenses = licenses;
        this.explain = explain;
    }

    public void write(DosHandleMedia<LicensePlanReport> media, Progress<LicensePlanReport> progress) {
        media.inner(this.plan.getName(), "plan-name");
        media.inner(this.plan.getIdentifier(), "plan-id");
        media.inner(Integer.toString(this.amount), "licenses");
        if (this.explain) {
            media.inner(this.licenses.keySet().stream().map(this::user).collect(Collectors.joining(",")), "users");
        }
    }

    private String user(UserDescriptor user) {
        Object[] objectArray = new Object[2];
        objectArray[0] = user.getFullName();
        objectArray[1] = this.licenses.get(user).stream().map(UserLicenseDescriptor::getIssueDate).map(this.format::format).collect(Collectors.joining(", "));
        return String.format("%s (%s)", objectArray);
    }
}

