/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.passage.loc.internal.licenses.core;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.osgi.util.NLS;
import org.eclipse.passage.lic.internal.equinox.events.EquinoxEvent;
import org.eclipse.passage.lic.internal.equinox.io.InstallationPath;
import org.eclipse.passage.lic.licenses.LicensePlanDescriptor;
import org.eclipse.passage.lic.licenses.model.meta.LicensesPackage;
import org.eclipse.passage.loc.internal.emf.BaseDomainRegistry;
import org.eclipse.passage.loc.internal.emf.DomainContentAdapter;
import org.eclipse.passage.loc.internal.emf.EditingDomainRegistry;
import org.eclipse.passage.loc.internal.licenses.LicenseRegistry;
import org.eclipse.passage.loc.internal.licenses.core.LicensesDomainRegistryTracker;
import org.eclipse.passage.loc.internal.licenses.core.i18n.LicensesCoreMessages;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.event.EventAdmin;

@Component(property={"org.eclipse.passage.lic.emf.edit.domain.name=licenses", "org.eclipse.passage.lic.emf.edit.file.extension=licenses_xmi"})
public class LicenseDomainRegistry
extends BaseDomainRegistry<LicensePlanDescriptor>
implements LicenseRegistry,
EditingDomainRegistry<LicensePlanDescriptor> {
    private final Map<String, LicensePlanDescriptor> licensePlanIndex = new HashMap<String, LicensePlanDescriptor>();
    private EventAdmin events;

    @Reference
    public void bindEventAdmin(EventAdmin admin) {
        this.events = admin;
    }

    public void unbindEventAdmin(EventAdmin admin) {
        this.events = null;
    }

    @Activate
    public void activate(Map<String, Object> properties) {
        super.activate(properties);
    }

    @Deactivate
    public void deactivate(Map<String, Object> properties) {
        this.licensePlanIndex.clear();
        super.deactivate(properties);
    }

    public String getFileExtension() {
        return "licenses_xmi";
    }

    public Class<LicensePlanDescriptor> getContentClass() {
        return LicensePlanDescriptor.class;
    }

    public String resolveIdentifier(LicensePlanDescriptor content) {
        return content.getIdentifier();
    }

    public Iterable<LicensePlanDescriptor> getLicensePlans() {
        return new ArrayList<LicensePlanDescriptor>(this.licensePlanIndex.values());
    }

    @Override
    public LicensePlanDescriptor getLicensePlan(String identifier) {
        return this.licensePlanIndex.get(identifier);
    }

    public void registerLicensePlan(LicensePlanDescriptor licensePlan) {
        String identifier = licensePlan.getIdentifier();
        LicensePlanDescriptor existing = this.licensePlanIndex.put(identifier, licensePlan);
        if (existing != null) {
            String msg = NLS.bind((String)LicensesCoreMessages.LicenseDomain_instance_duplication_message, (Object)existing, (Object)licensePlan);
            Platform.getLog(this.getClass()).warn(msg);
        }
        this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/licenses/registry/LicensePlan/create", (Object)licensePlan).get());
    }

    public void unregisterLicensePlan(String identifier) {
        LicensePlanDescriptor removed = this.licensePlanIndex.remove(identifier);
        if (removed != null) {
            this.events.postEvent(new EquinoxEvent("org/eclipse/passage/lic/licenses/registry/LicensePlan/delete", (Object)removed).get());
        }
    }

    protected DomainContentAdapter<LicensePlanDescriptor, LicenseDomainRegistry> createContentAdapter() {
        return new LicensesDomainRegistryTracker(this);
    }

    public EClass getContentClassifier() {
        return LicensesPackage.eINSTANCE.getLicensePlan();
    }

    public EStructuralFeature getContentIdentifierAttribute() {
        return LicensesPackage.eINSTANCE.getLicensePlan_Identifier();
    }

    public EStructuralFeature getContentNameAttribute() {
        return LicensesPackage.eINSTANCE.getLicensePlan_Name();
    }

    public void registerContent(LicensePlanDescriptor content) {
        this.registerLicensePlan(content);
    }

    public void unregisterContent(String identifier) {
        this.unregisterLicensePlan(identifier);
    }

    protected Path getResourceSetPath() throws Exception {
        Path passagePath = new InstallationPath().get();
        Files.createDirectories(passagePath, new FileAttribute[0]);
        return passagePath.resolve(this.domainName);
    }
}

